/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position.updates;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.structure.StructureState;

public class GoPrepositionUpdateRequest
implements PositionUpdateRequest {
    public final Noun goer;
    public final Preposition preposition;
    public final Preposition reversePreposition;
    public final Noun spot;
    public final Simulation simulation;

    public GoPrepositionUpdateRequest(Noun goer, Preposition preposition, Preposition reversePreposition, Simulation simulation, Noun spot) {
        this.goer = goer;
        this.preposition = preposition;
        this.reversePreposition = reversePreposition;
        this.spot = spot;
        this.simulation = simulation;
    }

    @Override
    public void apply(PositionStateBuilder partialState, Simulation simulation) {
        if (this.spot == null) {
            this.executeWithNoNoun(partialState);
            return;
        }
        Frame frame = simulation.getCurrentFrame();
        GoHandler goHandler = GoableState.get(frame).getGoHandlerOrDefault(this.spot, SpacialRelationship.of(this.preposition));
        goHandler.handleGo(this.goer, SpacialRelationship.of(this.preposition), SpacialRelationship.of(this.reversePreposition), simulation, partialState, this.spot);
    }

    private void executeWithNoNoun(PositionStateBuilder partialState) {
        Frame frame = this.simulation.getCurrentFrame();
        PositionState positionState = PositionState.get(frame);
        Noun spotToGoTo = this.getContainerToGoOutsideOf(frame);
        if (spotToGoTo == null) {
            PlayerNotificationEvent.postAlwaysPerceivable(this.goer, this.getNoNounCantGoMessage(), this.simulation);
            return;
        }
        Noun outsideSpot = positionState.getParent(spotToGoTo);
        if (outsideSpot == null) {
            PlayerNotificationEvent.postAlwaysPerceivable(this.goer, this.getNoNounCantGoMessage(), this.simulation);
            return;
        }
        Preposition outsidePreposition = positionState.getPreposition(spotToGoTo);
        Preposition outsideReversePreposition = positionState.getReversePreposition(spotToGoTo);
        partialState.put(this.goer, outsidePreposition, outsideReversePreposition, outsideSpot);
        PlayerExaminesSurroundingsEvent.post(this.goer, this.simulation);
    }

    private Noun getContainerToGoOutsideOf(Frame frame) {
        PositionState positionState = PositionState.get(frame);
        StructureState structureState = StructureState.get(frame);
        Noun parent = positionState.getParent(this.goer);
        if (parent == null) {
            return null;
        }
        if (structureState.isIntegral(parent)) {
            return positionState.getParent(parent);
        }
        return parent;
    }

    private String getNoNounCantGoMessage() {
        Frame frame = this.simulation.getCurrentFrame();
        if (this.spot == null) {
            return "You can't go " + this.preposition + " from here.";
        }
        return "You can't go " + this.preposition + " " + NounPhraseWithArticle.the(this.spot.getDefaultPerception(frame)) + ".";
    }
}

