/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position.updates;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.water.WaterState;

public class PlayerGoDirectionRequest
implements PositionUpdateRequest {
    private static final double WALKING_ENERGY_COST = -0.02;
    private static final double SWIMMING_ENERGY_COST = -0.05;
    private final Noun player;
    private final Noun direction;

    private PlayerGoDirectionRequest(Noun player, Noun direction) {
        this.player = player;
        this.direction = direction;
    }

    @Override
    public void apply(PositionStateBuilder partialState, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        GoableState goableState = GoableState.get(frame);
        Noun surroundParentOrRoot = StructureState.getSurroundParentOrRoot(this.player, frame);
        PathSegment exitSegment = PositionState.get(frame).getExit(surroundParentOrRoot, SpacialRelationship.of(this.direction));
        if (exitSegment == null) {
            PlayerNotificationEvent.post(this.player, simulation, "There is no way to go " + this.direction.getContextFreeDescription() + " from here.");
            return;
        }
        String goVerb = "walk";
        double energyCost = -0.02;
        double waterDepth = WaterState.get(frame).getDepthAt(exitSegment.endNoun, frame);
        if (waterDepth > 0.5) {
            goVerb = "swim";
            energyCost = -0.05;
        }
        Noun spotToGo = exitSegment.endNoun;
        SpacialRelationship spacialDirection = SpacialRelationship.of(this.direction);
        GoHandler goHandler = goableState.getGoHandlerOrDefault(spotToGo, spacialDirection);
        goHandler.handleGo(this.player, spacialDirection, null, simulation, partialState, spotToGo);
        EnergyState.requestChangeWithoutCause(this.player, energyCost, simulation);
    }

    public static void makeRequest(Noun direction, Command.Context context) {
        context.simulation.requestStateChange(PositionState.class, new PlayerGoDirectionRequest(context.player, direction));
    }
}

