/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public class DistanceLimitedScenery
implements Scenery {
    private final double nearest;
    private final double farthest;
    private final Scenery delegate;

    public DistanceLimitedScenery(double nearest, double farthest, Scenery delegate) {
        this.nearest = nearest;
        this.farthest = farthest;
        this.delegate = delegate;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        double distance = CoordinateState.getDistanceBetween(perceiver, associatedNoun, frame);
        if (distance >= this.nearest && distance <= this.farthest) {
            return this.delegate.asPerceivedBy(perceiver, direction, associatedNoun, channel, frame);
        }
        return null;
    }

    @Override
    public double getPerceivedDistance(Noun noun1, Noun noun2, Frame frame) {
        return this.delegate.getPerceivedDistance(noun1, noun2, frame);
    }
}

