/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.sun;

import com.fabriziopolo.textcraft.events.sun.SunStateChangedEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.sun.SunEffect;
import com.fabriziopolo.textcraft.states.sun.SunLightTracePathAlgorithm;
import com.fabriziopolo.textcraft.states.sun.SunStateBuilder;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.util.Map;

public class SunState
extends ValueState<SunEffect> {
    protected double intensityOutside = 1.0;
    protected TimeState prevTime;

    public static SunState get(Frame frame) {
        return (SunState)frame.states.get(SunState.class);
    }

    @Override
    protected SunEffect combineValues(Noun noun, SunEffect t1, SunEffect t2, Simulation simulation) {
        return t2;
    }

    @Override
    protected Class getStateKey() {
        return SunState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        int prevHour;
        int currHour;
        Frame currentFrame = simulation.getCurrentFrame();
        for (Map.Entry entry : this.getEntrySet()) {
            Noun noun = entry.getKey();
            SunEffect onExposureToSun = (SunEffect)entry.getValue();
            Double intensity = this.getIntensityAt(noun, currentFrame);
            if (intensity == null) continue;
            onExposureToSun.onSun(simulation, noun, intensity);
        }
        SunStateBuilder newStateBuilder = SunState.builder();
        newStateBuilder.setIntensityOutside(SunState.computeIntensityOutside(currentFrame));
        TimeState currTime = TimeState.get(currentFrame);
        newStateBuilder.setPrevTime(currTime);
        this.setUpdatedState(simulation, newStateBuilder);
        SunState newState = newStateBuilder.build();
        if (this.prevTime != null && (currHour = currTime.getGameTimeHour()) != (prevHour = this.prevTime.getGameTimeHour())) {
            SunStateChangedEvent.post(simulation, currHour, prevHour);
        }
        return newState;
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("effect", this.get(noun));
        builder.addLine("intensityAt", this.getIntensityAt(noun, frame));
        return builder.toString();
    }

    public Double getIntensityAt(Noun noun, Frame frame) {
        return new SunLightTracePathAlgorithm().traversePathFromExterior(SunState.computeIntensityOutside(frame), noun, frame);
    }

    public static Sentences getChangeDescription(long currHour, long prevHour) {
        if (SunState.isSunRising(currHour)) {
            if (!SunState.isSunRising(prevHour)) {
                return Nlg.literalSentences("The sun is rising.");
            }
            return null;
        }
        if (!SunState.isSunRising(currHour) && SunState.isSunRising(prevHour)) {
            return Nlg.literalSentences("The sun has risen.");
        }
        if (SunState.isSunSetting(currHour)) {
            if (!SunState.isSunSetting(prevHour)) {
                return Nlg.literalSentences("The sun is setting.");
            }
            return null;
        }
        if (SunState.isHighNoon(currHour) && !SunState.isHighNoon(prevHour)) {
            return Nlg.literalSentences("The sun is high in the sky.");
        }
        if (SunState.isNight(currHour)) {
            if (!SunState.isNight(prevHour)) {
                return Nlg.literalSentences("The sun has set.");
            }
            return null;
        }
        return null;
    }

    public static boolean becamePitchBlack(long currHour, long prevHour) {
        return SunState.isPitchBlack(currHour) && !SunState.isPitchBlack(prevHour);
    }

    public static boolean becameNotPitchBlack(long currHour, long prevHour) {
        return !SunState.isPitchBlack(currHour) && SunState.isPitchBlack(prevHour);
    }

    public static Sentences getDescription(Frame frame) {
        return SunState.getDescription(TimeState.get(frame).getGameTimeHour());
    }

    public static boolean isNight(Frame frame) {
        return SunState.isNight(SunState.getHour(frame));
    }

    public static boolean isPitchBlack(Frame frame) {
        return SunState.isPitchBlack(SunState.getHour(frame));
    }

    public static boolean isDawn(Frame frame) {
        return SunState.isDawn(SunState.getHour(frame));
    }

    private static Sentences getDescription(long hour) {
        if (SunState.isSunRising(hour)) {
            return Nlg.literalSentences("The sun is rising.");
        }
        if (SunState.isHighNoon(hour)) {
            return Nlg.literalSentences("The sun is high in the sky.");
        }
        if (SunState.isSunSetting(hour)) {
            return Nlg.literalSentences("The sun is setting.");
        }
        if (SunState.isDawn(hour)) {
            return Nlg.literalSentences("It is dawn.");
        }
        if (SunState.isDusk(hour)) {
            return Nlg.literalSentences("It is dusk.");
        }
        if (SunState.isNight(hour)) {
            return Nlg.literalSentences("It is night.");
        }
        return null;
    }

    public static Sentences getVerboseDescription(Frame frame) {
        return SunState.getVerboseDescription(TimeState.get(frame).getGameTimeHour());
    }

    private static Sentences getVerboseDescription(long hour) {
        Sentences description = SunState.getDescription(hour);
        if (description != null) {
            return description;
        }
        if (SunState.isNight(hour)) {
            return null;
        }
        if (SunState.isMorning(hour)) {
            return Nlg.literalSentences("It is morning.");
        }
        if (SunState.isAfternoon(hour)) {
            return Nlg.literalSentences("It is afternoon.");
        }
        if (SunState.isEvening(hour)) {
            return Nlg.literalSentences("It is evening.");
        }
        return null;
    }

    private static int getHour(Frame frame) {
        return TimeState.get(frame).getGameTimeHour();
    }

    private static double computeIntensityOutside(Frame frame) {
        return SunState.intensityCurve(SunState.getHour(frame));
    }

    private static double intensityCurve(int hour) {
        if (SunState.isPitchBlack(hour)) {
            return 0.1;
        }
        if (SunState.isNight(hour)) {
            return 0.3;
        }
        if (SunState.isHighNoon(hour)) {
            return 1.0;
        }
        return 0.7;
    }

    private static boolean isHighNoon(long hour) {
        return hour >= 11L && hour <= 13L;
    }

    private static boolean isPitchBlack(long hour) {
        return hour <= 4L || hour >= 21L;
    }

    private static boolean isNight(long hour) {
        return hour <= 5L || hour >= 20L;
    }

    private static boolean isSunRising(long hour) {
        return hour == 6L;
    }

    private static boolean isDawn(long hour) {
        return hour == 5L;
    }

    private static boolean isSunSetting(long hour) {
        return hour == 19L;
    }

    private static boolean isDusk(long hour) {
        return hour == 20L;
    }

    private static boolean isMorning(long hour) {
        return hour >= 6L && hour <= 10L;
    }

    private static boolean isAfternoon(long hour) {
        return hour >= 14L && hour <= 16L;
    }

    private static boolean isEvening(long hour) {
        return hour >= 17L && hour <= 19L;
    }

    public static SunStateBuilder builder() {
        return new SunStateBuilder();
    }

    public static void requestSetSunEffect(Noun noun, SunEffect effect, Simulation simulation) {
        simulation.requestStateChange(SunState.class, new ValueState.ChangeRequest<SunEffect>(noun, effect));
    }

    public static String getGameTimeDescription(int hour) {
        if (hour <= 4) {
            return "night";
        }
        if (hour == 5) {
            return "dawn";
        }
        if (hour == 6) {
            return "sunrise";
        }
        if (7 <= hour && hour <= 10) {
            return "morning";
        }
        if (11 <= hour && hour <= 13) {
            return "midday";
        }
        if (14 <= hour && hour <= 16) {
            return "afternoon";
        }
        if (17 <= hour && hour <= 18) {
            return "evening";
        }
        if (hour == 19) {
            return "sunset";
        }
        if (hour == 20) {
            return "dusk";
        }
        if (hour >= 21) {
            return "night";
        }
        throw new IllegalArgumentException("Bad hour " + hour);
    }
}

