/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.updatable;

import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.DelayedUpdateable;
import com.fabriziopolo.textcraft.states.updatable.OnceOnlyUpdateable;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import java.time.Duration;

public class Updateables {
    private Updateables() {
    }

    public static void create(Simulation simulation, Updateable updateable) {
        new WorldBuilder(simulation).createUpdateable(updateable);
    }

    public static void createOneTime(Simulation simulation, Updateable updateable) {
        Updateables.create(simulation, new OnceOnlyUpdateable(updateable));
    }

    public static void createDelayed(Simulation simulation, Duration delay, Updateable updateable) {
        Updateables.create(simulation, new DelayedUpdateable(TimeState.getGameTimeInstant(simulation.getCurrentFrame()).plus(delay), updateable));
    }

    public static void createOneTimeDelayed(Simulation simulation, Duration delay, Updateable updateable) {
        Updateables.createDelayed(simulation, delay, new OnceOnlyUpdateable(updateable));
    }
}

