/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.beach;

import com.fabriziopolo.textcraft.nlg.NounMatchingSingularAndPlural;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.AbstractDelegatingNoun;
import com.fabriziopolo.textcraft.objects.RoomFactory;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.putreceiver.RedirectingPutReceiver;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;
import com.fabriziopolo.timecraft.world.dsl.beach.Story;

public class Rooms
extends Beach {
    private final RoomFactory roomFactory;

    public Rooms(Simulation simulation) {
        super(simulation);
        this.roomFactory = new RoomFactory(simulation);
    }

    public Noun deepWater() {
        Noun floor = this.resources().endlessSeaWater();
        Noun room = this.roomFactory.roomWithFloor("the ocean", "The open ocean surrounds you.", "the sound of large ocean waves", "You are tossed relentlessly by large ocean waves.", floor);
        this.addWaterDepth(room, 0.75);
        return room;
    }

    private Noun getDiveableWater() {
        Noun surfaceNoun = this.resources().endlessSeaWater();
        this.resources().makeBehaveLikeEndlessSeawater(surfaceNoun);
        this.addWaterDepth(surfaceNoun, 0.75);
        SimpleNoun underNoun = new SimpleNounAutoBuilder().setDescription("Under the water.", "the ocean water", "waters", new String[0]).build();
        this.resources().makeBehaveLikeEndlessSeawater(underNoun);
        this.addWaterDepth(underNoun, 1.0);
        Noun entranceIntoWater = this.shelters().assembleInsideOutsideGetEntrance(underNoun, Prepositions.under, surfaceNoun);
        this.makeBlockRain(entranceIntoWater);
        this.createEntrance(surfaceNoun, Prepositions.on);
        this.makeGoToSpot(surfaceNoun, Prepositions.on, (Noun)underNoun);
        this.setPutReceiver(surfaceNoun, new RedirectingPutReceiver(underNoun, Prepositions.under));
        return surfaceNoun;
    }

    public Noun shallowWater() {
        Noun floor = this.resources().shallowWater();
        Noun room = this.roomFactory.roomWithFloor("the shallow ocean surf", "These shallow, coastal waters are pleasantly warm.", "the sound of gently crashing waves", "Warm tropical waves lap gently against your legs.", floor);
        this.resources().makeBehaveLikeEndlessSeawater(floor);
        this.addWaterDepth(room, 0.3);
        return room;
    }

    public Noun shallowWaterWithFish() {
        Noun shallowWater = this.resources().shallowWater();
        Noun room = this.roomFactory.roomWithFloor("the shallow ocean surf", "These pleasantly warm, shallow, coastal waters are teeming with tiny fish.", "the sound of gently crashing waves", "Warm tropical waves lap gently against your legs.", shallowWater);
        this.resources().makeBehaveLikeEndlessSeawater(shallowWater);
        this.addWaterDepth(room, 0.3);
        Noun fish = this.animals().schoolOfFish();
        this.put(fish, Prepositions.in, shallowWater);
        this.makeIntegral(fish);
        return room;
    }

    public Noun shallowWaterWithReeds(String directionName) {
        Noun shallowWater = this.resources().shallowWater();
        Noun room = this.roomFactory.roomWithFloor("the " + directionName + " end of a small inlet", "The " + directionName + " end of this small inlet in the beach harbors a stand of tall reeds.", "the sound of reeds rattling against one another under the action of the waves", "Warm tropical waves lap gently against your legs as you brush through tall reeds.", shallowWater);
        this.resources().makeBehaveLikeEndlessSeawater(shallowWater);
        this.addWaterDepth(room, 0.3);
        NounMatchingSingularAndPlural reedFactory = new NounMatchingSingularAndPlural(SimpleNoun.autoBuilder().setDescription("The reeds are wide, stiff, and taller than you.", "reed", "reeds", new String[0]).plural().visibleInDark().build());
        this.put(reedFactory, Prepositions.in, shallowWater);
        this.makeIntegral(reedFactory);
        this.setTakeHandler(reedFactory, new TakeReedsEndlessly());
        this.makeProminent(reedFactory);
        this.setProminent(reedFactory, (noun, args, frame) -> !SunState.isNight(frame));
        return room;
    }

    private void installTakeableSandFeature(Noun noun, Noun whiteSand) {
        this.makeIntegral(whiteSand);
        this.setTakeHandler(whiteSand, new TakeSandEndlessly());
    }

    public Noun whiteBeach() {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("a white beach", "This beach is made of fine white sand.", "a star-lit beach", "Fine sand crunches under foot while small waves can be heard gently crashing.", beachFloor);
        this.installTakeableSandFeature(room, beachFloor);
        return room;
    }

    public Noun whiteBeachCorner(String direction) {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("the white beach at the " + direction + " corner of the island", "This is the " + direction + " corner of the island.  The beach is made of fine white sand.", "a star-lit beach", "Fine sand crunches under foot while small waves can be heard gently crashing.", beachFloor);
        this.installTakeableSandFeature(room, beachFloor);
        return room;
    }

    public Noun whiteBeachWithPebbles() {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("a pebbled white beach", "This beach of white sand is littered with pebbles.", "a star-lit beach", "Fine sand crunches under foot while small waves can be heard gently crashing.", beachFloor);
        NounMatchingSingularAndPlural pebblesFactory = new NounMatchingSingularAndPlural(SimpleNoun.autoBuilder().setDescription("Many of the pebbles are small and worn round by the sea.  Some rougher stones of black and red are of more recent volcanic origin.", "pebble", "pebbles", new String[0]).visibleInDark().build());
        this.putIntegral(pebblesFactory, Prepositions.on, beachFloor);
        this.setTakeHandler(pebblesFactory, new TakePebblesEndlessly());
        this.installTakeableSandFeature(room, beachFloor);
        return room;
    }

    public Noun whiteBeachWithGrass() {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("a grassy white sand dune", "The sand forms into a dune here, held together by sparse, tall grass.  The stump of a crudely severed palm tree hides several feet beneath the tops of the grass.", "the rustling of grass in the wind", "Fine sand crunches under foot and tall grass brushes your legs as you navigate the sand dune, carefully avoiding tripping on the tree stump at its center.", beachFloor);
        SimpleNoun stump = new SimpleNounAutoBuilder().setDescription("A palm tree was felled here.  The top of the stump was crudely hacked away, definitely not by a power tool.", "a palm tree stump", "stumps", new String[0]).setDarkDescription("", "a palm tree stump", "stumps", new String[0]).build();
        this.makeIntegral(stump);
        this.makeUntakeable(stump, "That's firmly attached to the ground.");
        this.put(stump, Prepositions.on, beachFloor);
        Noun grass = this.plants().alwaysVisibleDuneGrassIntegralFeature();
        this.putIntegral(grass, Prepositions.on, beachFloor);
        this.setTakeHandler(grass, new TakeDuneGrassEndlessly());
        this.installTakeableSandFeature(room, beachFloor);
        return room;
    }

    public Noun dirtyWhiteBeach() {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("a dirty white beach", "This beach of fine white sand is littered with tiny shreds of seaweed.", "the sound of gently crashing waves", "Fine sand crunches under foot while small waves can be heard gently crashing.  The occasional bit of mushy seaweed squishes between your toes.", beachFloor);
        this.installTakeableSandFeature(room, beachFloor);
        this.installTakeableSeaweedFeature(room);
        return room;
    }

    public Noun southernWhiteBeachThatBecomesDirty() {
        return new AbstractDelegatingNoun(){

            @Override
            protected Noun getDelegate(Noun object, PerceptionChannel channel, Frame frame) {
                if (TimeState.getDaySinceDay0(frame) >= 5) {
                    return Rooms.this.dirtyWhiteBeach();
                }
                return Rooms.this.whiteBeach();
            }
        };
    }

    public void installTakeableSeaweedFeature(Noun room) {
        Noun feature = this.resources().shredOfSeaweed();
        this.makeIntegral(feature);
        this.put(feature, Prepositions.in, room);
        this.setTakeHandler(feature, new TakeHandler(){

            @Override
            public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
                return new Dsl(simulation).beach().resources().shredOfSeaweed();
            }
        });
    }

    public Noun islandTreeRoom() {
        SimpleNoun floor = SimpleNoun.auto("A patch of sandy soil, home to the only green stuff on the island.", "a sandy dirt patch", "dirts", new String[0]);
        Noun room = this.roomFactory.roomWithFloor("a patch of dirt", "This is probably the only part of the island that has anything describable as dirt.  Sure, it's sandy dirt, but it's dirt nonetheless.", "the unobstructed ocean wind", "", floor);
        Noun palmTree = this.plants().smallPalmTree();
        this.put(palmTree, Prepositions.on, floor);
        this.createExit(palmTree, SpacialRelationship.of(Prepositions.down), floor);
        this.put(this.jungle().plants().figTreeWithFigs(3), Prepositions.on, floor);
        this.put(this.plants().junglePlant(), Prepositions.on, floor);
        return room;
    }

    public Noun islandCenterRoom() {
        SimpleNoun floor = SimpleNoun.auto("A rocky lump that presumably is the protruding tip of the solid core of this island.", "a rocky knoll", "knolls", new String[0]);
        Noun room = this.roomFactory.roomWithFloor("the rocky island center", "Wind blows hard over the rocky knoll that is the center of this tiny island.", "the unobstructed ocean wind", "You stumble blindly over a hard, craggy knoll while unobstructed ocean wind whips your face.", floor);
        this.put(this.plants().poisonBerryBush(), Prepositions.on, floor);
        return room;
    }

    public Noun gameEndRoom() {
        Noun beachFloor = this.resources().whiteSand();
        Noun room = this.roomFactory.roomWithFloor("a white beach", "This beach is made of fine white sand.", "the sound of gently crashing waves", "Fine sand crunches under foot while small waves can be heard gently crashing.", beachFloor);
        this.installTakeableSandFeature(room, beachFloor);
        Story.EndGameRoomGoHandler endGameHandler = new Story.EndGameRoomGoHandler();
        this.directions().getAll().forEach(direction -> {
            this.setGoHandler(room, (Noun)direction, (GoHandler)endGameHandler);
            this.setGoHandler(beachFloor, (Noun)direction, (GoHandler)endGameHandler);
        });
        return room;
    }

    private static final class TakeDuneGrassEndlessly
    implements TakeHandler {
        private TakeDuneGrassEndlessly() {
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            return new Dsl(simulation).beach().plants().duneGrass();
        }
    }

    private static final class TakePebblesEndlessly
    implements TakeHandler {
        private TakePebblesEndlessly() {
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            Dsl dsl = new Dsl(simulation);
            switch (simulation.getRandom().nextInt(4)) {
                case 0: {
                    return dsl.beach().resources().roughPebble("red");
                }
                case 1: {
                    return dsl.beach().resources().roughPebble("black");
                }
            }
            return dsl.beach().resources().roundPebble();
        }
    }

    private static final class TakeSandEndlessly
    implements TakeHandler {
        private TakeSandEndlessly() {
        }

        @Override
        public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
            return true;
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            return new Dsl(simulation).beach().resources().whiteSand();
        }
    }

    private static final class TakeReedsEndlessly
    implements TakeHandler {
        private TakeReedsEndlessly() {
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            Dsl dsl = new Dsl(simulation);
            int i = simulation.getRandom().nextInt(4);
            if (i == 1) {
                return dsl.beach().plants().goldenReeds();
            }
            return dsl.beach().plants().reeds();
        }
    }
}

