/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.timelapse;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.scenery.BandedScenery;
import com.fabriziopolo.textcraft.states.scenery.UpScenery;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;

public class MountainRectangleMapPopulator
implements MapPopulator {
    private final int width;
    private final int height;
    private final Dsl dsl;

    public MountainRectangleMapPopulator(Dsl dsl, int height, int width) {
        this.dsl = dsl;
        this.width = width;
        this.height = height;
    }

    @Override
    public Noun createNewRoomAt(int x, int y) {
        return this.dsl.mountain().rooms().mountainSide();
    }

    @Override
    public void putObjectsInRoom(Noun room, int x, int y) {
    }

    @Override
    public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
    }

    @Override
    public void addScenery(Noun room, int x, int y) {
        if (x == 0 && y == 0) {
            BandedScenery foothillsFromJungle = new BandedScenery(1.0, 3.0, "east", this.dsl.mountain().sceneries().foothills());
            UpScenery foothillsFromTree = new UpScenery(new BandedScenery(1.0, 6.0, "east", this.dsl.mountain().sceneries().foothills()));
            this.dsl.putScenery(room, foothillsFromTree.or(foothillsFromJungle));
        }
    }

    @Override
    public void finish() {
    }
}

