/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Verb;

import gov.nih.nlm.nls.lexCheck.Compl.CheckAsComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckBinfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckEdComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckInfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckIngComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckParticle;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatVerbCplxtran
implements CheckFormat {
    private static final int LEGAL_FILLER1_NUM = 1;
    private static HashSet<String> filler1_ = new HashSet(1);
    private static final int LEGAL_FILLER2_NUM = 2;
    private static HashSet<String> filler2_ = new HashSet(2);

    @Override
    public boolean IsLegalFormat(String inCode) {
        boolean flag = false;
        int partIndex = inCode.indexOf(";part(");
        int passiveIndex = inCode.indexOf(";nopass");
        String filler = null;
        String particle = null;
        boolean passive = false;
        if (partIndex != -1) {
            filler = inCode.substring(0, partIndex);
            particle = passiveIndex != -1 ? inCode.substring(partIndex, passiveIndex) : inCode.substring(partIndex);
        } else {
            filler = passiveIndex != -1 ? inCode.substring(0, passiveIndex) : inCode;
        }
        flag = particle != null ? this.CheckCplxtranFiller(filler) && CheckParticle.IsLegal(particle) : this.CheckCplxtranFiller(filler);
        return flag;
    }

    private boolean CheckCplxtranFiller(String filler) {
        boolean flag = false;
        String filler1 = new String();
        String filler2 = new String();
        if (filler.startsWith("pphr(")) {
            int index = filler.indexOf("),");
            filler1 = filler.substring(0, index + 1);
            filler2 = filler.substring(index + 2);
        } else {
            int index = filler.indexOf(",");
            filler1 = filler.substring(0, index);
            filler2 = filler.substring(index + 1);
        }
        flag = this.CheckFiller1(filler1) && this.CheckFiller2(filler2);
        return flag;
    }

    private boolean CheckFiller1(String filler) {
        boolean flag = false;
        if (filler1_.contains(filler)) {
            flag = true;
        } else if (filler.startsWith("fincomp(")) {
            flag = CheckFinComp.IsLegal(filler);
        } else if (filler.startsWith("ingcomp:")) {
            flag = CheckIngComp.IsLegal(filler);
        } else if (filler.startsWith("pphr(")) {
            flag = CheckPphr.IsLegal(filler);
        }
        return flag;
    }

    private boolean CheckFiller2(String filler) {
        boolean flag = false;
        if (filler2_.contains(filler)) {
            flag = true;
        } else if (filler.startsWith("ascomp:")) {
            flag = CheckAsComp.IsLegal(filler);
        } else if (filler.startsWith("binfcomp:")) {
            flag = CheckBinfComp.IsLegal(filler);
        } else if (filler.startsWith("edcomp:")) {
            flag = CheckEdComp.IsLegal(filler);
        } else if (filler.startsWith("infcomp:")) {
            flag = CheckInfComp.IsLegal(filler);
        } else if (filler.startsWith("ingcomp:")) {
            flag = CheckIngComp.IsLegal(filler);
        } else if (filler.startsWith("pphr(")) {
            flag = CheckPphr.IsLegal(filler);
        }
        return flag;
    }

    static {
        filler1_.add("np");
        filler2_.add("adj");
        filler2_.add("advbl");
        filler2_.add("np");
    }
}

