/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.ToGetUnicodeNames;
import gov.nih.nlm.nls.lvg.Flows.ToGetUnicodeSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToUnicodeCoreNorm;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.Hashtable;
import java.util.Vector;

public class ToNormUnicodeWithSynonym
extends Transformation
implements Cloneable {
    private static final String INFO = "Unicode Norm With Synonym option";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, Character> unicodeSynonymMap, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, String startTag, String endTag, boolean detailsFlag, boolean mutateFlag) {
        String synonymTerm = ToGetUnicodeSynonyms.GetUnicodeSynonym(in.GetSourceTerm(), unicodeSynonymMap);
        String coreNormTerm = ToUnicodeCoreNorm.GetCoreNormStr(synonymTerm, symbolMap, unicodeMap, ligatureMap, diacriticMap);
        String term = ToGetUnicodeNames.GetUnicodeName(coreNormTerm, startTag, endTag);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToNormUnicodeWithSynonym.UpdateLexItem(in, term, 56, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToNormUnicodeWithSynonym.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, Character> unicodeSynonyms = ToGetUnicodeSynonyms.GetUnicodeSynonymMapFromFile(conf);
        Hashtable<Character, String> symbolMap = ToMapSymbolToAscii.GetSymbolMapFromFile(conf);
        Hashtable<Character, String> unicodeMap = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf);
        Hashtable<Character, String> ligatureMap = ToSplitLigatures.GetLigatureMapFromFile(conf);
        Hashtable<Character, Character> diacriticMap = ToStripDiacritics.GetDiacriticMapFromFile(conf);
        String startTag = conf.GetConfiguration("START_TAG");
        String endTag = conf.GetConfiguration("END_TAG");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToNormUnicodeWithSynonym.Mutate(in, unicodeSynonyms, symbolMap, unicodeMap, ligatureMap, diacriticMap, startTag, endTag, true, true);
        ToNormUnicodeWithSynonym.PrintResults(in, outs);
    }
}

