/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToRemoveGenitive
extends Transformation
implements Cloneable {
    private static final String INFO = "Remove Genitive";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToRemoveGenitive.RemoveGenitiveFromString(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToRemoveGenitive.UpdateLexItem(in, term, 3, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToRemoveGenitive.GetTestStr(args, "Downs' Syndrome");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToRemoveGenitive.Mutate(in, true, true);
        ToRemoveGenitive.PrintResults(in, outs);
    }

    private static String RemoveGenitiveFromString(String inStr) {
        StringTokenizer buf = new StringTokenizer(inStr, " \t,", true);
        String word = null;
        Vector<String> strList = new Vector<String>();
        while (buf.hasMoreTokens()) {
            word = ToRemoveGenitive.RemoveGenitiveFromWord(buf.nextToken());
            strList.addElement(word);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            buffer.append((String)strList.elementAt(i));
        }
        String out = buffer.toString();
        return out.trim();
    }

    private static String RemoveGenitiveFromWord(String inWord) {
        String out = inWord;
        int size = out.length();
        if (size < 3) {
            return out;
        }
        out = ToRemoveGenitive.RemoveLastChars(out, "s'", 1);
        out = ToRemoveGenitive.RemoveLastChars(out, "x'", 1);
        out = ToRemoveGenitive.RemoveLastChars(out, "z'", 1);
        out = ToRemoveGenitive.RemoveLastChars(out, "'s", 2);
        return out;
    }

    private static String RemoveLastChars(String inStr, String chars, int s) {
        int size = inStr.length();
        int cSize = chars.length();
        int index = inStr.toLowerCase().lastIndexOf(chars);
        int i = 0;
        while (index == size - cSize && index > 0) {
            inStr = inStr.substring(0, index + cSize - s);
            size = inStr.length();
            index = inStr.toLowerCase().lastIndexOf(chars);
            ++i;
        }
        return inStr;
    }

    private static boolean IsMoved(int oldSize, int newSize) {
        return oldSize != newSize;
    }
}

