/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSynonym;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToSynonyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Synonyms";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        Vector<SynonymRecord> records = ToSynonyms.GetSynonyms(in.GetSourceTerm(), conn);
        long inCat = in.GetSourceCategory().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < records.size(); ++i) {
            SynonymRecord record = records.elementAt(i);
            String term = record.GetSynonym();
            long curCat = record.GetCat1();
            if (!InputFilter.IsLegal(inCat, curCat)) continue;
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetFieldSeparator();
                mutate = "FACT" + fs + record.GetKeyFormNpLc() + fs + record.GetKeyForm() + fs + Category.ToName(record.GetCat1()) + fs + record.GetSynonym() + fs + Category.ToName(record.GetCat2()) + fs;
            }
            LexItem temp = ToSynonyms.UpdateLexItem(in, term, 28, record.GetCat2(), Inflection.GetBitValue(0), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToSynonyms.GetTestStr(args, "aminophylline");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToSynonyms.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToSynonyms.PrintResults(in, outs);
    }

    private static Vector<SynonymRecord> GetSynonyms(String inStr, Connection conn) {
        String strippedStr = ToStripPunctuation.StripPunctuation(inStr);
        String lcStrippedStr = strippedStr.toLowerCase();
        Vector<SynonymRecord> out = new Vector<SynonymRecord>();
        try {
            out = DbSynonym.GetSynonyms(lcStrippedStr, conn);
        }
        catch (SQLException e) {
            // empty catch block
        }
        return out;
    }
}

