/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToWordSize
extends Transformation
implements Cloneable {
    private static final String INFO = "Word Size Filter";

    public static Vector<LexItem> Mutate(LexItem in, int wordSize, boolean detailsFlag, boolean mutateFlag) {
        String term = ToWordSize.WordSizeFilter(in.GetSourceTerm(), wordSize);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToWordSize.UpdateLexItem(in, term, 48, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToWordSize.GetTestStr(args, "This is a test.");
        int wordsize = 3;
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToWordSize.Mutate(in, wordsize, true, true);
        ToWordSize.PrintResults(in, outs);
    }

    private static String WordSizeFilter(String inStr, int wordSize) {
        String delim = " \t";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        StringBuffer buffer = new StringBuffer();
        while (buf.hasMoreTokens()) {
            String cur = buf.nextToken();
            if (cur.length() < wordSize) continue;
            buffer.append(cur);
            buffer.append(" ");
        }
        String out = buffer.toString();
        return out.trim();
    }
}

