/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import gov.nih.nlm.nls.lvg.Util.Char;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class Word {
    private static final String catelogSeparators_ = ".-/";

    public static boolean IsCatelogNumber(String inWord) {
        boolean isCatelog = true;
        StringTokenizer buf = new StringTokenizer(inWord, catelogSeparators_);
        while (buf.hasMoreTokens()) {
            String temp = buf.nextToken();
            if (Word.IsDigitWord(temp)) continue;
            isCatelog = false;
            break;
        }
        return isCatelog;
    }

    public static boolean IsDate(String inWord) {
        boolean isDate = Word.IsDate(inWord, "d/M/yy") || Word.IsDate(inWord, "d.M.yy") || Word.IsDate(inWord, "d-M-yy");
        return isDate;
    }

    public static boolean IsFloat(String inWord) {
        boolean isFloat = false;
        try {
            Float.parseFloat(inWord);
            isFloat = true;
        }
        catch (NumberFormatException e) {
            isFloat = false;
        }
        return isFloat;
    }

    public static boolean HasPunctuation(String inWord) {
        boolean hasPunctuation = false;
        for (int i = 0; i < inWord.length(); ++i) {
            if (!Char.IsPunctuation(inWord.charAt(i))) continue;
            hasPunctuation = true;
            break;
        }
        return hasPunctuation;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("** Usage: java Word <inStr>");
        } else {
            String inStr = args[0];
            System.out.println("-- inStr: " + inStr);
            System.out.println("-- HasPunctuation: " + Word.HasPunctuation(inStr));
            System.out.println("-- IsCatelog: " + Word.IsCatelogNumber(inStr));
            System.out.println("-- IsFloat: " + Word.IsFloat(inStr));
            System.out.println("-- IsDate: " + Word.IsDate(inStr));
        }
    }

    private static boolean IsDate(String inWord, String pattern) {
        boolean isDate = false;
        try {
            SimpleDateFormat foo = new SimpleDateFormat(pattern);
            foo.parse(inWord);
            isDate = true;
        }
        catch (ParseException e) {
            isDate = false;
        }
        return isDate;
    }

    private static boolean IsDigitWord(String inWord) {
        boolean isDigitWord = true;
        for (int i = 0; i < inWord.length(); ++i) {
            char temp = inWord.charAt(i);
            if (Character.isDigit(temp)) continue;
            isDigitWord = false;
            break;
        }
        return isDigitWord;
    }
}

