/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    private static final int[] defaultLimits = new int[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    Expression queryCondition;
    Expression checkQueryCondition;
    private Expression havingCondition;
    Expression rowExpression;
    Expression[] exprColumns;
    private HsqlArrayList exprColumnList;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int groupByColumnCount;
    private int havingColumnCount;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean hasMemoryRow;
    public boolean isUniqueResultRows;
    private boolean simpleLimit = true;
    Type[] columnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    private OrderedHashSet conditionTables;
    public Index groupIndex;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext) {
        this(compileContext);
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        rangeVariable.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(rangeVariable);
        this.isMergeable = false;
        this.resolveReferences(session);
        this.resolveTypes(session);
        this.sortAndSlice = SortAndSlice.noSort;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.compileContext = compileContext;
        this.resultRangePosition = compileContext.getNextRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isMergeable = true;
    }

    void addRangeVariable(RangeVariable rangeVariable) {
        this.rangeVariableList.add(rangeVariable);
    }

    private void resolveRangeVariables(Session session) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTable(session, this.rangeVariables, i);
        }
    }

    void addSelectColumnExpression(Expression expression) {
        if (expression.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (expression.opType == 97 && ((ExpressionColumn)expression).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression expression2 = (Expression)this.exprColumnList.get(0);
            if (expression2.opType == 97 && ((ExpressionColumn)expression2).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(expression);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression expression) {
        this.queryCondition = expression;
    }

    void addGroupByColumnExpression(Expression expression) {
        if (expression.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(expression);
        this.isGrouped = true;
        ++this.groupByColumnCount;
    }

    void addHavingExpression(Expression expression) {
        this.exprColumnList.add(expression);
        this.havingCondition = expression;
        this.havingColumnCount = 1;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session) {
        this.resolveRangeVariables(session);
        this.resolveColumnReferencesForAsterisk();
        this.finaliseColumns();
        this.resolveColumnReferences();
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.setReferenceableColumns();
    }

    private void resolveColumnReferences() {
        int n;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            Expression expression = this.rangeVariables[n].getJoinCondition();
            if (expression == null) continue;
            this.resolveColumnReferencesAndAllocate(expression, n + 1, false);
        }
        this.resolveColumnReferencesAndAllocate(this.queryCondition, this.rangeVariables.length, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            this.resolveColumnReferencesAndAllocate(this.exprColumns[n], this.rangeVariables.length, this.acceptsSequences);
        }
        for (n = this.indexLimitVisible; n < this.indexStartHaving; ++n) {
            this.exprColumns[n] = this.resolveColumnReferencesInGroupBy(this.exprColumns[n]);
        }
        for (n = this.indexStartHaving; n < this.indexStartOrderBy; ++n) {
            this.resolveColumnReferencesAndAllocate(this.exprColumns[n], this.rangeVariables.length, false);
        }
        this.resolveColumnRefernecesInOrderBy(this.sortAndSlice);
    }

    void resolveColumnRefernecesInOrderBy(SortAndSlice sortAndSlice) {
        int n = sortAndSlice.getOrderLength();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(expressionOrderBy);
            if (expressionOrderBy.getLeftNode().queryTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && expressionOrderBy.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            expressionOrderBy.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(expressionOrderBy, this.rangeVariables.length, false);
            if (!this.isAggregated && !this.isGrouped || (bl = expressionOrderBy.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        sortAndSlice.prepare(this);
    }

    private boolean resolveColumnReferences(Expression expression, int n, boolean bl) {
        if (expression == null) {
            return true;
        }
        int n2 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = expression.resolveColumnReferences(this.rangeVariables, n, this.unresolvedExpressions, bl);
        int n3 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return n2 == n3;
    }

    private void resolveColumnReferencesForAsterisk() {
        int n = 0;
        while (n < this.indexLimitVisible) {
            Expression expression = (Expression)this.exprColumnList.get(n);
            if (expression.getType() == 97) {
                int n2;
                this.exprColumnList.remove(n);
                String string = ((ExpressionColumn)expression).getTableName();
                if (string == null) {
                    this.addAllJoinedColumns(expression);
                } else {
                    n2 = expression.findMatchingRangeVariableIndex(this.rangeVariables);
                    if (n2 == -1) {
                        throw Error.error(5501, string);
                    }
                    RangeVariable rangeVariable = this.rangeVariables[n2];
                    HashSet hashSet = this.getAllNamedJoinColumns();
                    rangeVariable.addTableColumns(expression, hashSet);
                }
                for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                    this.exprColumnList.add(n, expression.nodes[n2]);
                    ++n;
                }
                this.indexLimitVisible += expression.nodes.length - 1;
                continue;
            }
            ++n;
        }
    }

    private void resolveColumnReferencesAndAllocate(Expression expression, int n, boolean bl) {
        if (expression == null) {
            return;
        }
        HsqlList hsqlList = expression.resolveColumnReferences(this.rangeVariables, n, null, bl);
        if (hsqlList != null) {
            for (int i = 0; i < hsqlList.size(); ++i) {
                Expression expression2 = (Expression)hsqlList.get(i);
                boolean bl2 = expression2.isSelfAggregate() ? this.resolveColumnReferences(expression2.getLeftNode(), n, false) : this.resolveColumnReferences(expression2, n, bl);
                if (bl2) {
                    if (expression2.isSelfAggregate()) {
                        if (this.aggregateSet == null) {
                            this.aggregateSet = new ArrayListIdentity();
                        }
                        this.aggregateSet.add(expression2);
                        this.isAggregated = true;
                        expression.setAggregate();
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(expression2);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(expression2);
            }
        }
    }

    private Expression resolveColumnReferencesInGroupBy(Expression expression) {
        if (expression == null) {
            return null;
        }
        HsqlList hsqlList = expression.resolveColumnReferences(this.rangeVariables, this.rangeVariables.length, null, false);
        if (hsqlList != null) {
            Expression expression2;
            if (expression.getType() == 2 && (expression2 = expression.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible)) != expression) {
                return expression2;
            }
            this.resolveColumnReferencesAndAllocate(expression, this.rangeVariables.length, false);
        }
        return expression;
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet hashSet = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable rangeVariable = (RangeVariable)this.rangeVariableList.get(i);
            if (rangeVariable.namedJoinColumns == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(rangeVariable.namedJoinColumns);
        }
        return hashSet;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        HashSet hashSet = new HashSet();
        Expression expression = null;
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable rangeVariable2 = (RangeVariable)this.rangeVariableList.get(i);
            HashMappedList hashMappedList = rangeVariable2.rangeTable.columnList;
            for (int j = 0; j < hashMappedList.size(); ++j) {
                boolean bl2;
                ColumnSchema columnSchema = (ColumnSchema)hashMappedList.get(j);
                String string = rangeVariable2.getColumnAlias(j);
                boolean bl3 = orderedHashSet.contains(string);
                boolean bl4 = rangeVariable2.namedJoinColumns != null && rangeVariable2.namedJoinColumns.contains(string);
                boolean bl5 = bl2 = !bl4 && !hashSet.add(string);
                if (bl2 && (!bl || bl3)) {
                    throw Error.error(5578, string);
                }
                if (!bl3) continue;
                orderedHashSet2.add(string);
                int n = rangeVariable2.rangeTable.getColumnIndex(columnSchema.getNameString());
                int n2 = rangeVariable.rangeTable.getColumnIndex(string);
                ExpressionLogical expressionLogical = new ExpressionLogical(rangeVariable2, n, rangeVariable, n2);
                expression = ExpressionLogical.andExpressions(expression, expressionLogical);
                ExpressionColumn expressionColumn = rangeVariable2.getColumnExpression(string);
                if (expressionColumn == null) {
                    expressionColumn = new ExpressionColumn(new Expression[]{expressionLogical.getLeftNode(), expressionLogical.getRightNode()}, string);
                    rangeVariable2.addNamedJoinColumnExpression(string, expressionColumn);
                } else {
                    expressionColumn.nodes = (Expression[])ArrayUtil.resizeArray(expressionColumn.nodes, expressionColumn.nodes.length + 1);
                    expressionColumn.nodes[expressionColumn.nodes.length - 1] = expressionLogical.getRightNode();
                }
                rangeVariable.addNamedJoinColumnExpression(string, expressionColumn);
            }
        }
        if (bl && !orderedHashSet2.containsAll(orderedHashSet)) {
            throw Error.error(5501);
        }
        rangeVariable.addNamedJoinColumns(orderedHashSet2);
        return expression;
    }

    private void addAllJoinedColumns(Expression expression) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(hsqlArrayList);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    private void finaliseColumns() {
        int n;
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        for (n = 0; n < this.indexLimitVisible; ++n) {
            this.exprColumns[n].queryTableColumnIndex = n;
        }
        if (this.sortAndSlice.hasOrder()) {
            for (n = 0; n < this.sortAndSlice.getOrderLength(); ++n) {
                this.exprColumns[this.indexStartOrderBy + n] = (Expression)this.sortAndSlice.exprList.get(n);
            }
        }
        this.rowExpression = new Expression(25, this.exprColumns);
    }

    private void replaceColumnIndexInOrderBy(Expression expression) {
        int n;
        Expression expression2 = expression.getLeftNode();
        if (expression2.getType() != 1) {
            return;
        }
        if (expression2.getDataType().typeCode == 4 && 0 < (n = ((Integer)expression2.getValue(null)).intValue()) && n <= this.indexLimitVisible) {
            expression.setLeftNode(this.exprColumns[n - 1]);
            return;
        }
        throw Error.error(5576);
    }

    void collectRangeVariables(RangeVariable[] rangeVariableArray, Set set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectRangeVariables(rangeVariableArray, set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectRangeVariables(rangeVariableArray, set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectRangeVariables(rangeVariableArray, set);
        }
    }

    @Override
    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    public void resolveExpressionTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            Expression expression2 = this.exprColumns[n];
            expression2.resolveTypes(session, expression);
            if (expression2.getType() != 25) continue;
            throw Error.error(5564);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            Expression expression3 = this.rangeVariables[n].getJoinCondition();
            if (expression3 == null) continue;
            expression3.resolveTypes(session, null);
            if (expression3.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingCondition != null) {
            this.havingCondition.resolveTypes(session, null);
            if (this.havingCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int n = this.indexStartAggregates;
            int n2 = 0;
            while (n < this.indexLimitExpressions) {
                Expression expression = (Expression)this.tempSet.get(n2);
                this.exprColumns[n] = expression.duplicate();
                this.exprColumns[n].nodes = expression.nodes;
                this.exprColumns[n].dataType = expression.dataType;
                ++n;
                ++n2;
            }
            this.tempSet.clear();
        }
    }

    @Override
    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeVariableResolver = new RangeVariableResolver(this.rangeVariables, this.queryCondition, this.compileContext);
        rangeVariableResolver.processConditions(session);
        this.rangeVariables = rangeVariableResolver.rangeVariables;
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
    }

    @Override
    void resolveTypesPartOne(Session session) {
        this.resolveExpressionTypes(session, this.rowExpression);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int n;
        this.resolveGroups();
        for (n = 0; n < this.unionColumnTypes.length; ++n) {
            Type type = this.unionColumnTypes[n];
            if (type == null) {
                throw Error.error(5567);
            }
            this.exprColumns[n].setDataType(session, type);
        }
        for (n = 0; n < this.indexStartHaving; ++n) {
            if (this.exprColumns[n].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability();
        this.createResultMetaData();
        this.createTable(session);
        if (this.isMergeable) {
            this.mergeQuery();
        }
        this.setRangeVariableConditions(session);
        if (this.isAggregated && !this.isGrouped && !this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression expression = this.exprColumns[this.indexStartAggregates];
            int n2 = expression.getType();
            switch (n2) {
                case 73: 
                case 74: {
                    SortAndSlice sortAndSlice = new SortAndSlice();
                    sortAndSlice.isGenerated = true;
                    sortAndSlice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!sortAndSlice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = sortAndSlice;
                    break;
                }
                case 71: {
                    if (this.rangeVariables.length != 1 || this.queryCondition != null || expression.getLeftNode().getType() != 9) break;
                    this.isSimpleCount = true;
                }
            }
        }
        this.sortAndSlice.setSortRange(this);
        this.isResolved = true;
    }

    void checkLobUsage() {
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (!this.exprColumns[i].dataType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private void resolveGroups() {
        int n;
        Expression expression;
        Expression expression2;
        int n2;
        Expression expression3;
        int n3;
        int n4;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, Expression.aggregateFunctionSet, Expression.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                if (this.exprColumns[n4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, Expression.subqueryAggregateExpressionSet)) continue;
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (!this.tempSet.isEmpty() && !this.resolveForGroupBy(this.tempSet)) {
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        } else if (this.isAggregated) {
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, Expression.columnExpressionSet, Expression.aggregateFunctionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        }
        this.tempSet.clear();
        if (this.havingCondition != null) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (!this.havingCondition.isComposedOf(this.tempSet, Expression.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression3 = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression3.queryTableColumnIndex != -1 || expression3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression3 = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression3.queryTableColumnIndex != -1 || expression3.isAggregate() || expression3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isDistinctSelect || this.isGrouped) {
            this.simpleLimit = false;
        }
        if (!this.isAggregated) {
            return;
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        for (n2 = this.indexStartAggregates; n2 < this.indexLimitExpressions; ++n2) {
            expression2 = this.exprColumns[n2];
            expression = new ExpressionColumn(expression2, n2, this.resultRangePosition);
            orderedHashSet.add(expression2);
            orderedHashSet2.add(expression);
        }
        for (n2 = 0; n2 < this.indexStartHaving; ++n2) {
            if (this.exprColumns[n2].isAggregate() || !orderedHashSet.add(expression2 = this.exprColumns[n2])) continue;
            expression = new ExpressionColumn(expression2, n2, this.resultRangePosition);
            orderedHashSet2.add(expression);
        }
        n2 = this.sortAndSlice.getOrderLength();
        for (n = 0; n < n2; ++n) {
            expression = (Expression)this.sortAndSlice.exprList.get(n);
            if (!expression.getLeftNode().isAggregate()) continue;
            expression.setAggregate();
        }
        for (n = this.indexStartOrderBy; n < this.indexStartAggregates; ++n) {
            if (!this.exprColumns[n].getLeftNode().isAggregate()) continue;
            this.exprColumns[n].setAggregate();
        }
        for (n = 0; n < this.indexStartAggregates; ++n) {
            expression = this.exprColumns[n];
            if (!expression.isAggregate() && !expression.isCorrelated()) continue;
            this.aggregateCheck[n] = true;
            if (!expression.isAggregate()) continue;
            expression.convertToSimpleColumn(orderedHashSet, orderedHashSet2);
        }
        for (n = 0; n < this.aggregateSet.size(); ++n) {
            expression = (Expression)this.aggregateSet.get(n);
            expression.convertToSimpleColumn(orderedHashSet, orderedHashSet2);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (n = 0; n < this.resolvedSubqueryExpressions.size(); ++n) {
                expression = (Expression)this.resolvedSubqueryExpressions.get(n);
                expression.convertToSimpleColumn(orderedHashSet, orderedHashSet2);
            }
        }
    }

    boolean resolveForGroupBy(HsqlList hsqlList) {
        Cloneable cloneable;
        Cloneable cloneable2;
        int n;
        for (n = this.indexLimitVisible; n < this.indexLimitVisible + this.groupByColumnCount; ++n) {
            cloneable2 = this.exprColumns[n];
            if (((Expression)cloneable2).getType() != 2) continue;
            cloneable = ((Expression)cloneable2).getRangeVariable();
            int n2 = ((Expression)cloneable2).getColumnIndex();
            ((RangeVariable)cloneable).columnsInGroupBy[n2] = true;
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            cloneable2 = this.rangeVariables[n];
            ((RangeVariable)cloneable2).hasKeyedColumnInGroupBy = ((RangeVariable)cloneable2).rangeTable.getUniqueNotNullColumnGroup(((RangeVariable)cloneable2).columnsInGroupBy) != null;
        }
        OrderedHashSet orderedHashSet = null;
        for (int i = 0; i < hsqlList.size(); ++i) {
            cloneable = (Expression)hsqlList.get(i);
            orderedHashSet = ((Expression)cloneable).getUnkeyedColumns(orderedHashSet);
        }
        return orderedHashSet == null;
    }

    int[] getLimits(Session session, int n) {
        int[] nArray;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        boolean bl = false;
        if (this.sortAndSlice.hasLimit()) {
            Integer n5 = (Integer)this.sortAndSlice.limitCondition.getLeftNode().getValue(session);
            if (n5 == null || n5 < 0) {
                throw Error.error(3453);
            }
            n2 = n5;
            boolean bl2 = bl = n2 != 0;
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                n5 = (Integer)this.sortAndSlice.limitCondition.getRightNode().getValue(session);
                if (n5 == null || n5 <= 0) {
                    throw Error.error(3452);
                }
                if (n5 == 0) {
                    n3 = Integer.MAX_VALUE;
                } else {
                    n3 = n5;
                    bl = true;
                }
            }
        }
        if (n != 0) {
            if (n < n3) {
                n3 = n;
            }
            bl = true;
        }
        if (bl && this.simpleLimit && (!this.sortAndSlice.hasOrder() || this.sortAndSlice.skipSort) && (!this.sortAndSlice.hasLimit() || this.sortAndSlice.skipFullResult) && n4 - n2 > n3) {
            n4 = n2 + n3;
        }
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = n2;
            nArray2[1] = n3;
            nArray = nArray2;
            nArray2[2] = n4;
        } else {
            nArray = defaultLimits;
        }
        return nArray;
    }

    @Override
    Result getResult(Session session, int n) {
        Result result = this.getSingleResult(session, n);
        result.getNavigator().reset();
        return result;
    }

    private Result getSingleResult(Session session, int n) {
        int[] nArray = this.getLimits(session, n);
        Result result = this.buildResult(session, nArray[2]);
        RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
        if (this.isDistinctSelect) {
            rowSetNavigatorData.removeDuplicates();
        }
        if (this.sortAndSlice.hasOrder()) {
            rowSetNavigatorData.sortOrder();
        }
        if (nArray != defaultLimits) {
            rowSetNavigatorData.trim(nArray[0], nArray[1]);
        }
        return result;
    }

    private Result buildResult(Session session, int n) {
        int n2;
        RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, this);
        Result result = Result.newResult(rowSetNavigatorData);
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        if (this.isSimpleCount) {
            Object[] objectArray = new Object[this.indexLimitData];
            Table table = this.rangeVariables[0].getTable();
            PersistentStore persistentStore = table.getRowStore(session);
            int n3 = table.getIndex(0).size(session, persistentStore);
            objectArray[0] = objectArray[this.indexStartAggregates] = ValuePool.getInt(n3);
            rowSetNavigatorData.add(objectArray);
            return result;
        }
        int n4 = 0;
        RangeIterator[] rangeIteratorArray = new RangeIterator[this.rangeVariables.length];
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            rangeIteratorArray[n2] = this.rangeVariables[n2].getIterator(session);
        }
        n2 = 0;
        while (true) {
            int n5;
            int n6;
            RangeIterator rangeIterator;
            if (n2 < n4) {
                boolean bl = true;
                for (int i = n4 + 1; i < this.rangeVariables.length; ++i) {
                    if (!this.rangeVariables[i].isRightJoin) continue;
                    n4 = i;
                    n2 = i;
                    bl = false;
                    ((RangeVariable.RangeIteratorRight)rangeIteratorArray[i]).setOnOuterRows();
                    break;
                }
                if (bl) break;
            }
            if ((rangeIterator = rangeIteratorArray[n2]).next()) {
                if (n2 < this.rangeVariables.length - 1) {
                    ++n2;
                    continue;
                }
            } else {
                rangeIterator.reset();
                --n2;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] objectArray = new Object[this.indexLimitData];
            for (n6 = 0; n6 < this.indexStartAggregates; ++n6) {
                if (this.isAggregated && this.aggregateCheck[n6]) continue;
                objectArray[n6] = this.exprColumns[n6].getValue(session);
            }
            for (n6 = this.indexLimitVisible; n6 < this.indexLimitRowId; ++n6) {
                objectArray[n6] = n6 == this.indexLimitVisible ? rangeIterator.getRowidObject() : rangeIterator.getCurrentRow();
            }
            Object[] objectArray2 = null;
            if ((this.isAggregated || this.isGrouped) && (objectArray2 = rowSetNavigatorData.getGroupData(objectArray)) != null) {
                objectArray = objectArray2;
            }
            for (n5 = this.indexStartAggregates; n5 < this.indexLimitExpressions; ++n5) {
                objectArray[n5] = this.exprColumns[n5].updateAggregatingValue(session, objectArray[n5]);
            }
            if (objectArray2 == null) {
                rowSetNavigatorData.add(objectArray);
            } else if (this.isAggregated) {
                rowSetNavigatorData.update(objectArray2, objectArray);
            }
            n5 = rowSetNavigatorData.getSize();
            if (n5 == session.resultMaxMemoryRows && !this.isAggregated && !this.hasMemoryRow) {
                rowSetNavigatorData = new RowSetNavigatorDataTable(session, this, rowSetNavigatorData);
                result.setNavigator(rowSetNavigatorData);
            }
            if ((!this.isAggregated && !this.isGrouped || this.sortAndSlice.isGenerated) && n5 >= n) break;
        }
        rowSetNavigatorData.reset();
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            rangeIteratorArray[n2].reset();
        }
        if (!this.isGrouped && !this.isAggregated) {
            return result;
        }
        if (this.isAggregated) {
            if (!this.isGrouped && rowSetNavigatorData.getSize() == 0) {
                Object[] objectArray = new Object[this.exprColumns.length];
                rowSetNavigatorData.add(objectArray);
            }
            rowSetNavigatorData.reset();
            session.sessionContext.setRangeIterator(rowSetNavigatorData);
            while (rowSetNavigatorData.next()) {
                int n7;
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                for (n7 = this.indexStartAggregates; n7 < this.indexLimitExpressions; ++n7) {
                    objectArray[n7] = this.exprColumns[n7].getAggregatedValue(session, objectArray[n7]);
                }
                for (n7 = 0; n7 < this.indexStartAggregates; ++n7) {
                    if (!this.aggregateCheck[n7]) continue;
                    objectArray[n7] = this.exprColumns[n7].getValue(session);
                }
            }
        }
        rowSetNavigatorData.reset();
        if (this.havingCondition != null) {
            while (rowSetNavigatorData.hasNext()) {
                Object[] objectArray = rowSetNavigatorData.getNext();
                if (Boolean.TRUE.equals(objectArray[this.indexLimitVisible + this.groupByColumnCount])) continue;
                rowSetNavigatorData.remove();
            }
            rowSetNavigatorData.reset();
        }
        return result;
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String string = expression.getAlias();
            if (string.length() == 0) {
                HsqlNameManager.HsqlName hsqlName = HsqlNameManager.getAutoColumnName(i);
                expression.setAlias(hsqlName);
                continue;
            }
            int n = intValueHashMap.get((Object)string, -1);
            if (n == -1) {
                intValueHashMap.put(string, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[n] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] simpleNameArray) {
        if (simpleNameArray.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(simpleNameArray[i]);
        }
    }

    private void createResultMetaData() {
        Expression expression;
        int n;
        this.columnTypes = new Type[this.indexLimitData];
        for (n = 0; n < this.indexStartAggregates; ++n) {
            expression = this.exprColumns[n];
            this.columnTypes[n] = expression.getDataType();
        }
        for (n = this.indexLimitVisible; n < this.indexLimitRowId; ++n) {
            this.columnTypes[n] = n == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (n = this.indexLimitRowId; n < this.indexLimitData; ++n) {
            expression = this.exprColumns[n];
            this.columnTypes[n] = expression.getDataType();
        }
        this.resultMetaData = ResultMetaData.newResultMetaData(this.columnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (n = 0; n < this.indexLimitVisible; ++n) {
            expression = this.exprColumns[n];
            this.resultMetaData.columnTypes[n] = expression.getDataType();
            if (n >= this.indexLimitVisible) continue;
            ColumnBase columnBase = expression.getColumn();
            if (columnBase != null) {
                this.resultMetaData.columns[n] = columnBase;
                this.resultMetaData.columnLabels[n] = expression.getAlias();
                continue;
            }
            columnBase = new ColumnBase();
            columnBase.setType(expression.getDataType());
            this.resultMetaData.columns[n] = columnBase;
            this.resultMetaData.columnLabels[n] = expression.getAlias();
        }
    }

    @Override
    void createTable(Session session) {
        int[] nArray;
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.resultTable.createAndAddIndexStructure(session, null, this.sortAndSlice.sortOrder, this.sortAndSlice.sortDescending, this.sortAndSlice.sortNullsLast, false, false, false);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                nArray[i] = this.indexLimitVisible + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            nArray = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        }
    }

    void createFullIndex(Session session) {
        int[] nArray = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n = this.persistenceScope == 21 ? 2 : 9;
        HashMappedList hashMappedList = new HashMappedList();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = expression.getSimpleName();
            String string = simpleName.name;
            HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newColumnSchemaHsqlName(hsqlName, simpleName);
            if (!this.accessibleColumns[i]) {
                string = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName2, expression.dataType, true, false, null);
            hashMappedList.add(string, columnSchema);
        }
        try {
            this.resultTable = new TableDerived(session.database, hsqlName, n, this.columnTypes, hashMappedList, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        int n2 = this.indexLimitVisible;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.exprColumns[n].getSQL());
        }
        stringBuffer.append("FROM");
        n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (n > 0) {
                if (rangeVariable.isLeftJoin && rangeVariable.isRightJoin) {
                    stringBuffer.append("FULL").append(' ');
                } else if (rangeVariable.isLeftJoin) {
                    stringBuffer.append("LEFT").append(' ');
                } else if (rangeVariable.isRightJoin) {
                    stringBuffer.append("RIGHT").append(' ');
                }
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(rangeVariable.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            stringBuffer.append(' ').append("GROUP").append(' ').append("BY");
            n2 = this.indexLimitVisible + this.groupByColumnCount;
            for (n = this.indexLimitVisible; n < n2; ++n) {
                stringBuffer.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (this.havingCondition != null) {
            stringBuffer.append(' ').append("HAVING").append(' ');
            stringBuffer.append(this.havingCondition.getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            n2 = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
            for (n = this.indexStartOrderBy; n < n2; ++n) {
                stringBuffer.append(this.exprColumns[n].getSQL());
                if (n >= n2 - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            stringBuffer.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return stringBuffer.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session, int n) {
        String string;
        int n2;
        int n3;
        String string2 = ValuePool.spaceString.substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append(string2).append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append(string2).append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append(string2).append("columns=[");
        for (n3 = 0; n3 < this.indexLimitVisible; ++n3) {
            n2 = n3;
            if (this.exprColumns[n3].getType() == 5) {
                n2 = this.exprColumns[n3].columnIndex;
            }
            stringBuffer.append(string2).append(this.exprColumns[n2].describe(session, 2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(string2).append("]\n");
        for (n3 = 0; n3 < this.rangeVariables.length; ++n3) {
            stringBuffer.append(string2).append("[");
            stringBuffer.append("range variable ").append(n3 + 1).append("\n");
            stringBuffer.append(this.rangeVariables[n3].describe(session, n + 2));
            stringBuffer.append(string2).append("]");
        }
        stringBuffer.append(string2).append("]\n");
        String string3 = string = this.queryCondition == null ? "null" : this.queryCondition.describe(session, n);
        if (this.isGrouped) {
            stringBuffer.append(string2).append("groupColumns=[");
            for (n3 = this.indexLimitRowId; n3 < this.indexLimitRowId + this.groupByColumnCount; ++n3) {
                n2 = n3;
                if (this.exprColumns[n3].getType() == 5) {
                    n2 = this.exprColumns[n3].columnIndex;
                }
                stringBuffer.append(this.exprColumns[n2].describe(session, n));
            }
            stringBuffer.append(string2).append("]\n");
        }
        if (this.havingCondition != null) {
            string = this.havingCondition.describe(session, n);
            stringBuffer.append(string2).append("havingCondition=[").append(string).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            stringBuffer.append(string2).append("order by=[\n");
            for (n3 = 0; n3 < this.sortAndSlice.exprList.size(); ++n3) {
                stringBuffer.append(string2).append(((Expression)this.sortAndSlice.exprList.get(n3)).describe(session, n));
                stringBuffer.append(string2).append("\n]");
            }
            stringBuffer.append(string2).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                stringBuffer.append(string2).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, 0)).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                stringBuffer.append(string2).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, 0)).append("]\n");
            }
        }
        return stringBuffer.toString();
    }

    void setMergeability() {
        if (this.isGrouped || this.isDistinctSelect) {
            this.isMergeable = false;
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            this.isMergeable = false;
            return;
        }
        if (this.rangeVariables.length != 1) {
            this.isMergeable = false;
            return;
        }
    }

    void setUpdatability() {
        String string;
        Object object;
        int n;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (!this.isMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            return;
        }
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Table table2 = table.getBaseTable();
        if (table2 == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        int[] nArray = table.getBaseTableColumnMap();
        int[] nArray2 = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(table2.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (n = 0; n < this.indexLimitVisible; ++n) {
            object = this.exprColumns[n];
            if (((Expression)object).getType() == 2) {
                string = ((Expression)object).getColumn().getName().name;
                if (intValueHashMap.containsKey(string)) {
                    intValueHashMap.put(string, 1);
                    continue;
                }
                intValueHashMap.put(string, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, (Expression)object);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (n = 0; n < this.indexLimitVisible; ++n) {
            if (this.accessibleColumns[n] && ((Expression)(object = this.exprColumns[n])).getType() == 2 && intValueHashMap.get(string = ((Expression)object).getColumn().getName().name) == 0) {
                int n2 = table.findColumn(string);
                nArray2[n] = nArray[n2];
                if (nArray2[n] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            nArray2[n] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] blArray = table2.getColumnCheckList(nArray2);
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n] || ((ColumnBase)(object = table2.getColumn(n))).isIdentity() || ((ColumnSchema)object).isGenerated() || ((ColumnSchema)object).hasDefault() || ((ColumnSchema)object).isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = nArray2;
            this.baseTable = table2;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!table2.isFileBased()) {
                ++this.indexLimitRowId;
                this.hasMemoryRow = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery() {
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Expression expression = this.queryCondition;
        if (table instanceof TableDerived) {
            QueryExpression queryExpression = ((TableDerived)table).getQueryExpression();
            if (queryExpression == null || !queryExpression.isMergeable) {
                this.isMergeable = false;
                return;
            }
            QuerySpecification querySpecification = queryExpression.getMainSelect();
            if (queryExpression.view == null) {
                this.rangeVariables[0] = querySpecification.rangeVariables[0];
                this.rangeVariables[0].resetConditions();
                Expression[] expressionArray = new Expression[this.indexLimitData];
                for (int i = 0; i < this.indexLimitData; ++i) {
                    Expression expression2 = this.exprColumns[i];
                    expressionArray[i] = expression2.replaceColumnReferences(rangeVariable, querySpecification.exprColumns);
                }
                this.exprColumns = expressionArray;
                if (expression != null) {
                    expression = expression.replaceColumnReferences(rangeVariable, querySpecification.exprColumns);
                }
                Expression expression3 = querySpecification.queryCondition;
                this.checkQueryCondition = querySpecification.checkQueryCondition;
                this.queryCondition = ExpressionLogical.andExpressions(expression3, expression);
            } else {
                Expression expression4;
                int n;
                RangeVariable[] rangeVariableArray = new RangeVariable[]{querySpecification.rangeVariables[0].duplicate()};
                Expression[] expressionArray = new Expression[querySpecification.indexLimitData];
                for (n = 0; n < querySpecification.indexLimitData; ++n) {
                    expressionArray[n] = expression4 = querySpecification.exprColumns[n].duplicate();
                    expression4.replaceRangeVariables(querySpecification.rangeVariables, rangeVariableArray);
                }
                for (n = 0; n < this.indexLimitData; ++n) {
                    expression4 = this.exprColumns[n];
                    this.exprColumns[n] = expression4.replaceColumnReferences(rangeVariable, expressionArray);
                }
                Expression expression5 = querySpecification.queryCondition;
                if (expression5 != null) {
                    expression5 = expression5.duplicate();
                    expression5.replaceRangeVariables(querySpecification.rangeVariables, rangeVariableArray);
                }
                if (expression != null) {
                    expression = expression.replaceColumnReferences(rangeVariable, expressionArray);
                }
                this.checkQueryCondition = querySpecification.checkQueryCondition;
                if (this.checkQueryCondition != null) {
                    this.checkQueryCondition = this.checkQueryCondition.duplicate();
                    this.checkQueryCondition.replaceRangeVariables(querySpecification.rangeVariables, rangeVariableArray);
                }
                this.queryCondition = ExpressionLogical.andExpressions(expression5, expression);
                this.rangeVariables = rangeVariableArray;
            }
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = expression;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet orderedHashSet, Expression expression) {
        expression.collectAllExpressions(orderedHashSet, Expression.subqueryExpressionSet, Expression.emptyExpressionSet);
        int n = orderedHashSet.size();
        for (int i = 0; i < n; ++i) {
            Expression expression2 = (Expression)orderedHashSet.get(i);
            expression2.collectObjectNames(orderedHashSet);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            orderedHashSet = this.exprColumns[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllSubqueries(orderedHashSet);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectAllSubqueries(orderedHashSet);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            OrderedHashSet orderedHashSet2 = this.rangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectAllSubqueries(OrderedHashSet orderedHashSet) {
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            orderedHashSet = this.exprColumns[i].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.havingCondition != null) {
            orderedHashSet = this.havingCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public void collectObjectNames(Set set) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectObjectNames(set);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            HsqlNameManager.HsqlName hsqlName = this.rangeVariables[n].getTable().getName();
            set.add(hsqlName);
        }
    }

    @Override
    public void replaceColumnReference(RangeVariable rangeVariable, Expression[] expressionArray) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceColumnReferences(rangeVariable, expressionArray);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n;
        for (n = 0; n < this.indexStartAggregates; ++n) {
            this.exprColumns[n].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        int n2 = this.rangeVariables.length;
        for (n = 0; n < n2; ++n) {
            this.rangeVariables[n].getSubqueries();
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            stringArray[i] = this.exprColumns[i].getAlias();
        }
        return stringArray;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.columnTypes.length == this.indexLimitVisible) {
            return this.columnTypes;
        }
        Type[] typeArray = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.columnTypes, typeArray, typeArray.length);
        return typeArray;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table table = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isReadOnly() || table.isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
    }

    @Override
    boolean isEquivalent(QueryExpression queryExpression) {
        if (!(queryExpression instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification querySpecification = (QuerySpecification)queryExpression;
        if (!Expression.equals(this.exprColumns, querySpecification.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, querySpecification.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != querySpecification.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == querySpecification.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }
}

