/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.NIHDBLexicon;

public class NIHLexiconXMLDumpUtil {
    private static String DB_FILENAME;
    private static String WORDLIST_FILENAME;
    private static String XML_FILENAME;

    public static void main(String[] args) {
        NIHDBLexicon lex = null;
        if (args.length == 3) {
            DB_FILENAME = args[0];
            WORDLIST_FILENAME = args[1];
            XML_FILENAME = args[2];
            boolean dbDriverAvaliable = false;
            try {
                Class<?> driverClass = Class.forName("org.hsqldb.jdbc.JDBCDriver", false, NIHLexiconXMLDumpUtil.class.getClassLoader());
                if (null != driverClass) {
                    dbDriverAvaliable = true;
                }
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("*** Please add the HSQLDB JDBCDriver to your Java classpath and try again.");
            }
            if (null != DB_FILENAME && !DB_FILENAME.isEmpty() && null != WORDLIST_FILENAME && !WORDLIST_FILENAME.isEmpty() && null != XML_FILENAME && !XML_FILENAME.isEmpty() && dbDriverAvaliable) {
                lex = new NIHDBLexicon(DB_FILENAME);
                try {
                    LineNumberReader wordListFile = new LineNumberReader(new FileReader(WORDLIST_FILENAME));
                    FileWriter xmlFile = new FileWriter(XML_FILENAME);
                    xmlFile.write(String.format("<lexicon>%n", new Object[0]));
                    String line = wordListFile.readLine();
                    while (line != null) {
                        String[] cols = line.split(",");
                        String base = cols[0];
                        String cat = cols[1];
                        WordElement word = null;
                        if (cat.equalsIgnoreCase("noun")) {
                            word = lex.getWord(base, LexicalCategory.NOUN);
                        } else if (cat.equalsIgnoreCase("verb")) {
                            word = lex.getWord(base, LexicalCategory.VERB);
                        } else if (cat.equalsIgnoreCase("adv")) {
                            word = lex.getWord(base, LexicalCategory.ADVERB);
                        } else if (cat.equalsIgnoreCase("adj")) {
                            word = lex.getWord(base, LexicalCategory.ADJECTIVE);
                        } else if (cat.equalsIgnoreCase("det")) {
                            word = lex.getWord(base, LexicalCategory.DETERMINER);
                        } else if (cat.equalsIgnoreCase("prep")) {
                            word = lex.getWord(base, LexicalCategory.PREPOSITION);
                        } else if (cat.equalsIgnoreCase("pron")) {
                            word = lex.getWord(base, LexicalCategory.PRONOUN);
                        } else if (cat.equalsIgnoreCase("conj")) {
                            word = lex.getWord(base, LexicalCategory.CONJUNCTION);
                        } else if (cat.equalsIgnoreCase("modal")) {
                            word = lex.getWord(base, LexicalCategory.MODAL);
                        } else if (cat.equalsIgnoreCase("interjection")) {
                            word = lex.getWord(base, LexicalCategory.NOUN);
                        }
                        if (word == null) {
                            System.out.println("*** The following baseform and POS tag is not found: " + base + ":" + cat);
                        } else {
                            xmlFile.write(word.toXML());
                        }
                        line = wordListFile.readLine();
                    }
                    xmlFile.write(String.format("</lexicon>%n", new Object[0]));
                    wordListFile.close();
                    xmlFile.close();
                    ((Lexicon)lex).close();
                    System.out.println("*** XML Lexicon Export Completed.");
                }
                catch (Exception e) {
                    System.err.println("*** An Error occured during the export. The Exception message is below: ");
                    System.err.println(e.getMessage());
                    System.err.println("************************");
                    System.err.println("Please make sure you have the correct application arguments: ");
                    NIHLexiconXMLDumpUtil.printArgumentsMessage();
                }
            } else {
                NIHLexiconXMLDumpUtil.printErrorArgumentMessage();
            }
        } else {
            NIHLexiconXMLDumpUtil.printErrorArgumentMessage();
        }
    }

    private static void printErrorArgumentMessage() {
        System.err.println("Insuffient number of arguments supplied. Please supply the following Arguments: \n");
        NIHLexiconXMLDumpUtil.printArgumentsMessage();
    }

    private static void printArgumentsMessage() {
        System.err.println("\t\t 1. The full path to the NIHDB Lexicon database file e.g. C:\\NIHDB\\lexAccess2009 ");
        System.err.println("\t\t 2. The full path to the list of baseforms and POS tags to include in the written out XML Lexicon file");
        System.err.println("\t\t 3. The full path to the XML file that the XML Lexicon will be written out to.");
    }
}

