room {
  nam = "loc_roof",
  episode = 1,
  forcedsc = true,
  noinv = true,
  disp = "Stairway to the roof",
  decor = function(s, w)
    p [[I climb the stairs. From up ahead I hear two voices arguing loudly about something. ^]]
    if s.episode > 1 then
      p([[
      ^
      Immediately, I recognize Ruslan's voice.^
      <i>"How do you not understand !? I pulled this entire ^
      project together, I found you some guinea pigs …^
      err, volunteers …^
      What would you have done without me?"</i>^
      ]])
    end
    if s.episode > 2 then
      p(fmt.r([[
       ^
      <i>"You're crazy, Ruslan!"</i>^
      Sounds like it's Nikolai.^
      <i> "I won’t let you ..."</i>^
      ]]))
    end
    if s.episode > 3 then
    p([[
    ^
    Noise, muffled blows, shouting. A fight???^
    ]])
    end
  end,
  enter = function(s,w)
    s.episode = 1
    theme_switch('finale')
    music_player('snd/rain_and_thunder.ogg')
  end
}:with {
  obj {
    nam = "#next",
    spacer = '',
    dsc = function(s)
      if _"loc_roof".episode < 4 then
        p(s.spacer .. "{Up >>>}")
      else 
        p(s.spacer .. "I      r   u  s h  {up the stairs}.")
      end
    end,
    act = function(s)
      if _"loc_roof".episode == 4 then
        walk 'loc_roof_1'
      else
        _"loc_roof".episode = _"loc_roof".episode + 1
        s.spacer = s.spacer .. '                  '
      end
    end
  }
}


room {
  nam = "loc_roof_1",
  forcedsc = true,
  noinv = true,
  disp = '',
  enter = function ()
    theme_switch('finale')
  end,
  decor = function(s, w)
    p "I push the door and run out onto the roof and into the pouring rain.^At the edge of the roof two men are fighting:^ ^"
    p(fmt.r("Ruslan^ and^ Nikolai.^"))
  end,
}:with {
  obj {
    nam = "#next",
    dsc = "I run {to them}.",
    act = function(s)
      walk 'loc_roof_2'
    end
  }
}


room {
  nam = "loc_roof_2",
  forcedsc = true,
  noinv = true,
  disp = '',
  enter = function ()
    theme_switch('finale')
  end,
  decor = function(s, w)
    p(fmt.c([[^I run to them, but it's too late.^]]))
    p(fmt.c("I can only watch:^"))
    p(fmt.c("as if in slow motion,^^"))
    p(fmt.c("Nikolai^^"))
    p(fmt.c("f^"))
    p(fmt.c("a^"))
    p(fmt.c("l^"))
    p(fmt.c("l^"))
    p(fmt.c("s^^"))
    p(fmt.c("to the wet cold asphalt below."))
  end,
}:with {
  obj {
    nam = "#next",
    dsc = function(s)
      p(fmt.c("{>>>}"))
    end,
    act = function(s)
      walk 'loc_roof_3'
    end
  }
}


room {
  nam = "loc_roof_3",
  forcedsc = true,
  noinv = true,
  disp = '',
  enter = function ()
    theme_switch('finale')
  end,
  decor = function(s, w)
    p([[
    However, Ruslan, by a lucky chance, is still alive.^
     ^
    He^
    hangs^
    on the edge^
    of the roof,^
    his clothes^
    caught^ 
    on    s o m e    j u t t i n g    r e b a r.^
    ]])
    p(fmt.r([[
    Trying to stay calm,^
    Ruslan^
    turns^
    {#next|to address me}.
    ]]))
  end
}:with {
  obj {
    nam = "#next",
    act = function(s)
      walk 'loc_roof_4'
    end
  }
}


room {
  nam = "loc_roof_4",
  forcedsc = true,
  noinv = true,
  disp = '',
  enter = function ()
    theme_switch('finale')
  end,
  decor = function(s, w)
    p([[
     "Of course, I understand what the author's intention is, and exactly what you should do. 
      Or rather, the character you are playing. But you don't have to do this!
        Yes, in this story I’m playing the antagonist, but it is just a role!"^
      A strange expression flashes across Ruslan's face. ^
      He says, "Anyway, do whatever you want. After all, the debugger is in your hands, not mine, and..."^
      A gust of wind drowns out his words.^
      ^
      I move away from the roof’s edge to {#next|consider the situation}.
    ]])
  end,
}:with {
  obj {
    nam = "#next",
    act = function(s)
      walk 'loc_roof_scene'
    end
  }
}



-- ==========================================================================================================

obj {
  nam = "roof_edge",
  disp = "Edge of the Roof",
  dsc = "Raindrops drum down on the concrete {edge of the roof}.^",
  act = "Rebar sticks out in several places where the concrete has crumbled.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('roof_edge')
      return
    end
    return false
  end
}


obj {
  nam = "armatura",
  is_strong = true,
  with_ruslan = true,
  disp = "Rebar", 
  dsc = "{Rebar} sticks out from the crumbling concrete.",
  act = "The rebar itself looks strong enough, but not so the concrete. A couple blows on the rebar would be enough to send Ruslan tumbling.",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('armatura');
      return
    elseif w.HIDDEN_name == name_of_kuvalda then
      if w.is_working then
        if not s.with_ruslan then
          p "Why hit the rebar for no reason?"
        elseif s.is_strong then
          p [[A single blow and the concrete crumb crashes down to the asphalt.^"Hey! What are you doing?!" shouts Ruslan. "Stop it!"]]
          s.is_strong = false
        else
          walk 'loc_roof_finale'
        end
      else
        p "I cannot hit the rebar with a broken sledgehammer."
      end
      return
    elseif w.HIDDEN_name == name_of_ruslan then
      p "Ruslan still hangs, clinging to the rebar."
      s.with_ruslan = true
      return
    end
    return false
  end
}

obj {
  nam = "ruslan",
  HIDDEN_name = name_of_ruslan,
  is_standing = false,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = function(s)
    if s.is_standing then
      p "^{Ruslan} stands on the edge of the roof looking nervously downward."
    else
      p "{Ruslan} hangs precariously from it. The slightest twist and he may fall."
    end
  end,
  act = function(s)
    if s.is_standing then
      p [["It seems that this scene will end only if I fall down," Rusland sighs. "Come on, come up with something."]]
    else
      p "I need to do something. But what? Save Ruslan or let him fall off the roof?"
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('ruslan');
      return
    end
    return false
  end
}


room {
  nam = "loc_roof_scene",
  forcedsc = true,
  disp = "Roof",
  pic = "gfx/rain.png",
  dsc = false,
  enter = function ()
    theme_switch('game')
  end,
}:with{
  'roof_edge',
  'armatura',
  'ruslan'
}


room {
  nam = "loc_roof_finale",
  forcedsc = true,
  noinv = true,
  disp = false,
  pic = function(s, w)
    if _'ruslan'.is_standing then
       return "gfx/city_view.png"
    else
       return "gfx/falling_man.png"
    end
  end,
  enter = function ()
    theme_switch('finale')
    music_player('snd/Ryan_Andersen_-_Rise.ogg')
  end,
  dsc = function(s, w)
    pn ()
    if _'ruslan'.is_standing then
      p [[
        Ruslan, along with me, watches as the rebar falls down and hits the pavement with a thud.
        ^
        "Well," he finally breaks the silence. "Thank you for everything. I did not believe until
        the last moment that I could be saved. The author will probably be upset that the ending
        was not what he intended. But you know what? He deserved this! After all, if he wanted
        another ending, he should have been written it himself."
        ^
        The rain subsides and soon the sun appears from behind the clouds. Ruslan shakes my hand and leaves.
        ^
        I stand still and admire the urban landscape. I have nowhere to go.
      ]]
    else
      p [[
        Leaning over the railing, I listen to the Ruslan’s shout as he falls down -- just like Nikolai did a few minutes ago.
        ^
        In the distance, lightning strikes and I hear thunder. Excellent scenery for the epilogue, in which the antagonist
        dies at the hands of the protagonist. But should he perish?
        ^
        I just cannot help but think that I could have saved Ruslan. Could have -- but did not -- obeying the will
        of the game’s author. But was the author right? After all, he was not able to write this ending,
        which means that everything could end quite differently.
        ^
        My clothes are soaked, water sloshes in my shoes -- but I'm still standing on the roof. I have nowhere to go. 
      ]]
    end
  end
}:with {
  obj {
    nam = "#next",
    dsc = function(s)
      p(fmt.c("{>>>}"))
    end,
    act = function(s)
      walk 'titles'
    end
  }
}

