/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.base;

import org.zmpp.base.MemoryAccess;

public class DefaultMemoryAccess
implements MemoryAccess {
    private byte[] data;

    public DefaultMemoryAccess(byte[] byArray) {
        this.data = byArray;
    }

    public long readUnsigned32(int n) {
        return (this.data[n] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF;
    }

    public long readUnsigned48(int n) {
        return (this.data[n + 0] & 0xFF) << 40 | (this.data[n + 1] & 0xFF) << 32 | (this.data[n + 2] & 0xFF) << 24 | (this.data[n + 3] & 0xFF) << 16 | (this.data[n + 4] & 0xFF) << 8 | this.data[n + 5] & 0xFF;
    }

    public void writeUnsigned48(int n, long l) {
        this.data[n + 0] = (byte)((l & 0xFF0000000000L) >> 40);
        this.data[n + 1] = (byte)((l & 0xFF00000000L) >> 32);
        this.data[n + 2] = (byte)((l & 0xFF000000L) >> 24);
        this.data[n + 3] = (byte)((l & 0xFF0000L) >> 16);
        this.data[n + 4] = (byte)((l & 0xFF00L) >> 8);
        this.data[n + 5] = (byte)(l & 0xFFL);
    }

    public int readUnsignedShort(int n) {
        return (this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF;
    }

    public short readShort(int n) {
        return (short)(this.data[n] << 8 | this.data[n + 1] & 0xFF);
    }

    public short readUnsignedByte(int n) {
        return (short)(this.data[n] & 0xFF);
    }

    public byte readByte(int n) {
        return this.data[n];
    }

    public void writeUnsignedShort(int n, int n2) {
        this.data[n] = (byte)((n2 & 0xFF00) >> 8);
        this.data[n + 1] = (byte)(n2 & 0xFF);
    }

    public void writeShort(int n, short s) {
        this.data[n] = (byte)((s & 0xFF00) >>> 8);
        this.data[n + 1] = (byte)(s & 0xFF);
    }

    public void writeUnsignedByte(int n, short s) {
        this.data[n] = (byte)(s & 0xFF);
    }

    public void writeByte(int n, byte by) {
        this.data[n] = by;
    }

    public void writeUnsigned32(int n, long l) {
        this.data[n] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
        this.data[n + 1] = (byte)((l & 0xFF0000L) >> 16);
        this.data[n + 2] = (byte)((l & 0xFF00L) >> 8);
        this.data[n + 3] = (byte)(l & 0xFFL);
    }
}

