/*
 * Decompiled with CFR 0.152.
 */
package Adventure.Commands;

import Modules.Consumers.AbstractConsumer;
import Modules.DataStore.IDataStoreXML;
import Modules.Errors.ErrorsFactory;
import Modules.Errors.IErrorModule;
import Modules.Queues.IMessage;
import Modules.Queues.MessageFactory;
import Modules.TextAnalizer.InnerGrammatic;
import Modules.TextAnalizer.InverseToken;
import Modules.TextAnalizer.Phrase;

public class GoCommand
extends AbstractConsumer {
    private String token_n = "NORTH";
    private String token_s = "SOUTH";
    private String token_e = "EAST";
    private String token_w = "WEST";
    private String token_u = "UP";
    private String token_d = "DOWN";
    private String token_g = "GO";

    public GoCommand(String name) {
        super(name);
    }

    public GoCommand() {
        super("ExCommand");
    }

    public boolean consumeMessage(IMessage message) {
        String idExit = "";
        if (!message.messageIs(1)) {
            return true;
        }
        Phrase p = (Phrase)message.getAttrib();
        if (p.getVerbToken() != InnerGrammatic.TOKEN(this.token_n) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_s) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_e) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_w) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_u) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_d) && p.getVerbToken() != InnerGrammatic.TOKEN(this.token_g)) {
            return true;
        }
        IErrorModule em = ErrorsFactory.GetErrorModule("GOERROR");
        if (em == null) {
            em = ErrorsFactory.CreateModule("GOERROR", "VerbGoErrors.xml", this.salida);
        }
        if (p.getVerbToken() == InnerGrammatic.TOKEN(this.token_g)) {
            if (p.getCompNumber() < 1) {
                em.showError("DIRUNKNOWN", p.getComp());
                return false;
            }
            idExit = InverseToken.InverseToken(p.getCdToken());
        }
        if (idExit == null) {
            this.messages.addLast(MessageFactory.Build("COMPNOTHERE", (Object)p));
            return false;
        }
        if (idExit.compareTo("") == 0) {
            idExit = InverseToken.InverseToken(p.getVerbToken());
        }
        IDataStoreXML global = this.registry.getDataStore("GLOBAL");
        String idRoom = global.leerEtiqueta("ROOM");
        IDataStoreXML rooms = this.registry.getDataStore("ROOMS");
        IDataStoreXML room = rooms.buscarEtiqueta("ROOM", idRoom);
        IDataStoreXML exits = room.leerSeccion("EXITS");
        IDataStoreXML exit = exits.buscarEtiqueta("EXIT", idExit);
        if (exit == null) {
            em.showError("DIRINVALID", p.getComp());
            return false;
        }
        idRoom = exit.leerAtributo("TO");
        global.escribirEtiqueta("ROOM", idRoom);
        this.messages.addLast(MessageFactory.Build(3, null));
        return false;
    }
}

