/*
 * Decompiled with CFR 0.152.
 */
package Modules.TextAnalizer;

import java.util.Hashtable;
import java.util.Vector;

public class Phrase {
    private Vector vecPhrase = new Vector(VECTOR_SIZE);
    private Vector vecTokens = new Vector(VECTOR_SIZE);
    private Hashtable tblAttributes = new Hashtable();
    private int compNumber = 0;
    private int tokenNumber = 0;
    public static int VECTOR_SIZE = 6;

    public void clear() {
        this.compNumber = 0;
        this.vecPhrase.clear();
        this.vecTokens.clear();
        this.tblAttributes.clear();
    }

    public void setVerb(String pComp) {
        this.vecPhrase.add(0, pComp);
    }

    public void setVerb(int intToken) {
        this.vecTokens.add(0, new Integer(intToken));
    }

    public String getVerb() {
        try {
            return (String)this.vecPhrase.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setComp(String pComp) {
        this.vecPhrase.add(++this.compNumber, pComp);
    }

    public void setComp(int intToken) {
        try {
            this.vecTokens.add(++this.tokenNumber, new Integer(intToken));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Soy setComp(int) / compNumber=" + this.compNumber + " inToken = " + intToken);
        }
    }

    public void setComp(int index, int intToken) {
        try {
            this.vecTokens.add(index, new Integer(intToken));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Soy setComp(int, int) / compNumber=" + this.compNumber + " inToken = " + intToken + " index=" + index);
        }
    }

    public String getComp() {
        return this.getComp(1);
    }

    public String getComp(int index) {
        try {
            if (index > this.compNumber) {
                return (String)this.vecPhrase.elementAt(this.compNumber);
            }
            return (String)this.vecPhrase.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Vector getCompList() {
        Vector vec = new Vector(VECTOR_SIZE);
        int c = 1;
        while (c < this.vecPhrase.size()) {
            vec.add(this.vecPhrase.elementAt(c));
            ++c;
        }
        return vec;
    }

    public int getCompNumber() {
        return this.compNumber;
    }

    public void setAttrib(String token, int intAttrib) {
        if (this.vecPhrase.contains(token)) {
            this.tblAttributes.put(token, new Integer(intAttrib));
        }
    }

    public void setObjAttrib(String token, Object Attrib) {
        if (this.vecPhrase.contains(token)) {
            this.tblAttributes.put(token, Attrib);
        }
    }

    public int getIntAttrib(String token) {
        if (this.vecPhrase != null && token != null && this.tblAttributes.get(token) != null && this.vecPhrase.contains(token)) {
            Integer tmp = (Integer)this.tblAttributes.get(token);
            return tmp;
        }
        return -1;
    }

    public Object getObjAttrib(String token) {
        if (this.vecPhrase.contains(token)) {
            return this.tblAttributes.get(token);
        }
        return null;
    }

    public int getVerbAttrib() {
        if (this.vecPhrase != null && this.vecPhrase.size() > 0 && this.vecPhrase.elementAt(0) != null) {
            return this.getIntAttrib((String)this.vecPhrase.elementAt(0));
        }
        return -1;
    }

    public int getToken(int index) {
        try {
            if (this.vecTokens != null && this.vecTokens.size() > 0 && index + 1 <= this.vecTokens.size() && this.vecTokens.elementAt(index) != null) {
                Integer tmp = (Integer)this.vecTokens.get(index);
                return tmp;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Soy getToken() / index=" + index + " compNumber=" + this.compNumber + " vecTokens.size = " + this.vecTokens.size());
        }
        return -1;
    }

    public int getCdToken() {
        return this.getToken(1);
    }

    public int getCiToken() {
        return this.getToken(2);
    }

    public int getVerbToken() {
        return this.getToken(0);
    }

    public void setAttrib(int token, int intAttrib) {
        this.tblAttributes.put(new Integer(token), new Integer(intAttrib));
    }

    public void setObjAttrib(int token, Object Attrib) {
        if (this.vecTokens.contains(new Integer(token))) {
            this.tblAttributes.put(new Integer(token), Attrib);
        }
    }

    public int getIntAttrib(int token) {
        Integer tmp = new Integer(token);
        if (this.vecTokens != null && token >= 0 && this.tblAttributes.get(tmp) != null) {
            Integer tmp2 = (Integer)this.tblAttributes.get(tmp);
            return tmp2;
        }
        return -1;
    }

    public Object getObjAttrib(int token) {
        if (this.vecTokens.contains(new Integer(token))) {
            return this.tblAttributes.get(new Integer(token));
        }
        return null;
    }

    public boolean unknowVerb() {
        return this.getVerbToken() == -1;
    }

    public boolean unknowComp() {
        boolean tmp = true;
        int c = 1;
        try {
            while (tmp && c <= this.compNumber) {
                tmp = this.getToken(c) == -1;
                ++c;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Soy unkwonComp() / c=" + c + " compNumber=" + this.compNumber);
        }
        return tmp;
    }
}

