/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.identity;

import com.sun.msv.driver.textui.Debug;
import com.sun.msv.grammar.xmlschema.ElementDeclExp;
import com.sun.msv.grammar.xmlschema.IdentityConstraint;
import com.sun.msv.grammar.xmlschema.KeyRefConstraint;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.util.LightStack;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.verifier.Acceptor;
import com.sun.msv.verifier.ErrorInfo;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.KeyValue;
import com.sun.msv.verifier.identity.Matcher;
import com.sun.msv.verifier.identity.SelectorMatcher;
import com.sun.msv.verifier.regexp.xmlschema.XSREDocDecl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IDConstraintChecker
extends Verifier {
    protected final XMLSchemaGrammar grammar;
    protected final Vector matchers = new Vector();
    private final Map keyValues = new HashMap();
    private final Map referenceScope = new HashMap();
    private final Map activeScopes = new HashMap();
    public static final String ERR_UNMATCHED_KEY_FIELD = "IdentityConstraint.UnmatchedKeyField";
    public static final String ERR_NOT_UNIQUE = "IdentityConstraint.NotUnique";
    public static final String ERR_NOT_UNIQUE_DIAG = "IdentityConstraint.NotUnique.Diag";
    public static final String ERR_DOUBLE_MATCH = "IdentityConstraint.DoubleMatch";
    public static final String ERR_UNDEFINED_KEY = "IdentityConstraint.UndefinedKey";

    public IDConstraintChecker(XMLSchemaGrammar grammar, ErrorHandler errorHandler) {
        super(new XSREDocDecl(grammar), errorHandler);
        this.grammar = grammar;
    }

    protected void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    protected void remove(Matcher matcher) {
        this.matchers.remove(matcher);
    }

    protected SelectorMatcher getActiveScope(IdentityConstraint c) {
        LightStack s = (LightStack)this.activeScopes.get(c);
        if (s == null) {
            return null;
        }
        if (s.size() == 0) {
            return null;
        }
        return (SelectorMatcher)s.top();
    }

    protected void pushActiveScope(IdentityConstraint c, SelectorMatcher matcher) {
        LightStack s = (LightStack)this.activeScopes.get(c);
        if (s == null) {
            s = new LightStack();
            this.activeScopes.put(c, s);
        }
        s.push(matcher);
    }

    protected void popActiveScope(IdentityConstraint c, SelectorMatcher matcher) {
        LightStack s = (LightStack)this.activeScopes.get(c);
        if (s == null) {
            throw new Error();
        }
        if (s.pop() != matcher) {
            throw new Error();
        }
    }

    protected boolean addKeyValue(SelectorMatcher scope, KeyValue value) {
        HashSet<KeyValue> keys = (HashSet<KeyValue>)this.keyValues.get(scope);
        if (keys == null) {
            keys = new HashSet<KeyValue>();
            this.keyValues.put(scope, keys);
        }
        return keys.add(value);
    }

    protected KeyValue[] getKeyValues(SelectorMatcher scope) {
        Set keys = (Set)this.keyValues.get(scope);
        if (keys == null) {
            return new KeyValue[0];
        }
        return keys.toArray(new KeyValue[keys.size()]);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.keyValues.clear();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        Map.Entry[] scopes = this.keyValues.entrySet().toArray(new Map.Entry[this.keyValues.size()]);
        if (Debug.debug) {
            System.out.println("key/keyref check: there are " + this.keyValues.size() + " scope(s)");
        }
        int i = 0;
        while (i < scopes.length) {
            SelectorMatcher key = (SelectorMatcher)scopes[i].getKey();
            Set value = (Set)scopes[i].getValue();
            if (key.idConst instanceof KeyRefConstraint) {
                Set keys = (Set)this.keyValues.get(this.referenceScope.get(key));
                KeyValue[] keyrefs = value.toArray(new KeyValue[value.size()]);
                int j = 0;
                while (j < keyrefs.length) {
                    if (keys == null || !keys.contains(keyrefs[j])) {
                        this.reportError(keyrefs[j].locator, null, ERR_UNDEFINED_KEY, new Object[]{key.idConst.namespaceURI, key.idConst.localName});
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void onNextAcceptorReady(StartTagInfo sti, Acceptor next) throws SAXException {
        int len = this.matchers.size();
        int i = 0;
        while (i < len) {
            Matcher m = (Matcher)this.matchers.get(i);
            m.startElement(sti.namespaceURI, sti.localName);
            ++i;
        }
        Object e = next.getOwnerType();
        if (e instanceof ElementDeclExp.XSElementExp) {
            ElementDeclExp.XSElementExp exp = (ElementDeclExp.XSElementExp)e;
            if (exp.identityConstraints != null) {
                int m = exp.identityConstraints.size();
                int i2 = 0;
                while (i2 < m) {
                    this.add(new SelectorMatcher(this, (IdentityConstraint)exp.identityConstraints.get(i2), sti.namespaceURI, sti.localName));
                    ++i2;
                }
                int i3 = 0;
                while (i3 < m) {
                    IdentityConstraint c = (IdentityConstraint)exp.identityConstraints.get(i3);
                    if (c instanceof KeyRefConstraint) {
                        SelectorMatcher keyScope = this.getActiveScope(((KeyRefConstraint)c).key);
                        if (keyScope == null) {
                            // empty if block
                        }
                        this.referenceScope.put(this.getActiveScope(c), keyScope);
                    }
                    ++i3;
                }
            }
        }
    }

    protected Datatype[] feedAttribute(Acceptor child, String uri, String localName, String qName, String value) throws SAXException {
        Datatype[] result = super.feedAttribute(child, uri, localName, qName, value);
        int len = this.matchers.size();
        int i = 0;
        while (i < len) {
            Matcher m = (Matcher)this.matchers.get(i);
            m.onAttribute(uri, localName, value, result == null ? null : result[0]);
            ++i;
        }
        return result;
    }

    public void characters(char[] buf, int start, int len) throws SAXException {
        super.characters(buf, start, len);
        int m = this.matchers.size();
        int i = 0;
        while (i < m) {
            ((Matcher)this.matchers.get(i)).characters(buf, start, len);
            ++i;
        }
    }

    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        super.endElement(namespaceUri, localName, qName);
        Datatype[] lastType = this.getLastCharacterType();
        Datatype dt = lastType == null || lastType.length == 0 ? null : this.getLastCharacterType()[0];
        int len = this.matchers.size();
        int i = len - 1;
        while (i >= 0) {
            ((Matcher)this.matchers.get(i)).endElement(dt);
            --i;
        }
    }

    protected void reportError(ErrorInfo ei, String propKey, Object[] args) throws SAXException {
        this.reportError(this.getLocator(), ei, propKey, args);
    }

    protected void reportError(Locator loc, ErrorInfo ei, String propKey, Object[] args) throws SAXException {
        this.hadError = true;
        this.errorHandler.error(new ValidityViolation(loc, IDConstraintChecker.localizeMessage(propKey, args), ei));
    }

    public static String localizeMessage(String propertyName, Object arg) {
        return IDConstraintChecker.localizeMessage(propertyName, new Object[]{arg});
    }

    public static String localizeMessage(String propertyName, Object[] args) {
        String format = ResourceBundle.getBundle("com.sun.msv.verifier.identity.Messages").getString(propertyName);
        return MessageFormat.format(format, args);
    }

    static {
        ERR_UNMATCHED_KEY_FIELD = ERR_UNMATCHED_KEY_FIELD;
        ERR_NOT_UNIQUE = ERR_NOT_UNIQUE;
        ERR_NOT_UNIQUE_DIAG = ERR_NOT_UNIQUE_DIAG;
        ERR_DOUBLE_MATCH = ERR_DOUBLE_MATCH;
        ERR_UNDEFINED_KEY = ERR_UNDEFINED_KEY;
    }
}

