/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private static Locator dummyLocator = new Locator(){

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId() {
            return null;
        }

        public String getPublicId() {
            return null;
        }
    };

    public void parse(Element e, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e);
        handler.startDocument();
        handler.setDocumentLocator(dummyLocator);
        this.visit(e);
        this.setCurrentLocation(e);
        handler.endDocument();
    }

    public void visit(Element e) throws SAXException {
        this.setCurrentLocation(e);
        NamedNodeMap attributes = e.getAttributes();
        this.atts.clear();
        int len = attributes.getLength();
        int i = len - 1;
        while (i >= 0) {
            Attr a = (Attr)attributes.item(i);
            String name = a.getName();
            if (name.equals("xmlns")) {
                this.receiver.startPrefixMapping("", a.getValue());
            } else if (name.startsWith("xmlns:")) {
                this.receiver.startPrefixMapping(a.getLocalName(), a.getValue());
            } else {
                String uri = a.getNamespaceURI();
                if (uri == null) {
                    uri = "";
                }
                this.atts.addAttribute(uri, a.getLocalName(), a.getName(), null, a.getValue());
            }
            --i;
        }
        String uri = e.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local = e.getLocalName();
        String qname2 = e.getTagName();
        this.receiver.startElement(uri, local, qname2, this.atts);
        NodeList children = e.getChildNodes();
        int clen = children.getLength();
        int i2 = 0;
        while (i2 < clen) {
            this.visit(children.item(i2));
            ++i2;
        }
        this.setCurrentLocation(e);
        this.receiver.endElement(uri, local, qname2);
        int i3 = len - 1;
        while (i3 >= 0) {
            Attr a = (Attr)attributes.item(i3);
            String name = a.getName();
            if (name.startsWith("xmlns:")) {
                this.receiver.endPrefixMapping(a.getLocalName());
            }
            --i3;
        }
    }

    private void visit(Node n) throws SAXException {
        this.setCurrentLocation(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                String value = n.getNodeValue();
                this.receiver.characters(value.toCharArray(), 0, value.length());
                break;
            }
            case 1: {
                this.visit((Element)n);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }
}

