/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.UName;
import com.sun.xml.xsom.impl.parser.AnnotationParser;
import com.sun.xml.xsom.impl.parser.DefaultAnnotationParser;
import com.sun.xml.xsom.impl.parser.Messages;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import com.sun.xml.xsom.impl.parser.XSOMParser;
import com.sun.xml.xsom.impl.parser.state.NGCCRuntime;
import com.sun.xml.xsom.impl.parser.state.Schema;
import com.sun.xml.xsom.impl.util.Uri;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Stack;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class NGCCRuntimeEx
extends NGCCRuntime
implements PatcherManager {
    public final XSOMParser parser;
    public SchemaImpl currentSchema;
    public int finalDefault = 0;
    public int blockDefault = 0;
    public boolean elementFormDefault = false;
    public boolean attributeFormDefault = false;
    private String baseUri;
    private final Stack elementNames = new Stack();
    private Context currentContext = null;
    public static final String XMLSchemaNSURI = "http://www.w3.org/2001/XMLSchema";

    NGCCRuntimeEx(XSOMParser _parser) {
        this.parser = _parser;
        this.currentContext = new Context("", "", null);
        this.currentContext = new Context("xml", "http://www.w3.org/XML/1998/namespace", this.currentContext);
    }

    public void addPatcher(Patch patcher) {
        this.parser.patcherManager.addPatcher(patcher);
    }

    public void reportError(String msg, Locator loc) throws SAXException {
        this.parser.patcherManager.reportError(msg, loc);
    }

    private InputSource resolveEntity(String relativeUri) throws SAXException {
        String systemId = Uri.resolve(this.baseUri, relativeUri);
        return new InputSource(systemId);
    }

    public void includeSchema(String schemaLocation) throws SAXException {
        NGCCRuntimeEx runtime = new NGCCRuntimeEx(this.parser);
        runtime.currentSchema = this.currentSchema;
        runtime.blockDefault = this.blockDefault;
        runtime.finalDefault = this.finalDefault;
        if (schemaLocation == null) {
            SAXParseException e = new SAXParseException(Messages.format("MissingSchemaLocation"), this.getLocator());
            this.parser.errorHandler.fatalError(e);
            throw e;
        }
        runtime.parseEntity(this.resolveEntity(schemaLocation), true, this.getLocator());
    }

    public void importSchema(String ns, String schemaLocation) throws SAXException {
        if (this.parser.schemaSet.getSchema(ns) == null) {
            if (schemaLocation == null) {
                SAXParseException e = new SAXParseException(Messages.format("MissingSchemaLocation"), this.getLocator());
                this.parser.errorHandler.fatalError(e);
                throw e;
            }
            NGCCRuntimeEx newRuntime = new NGCCRuntimeEx(this.parser);
            newRuntime.parseEntity(this.resolveEntity(schemaLocation), false, this.getLocator());
        }
    }

    public void parseEntity(InputSource source, boolean includeMode, Locator importLocation) throws SAXException {
        block5: {
            try {
                Schema s = new Schema(this, includeMode);
                this.setRootHandler(s);
                this.baseUri = source.getSystemId();
                if (this.baseUri.startsWith("file:///")) {
                    this.baseUri = "file:/" + this.baseUri.substring(8);
                }
                if (this.baseUri != null && !this.parser.parsedDocuments.add(this.baseUri)) break block5;
                try {
                    this.parser.parser.parse(source, this);
                }
                catch (IOException e) {
                    SAXParseException se = new SAXParseException(e.toString(), importLocation, e);
                    this.parser.errorHandler.fatalError(se);
                    throw se;
                }
            }
            catch (SAXException e) {
                this.parser.setErrorFlag();
                throw e;
            }
        }
    }

    public AnnotationParser createAnnotationParser() {
        if (this.parser.apFactory == null) {
            return DefaultAnnotationParser.theInstance;
        }
        return this.parser.apFactory.create();
    }

    public String getAnnotationContextElementName() {
        return (String)this.elementNames.get(this.elementNames.size() - 2);
    }

    public Locator copyLocator() {
        return new LocatorImpl(this.getLocator());
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.errorHandler;
    }

    public void onEnterElementConsumed(String uri, String localName, String qname2, Attributes atts) throws SAXException {
        super.onEnterElementConsumed(uri, localName, qname2, atts);
        this.elementNames.push(localName);
    }

    public void onLeaveElementConsumed(String uri, String localName, String qname2) throws SAXException {
        super.onLeaveElementConsumed(uri, localName, qname2);
        this.elementNames.pop();
    }

    public ValidationContext createValidationContext() {
        return this.currentContext;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.currentContext = new Context(prefix, uri, this.currentContext);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.currentContext = this.currentContext.previous;
    }

    public UName parseUName(String qname2) throws SAXException {
        int idx = qname2.indexOf(58);
        if (idx < 0) {
            String uri = this.resolveNamespacePrefix("");
            return new UName(uri, qname2, qname2);
        }
        String prefix = qname2.substring(0, idx);
        String uri = this.currentContext.resolveNamespacePrefix(prefix);
        if (uri == null) {
            this.reportError(Messages.format("UndefinedPrefix", prefix), this.getLocator());
            uri = "undefined";
        }
        return new UName(uri, qname2.substring(idx + 1), qname2);
    }

    public boolean parseBoolean(String v) {
        if (v == null) {
            return false;
        }
        return (v = v.trim()).equals("true") || v.equals("1");
    }

    protected void unexpectedXXX(String token) throws SAXException {
        SAXParseException e = new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", token, new Integer(this.getLocator().getLineNumber()), new Integer(this.getLocator().getColumnNumber())), this.getLocator());
        this.parser.errorHandler.fatalError(e);
        throw e;
    }

    static {
        XMLSchemaNSURI = XMLSchemaNSURI;
    }

    private static class Context
    implements ValidationContext {
        private final String prefix;
        private final String uri;
        private final Context previous;

        Context(String _prefix, String _uri, Context _context) {
            this.previous = _context;
            this.prefix = _prefix;
            this.uri = _uri;
        }

        public String resolveNamespacePrefix(String p) {
            if (p.equals(this.prefix)) {
                return this.uri;
            }
            if (this.previous == null) {
                return null;
            }
            return this.previous.resolveNamespacePrefix(p);
        }

        public String getBaseUri() {
            return null;
        }

        public boolean isNotation(String arg0) {
            return false;
        }

        public boolean isUnparsedEntity(String arg0) {
            return false;
        }
    }
}

