/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class GameInfo
implements Serializable {
    private String[] theInfo;
    private File f = null;
    static Vector allInstances = new Vector();

    public boolean equals(Object obj) {
        if (!(obj instanceof GameInfo)) {
            return false;
        }
        return (this.f == null ? ((GameInfo)obj).f == null : this.f.equals(((GameInfo)obj).f)) && (this.theInfo == null ? ((GameInfo)obj).theInfo == null : Arrays.equals(this.theInfo, ((GameInfo)obj).theInfo));
    }

    public static GameInfo getGameInfoFromFile(File f) {
        int i = 0;
        while (i < allInstances.size()) {
            if (((GameInfo)allInstances.elementAt(i)).getFile() != null && ((GameInfo)allInstances.elementAt(i)).getFile().equals(f)) {
                return (GameInfo)allInstances.elementAt(i);
            }
            ++i;
        }
        try {
            return GameInfo.getGameInfo(f);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GameInfo(String[] info, File f) {
        this.theInfo = info;
        this.f = f;
        allInstances.add(this);
    }

    public GameInfo() {
        this.theInfo = new String[5];
        int i = 0;
        while (i < 5) {
            this.theInfo[i] = "";
            ++i;
        }
        allInstances.add(this);
    }

    public File getFile() {
        return this.f;
    }

    public boolean isValid() {
        return this.f != null;
    }

    public String getName() {
        return this.theInfo[0];
    }

    public String getAuthor() {
        return this.theInfo[1];
    }

    public String getDate() {
        return this.theInfo[3];
    }

    public String getVersion() {
        return this.theInfo[2];
    }

    public String getAGEVersion() {
        return this.theInfo[4];
    }

    public String toString() {
        return String.valueOf(this.theInfo[0]) + " " + this.theInfo[2];
    }

    public String toLongString() {
        return "Nombre: " + this.getName() + "\nAutor: " + this.getAuthor() + "\nFecha: " + this.getDate() + "\nVersi\u00f3n: " + this.getVersion() + "\nVersi\u00f3n AGE requerida: " + this.getAGEVersion() + "\nFichero: " + this.getFile();
    }

    public static GameInfo getGameInfo(File modulefile) throws FileNotFoundException, IOException {
        System.out.println("getGameInfo called on " + modulefile);
        String linea = "";
        String token = "";
        String[] moduleInfo = new String[]{"?", "?", "?", "?", "?"};
        boolean useAlternativeFile = false;
        if (modulefile.getName().toLowerCase().endsWith(".xml")) {
            File resFile = new File(String.valueOf(modulefile.getAbsolutePath().substring(0, modulefile.getAbsolutePath().length() - 4)) + ".res");
            if (resFile.exists()) {
                System.out.println("RES file exists.\n");
                useAlternativeFile = true;
            } else {
                System.out.println("RES file doesn't exist.\n");
                Document d = null;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(modulefile), "ISO-8859-1"));
                    InputSource is = new InputSource(br);
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    d = db.parse(is);
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("RES file, nay1.");
                    System.out.print("Estactraza: ");
                    fnfe.printStackTrace();
                    throw fnfe;
                }
                catch (ParserConfigurationException pce) {
                    System.out.println(pce);
                }
                catch (SAXException se) {
                    System.out.println(se);
                }
                catch (IOException ioe) {
                    System.out.println("RES file, nay2.");
                    ioe.printStackTrace();
                    throw ioe;
                }
                Element n = d.getDocumentElement();
                if (n.hasAttribute("moduleName")) {
                    moduleInfo[0] = n.getAttribute("moduleName");
                }
                if (n.hasAttribute("author")) {
                    moduleInfo[1] = n.getAttribute("author");
                }
                if (n.hasAttribute("version")) {
                    moduleInfo[2] = n.getAttribute("version");
                }
                if (n.hasAttribute("date")) {
                    moduleInfo[3] = n.getAttribute("date");
                }
                if (n.hasAttribute("parserVersion")) {
                    moduleInfo[4] = n.getAttribute("parserVersion");
                }
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(resFile)));
                pw.println("comment Fichero resumen de informaci\u00f3n de mundo generado por Aetheria Game Engine el " + DateFormat.getDateTimeInstance().format(new Date()) + " a partir de " + modulefile);
                pw.println("modulename " + moduleInfo[0]);
                pw.println("author " + moduleInfo[1]);
                pw.println("version " + moduleInfo[2]);
                pw.println("date " + moduleInfo[3]);
                pw.println("parserversion " + moduleInfo[4]);
                pw.flush();
                pw.close();
                System.out.println("Print Writer closed");
                return new GameInfo(moduleInfo, modulefile);
            }
        }
        FileInputStream fp = null;
        BufferedReader filein = null;
        if (useAlternativeFile) {
            File resFile = new File(String.valueOf(modulefile.getAbsolutePath().substring(0, modulefile.getAbsolutePath().length() - 4)) + ".res");
            fp = new FileInputStream(resFile);
            filein = new BufferedReader(new InputStreamReader((InputStream)fp, "ISO-8859-1"));
        } else {
            fp = new FileInputStream(modulefile);
            filein = new BufferedReader(new InputStreamReader((InputStream)fp, "ISO-8859-1"));
        }
        while ((linea = filein.readLine()) != null) {
            String id_linea;
            token = StringMethods.getTok(linea, 1, ' ');
            if (token.equalsIgnoreCase("modulename")) {
                moduleInfo[0] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("author")) {
                moduleInfo[1] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("version")) {
                moduleInfo[2] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("date")) {
                moduleInfo[3] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("parserversion")) {
                moduleInfo[4] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("begin_eva_code")) {
                boolean terminamos = false;
                while (!terminamos) {
                    linea = filein.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    if (!id_linea.equalsIgnoreCase("end_eva_code")) continue;
                    terminamos = true;
                }
                continue;
            }
            if (!token.equalsIgnoreCase("begin_bsh_code")) continue;
            boolean terminamos = false;
            while (!terminamos) {
                linea = filein.readLine();
                id_linea = StringMethods.getTok(linea, 1, ' ');
                if (!id_linea.equalsIgnoreCase("end_bsh_code")) continue;
                terminamos = true;
            }
        }
        return new GameInfo(moduleInfo, modulefile);
    }

    public static GameInfo[] getListOfGames() {
        System.out.println("getListOfGames() called\n");
        File f = new File(System.getProperty("user.dir"));
        File[] fl = f.listFiles();
        Vector<GameInfo> result = new Vector<GameInfo>();
        int i = 0;
        while (i < fl.length) {
            if (fl[i].isDirectory()) {
                File[] fl2 = fl[i].listFiles();
                int j = 0;
                while (j < fl2.length) {
                    if (fl2[j].getName().equalsIgnoreCase("world.dat") || fl2[j].getName().equalsIgnoreCase("world.xml")) {
                        try {
                            result.addElement(GameInfo.getGameInfo(fl2[j]));
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            ioe.printStackTrace();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] objetos = result.toArray();
        GameInfo[] ficheros = new GameInfo[objetos.length];
        int i2 = 0;
        while (i2 < objetos.length) {
            ficheros[i2] = (GameInfo)objetos[i2];
            ++i2;
        }
        return ficheros;
    }
}

