/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class MeterFrame
extends JInternalFrame {
    JProgressBar progressBarMem = new JProgressBar(0, 100);
    JTextField tf1 = new JTextField("Memoria de objetos asignada: ");
    JTextField tf2 = new JTextField("Memoria de objetos no usada: ");
    JTextField tf3 = new JTextField("Memoria de objetos m\u00e1xima: ");
    JPanel barsPanel;
    Thread meterThread;
    Object stopthrSem = new Object();
    boolean stopthr = false;
    JInternalFrame self = this;

    public MeterFrame() {
        super("Medidor de recursos", false, true, true, true);
        this.setTitle("Medidor de recursos");
        this.setSize(400, 150);
        this.setVisible(true);
        this.tf1.setEditable(false);
        this.tf2.setEditable(false);
        this.tf3.setEditable(false);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                MeterFrame.this.setVisible(false);
                MeterFrame.this.stopMeterThread();
            }
        });
        this.barsPanel = new JPanel();
        this.barsPanel.setLayout(new GridLayout(5, 1));
        this.barsPanel.add(new JLabel("Uso de memoria:"));
        this.barsPanel.add(this.progressBarMem);
        this.barsPanel.add(this.tf1);
        this.barsPanel.add(this.tf2);
        this.barsPanel.add(this.tf3);
        this.progressBarMem.setStringPainted(true);
        this.getContentPane().add(this.barsPanel);
        this.updateMemProgressBar();
        this.meterThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    MeterFrame.this.updateMemProgressBar();
                    Object object = MeterFrame.this.stopthrSem;
                    synchronized (object) {
                        if (MeterFrame.this.stopthr) {
                            MeterFrame.this.self.dispose();
                            return;
                        }
                    }
                }
            }
        };
        this.meterThread.start();
    }

    public void stopMeterThread() {
        Object object = this.stopthrSem;
        synchronized (object) {
            this.stopthr = true;
        }
    }

    public String humanReadableSize(long size) {
        String unit = "";
        int divisor = 1;
        if (size < 1024L) {
            divisor = 1;
            unit = "B";
        }
        if (size < 0x100000L) {
            divisor = 1024;
            unit = "KB";
        }
        if (size < 0x40000000L) {
            divisor = 0x100000;
            unit = "MB";
        }
        double amount = (double)size / (double)divisor;
        return String.valueOf(new DecimalFormat("#.###").format(amount)) + " " + unit;
    }

    public void updateMemProgressBar() {
        double freeMemory = Runtime.getRuntime().freeMemory();
        double totalMemory = Runtime.getRuntime().totalMemory();
        double maxMemory = Runtime.getRuntime().maxMemory();
        double usedMemory = totalMemory - freeMemory;
        this.tf1.setText("Memoria de objetos asignada: " + this.humanReadableSize((long)totalMemory));
        this.tf2.setText("Memoria de objetos usada: " + this.humanReadableSize((long)usedMemory));
        this.tf3.setText("Memoria de objetos m\u00e1xima: " + this.humanReadableSize((long)maxMemory));
        int percent = (int)(usedMemory / maxMemory * 100.0);
        this.progressBarMem.setValue(percent);
        this.progressBarMem.setString(String.valueOf(percent) + "%");
        if (percent <= 60) {
            this.progressBarMem.setForeground(Color.green);
        } else if (percent <= 85) {
            this.progressBarMem.setForeground(Color.yellow);
        } else {
            this.progressBarMem.setForeground(Color.red);
        }
    }
}

