/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PluginMenu
extends JMenu {
    private final JDesktopPane dPane;

    public PluginMenu(final JDesktopPane dPane) {
        super("Plugins");
        this.dPane = dPane;
        final String[] names = this.getPluginClassNames();
        int i = 0;
        while (i < names.length) {
            final int ind = i;
            JMenuItem thisItem = new JMenuItem(names[i]);
            thisItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Class cl = PluginMenu.this.loadPluginClass(names[ind]);
                    try {
                        JInternalFrame jif = (JInternalFrame)cl.newInstance();
                        dPane.add(jif);
                        jif.setVisible(true);
                    }
                    catch (ClassCastException cce) {
                        System.out.println("Plugin error: plugin class must extend JInternalFrame.");
                        cce.printStackTrace();
                    }
                    catch (InstantiationException ie) {
                        System.out.println("Plugin error: plugin class couldn't be instantiated.");
                        ie.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.add(thisItem);
            ++i;
        }
    }

    Class loadPluginClass(String name) {
        File file = new File("plugins/");
        Class<?> cls = null;
        try {
            URL url = file.toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader cl = new URLClassLoader(urls);
            cls = cl.loadClass(name);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return cls;
    }

    String[] getPluginClassNames() {
        File plugindir = new File("plugins/");
        System.out.println("Plugin directory: " + plugindir);
        File[] fList = plugindir.listFiles();
        if (fList == null) {
            return new String[0];
        }
        System.out.println(fList.length + " plugins found.");
        String[] names = new String[fList.length];
        int i = 0;
        while (i < fList.length) {
            String fullFileName = fList[i].getName();
            StringTokenizer st = new StringTokenizer(fullFileName, ".");
            names[i] = st.nextToken();
            ++i;
        }
        return names;
    }
}

