/*
 *
 * The Xylophoniad
 *
 * Things
 *
 * code and data dealing with 'things' in the game,
 * which I'm making a point of NOT calling objects.
 *
 */

var Thing = new Object;
NUM_THNG = 0;
function th(name,fullname,wearable,firstplace,description,uses,daemonBefore,daemonAfter)
{
	Thing[++NUM_THNG] = new Object;
	Thing[NUM_THNG].id = NUM_THNG;
	Thing[NUM_THNG].name = name; // short version of name
	Thing[NUM_THNG].shortname = name; // short version of name
	Thing[NUM_THNG].fullname = fullname; // full name
	Thing[NUM_THNG].wearable = wearable; // true for clothing
	Thing[NUM_THNG].firstplace = firstplace; // starting place
	Thing[NUM_THNG].description = description;
	Thing[NUM_THNG].uses = uses; // general uses
	Thing[NUM_THNG].daemonBefore = daemonBefore;
	Thing[NUM_THNG].daemonAfter = daemonAfter;
	var varname = name;
	while(varname.indexOf(' ')!=-1) {
		varname = varname.replace(' ', '_');
	}
	eval(varname + ' = Thing[' + NUM_THNG + '];');
	
	Thing[NUM_THNG].isContainer = false;
}


th('nothing',
'nothing',
false,
nowhere,
'It is nothing at all. You shouldn\'t be looking at it!',
{},
null, null
);

th('sword',
'your sword',
false,
nowhere,
"This is your sword. It's not a magical sword, or even \
an expensive one, but it's long and sharp and you know how \
to use it.",
{
	wave: "You give your sword a few practice swings. That feels good." },
null, null);

th('scroll',
'a scroll',
false,
nowhere,
'This is a court order listing the three labours you\'ve been charged to do: \n\
&nbsp;\n\
[[ scroll_html() ]]',
{},
null, null);
function scroll_html() {
	// can't say this using [[expression]]s because weird things happen if a [[]] comes in the middle of an HTML tag
	return '<center><div class="scroll"><span class="laboursTitle">The three labours of Xylophone</span>:\n\
	<span class="labour' + (gs(FINISHED_BICYCLOPS) ? ' completed' : '') + '">1. Slay the Bicyclops</span>\n\
	<span class="labour' + (gs(FINISHED_HADES) ? ' completed' : '') + '">2. Recover two souls from Hades</span>\n\
	<span class="labour' + (gs(FINISHED_TROY) ? ' completed' : '') + '">3. End the Trojan war and rescue Helen</span></div></center>';
}

//th(name,fullname,wearable,firstplace,description,uses,
//daemonBefore,daemonAfter)

th('figurine',
'an ivory figurine',
false,
temple_eris,
"An intricately carved figurine of a water nymph, about \
a handspan long, made of pearly white ivory.",
{},
null, null);


function pldo(th)
{
	return('does');
}

// called when you attempt to foo something that can't be fooed
function default_use(verb,th)
{
	if(verb=='eat')
		say('I don\'t think the ' + th.name + ' would be very tasty.');
	else if(verb=='talk')
		say('The ' + th.name + ' doesn\'t seem to be very talkative.');
	else if(verb=='smell')
		say('The ' + th.name + ' doesn\'t smell very interesting.');
	else if(verb=='kiss')
		say('I don\'t think you and the ' + th.name + ' are close enough for that.');
	else if(verb=='fight')
		say('You have no animosity towards the ' + th.name + '.');
	else if(verb=='wave')
		say('Waving the ' + th.name + ' about has no useful effect.');
	else if(verb=='wear')
		say('You can\'t wear the ' + th.name + '!');
	else
		say('You can\'t do that with the ' + th.name + '.');
}

/*
th('harp',
'a harp/
*/

th('ointment',
"a pot of ointment",
false,
medusas_cave,
"A ceramic pot containing a quantity of gloopy green ointment.",
{
	'wear' : use_ointment,
	'use' : use_ointment,
	'try' : use_ointment,
},
null, null);
function use_ointment() {
	
	for(var i=3; i<=MAX_TOKENS; ++i) {
		if(Token[i] && Token[i] != 'on' && Token[i] != 'skin' && Token[i] != 'self') {
			say("That would be pointless.");
			return;
		}
	}

	say("You rub a little of the ointment on your skin. \
	     It tingles slightly, and makes your skin feel a \
	     lot softer.");
}


th('key',
'a bronze key',
false,
nowhere,
"A heavy bronze key with a heart-shaped loop. On the shaft is engraved in tiny writing: " +
 "<i>To the bedchamber of she whose face launched a thousand ships.</i>",
{},
null, null);

th('chicken',
"a chicken leg",
false,
nowhere,
"A partly eaten leg of roast chicken, dripping with grease.",
{
	eat: "You gnaw a little bit of meat from the chicken leg. Mmmm, greasy.",
	smell: "It smells savoury and delicious.",
},
null, null);

th('kithara',
"a kithara",
false,
sapphos_house,
"The kithara is a lyre-like stringed musical instrument. This is a big bass one, with a large, triangular frame and enough strings for four octaves.",
{
	play: "You pluck the strings of the kithara and manage to strike out the melody to the musical poem \"Tria Typhla Pontikia\". " +
	       "The music is deep and resonant.",
},
null, null);

th('aulos',
"an aulos",
false,
sapphos_house,
"The aulos is a double-barrelled flute consisting of two hollow straws attached at the mouthpiece. This is a small wooden one in a soprano register.",
{
	play: "You blow the aulos and manage to toot out the melody to the musical poem \"Maria Eiche Ena Mikro Arni\". " +
	       "The music is high and soft.[[ play_aulos_in_cave(); ]]",
},
null, null);
function play_aulos_in_cave() {
	if(!gs(MEDUSA_CURED) && (heroloc()==cave_mouth || heroloc()==medusas_cave) && personloc(medusa)==medusas_cave) {
		say("\nThe hissing noise gets louder. Snakes <i>hate</i> aulos music!");
	}
}

th('fish',
"a dead fish",
false,
dock,
"It seems to be a lost sole.",
{
	eat: "What, raw? No way.",
},
function() {
	for(var i=2; i<=MAX_TOKENS; ++i) {
		if(Token[i]=='fish' && Token[i-1]=='dead') {
			Token[i-1] = 'fish';
			for(var j=i; i<=MAX_TOKENS-1; ++j) {
				Token[j] = Token[j+1];
			}
			Token[MAX_TOKENS] = '';
		}
	}
},
null
);

// th(name,fullname,wearable,firstplace,description,uses,daemonBefore,daemonAfter)
th('handcart',
"a handcart",
false,
dock,
"An old handcart made of worm-eaten wood. It has [[ !gs(WHEELS_OFF_HANDCART) ? 'a couple of wheels, ' : '' ]]a pole " +
 "on the back for pushing it, and a basket large enough to stand in.",
{
	take: "The handcart is too big to actually lift.[[ gs(WHEELS_OFF_HANDCART) ? '' : ' You could try pushing it.']]",
	//push: push_handcart,
},
null, null);
function push_handcart() {
	if(gs(WHEELS_OFF_HANDCART)) {
		say("The wheel-less cart just scrapes a few inches along the ground before you give up.");
	} else {
		say("As soon as you put your hands on the handcart, its wheels fall off. [[ Token[1]=='take' ? 'You pick them up.' : 'So much for that.' ]]");
		get_point_for(WHEELS_OFF_HANDCART);
		if(Token[1]=='take') {
			give_hero(cartwheels)
		} else {
			set_thingloc(cartwheels, heroloc());
		}
	}
	
	//return true;
}
handcart.isContainer = true;

th('cartwheels',
"a pair of cartwheels",
false,
nowhere,
"A couple of spoked wooden wheels about two feet in diameter. They're old and a bit shabby, but still seem fairly strong.",
{},
null, null);

th('saddle',
"a saddle",
false,
nowhere,
"An old leather saddle with cloth straps.",
{},
null, null);

th('coldbox',
"a coldbox",
false,
daedalus_workshop,
"A large white box with an open top, emitting a faint humming noise. From the mist condensing around it, it seems to be very cold.[[ personloc(daedalus)==daedalus_workshop ? '\\n\"That\\\'s another invention of mine,\" says Daedalus. \"It\\\'s a box for keeping food cold. I named it after the kingdom of Phrygia " +
	          "in Anatolia. Behold, the Anatoliarator!\"' : \"\" ]]",
{ take: "The coldbox is too heavy to lift.",
},
function() {
	if(heroloc()==thingloc(coldbox)) {
		for(var i=2; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='crates' && Token[i-1]=='cold') {
				Token[i-1] = 'coldbox';
				for(var j=i; j<=MAX_TOKENS-1; ++j) {
					Token[j] = Token[j+1];
				}
				Token[MAX_TOKENS] = '';
			}
		}
		
		// in the presence of the coldbox, 'crates' means coldbox
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='crates') {
				Token[i] = 'coldbox';
			}
		}
	}
},
null);
coldbox.isContainer = true;

th('cheese',
"a wedge of cheese",
false,
nowhere,
"A piece of bright yellow cheese shaped into a sturdy triangular wedge.",
{ eat: "You nibble a corner of the cheese. It's a bit strong for you.",
  smell: "The cheese smells rather strongly of rancid milk and old socks." },
null, null);

th('pitchfork',
"a pitchfork",
false,
empty_cell,
"A two-tined pitchfork made of some weird, cold material. The tips of the prongs are glowing slightly.",
{},
null, null);
 
/*** begin money (keep last) ***/
th('money',
'some money',
false,
nowhere,
'You have [[ numberToWords(gs(MONEY_LEFT)) ]] obol[[ gs(MONEY_LEFT) == 1 ? "" : "s" ]] left. [[ money_comment() ]]',
{ 'talk' : "Turns out money doesn't talk.",
  'count' : "*thingsee(money)" }
);
function money_comment() {

	var moneyLeft = gs(MONEY_LEFT);
	if(gs(MONEY_LEFT) >= 20) {
		say("Not a fortune, but it'll get you through.");
	} else if(gs(MONEY_LEFT) >= 10) {
		say("Tight, but you'll manage.");
	} else {
		say("Better watch the pennies.");
	}
	
}

// spend n obols. return true if successful. take away the 'money' object if it falls to zero.
function spend(n) {
	var moneyleft = gs(MONEY_LEFT);
	if(!in_inv(money)) {
		say("You haven't got any money.");
		return false;
	}
	if(n > MONEY_LEFT) {
		say("You haven't got enough money. You've only got [[ numberToWords(moneyleft) ]] obols.");
		return false;
	} else {
		sgs(MONEY_LEFT, gs(MONEY_LEFT) - 1);
		if(gs(MONEY_LEFT) == 0) {
			take_away(money);
		}
		return true;
	}
}
/*** end money ***/



