/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.MemoryAccess;
import org.zmpp.vm.StoryFileHeader;

public class DefaultStoryFileHeader
implements StoryFileHeader {
    private MemoryAccess memaccess;

    public DefaultStoryFileHeader(MemoryAccess memoryAccess) {
        this.memaccess = memoryAccess;
    }

    public int getVersion() {
        return this.memaccess.readUnsignedByte(0);
    }

    public int getRelease() {
        return this.memaccess.readUnsignedShort(2);
    }

    public int getHighMemAddress() {
        return this.memaccess.readUnsignedShort(4);
    }

    public int getProgramStart() {
        return this.memaccess.readUnsignedShort(6);
    }

    public int getDictionaryAddress() {
        return this.memaccess.readUnsignedShort(8);
    }

    public int getObjectTableAddress() {
        return this.memaccess.readUnsignedShort(10);
    }

    public int getGlobalsAddress() {
        return this.memaccess.readUnsignedShort(12);
    }

    public int getStaticsAddress() {
        return this.memaccess.readUnsignedShort(14);
    }

    public String getSerialNumber() {
        return this.extractAscii(18, 6);
    }

    public int getAbbreviationsAddress() {
        return this.memaccess.readUnsignedShort(24);
    }

    public int getFileLength() {
        int n = this.memaccess.readUnsignedShort(26);
        n = this.getVersion() <= 3 ? (n *= 2) : (this.getVersion() <= 5 ? (n *= 4) : (n *= 8));
        return n;
    }

    public int getChecksum() {
        return this.memaccess.readUnsignedShort(28);
    }

    public void setInterpreterNumber(int n) {
        this.memaccess.writeUnsignedByte(30, (short)n);
    }

    public void setInterpreterVersion(int n) {
        if (this.getVersion() == 4 || this.getVersion() == 5) {
            this.memaccess.writeUnsignedByte(31, (short)String.valueOf(n).charAt(0));
        } else {
            this.memaccess.writeUnsignedByte(31, (short)n);
        }
    }

    public void setScreenWidth(int n) {
        this.memaccess.writeUnsignedByte(33, (short)n);
    }

    public void setScreenWidthUnits(int n) {
        this.memaccess.writeUnsignedShort(34, n);
    }

    public int getScreenWidth() {
        return this.memaccess.readUnsignedByte(33);
    }

    public void setScreenHeight(int n) {
        this.memaccess.writeUnsignedByte(32, (short)n);
    }

    public void setScreenHeightUnits(int n) {
        this.memaccess.writeUnsignedShort(36, n);
    }

    public int getRoutineOffset() {
        return this.memaccess.readUnsignedShort(40);
    }

    public int getStaticStringOffset() {
        return this.memaccess.readUnsignedShort(42);
    }

    public int getDefaultBackgroundColor() {
        return this.memaccess.readUnsignedByte(44);
    }

    public int getDefaultForegroundColor() {
        return this.memaccess.readUnsignedByte(45);
    }

    public void setDefaultBackgroundColor(int n) {
        this.memaccess.writeUnsignedByte(44, (short)n);
    }

    public void setDefaultForegroundColor(int n) {
        this.memaccess.writeUnsignedByte(45, (short)n);
    }

    public void setStandardRevision(int n, int n2) {
        this.memaccess.writeUnsignedByte(50, (short)n);
        this.memaccess.writeUnsignedByte(51, (short)n2);
    }

    public int getTerminatorsAddress() {
        return this.memaccess.readUnsignedShort(46);
    }

    public void setFontWidth(int n) {
        if (this.getVersion() == 6) {
            this.memaccess.writeUnsignedByte(39, (short)n);
        } else {
            this.memaccess.writeUnsignedByte(38, (short)n);
        }
    }

    public void setFontHeight(int n) {
        if (this.getVersion() == 6) {
            this.memaccess.writeUnsignedByte(38, (short)n);
        } else {
            this.memaccess.writeUnsignedByte(39, (short)n);
        }
    }

    public int getCustomAlphabetTable() {
        return this.memaccess.readUnsignedShort(52);
    }

    public void setMouseCoordinates(int n, int n2) {
        int n3 = this.memaccess.readUnsignedShort(54);
        if (n3 > 0) {
            int n4 = this.memaccess.readUnsignedShort(n3);
            if (n4 >= 1) {
                this.memaccess.writeUnsignedShort(n3 + 1, n);
            }
            if (n4 >= 2) {
                this.memaccess.writeUnsignedShort(n3 + 2, n2);
            }
        }
    }

    public int getCustomAccentTable() {
        int n;
        int n2 = 0;
        int n3 = this.memaccess.readUnsignedShort(54);
        if (n3 > 0 && (n = this.memaccess.readUnsignedShort(n3)) >= 3) {
            n2 = this.memaccess.readUnsignedShort(n3 + 2);
        }
        return n2;
    }

    public void setEnabled(StoryFileHeader.Attribute attribute, boolean bl) {
        switch (attribute) {
            case DEFAULT_FONT_IS_VARIABLE: {
                this.setDefaultFontIsVariablePitch(bl);
                break;
            }
            case TRANSCRIPTING: {
                this.setTranscripting(bl);
                break;
            }
            case FORCE_FIXED_FONT: {
                this.setForceFixedFont(bl);
                break;
            }
            case SUPPORTS_TIMED_INPUT: {
                this.setTimedInputAvailable(bl);
                break;
            }
            case SUPPORTS_FIXED_FONT: {
                this.setFixedFontAvailable(bl);
                break;
            }
            case SUPPORTS_BOLD: {
                this.setBoldFaceAvailable(bl);
                break;
            }
            case SUPPORTS_ITALIC: {
                this.setItalicAvailable(bl);
                break;
            }
            case SUPPORTS_SCREEN_SPLITTING: {
                this.setScreenSplittingAvailable(bl);
                break;
            }
            case SUPPORTS_STATUSLINE: {
                this.setStatusLineAvailable(bl);
                break;
            }
            case SUPPORTS_COLOURS: {
                this.setSupportsColours(bl);
            }
        }
    }

    public boolean isEnabled(StoryFileHeader.Attribute attribute) {
        switch (attribute) {
            case TRANSCRIPTING: {
                return this.isTranscriptingOn();
            }
            case FORCE_FIXED_FONT: {
                return this.forceFixedFont();
            }
            case SCORE_GAME: {
                return this.isScoreGame();
            }
            case DEFAULT_FONT_IS_VARIABLE: {
                return this.defaultFontIsVariablePitch();
            }
            case USE_MOUSE: {
                return this.useMouse();
            }
        }
        return false;
    }

    private String extractAscii(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            stringBuilder.append((char)this.memaccess.readUnsignedByte(i));
        }
        return stringBuilder.toString();
    }

    private void setTranscripting(boolean bl) {
        int n = this.memaccess.readUnsignedByte(16);
        n = bl ? n | 1 : n & 0xFE;
        this.memaccess.writeUnsignedByte(16, (short)n);
    }

    private boolean isTranscriptingOn() {
        return (this.memaccess.readUnsignedByte(16) & 1) > 0;
    }

    private boolean forceFixedFont() {
        return (this.memaccess.readUnsignedByte(16) & 2) > 0;
    }

    private void setForceFixedFont(boolean bl) {
        int n = this.memaccess.readUnsignedByte(16);
        n = bl ? n | 2 : n & 0xFD;
        this.memaccess.writeUnsignedByte(16, (short)n);
    }

    private void setTimedInputAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 0x80 : n & 0x7F;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private boolean isScoreGame() {
        return (this.memaccess.readUnsignedByte(1) & 2) == 0;
    }

    private void setFixedFontAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 0x10 : n & 0xEF;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private void setBoldFaceAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 4 : n & 0xFB;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private void setItalicAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 8 : n & 0xF7;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private void setScreenSplittingAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 0x20 : n & 0xDF;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private void setStatusLineAvailable(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 0x10 : n & 0xEF;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private void setDefaultFontIsVariablePitch(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 0x40 : n & 0xBF;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private boolean defaultFontIsVariablePitch() {
        return (this.memaccess.readUnsignedByte(1) & 0x40) > 0;
    }

    private void setSupportsColours(boolean bl) {
        int n = this.memaccess.readUnsignedByte(1);
        n = bl ? n | 1 : n & 0xFE;
        this.memaccess.writeUnsignedByte(1, (short)n);
    }

    private boolean useMouse() {
        return (this.memaccess.readUnsignedByte(16) & 0x20) > 0;
    }
}

