
var loc = null;
var lastcrisis = null;
var kingchoice = null;
var studentchoice = null;
var dist = 0;
var maxdist = 0;
var exilecount = 0;
var penurycount = 0;
var madnesscount = 0;

function startup()
{
    say('\n\n\n');

    say('Hail, O King! Hail! ');
    say('(Chant the thousand voices of the priests.)\n', 'emphasized', true);

    say('The Paths of the Gods open before you. Life is choice, but all choices are behind you now. As you lived, so will you be greeted in death. What have you chosen?\n');

    say('(And then the chant ends, and the footsteps of the living recede. Somewhere, a door crashes shut.)\n', 'emphasized');

    loc = 'start';
    lastcrisis = null;
    kingchoice = null;
    studentchoice = null;
    dist = 1;
    maxdist = 1;
    exilecount = 0;
    penurycount = 0;
    madnesscount = 0;

    look();
}

function choiceof(ls)
{
    var ix = Math.floor(ls.length * Math.random());
    return ls[ix];
}

function crisisexit()
{
    say(runproctext('ExitLeads', true));
    say_runon(' ');
    say_hyperlink('forward', 'f');
    say_runon('.');
    say('No! Enough! I want to go ');
    say_hyperlink('back', 'b');
    say_runon('!');
}

function studentexit()
{
    say('You can go ');
    say_hyperlink('forward', 'f');
    say_runon('.');
    say('I do not understand this. Let me go ');
    say_hyperlink('back', 'b');
    say_runon('.');
}

function look()
{
    if (loc == 'start' || loc == 'convo')
        say('');
    else if (loc == 'chapter2' || loc == 'chapter3')
        say('     --- You retreat... ---\n');
    else
        say('     --- You advance... ---\n');

    switch (loc) {
    case 'start':
        say('The Afterlife', 'subheader');
        say('Death is dim and more cramped than you expected. Or maybe your tomb is roomier than you expected? But no -- this isn\'t the inside of the royal sarcophagus. It\'s a stone passage, slimed with mud and trickling with damp nitre.\n');

        say('You can go ');
        say_hyperlink('forward', 'f');
        say_runon('. Never back. All the priest-tales about the afterlife agree on ');
        say_runon('that.', 'emphasized');
        break;

    case 'hall':
        say(runproctext('CorridorHead', true), 'subheader');
        say(runproctext('CorridorBody'));

        say('You can go ');
        say_hyperlink('forward', 'f');
        say_runon('.');
        break;

    case 'famine':
        say(runproctext('FamineHead', true), 'subheader');
        say(runproctext('MuralRoomBody', false, {crisis:loc}));
        say('');
        say(runproctext('FamineMural'), 'emphasized');
        say('');
        crisisexit();
        break;

    case 'revolt':
        say(runproctext('RevoltHead', true), 'subheader');
        say(runproctext('MuralRoomBody', false, {crisis:loc}));
        say('');
        say(runproctext('RevoltMural'), 'emphasized');
        say('');
        crisisexit();
        break;

    case 'plague':
        say(runproctext('PlagueHead', true), 'subheader');
        say(runproctext('MuralRoomBody', false, {crisis:loc}));
        say('');
        say(runproctext('PlagueMural'), 'emphasized');
        say('');
        crisisexit();
        break;

    case 'chapter2':
        say('You stumble back into the gloom. Your foot lands on nothing...');
        say('\nSee, ');
        say_runon('this', 'emphasized');
        say_runon(' is why you\'re not supposed to go backwards.)');
        say('\n...The walls are gone.');
        say('');
        say('Ruins, Outdoors', 'subheader');
        say('Sunlight blinds you, and the hot smell of dirt on a summer\'s day. You hear cheerful shouts in the distance. But you see no one -- only crumbling walls and heaps of worn stone.');
        say('\n"Dammit, I dropped my phone somewhere. Must have been the dig session this morning." comes a voice.');

        say('\nBroken stone is heaped around your feet. You can still move ');
        say_hyperlink('forward', 'f');
        say_runon('.');
        break;

    case 'site':
        say(runproctext('SiteHead', true), 'subheader');
        say(runproctext('SiteBody'));

        say('\nYou can go ');
        say_hyperlink('forward', 'f');
        say_runon('.');
        break;

    case 'exile':
        say('Exile', 'subheader');
        say(runproctext('SitePresence'));
        say('');
        switch (exilecount++) {
        case 0:
            say('You hear the voice: "So then Tanya\'s other girlfriend freaked out, and they broke up, which is fine -- she was damage central, I swear -- but now half of Tanya\'s friends are mad at her. And the other half are mad at ');
            say_runon('me', 'emphasized');
            say_runon(' for introducing them in the first place."');
            break;
        case 1:
            say('"I want to be there for Tanya, but no, I\'m out here in Crete, having the time of my life -- more or less -- the point is, she can\'t even be upset that we\'re long distance. Because Tanya is actually a nice person. Dammit."');
            break;
        case 2:
            say('"I\'d encourage her to find a new sweetie, but she\'d be all \'add new person?\' if ');
            say_runon('I', 'emphasized');
            say_runon(' said it. Anyway, most of her local network went with the damage monster."');
            break;
        default:
            say('"Relationships. They are hard. Ding!"');
            break;
        }
        say('');
        studentexit();
        break;

    case 'penury':
        say('Penury', 'subheader');
        say(runproctext('SitePresence'));
        say('');
        switch (penurycount++) {
        case 0:
            say('"Sure, the summer session is great, but what about my student loans?" comes the voice.');
            break;
        case 1:
            say('"I\'m going to wind up with a degree, a ton of dig experience, and a lifetime membership in \'Do You Want Fries With That?\' Prime."');
            break;
        case 2:
            say('"I should have the loans paid off by, oh, 2100. Which, by coincidence, will be the year this island will be submerged by global warming."');
            break;
        default:
            say('"I can have a second career as a scuba-diving archeologist who knows how to flip burgers. If there are any cows left."');
            break;
        }
        say('');
        studentexit();
        break;

    case 'madness':
        say('Madness', 'subheader');
        say(runproctext('SitePresence'));
        say('');
        switch (madnesscount++) {
        case 0:
            say('"Well, you try adjusting your meds the week before starting a semester abroad," says the voice. "No, the old stuff really wasn\'t working any more, so I switched to ZXO in the spring -- yeah -- and then I basically didn\'t sleep for a month."');
            break;
        case 1:
            say('"The doctor recommended halving the dosage and adding another thing, which seemed smart, but there I was leaving in a week. Timing! But I knew that doing the dig on permanent insomnia would kill me."');
            break;
        case 2:
            say('"So yeah, my concentration is sort of shot and I get hot flashes, but I can get work done. The rest, I\'ll have to work out with Tanya when I get home. Assuming we\'re still a thing."');
            break;
        default:
            say('"My therapist is great, actually. But again -- in Massachusetts."');
            break;
        }
        say('');
        studentexit();
        break;

    case 'chapter3':
        say('You take a step back. You try to be more careful this time, but nonetheless -- your probing foot comes down on nothing...');
        say('\n...The sunlight is gone. The walls are gone. There is only a fog, and, somewhere within it, the woman\'s voice.');
        say('\n"So, Mister Minos. What do you have to say for yourself, I wonder..."');
        
        say('\n');
        say_hyperlink('Forward', 'f');
        say_runon(' and ');
        say_hyperlink('backward', 'b');
        say_runon(' are all the same now.');
        break;

    case 'convo':
        say('Conversation', 'subheader');
        say('');
        outcome(kingchoice+'-'+studentchoice);
        say('\nThe conversation moves forward...', 'emphasized');
        say('\n...But we will leave you for now.');
        say('\n(You may ');
        say_hyperlink('start over', 'b');
        say_runon(' or ');
        say_hyperlink('leave the game', 'f');
        say_runon('.)');
        break;

    default:
        say('ERROR: Unknown location: ' + loc);
        break;
    }

    say('');
}

function respond(link) 
{
    if (link != 'f' && link != 'b') {
        say('ERROR: Unknown link: "' + link + '".');
        return;
    }
    var forward = (link == 'f');

    function noback() {
        say('You know you cannot go back.');
    };
    
    switch (loc) {

    case 'start':
        if (!forward) return noback();
        loc = 'hall';
        dist = 1;
        break;

    case 'hall':
        if (!forward) return noback();
        dist--;
        if (dist <= 0) {
            loc = null;
            while (!loc || loc == lastcrisis)
                loc = choiceof(['famine', 'plague', 'revolt']);
        }
        break;

    case 'famine':
    case 'plague':
    case 'revolt':
        if (!forward) {
            kingchoice = loc;
            loc = 'chapter2';
            break;
        }
        lastcrisis = loc;
        dist = maxdist;
        maxdist++;
        loc = 'hall';
        break;

    case 'chapter2':
        if (!forward) return noback();
        loc = 'site';
        dist = 1;
        maxdist = 1;
        lastcrisis = null;
        break;

    case 'site':
        if (!forward) return noback();
        dist--;
        if (dist <= 0) {
            loc = null;
            while (!loc || loc == lastcrisis)
                loc = choiceof(['exile', 'penury', 'madness']);
        }
        break;

    case 'exile':
    case 'penury':
    case 'madness':
        if (!forward) {
            studentchoice = loc;
            loc = 'chapter3';
            break;
        }
        lastcrisis = loc;
        dist = Math.floor(maxdist);
        maxdist += 0.25;
        loc = 'site';
        break;

    case 'chapter3':
        loc = 'convo';
        break;

    case 'convo':
        if (!forward) {
            clearwindow();
            startup();
            return;
        }
        disablewindow();
        GlkOte.warning('The game has ended.');
        return;

    default:
        say('ERROR: Unknown location: ' + loc);
        return;
    }

    look();
}

function outcome(val)
{
    switch (val) {

    case 'famine-penury':
        say('"You are in debt, child; you are not ');
        say_runon('destitute', 'emphasized');
        say_runon('. You eat well. You sleep on cushions."\n\n"Sure, I know. In your time everybody was malnourished and runty. For most of the next four thousand years, too."\n\n"And in your time, all are wealthy?"\n\n"Heck no. Or maybe. As a civilization we are inconceivably wealthy. That doesn\'t mean nobody is poor, it just means that most people have food and beds... I must sound like an idiot to you."\n\n"I was a king, and now I am dead. I have been dead for four thousand years, you say. Who can say whether I was wealthy or you are mad."');
        break;

    case 'famine-exile':
        say('"You cannot look at the starvation of my people and compare it to your friend\'s love affair."\n\n"Hey, that\'s my ');
        say_runon('girlfriend\'s', 'emphasized');
        say_runon(' love affair. And I darn well can. You\'re dead. Everyone in your kingdom is dead. No quantity of free ramen would have kept them alive until today."\n\n"Still we lived. Still we suffered."\n\n"Don\'t give me that \'we\', Mister King Minos. You had plenty to eat. And for the tens of thousands of peasants who died during your reign... sorry. Famines happened."\n\n"I too am sorry. I do not mean to throw my troubles in your face. They are behind me as well. Whereas your... friend Tanya is alive. You care about her."\n\n"I mean, I care about you people too, right? I study your lives. I even try to imagine them. But I can\'t carry them all. ');
        say_runon('My', 'emphasized');
        say_runon(' life is the one I live."');
        break;

    case 'famine-madness':
        say('"The notion of a medicine to cure madness is not strange. Any charlatan will offer to sell you one."\n\n"But my pills mostly work. That\'d be the strange part, to you. And, by the way, it\'s not \'madness\'. It\'s depression."\n\n"Madness would be talking to the ghost of a king, I suppose."\n\n"You\'re funny, dead man. No, I can pretend to talk to anyone I want to. That\'s not madness, that\'s archeology."\n\n"I suppose we would call it priesthood."\n\n"No, that\'s... hm. Let me get back to you on that."');
        break;

    case 'plague-madness':
        say('"Medicines for an ill mind... physicians must have discovered many wonders of healing in four thousand years."\n\n"Yes. Really, most of them in the last hundred. Really it was all details after \'wash your hands\'."\n\n"We built sewers, you know. Clean lavatories with flowing water. Storm drains."\n\n"I know! Seen \'em. We were all impressed. Didn\'t last, though."\n\n"If we had had your medicines, would the plague have spared us?"\n\n"I don\'t know, man. From what you\'ve described, it might have been a plankton bloom rather than a disease."\n\n"Flowers?"\n\n"Bad fish."\n\n"Ah. That I understand."');
        break;

    case 'plague-penury':
        say('"And have you cured all ills in your time?"\n\n"No, no. We can cure a lot of diseases, and then one of the others gets you. Plus there\'s all this argument about costs."\n\n"The rich can afford physicians, of course. And you? You are indebted, but you have coin."\n\n"That\'s the thing though. Health care is expensive. There\'s this system... I don\'t think I\'ll try to explain it to you. I\'m still on my parents\', anyhow."\n\n"They are wealthy, then."\n\n"That is... almost exactly the opposite of the reason. But hey, maybe dad\'s book will sell."');
        break;

    case 'plague-exile':
        say('"Your problems seem very small compared to the plague of that summer."\n\n"I certainly don\'t want to stack them up and measure. But you all lived and died so long ago."\n\n"And you won\'t be born for... how long have I been dead?"\n\n"Mister, I\'m not sure you were ever alive. Just because we named the place after you doesn\'t mean you existed."\n\n"There is glory in my name, then, at least. And my line?"\n\n"Let\'s see. Children of Minos. There are stories about Ariadne, Phaedra, Glaucus..."\n\n"My sons and daughters were no Greeks!"\n\n"I suppose not. A lot of legends stuck to you, though."\n\n"And your line, child? You spoke of your lover, but..."\n\n"Oh, we\'ve talked about having kids. We\'ll work it out. If, you know, we work it out."');
        break;

    case 'revolt-penury':
        say('"Slaves were kept in Crete, indeed. Greeks from the mainland, debtors, raiders captured at sea."\n\n"We knew that, yeah. But we were never sure how important slavery was."\n\n"It served a purpose. Some tasks would not be done by peasants. And you? You speak as if you were indentured to your teachers."\n\n"That\'s not exactly it. When I say the bank owns my ass, I\'m more or less joking..."\n\n"Truth spoken in jest, perhaps."\n\n"The grad students aren\'t going to rise up and burn the administrative office, though. Probably. I think. Hasn\'t happened yet, anyway."');
        break;

    case 'revolt-madness':
        say('"You say slavery has been forbidden among your great nations for a hundred and fifty years. So thus it was accepted for the four thousand years before that?"\n\n"I\'m not saying we\'ve done a ');
        say_runon('great', 'emphasized');
        say_runon(' job. Even after a hundred fifty years, the problems among the -- well, there are still problems."\n\n"We had laws about the holding and treatment of slaves, you understand."\n\n"That\'s less reassuring than you might think. You shouldn\'t have been surprised about the uprising."\n\n"It was madness. It caused great suffering, and the laws were harsher afterwards."\n\n"See, we already talked about madness."');
        break;

    case 'revolt-exile':
        say('"But without marriage, how do you know who fathers your -- oh, I beg your pardon."\n\n"No sweat. I don\'t expect you to catch up all at once. Anyhow, plenty of people get married. We just don\'t figure it\'s the only way to do things."\n\n"My father would have talked sternly about the collapse of honor, virtue, and the foundations of society. He dearly loved that speech, when I was young and learning of women."\n\n"Bit of irony there, Mister Minos, considering your father -- oh, never mind. Anyway, we figure society is people and they can figure it out."\n\n"Thus we believed as well. The revolt was a great surprise."\n\n"You can\'t compare slavery to -- hm. Don\'t tell my grandmother I said that."');
        break;

    default:
        say('ERROR: Unknown combo: ' + val);
        break;

    }
}

function runproctext(label, skipstop, initmap)
{
    var proc = proctexts[label];
    if (!proc) {
        return 'ERROR: ProcText: entry does not exist: ' + label;
    }
    
    context = {};
    context.store = {};
    context.proctext = proc;
    context.procshufflelast = {};
    context.procshufflelist = {};
    context.procaccum = [];

    if (initmap)
        jQuery.extend(context.store, initmap);
    
    procgenerate(context, 'root');

    var accum = context.procaccum;
    context.proctext = null;
    context.procshufflelast = null;
    context.procshufflelist = null;
    context.procaccum = null;
    var res = procassemble(context, accum, skipstop);
    return res;
}
