/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;

class XThis
extends This {
    Hashtable interfaces;
    InvocationHandler invocationHandler = new Handler();

    XThis(NameSpace nameSpace, Interpreter interpreter) {
        super(nameSpace, interpreter);
    }

    public String toString() {
        return "'this' reference (XThis) to Bsh object: " + this.namespace.name;
    }

    String toStringShowInts(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer(this.toString() + "\nimplements:");
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(" " + classArray[n2].getName() + (classArray.length > 1 ? "," : ""));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Object getInterface(Class clazz) {
        Object object;
        if (this.interfaces == null) {
            this.interfaces = new Hashtable();
        }
        if ((object = this.interfaces.get(clazz)) == null) {
            object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, this.invocationHandler);
            this.interfaces.put(clazz, object);
        }
        return object;
    }

    class Handler
    implements InvocationHandler,
    Serializable {
        Handler() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws EvalError {
            try {
                return this.invokeImpl(object, method, objectArray);
            }
            catch (EvalError evalError) {
                Interpreter.debug("EvalError in scripted interface: " + XThis.this.toString() + ": " + evalError);
                throw evalError;
            }
        }

        public Object invokeImpl(Object object, Method method, Object[] objectArray) throws EvalError {
            CallStack callStack = XThis.this.newCallStack();
            Class[] classArray = Reflect.getTypes(objectArray);
            BshMethod bshMethod = XThis.this.namespace.getMethod(method.getName(), classArray);
            if (bshMethod != null) {
                return Primitive.unwrap(bshMethod.invokeDeclaredMethod(objectArray, XThis.this.declaringInterpreter, callStack, null));
            }
            bshMethod = XThis.this.namespace.getMethod("invoke", new Class[]{null, null});
            if (bshMethod != null) {
                return Primitive.unwrap(bshMethod.invokeDeclaredMethod(new Object[]{method.getName(), objectArray}, XThis.this.declaringInterpreter, callStack, null));
            }
            if (method.getName().equals("toString")) {
                return XThis.this.toStringShowInts(object.getClass().getInterfaces());
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("equals")) {
                Object object2 = objectArray[0];
                return new Boolean(object == object2);
            }
            throw new EvalError("Bsh script method: " + method.getName() + " not found in namespace: " + XThis.this.namespace.name);
        }
    }
}

