/*
 * Decompiled with CFR 0.152.
 */
package Modules.TextAnalizer;

import Modules.TextAnalizer.Analizer;
import Modules.TextAnalizer.GramList;
import Modules.TextAnalizer.InnerGenericParser;
import Modules.TextAnalizer.Phrase;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Vector;

public class GenericParser
extends InnerGenericParser {
    public GenericParser(GramList voidGrammar, GramList verbGrammar, GramList compGrammar) {
        super(voidGrammar, verbGrammar, compGrammar);
    }

    protected LinkedList cleanText(String text) {
        LinkedList<String> phrase = new LinkedList<String>();
        StreamTokenizer ist = new StreamTokenizer(new StringReader(text));
        try {
            while (ist.nextToken() != -1) {
                if (ist.ttype != -3) continue;
                if (this.voidGrammar != null) {
                    if (this.voidGrammar.in(ist.sval)) continue;
                    phrase.add(ist.sval);
                    continue;
                }
                phrase.add(ist.sval);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return phrase;
    }

    protected Phrase makeCommand(LinkedList phrase) {
        Phrase command = new Phrase();
        if (phrase.size() > 0) {
            command.setVerb((String)phrase.get(0));
            int c = 1;
            while (c < phrase.size()) {
                command.setComp((String)phrase.get(c));
                ++c;
            }
        }
        return command;
    }

    protected Vector verbAnalisys(LinkedList phrase) {
        Analizer analizador = new Analizer(this.verbGrammar);
        Vector vec = new Vector();
        int c = 0;
        while (c < phrase.size()) {
            vec.add(phrase.get(c));
            ++c;
        }
        analizador.loadWords(vec);
        analizador.comp();
        this.command.setVerb(analizador.getTheWord());
        this.command.setVerb(analizador.getToken());
        return analizador.getListOfWords();
    }

    protected void compAnalisys(Vector phrase) {
        Analizer analizador = new Analizer(this.compGrammar);
        analizador.loadWords(phrase);
        analizador.setWordsInComp(4);
        while (analizador.moreWords()) {
            analizador.comp();
            this.command.setComp(analizador.getTheWord());
            this.command.setComp(analizador.getToken());
        }
    }
}

