/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.zmpp.blorb.BlorbMediaCollection;
import org.zmpp.blorb.MemoryAccessInputStream;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlorbImages
extends BlorbMediaCollection<BufferedImage> {
    private Map<Integer, BufferedImage> images;

    public BlorbImages(FormChunk formChunk) {
        super(formChunk);
    }

    @Override
    public void clear() {
        super.clear();
        this.images.clear();
    }

    @Override
    protected void initDatabase() {
        this.images = new HashMap<Integer, BufferedImage>();
    }

    @Override
    protected boolean isHandledResource(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 105 && byArray[2] == 99 && byArray[3] == 116;
    }

    @Override
    public BufferedImage getResource(int n) {
        return this.images.get(n);
    }

    @Override
    protected boolean putToDatabase(Chunk chunk, int n) {
        MemoryAccessInputStream memoryAccessInputStream = new MemoryAccessInputStream(chunk.getMemoryAccess(), 8, chunk.getSize() + 8);
        try {
            BufferedImage bufferedImage = ImageIO.read(memoryAccessInputStream);
            this.images.put(n, bufferedImage);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

