/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.io.IOException;
import org.zmpp.instructions.DefaultInstructionDecoder;
import org.zmpp.io.FileInputStream;
import org.zmpp.io.IOSystem;
import org.zmpp.io.InputStream;
import org.zmpp.io.TranscriptOutputStream;
import org.zmpp.media.Resources;
import org.zmpp.vm.GameDataImpl;
import org.zmpp.vm.Machine;
import org.zmpp.vm.MachineImpl;
import org.zmpp.vm.MemoryOutputStream;
import org.zmpp.vm.Output;
import org.zmpp.vm.SaveGameDataStore;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StatusLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MachineFactory<T> {
    public Machine buildMachine() throws IOException {
        GameDataImpl gameDataImpl = new GameDataImpl(this.readStoryData(), this.readResources());
        if (this.isInvalidStory(gameDataImpl.getStoryFileHeader().getVersion())) {
            this.reportInvalidStory();
        }
        MachineImpl machineImpl = new MachineImpl();
        DefaultInstructionDecoder defaultInstructionDecoder = new DefaultInstructionDecoder();
        machineImpl.initialize(gameDataImpl, defaultInstructionDecoder);
        this.initUI(machineImpl);
        this.initIOSystem(machineImpl);
        return machineImpl;
    }

    protected abstract T initUI(Machine var1);

    public abstract T getUI();

    protected abstract byte[] readStoryData() throws IOException;

    protected abstract Resources readResources() throws IOException;

    protected abstract void reportInvalidStory();

    protected abstract IOSystem getIOSystem();

    protected abstract InputStream getKeyboardInputStream();

    protected abstract StatusLine getStatusLine();

    protected abstract ScreenModel getScreenModel();

    protected abstract SaveGameDataStore getSaveGameDataStore();

    private boolean isInvalidStory(int n) {
        return n < 1 || n > 8;
    }

    private void initIOSystem(Machine machine) {
        this.initInputStreams(machine);
        this.initOutputStreams(machine);
        machine.setStatusLine(this.getStatusLine());
        machine.setScreen(this.getScreenModel());
        machine.setSaveGameDataStore(this.getSaveGameDataStore());
    }

    private void initInputStreams(Machine machine) {
        machine.getInput().setInputStream(0, this.getKeyboardInputStream());
        machine.getInput().setInputStream(1, new FileInputStream(this.getIOSystem(), machine.getGameData().getZsciiEncoding()));
    }

    private void initOutputStreams(Machine machine) {
        Output output = machine.getOutput();
        output.setOutputStream(1, this.getScreenModel().getOutputStream());
        output.selectOutputStream(1, true);
        output.setOutputStream(2, new TranscriptOutputStream(this.getIOSystem(), machine.getGameData().getZsciiEncoding()));
        output.selectOutputStream(2, false);
        output.setOutputStream(3, new MemoryOutputStream(machine));
        output.selectOutputStream(3, false);
    }
}

