/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.vm.AbstractZObject;

public class ClassicZObject
extends AbstractZObject {
    private static final int OFFSET_PARENT = 4;
    private static final int OFFSET_SIBLING = 5;
    private static final int OFFSET_CHILD = 6;
    private static final int OFFSET_PROPERTYTABLE = 7;

    public ClassicZObject(MemoryAccess memoryAccess, int n, ZCharDecoder zCharDecoder) {
        super(memoryAccess, n, zCharDecoder);
    }

    protected AbstractZObject.PropertyTable createPropertyTable() {
        return new ClassicPropertyTable();
    }

    public int getParent() {
        return this.getMemoryAccess().readUnsignedByte(this.getObjectAddress() + 4);
    }

    public void setParent(int n) {
        this.getMemoryAccess().writeUnsignedByte(this.getObjectAddress() + 4, (short)(n & 0xFF));
    }

    public int getSibling() {
        return this.getMemoryAccess().readUnsignedByte(this.getObjectAddress() + 5);
    }

    public void setSibling(int n) {
        this.getMemoryAccess().writeUnsignedByte(this.getObjectAddress() + 5, (short)(n & 0xFF));
    }

    public int getChild() {
        return this.getMemoryAccess().readUnsignedByte(this.getObjectAddress() + 6);
    }

    public void setChild(int n) {
        this.getMemoryAccess().writeUnsignedByte(this.getObjectAddress() + 6, (short)(n & 0xFF));
    }

    public int getPropertyTableAddress() {
        return this.getMemoryAccess().readUnsignedShort(this.getObjectAddress() + 7);
    }

    public static int getPropertyLengthAtData(MemoryAccess memoryAccess, int n) {
        if (n == 0) {
            return 0;
        }
        short s = memoryAccess.readUnsignedByte(n - 1);
        return s / 32 + 1;
    }

    class ClassicPropertyTable
    extends AbstractZObject.PropertyTable {
        ClassicPropertyTable() {
        }

        protected int getNumPropertySizeBytes(int n) {
            return 1;
        }

        public short getPropertyNum(int n) {
            int n2 = this.getPropertyAddressAt(n);
            short s = ClassicZObject.this.getMemoryAccess().readUnsignedByte(n2);
            return (short)(s - 32 * (this.getPropertySizeAtAddress(n2) - 1));
        }

        protected int getPropertySizeAtAddress(int n) {
            return ClassicZObject.getPropertyLengthAtData(ClassicZObject.this.getMemoryAccess(), n + this.getNumPropertySizeBytes(n));
        }
    }
}

