/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import java.util.ArrayList;
import java.util.Iterator;
import org.zmpp.base.MemoryReadAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.encoding.ZCharTranslator;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.encoding.ZsciiStringBuilder;

public final class DefaultZCharDecoder
implements ZCharDecoder {
    private ZCharTranslator translator;
    private ZsciiEncoding encoding;
    private ZCharDecoder.AbbreviationsTable abbreviations;
    private ZCharDecoder abbreviationDecoder;

    public DefaultZCharDecoder(ZsciiEncoding zsciiEncoding, ZCharTranslator zCharTranslator, ZCharDecoder.AbbreviationsTable abbreviationsTable) {
        this.abbreviations = abbreviationsTable;
        this.translator = zCharTranslator;
        this.encoding = zsciiEncoding;
    }

    public ZsciiString decode2Zscii(MemoryReadAccess memoryReadAccess, int n, int n2) {
        ZsciiStringBuilder zsciiStringBuilder = new ZsciiStringBuilder();
        this.translator.reset();
        short[] sArray = DefaultZCharDecoder.extractZbytes(memoryReadAccess, n, n2);
        int n3 = 0;
        while (n3 < sArray.length) {
            boolean bl = false;
            short s = sArray[n3];
            int n4 = this.handleAbbreviation(zsciiStringBuilder, memoryReadAccess, sArray, n3);
            bl = n4 > n3;
            n3 = n4;
            if (!bl) {
                n4 = this.handleEscapeA2(zsciiStringBuilder, sArray, n3);
                bl = n4 > n3;
                n3 = n4;
            }
            if (bl) continue;
            this.decodeZchar(zsciiStringBuilder, s);
            ++n3;
        }
        return zsciiStringBuilder.toZsciiString();
    }

    private int handleAbbreviation(ZsciiStringBuilder zsciiStringBuilder, MemoryReadAccess memoryReadAccess, short[] sArray, int n) {
        int n2 = n;
        short s = sArray[n2];
        if (this.translator.isAbbreviation(s)) {
            if (n2 < sArray.length - 1) {
                ++n2;
                if (this.abbreviations != null) {
                    short s2 = sArray[n2];
                    int n3 = 32 * (s - 1) + s2;
                    int n4 = this.abbreviations.getWordAddress(n3);
                    if (this.abbreviationDecoder == null) {
                        try {
                            this.abbreviationDecoder = new DefaultZCharDecoder(this.encoding, (ZCharTranslator)this.translator.clone(), null);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            cloneNotSupportedException.printStackTrace();
                        }
                    }
                    ZsciiString zsciiString = this.abbreviationDecoder.decode2Zscii(memoryReadAccess, n4, 0);
                    zsciiStringBuilder.append(zsciiString);
                }
            }
            ++n2;
        }
        return n2;
    }

    private int handleEscapeA2(ZsciiStringBuilder zsciiStringBuilder, short[] sArray, int n) {
        int n2 = n;
        if (this.translator.willEscapeA2(sArray[n2])) {
            if (n2 < sArray.length - 2) {
                this.joinToZsciiChar(zsciiStringBuilder, sArray[n2 + 1], sArray[n2 + 2]);
                n2 += 2;
            }
            ++n2;
            this.translator.resetToLastAlphabet();
        }
        return n2;
    }

    public short decodeZChar(short s) {
        if (ZsciiEncoding.isAscii(s) || ZsciiEncoding.isAccent(s)) {
            return s;
        }
        return (short)this.translator.translate(s);
    }

    private void decodeZchar(ZsciiStringBuilder zsciiStringBuilder, short s) {
        short s2 = this.decodeZChar(s);
        if (s2 != 0) {
            zsciiStringBuilder.append(s2);
        }
    }

    public ZCharTranslator getTranslator() {
        return this.translator;
    }

    public static boolean isEndWord(short s) {
        return (s & 0x8000) > 0;
    }

    public static short[] extractZbytes(MemoryReadAccess memoryReadAccess, int n, int n2) {
        short s = 0;
        int n3 = n;
        ArrayList<short[]> arrayList = new ArrayList<short[]>();
        do {
            s = memoryReadAccess.readShort(n3);
            arrayList.add(DefaultZCharDecoder.extractBytes(s));
        } while ((n2 <= 0 || (n3 += 2) - n < n2) && !DefaultZCharDecoder.isEndWord(s));
        short[] sArray = new short[arrayList.size() * 3];
        int n4 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            short[] sArray2;
            for (short s2 : sArray2 = (short[])iterator.next()) {
                sArray[n4++] = s2;
            }
        }
        return sArray;
    }

    private static short[] extractBytes(short s) {
        short[] sArray = new short[3];
        sArray[2] = (short)(s & 0x1F);
        sArray[1] = (short)(s >> 5 & 0x1F);
        sArray[0] = (short)(s >> 10 & 0x1F);
        return sArray;
    }

    private void joinToZsciiChar(ZsciiStringBuilder zsciiStringBuilder, short s, short s2) {
        zsciiStringBuilder.append((short)(s << 5 | s2));
    }
}

