! BajoNivel.h
!
! (c) 2000 Zak McKracken (17/Octubre/2000)
!
! Las funciones definidas en este mdulo vienen tambin en la librera
! SIX v2, por lo que si usas SIX no necesitas incluir este mdulo (no
! podrs, de hecho).
!
! Este mdulo implementa las funciones BorrarPantalla
! y EsperarTecla. Estas funciones solan escribirse en ensamblador de
! la mquina Z a base de @read y @erase_window. Pero este mtodo
! complica la adaptacin del juego para su compilacin bajo Glulx.
!
! Incluyendo este mdulo, el programador puede poner simplemente
! BorrarPantalla(); en lugar de @erase_window -1. Cuando compile para
! la mquina Z, el efecto ser el mismo, pero cuando compile para
! Glulx, se convertir en llamadas a Glk para borrar la pantalla.
!
! De forma anloga EsperarTecla(); espera a que se pulse una tecla
! antes de continuar. Pueden pasrsele dos parmetros, opcionales. El
! primero sera un texto a mostrar antes de esperar, y el segundo el
! tiempo mximo a esperar en dcimas de segundo. Por ejemplo:
!
! EsperarTecla("[Pulsa una tecla]", 100);
!
! esperara un mximo de 10 segundos, tras lo cual retornara como si
! el jugador hubiera pulsado una tecla. Si se pulsa una tecla, se
! retorna el cdigo de la misma, si no se pulsa y el tiempo se agota,
! se retorna cero.
!
! Si se omite el segundo parmetro, la espera ser infinita. Si se
! omiten ambos parmetros, no se muestra texto y la espera es
! infinita. Para omitir el primer parmetro pero no el segundo la
! llamada ha de ser algo como:
!
! EsperarTecla(0, 100);
!
! En cuyo caso no se escribira nada y se esperaran 10 segundos.
! [NOTA: La espera temporizada puede no estar disponible en algunos
! intrpretes, que harn pausa infinita siempre]
!
#ifndef WORDSIZE;
Constant WORDSIZE = 2;
Constant TARGET_ZCODE;
#endif;

#ifdef TARGET_ZCODE;
[ BorrarPantalla ;
  @erase_window -1;
];

[ Volver;
    rtrue;
];

[ EsperarTecla msg delay k;
    if (msg~=0) print (string) msg;
    if (delay==0)
    	@read_char 1 0 0 k;
    else @read_char 1 delay Volver k;
    return k;
];
#endif;

#ifdef TARGET_GLULX;
[ BorrarPantalla w;
    if (w==0) w=gg_mainwin;
    if (gg_quotewin) ! Cerrar la ventana de boxes
    {
    	glk($0024, gg_quotewin, 0); ! close_window
    	gg_quotewin = 0;
    }
    glk($002A, w);  ! window_clear
];

[ EsperarTecla s delay;
    if (s) print (string) s;
    glk($00D6, delay*100); ! request_timer_events
    glk($00D2, gg_mainwin); ! glk_request_char_event(gg_mainwin);
    while(1) 
    {
	glk($00C0, gg_arguments); ! glk_select(gg_arguments);
	if ((gg_arguments-->0) == 2) break; ! 2=evType_CharInput
	if ((gg_arguments-->0) == 1)
	{
	    glk($00D3, gg_mainwin); ! cancel_char_event
    	    glk($00D6, 0); ! request_timer_events (cancelados)
	    return 0;
	}
    }
    return gg_arguments-->2;
];
#endif;
