! New verbs for holder.h. Include at end of I6 .inf file, after Grammar.

Extend 'pick' * 'up' noun 'with'/'in' noun		-> TakeIndirect;
Extend 'take' * noun 'with' noun				-> TakeIndirect;
Extend 'drop' first
	* 'all'										-> DropAll
	* heldindirect								-> DropIndirect;
Extend 'put' first
	* 'down' 'all'								-> DropAll
	* 'all' 'down'								-> DropAll
	* heldindirect 'in'/'into'/'inside' noun	-> InsertIndirect
	* heldindirect 'on'/'onto' noun				-> PutOnIndirect
	* 'down' heldindirect						-> DropIndirect;

! A global array used by DropAllSub:
Array possessions --> 100;

[DropAllSub obj i ;
	for (i=0 : i<100 : i++) possessions-->i = 0;
	i = 0;
	! Make a list of the things the player is holding:
	objectloop (obj in player)
	{
		if (obj hasnt worn) { possessions-->i = obj; i++; }
	}
	i = 0;
	while (possessions-->i ~= 0)
	{
		obj = possessions-->i;
		print (name) obj, ": ";
		<Drop obj>;
		i++;
	}
];

[TakeIndirectSub c h o w v;
	if (noun == player) "You can't pick up yourself!";
	if (noun has animate) "You can only use ", (the) second, " to pick up something inanimate.";
	if (ObjectIsUntouchable (noun, true, true)) "You can't reach ", (the) noun, ".";
	if ((noun ofclass Portable) == false) "That's not something you can pick up.";
	if ((second ofclass IndHolder) == false) "That's not something that can be used
			to pick things up.";
	if (second notin player)
	{
		print "You need to be holding ", (the) second, " in order to use ";
		if (second has pluralname) print "them"; else print "it";
		" for that.";
	}
	if (second has holdingindirect)
	{
		print "The ", (name) second;
		if (second has pluralname) print " are"; else print " is";
		" already being used to hold something.";
	}
	! Set v to the capacity_volume of the indirect holder:
	if (metaclass (second.capacity_volume) == Routine) v = second.capacity_volume();
		else v = second.capacity_volume;
	! Set c to the volume of the object we're trying to pick up:
	if (metaclass (noun.volume) == Routine) c = noun.volume();
		else c = noun.volume;
	if (v < c)
	{
		print "The ", (name) noun;
		if (noun has pluralname) print " are"; else print " is";
		" too big to fit in ", (the) second, ".";
	}
	c = children(player);
	if (c > 1)
	{
		w = 0;
		objectloop (o in player)
		{
			if (o has worn) w++;
		}
		! If you're holding something else besides the indirect holder and one other thing:
		if (c - w > 2) "You can't pick anything up with ", (the) second, " while
			you're holding more than one other thing.";
	}
	! At this point, we know that the player is holding the indirect holder, attempting to pick up
	! something portable (and small enough), that the indirect holder isn't holding anything else,
	! and that the player isn't holding more than one other thing.
	h = second.my_holder;
	give second holdingindirect;
	give noun heldindirect;
	move noun to h;
	"You pick up ", (the) noun, " with ", (the) second, ".";
];

[DropIndirectSub h hh;
	! The first line shouldn't be necessary, unless there's a bug elsewhere:
	if (noun hasnt heldindirect) "You're not holding ", (the) noun, " with anything.";
	hh = parent (noun);
	h = hh.my_parent();
	give noun ~heldindirect;
	give h ~holdingindirect;
	move noun to real_location;
	print "The ", (name) noun, " fall";
	if (noun hasnt pluralname) print "s";
	" from ", (the) h, ".";
];

[InsertIndirectSub h hh;
	if (second == player) "You can't put anything into yourself!";
	if (second has animate) "I don't think ", (the) second, " would like that.";
	if (ObjectIsUntouchable (second, true, true)) "You can't reach ", (the) second, ".";
	if (second hasnt container) "That can't contain things.";
	if (second hasnt open) "You'll need to open ", (the) second, " first.";
	! Does the second object to receiving the object?
	if (second.receive_indirect()) return;
	! Okay, let's make the deposit:
	hh = parent (noun);
	h = hh.my_parent();
	move noun to second;
	give noun ~heldindirect;
	give h ~holdingindirect;
	"You put ", (the) noun, " in ", (the) second, ".";
];

[PutOnIndirectSub h hh;
	if (second == player) "You can't put anything into yourself!";
	if (second has animate) "I don't think ", (the) second, " would like that.";
	if (ObjectIsUntouchable (second, true, true)) "You can't reach ", (the) second, ".";
	if (second hasnt supporter) "You can't put anything on that.";
	! Does the second object to receiving the object?
	if (second.receive_indirect()) return;
	! Okay, now we're ready to make the deposit:
	hh = parent (noun);
	h = hh.my_parent();
	move noun to second;
	give noun ~heldindirect;
	give h ~holdingindirect;
	"You put ", (the) noun, " on ", (the) second, ".";
];