!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.03.12 ORConverseMenu
! A conversation menu which sits on top of the Ask/Tell system.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! A more detailed description of this file, what it does, and how to use it should go 
! here. Some day soon I hope to do just that.
!--------------------------------------------------------------------------------------
! AutoDep:	ORObjectInitialise
!			OROptionListMenu
!			ORKeyboardPrimitive
!			ORKeyboard
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORConverseMenu; #include "ORConverseMenu"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORConverseMenu; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.07.21	Initial Creation
! 2002.08.23	Fixed bug when menu does not open when NPC's being talked to are present
!				but not in the same location (e.g. sitting on a chair)
! 2002.09.02	Converted attributes previously defined in this module to properties.
! 2002.10.19	Added autodep for ObjectInitialise.  Also fixed NOABOUT reversal bug.
! 2003.01.11	Rearranged some code to filter the conversation menu from a stand-alone
!				routine named FilterConverseMenu() so that it can be determined whether 
!				or not their are possible conversation topics prior to showing the menu. 
!				Also added a few additional synonyms to the menuspeak and automenuspeak
!				commands.
!				Also added filtering out of name of person being spoken to if 
!				nonspecifictarget property is true.
! 2003.01.16	Changed the default setting of AutoShowConverseMenu to false rather 
!				true.
! 2003.01.31	Modified the MenuSpeak to respond with an appropriate message if there 
!				is nothing to display.
! 2003.02.16	Fixed bug with ~~ preventing name of person talking to...
! 2003.02.17	Added a property to the ConMenu object to allow an action to determine
!				if it was called from the menu or not.
! 2003.02.19	Added better ifdef for self docs
! 2003.02.27	Another battle with newlines.
! 2003.03.12	modified AutoDoc text.
!--------------------------------------------------------------------------------------
#ifdef USE_ORConverseMenu;message "          Processing library extension ORConverseMenu...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_OROptionListMenu; Constant USE_OROptionListMenu; message "          ****Forcing inclusion of OROptionListMenu****"; #include "OROptionListMenu"; #endif; 
	#ifndef USE_ORKeyboardPrimitive; Constant USE_ORKeyboardPrimitive; message "          ****Forcing inclusion of ORKeyboardPrimitive****"; #include "ORKeyboardPrimitive"; #endif; 
	#ifndef USE_ORKeyboard; Constant USE_ORKeyboard; message "          ****Forcing inclusion of ORKeyboard****"; #include "ORKeyboard"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORConverseMenu_DONEREPLACE; constant ORConverseMenu_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	replace KeyboardGetInput; !--replace the ORLibrary-defined componant to Keyboard
	replace KeyboardPrepInput; !--add code to exit on game over
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORConverseMenu_DONEMESSAGE; constant ORConverseMenu_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORConverseMenu requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORConverseMenu_DONECODE;constant ORConverseMenu_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
!----------------------------------------------------
! The MenuSpeak conversation menu
! To use, simply connect the menu to the talking_npc_c
! object that the player inhabits:
!
!	ConMenu.source=player;
!
! This needs to be redone following execution of the 
! ChangePlayer() command.
!----------------------------------------------------
	global AutoShowConverseMenu=false;
	default MSMulti "Multi";
	!--First we can define the OptionListMenu 
	OROptionListMenu ConMenu
		with source 0
		,	Instantiated false
		,	directions "----------Press X to exit----------"
	;
	!--Now lets install a wedge into the KeyboardPrimitive routine to call the previously defined conversation menu if needed...
	object with object_initialise[; !--actually install the wedge...
			ORKBInstead.add_routine(self.ORDoConverseMenuInstead); 
		]
	,	ORDoConverseMenuInstead[; !--the wedge itself...
			return DoConverseMenu(); !--wedge does nothing but call another routine (which possibly displays the menu or not)
		]
	,	noabout !--just to define the property
	;
	
	global ConvMenuShownCount=0;
	OROptionList _menuol;
	[FilterConverseMenu o a i c x; !--after filtering, return true or false to indicate whether or not the menu can be displayed.
		!--------------------------------------------
		! Here we need to filter the menu and modify
		! the way it displays
		!--------------------------------------------
			a=ConMenu.source; !--just for ease of referencing below
			if(a==0)rfalse;

			for(i=0:i<a.count():i++)  give a.GetOption(i) workflag; !--clear everything
			objectloop(o has animate or talkable && o~=a && testscope(o,a)==true) c++; !--number of people present
			if(c~=0 && a ofclass OROptionList) { !--if there are actually people present (one or more) && the source is derived from OROptionList
				for(i=0:i<a.count():i++){ !--cycle through all topics...
					o=a.GetOption(i); !--get the topic 
					if(c==1){ !--only one person to talk to...
						if(o.locatetargetcount(a)==1) give o ~workflag; !--and topic can be spoken to 1 person then must be the same...
						a.SetAssociation2(i,0); !--... so clear the second association (we don't want to qualify this in the menu)
					}
					else{ !--here we have multiple people to talk to 
						x=o.locatetargetcount(a);
						if(x==0) continue;
						give o ~workflag; !--otherwise we can talk about this...
						if(o provides nonspecifictarget && valueorrun(o,nonspecifictarget)==true) 
							a.SetAssociation2(i,0); !--clear 
						else {
							if(x==1)
								a.SetAssociation2(i,o.locatetarget(a)); !--set Association2 to the one person
							else
								a.SetAssociation2(i,MSMulti);!--set Association2 to the "MULTI" indicator
						}
					}
				}
			}
			if(conmenu.count()>0) rtrue; 
			rfalse;
	];
	!--The routine called by the installed wedge; It is also called by the MenuSpeak command.  It displays the menu, and issues the command if one was chosen
	[DoConverseMenu fromcommand r o a i t; !--actually show the menu and perform the action if selected...pass in true to force a menu regardless of the state of the AutoShowConverseMenu variable
		!--first, massage the data in the pool...
		if(deadflag~=0) rfalse;
		r=FilterConverseMenu();
		a=ConMenu.source; !--just for ease of referencing below
		!--------------------------------------------
		!--show the menu if supposed to...
.domenuloc;
		o=0; !--this will be the selected menu option (the ORKnowledgeTopic object)
		if((AutoShowConverseMenu==true || fromcommand==true) &&  a ofclass OROptionList && r==true) {
			o=ConMenu.show();
			if(o~=0) ConvMenuShownCount++;
			if(ConvMenuShownCount==4) ConMenu.directions=0; !--turn off the directions after four showings
		}
		if(o~=0){ !--if we actually had a result
			t=a.GetAssociation2(a.LocateOption(o));
			if(o provides nonspecifictarget && valueorrun(o,nonspecifictarget)==true) t=0;
			switch(t){  !--get the association2 of the selected item (person to whom we can speak this to)
				MSMulti	: _menuol.clearoptionlist(); !--we need to clarify to who we are speaking
						objectloop(t has animate or talkable && testscope(t,a) && t~=a) {
							if(o.isincontext(t,a)==true && o.isknownby(t)~=o.isknownby(a)) _menuol.pushoption(t);
						}
						ConMenu.source=_menuol;
						i=conmenu.show();
						ConMenu.source=a;
				default	: i=o.locatetarget(a); !--works for either zero or the single option
			}
			if(i==0) jump domenuloc;
		}
		!--now that the menu is done and any scrolling that may have taken place by the menu classes has been completed, we can print the prompt
		if(fromcommand~=true || o~=0){
			L__M(##Prompt);
			AfterPrompt();
		}
		#IFV5; DrawStatusLine(); #ENDIF;		
		if(o==0) rfalse;!--if no conversation topic was selected then lets just exit out, returning false to indicate input should continue as normal
		!--otherwise, a knowledge topic WAS selected from the menu. SO lets create and perform the talking command.  Set...
		actor=ConMenu.source;			!--actor to the person whose decision pool the menu is focused on
		noun=i;	!--noun to the person we are talking to
		second=o;						!--second to the actual topic chosen
		if(o.isknownby(actor)==true){	!--if known by the person talking then assume tell mode
			print "tell ";
			action=##TellTopic;	
		}
		else{							!--otherwise we must be asking a question
			print "ask ";
			action=##AskTopic;
		}
		!--We've already printed ASK/TELL.  Lets finish the "imaginary" command text output.  For example: Tell...
		if((~~(o provides nonspecifictarget)) || (o provides nonspecifictarget && valueorrun(o,nonspecifictarget)==false)) print (name)noun," ";			!--GINGER...
		if((~~(o provides noabout)) || (o provides noabout && valueorrun(o,NoAbout)==false)) print "about "; !--ABOUT... 
		print (name)second,"^";				!--DINOSAUR...
		ConMenu.Instantiated=true;
		ActionPrimitive();				!--Now let us actually perform the action
		ConMenu.Instantiated=false;
		InformLibrary.end_turn_sequence(); !--and do all the normal stuff that follows an action
		if(deadflag==0) rtrue;			!-returning true to indicate that we actually usurped the input routine and to not try and continue with this turn (see following routine)
		!---Ulp! Game Over caused by a Daemon or each_turn event. 
		__ORInformLibrary.play_handle_death();
		rtrue;
	];
	!--Add code to the standard libraries "Keyboard" routine to cancel all parser interaction if the menusystem wedge decides "usurp" this action and do something itself
	!-- Additionally, do not show the prompt since it needs to be shown after the menu closes so is handled in the wedge.
	[KeyboardGetInput a_buffer a_table i; !--return -1 to get freshinput
		for (i=0:i<64:i++) oops_workspace->i = a_buffer->i;
		#ifndef TARGET_GLULX;
			a_buffer->0 = INPUT_BUFFER_LEN;
			a_table->0 = 15;  ! Allow to split input into this many words
		#endif; 
		#IFV5; DrawStatusLine(); #ENDIF;
		if(KeyboardPrimitive(a_buffer, a_table)==false && deadflag==0) return -1;
		rtrue;
	];
	[KeyboardPrepInput a_table nw; !--return -1 to get freshinput	
		if(deadflag~=0) rtrue;
	#ifndef TARGET_GLULX;
		nw=a_table->1;
	#ifnot; ! TARGET_GLULX
		nw=a_table-->0;
	#endif; ! TARGET_
		!  If the line was blank, get a fresh line
		if (nw == 0){ 
			L__M(##Miscellany,10); 
			return -1;
		}
		rtrue;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORConverseMenu_DONEGRAMMAR; constant ORConverseMenu_DONEGRAMMAR; #ifdef ORConverseMenu_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
#ifndef bkt; [bkt m; print (string)m;]; #endif;
	!--AutoMenuSpeak [ON|OFF] : turn on or off automatic menu-mode conversations
		verb meta "AutoMenuSpeak" "ams" "amspk" "automspk" "automs"
			* -> AutoError
			* 'on' -> AutoOn
			* 'off' -> AutoOff
		;
		[AutoErrorSub;
			"This command turns on or off the automatic instantiation of the Menu-Speak conversation system.  The syntax for this is:^^     AutoMenuSpeak|AMS On|Off^^For example:^^     >AMS OFF^^or^^     >AUTOMENUSPEAK ON";
		];
		[AutoOffSub;
			if(AutoShowConverseMenu==false) print_ret (bkt)"The Menu-Speak conversation system is already turned off.";
			AutoShowConverseMenu=false;
			print_ret (bkt)"The Menu-Speak conversation system is now turned off.";
		];
		[AutoOnSub;
			if(AutoShowConverseMenu==true) print_ret (bkt)"The Menu-Speak conversation system is already turned on.";
			AutoShowConverseMenu=true;
			print_ret (bkt)"The Menu-Speak conversation system is now turned on.";
		];
	!--MenuSpeak : show conversation menu system
		verb meta "MenuSpeak" "ms" "mspk" * -> ShowConverseMenu;
		[ShowConverseMenuSub; 
			if(FilterConverseMenu()==true) 
				DoConverseMenu(true);
			else
				print_ret (bkt)"There are no conversation topics currently in the menu system.";
		];

#ifdef ORMenuCatch;
	!--Commands, document thyself.
	ORMenu ORHelpAMS "The MenuSpeak Conversation System" with text "The MenuSpeak conversation system allows the player to select topics of conversation from a list. It is a system that rests on top of, but does not necessarily replace, the standard ASK/TELL system and supports conversations with multiple people. Two commands are available to the user: ~MenuSpeak~ and ~AutoMenuSpeak.~"
		,	object_initialise[;	if(ORMenuCatch~=0) move self to ORMenuCatch; ]
	;
		ORMenu -> "MenuSpeak" with text "The ~MenuSpeak~ command, or ~MS~ for short, turns on the conversation menu if there are any choices available to be made. It should be noted that the absence of a choice from the menu does not necessarily mean that the player cannot ask it manually by exiting the menu and using the traditional ASK/Tell method. In fact, this is often the method that is employed for changing the ~topic~ of conversation.^^In short, the MenuSpeak system is a method of representing a relation between topics in an easy to view manner and allows the topics to be selected from a list.^^This list can be made to display automatically with the ~AutoMenuSpeak~ command.";
		ORMenu -> "AutoMenuSpeak" with text "The ~AutoMenuSpeak~ command, or ~AMS~ for short, allows the player to choose whether or not the menu will appear automatically when the player character enters into a potential conversation with an NPC. The syntax to turn this mode on or off is simply: ^^AMS ON^^or^^AMS OFF";
#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;