!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.03.15 ORWAE_Formatting
! A framework for implementing text that qualifies objects, such as "(providing light)".
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! During inventory and room descriptions, the standard library interogates objects and 
! prints qualifying text such as "(providing light)" or "(closed, empty and providing 
! light)".  This module implements an extensible framework for defining new qualifiers 
! as well as redefining or removing existing qualifiers.
! 
! This is accomplished through the use of routines that are registered with at least
! one of two ORRoutinesList objects, "ORWAE_PartFormatting" and "ORWAE_FullFormatting".
!
! This module eliminates the use of Messages "ListMiscellany #7-17".
!
!--------------------------------------------------------------------------------------
! AutoDep:	
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORWAE_Formatting; #include "ORWAE_Formatting"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORWAE_Formatting; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2003.03.15	Initial Creation
!--------------------------------------------------------------------------------------
#ifdef USE_ORWAE_Formatting;message "          Processing library extension ORWAE_Formatting...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---#ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif;    
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORLibraryMessages; Constant USE_ORLibraryMessages; message "          ****Forcing inclusion of ORLibraryMessages****"; #include "ORLibraryMessages"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORWriteAfterEntry; Constant USE_ORWriteAfterEntry; message "          ****Forcing inclusion of ORWriteAfterEntry****"; #include "ORWriteAfterEntry"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORWAE_Formatting_DONEREPLACE; constant ORWAE_Formatting_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	replace WAE_PartInv;
	replace WAE_FullInv;
!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORWAE_Formatting_DONEMESSAGE; constant ORWAE_Formatting_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORWAE_Formatting requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORWAE_Formatting_DONECODE;constant ORWAE_Formatting_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
[ WAE_PartInv o comb;
	if (c_style & PARTINV_BIT ~= 0) {
		comb=ORWAE_PartFormatting.run_accumulate(o,true);
		if(comb==0) rfalse;
		ORWAE_PartFormatting.total_count=comb;
		print " (";
		if(comb==1) print "which ",(isorare)o," ";
		ORWAE_PartFormatting.run_accumulate(o);
		print ")";
	}
	rfalse;
];
[WAE_FullInv o comb;
	if (c_style & FULLINV_BIT ~= 0) {
		if (o.invent ~= 0)
		{   inventory_stage=2;
			if (RunRoutines(o,invent)~=0)
			{   if (c_style & NEWLINE_BIT ~= 0) new_line;
				rtrue;
			}
		}
		comb=ORWAE_FullFormatting.run_accumulate(o,true);
		if(comb==0) rfalse;
		ORWAE_FullFormatting.total_count=comb;
		print " (";
		if(comb==1) print "which ",(isorare)o," ";
		ORWAE_FullFormatting.run_accumulate(o);
		print ")";		
	}
	rfalse;
];

system_file;
ORRoutinesList ORWAE_PartFormatting
	with routines 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
	,	between_calls[retval;
			if(retval==false) return;
			self.total_count=self.total_count-1;
			if(self.total_count==1) print " and ";
			if(self.total_count>1) print ", ";
		]
	,	object_initialise[;
			self.add_routine(_WAE_light);
			self.add_routine(_WAE_closedcontainer );
			self.add_routine(_WAE_emptycontainer );
		]
	,	total_count 0
;
ORRoutinesList ORWAE_FullFormatting
	with routines 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
	,	between_calls[retval;
			if(retval==false) return;
			self.total_count=self.total_count-1;
			if(self.total_count==1) print " and ";
			if(self.total_count>1) print ", ";
		]
	,	object_initialise[;
			self.add_routine(_WAE_light);
			self.add_routine(_WAE_worn);
			self.add_routine(_WAE_closedcontainer );
			self.add_routine(_WAE_opencontainer );
			self.add_routine(_WAE_lockedcontainer );
			self.add_routine(_WAE_emptycontainer );
		]

,	total_count 0
;
!--New formatting routines ---------------------------------------------------------------
[_WAE_worn obj suppress retval;
	retval=(obj has worn);
	if(suppress==false && retval==true) L__M(##ListMiscellany, 4);
	return retval;
];
[_WAE_light obj suppress retval;
	retval=(obj has light && location hasnt light && parent(actor) hasnt light);
	if(suppress==false && retval==true) L__M(##ListMiscellany, 3);
	return retval;
];
[_WAE_closedcontainer obj suppress retval;
	retval=(obj has container && obj hasnt open);
	if(suppress==false && retval==true) L__M(##ListMiscellany, 1);
	return retval;
];
[_WAE_opencontainer obj suppress retval;
	retval=(obj has container && obj has openable && obj has open);
	if(suppress==false && retval==true) L__M(##ListMiscellany, 6);
	return retval;
];
[_WAE_lockedcontainer obj suppress retval;
	retval=(obj has openable && obj hasnt open && obj has lockable && obj has locked);
	if(suppress==false && retval==true) L__M(##ListMiscellany, 5);
	return retval;
];
[_WAE_emptycontainer obj suppress retval;
	retval=(obj has container && obj has open or transparent && (child(obj)==0));
	if(suppress==false && retval==true) L__M(##ListMiscellany, 2);
	return retval;
];
!-----------------------------------------------------------------------------------------
ORLibMessage 
	with body[;
		ListMiscellany:switch(lm_n){
							1: print "closed";
								rtrue;
							2: print "empty";
								rtrue;
							3: print "providing light";
								rtrue;
							4: print "being worn";
								rtrue;
							5: print "locked";
								rtrue;
							6: print "open";
								rtrue;
						}
					]
;

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORWAE_Formatting_DONEGRAMMAR; constant ORWAE_Formatting_DONEGRAMMAR; #ifdef ORWAE_Formatting_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;