! ==============================================================================
! VERBLIB for Triform 1.2a
!
! Nearly all of this file is copyrighted by Graham Nelson, 1993-2004, or David
! Griffith, 2012-2014, and licensed under the traditional Inform license:

! Copyright on Inform, the program and its source code, its example
! games and documentation (including this book) is retained by Graham
! Nelson, who asserts the moral right to be identified as the author
! under the Copyrights, Designs and Patents Act 1988.  Having said
! this, I am happy for it to be freely distributed to anybody who wants
! a copy, provided that: (a) distributed copies are not substantially
! different from those archived by the author, (b) this and other
! copyright messages are always retained in full, and (c) no profit is
! involved.  (Exceptions to these rules must be negotiated directly
! with the author.)  However, a story file produced with the Inform
! compiler (and libraries) then belongs to its author, and may be sold
! for profit if desired, provided that its game banner contains the
! information that it was compiled by Inform, and the Inform version
! number.

! All code contributed by myself and not appearing in any of the standard Inform
! libraries is public domain.
! ==============================================================================

System_file;

Default MAX_SCORE        0;
Default NUMBER_TASKS     1;
Default TASKS_PROVIDED   1;

#Ifndef task_scores;
Array  task_scores --> 0 0 0 0;
#Endif;

Array  task_done -> NUMBER_TASKS;

#Ifndef LibraryMessages;
Object LibraryMessages;
#Endif;

#Ifndef NO_PLACES;
[ ObjectsSub; Objects1Sub(); ];
[ PlacesSub;  Places1Sub(); ];
#Endif;

! ----------------------------------------------------------------------------
!  The WriteListFrom routine, a flexible object-lister taking care of
!  plurals, inventory information, various formats and so on.  This is used
!  by everything in the library which ever wants to list anything.
!
!  If there were no objects to list, it prints nothing and returns false;
!  otherwise it returns true.
!
!  o is the object, and style is a bitmap, whose bits are given by:
! ----------------------------------------------------------------------------

Constant NEWLINE_BIT       1;       ! New-line after each entry
Constant INDENT_BIT        2;       ! Indent each entry by depth
Constant FULLINV_BIT       4;       ! Full inventory information after entry
Constant ENGLISH_BIT       8;       ! English sentence style, with commas and and
Constant RECURSE_BIT      16;       ! Recurse downwards with usual rules
Constant ALWAYS_BIT       32;       ! Always recurse downwards
Constant TERSE_BIT        64;       ! More terse English style
Constant PARTINV_BIT     128;       ! Only brief inventory information after entry
Constant DEFART_BIT      256;       ! Use the definite article in list
Constant WORKFLAG_BIT    512;       ! At top level (only), only list objects
                                    ! which have the "workflag" attribute
Constant ISARE_BIT      1024;       ! Print " is" or " are" before list
Constant CONCEAL_BIT    2048;       ! Omit objects with "concealed" or "scenery":
                                    ! if WORKFLAG_BIT also set, then does _not_
                                    ! apply at top level, but does lower down
Constant NOARTICLE_BIT  4096;       ! Print no articles, definite or not


[ NextEntry o odepth;
    for (::) {
        o = sibling(o);
        if (o == 0) return 0;
        if (lt_value ~= 0 && o.list_together ~= lt_value) continue;
        if (c_style & WORKFLAG_BIT ~= 0 && odepth == 0 && o hasnt workflag) continue;
        if (c_style & CONCEAL_BIT ~= 0 && (o has concealed || o has scenery)) continue;
        return o;
    }
];

[ WillRecurs o;
    if (c_style & ALWAYS_BIT) rtrue;
    if (c_style & RECURSE_BIT == 0) rfalse;
    if (o has transparent ||
	(o ofclass Container && 
		(o.ontop_capacity() > 0 || (o.inside_capacity() > 0 && o hasnt closed))
		)
	)
	rtrue;
    rfalse;
];

[ ListEqual o1 o2;
    if (child(o1) ~= 0 && WillRecurs(o1) ~= 0) rfalse;
    if (child(o2) ~= 0 && WillRecurs(o2) ~= 0) rfalse;
    if (c_style & (FULLINV_BIT + PARTINV_BIT) ~= 0) {

#Ifdef COMPLEXCLOTHING;
        if (o1 ofclass Wearable && o2 ofclass Wearable) {
		if ((o1.worn_by == 0 && o2.worn_by ~= 0) || (o2.worn_by == 0 && o1.worn_by ~= 0)) rfalse; }
#Ifnot;
        if (o1 has clothing && o2 has clothing) {
		if ((o1 has worn && o2 hasnt worn) || (o2 hasnt worn && o1 has worn)) rfalse; }
#Endif;
#Ifndef NO_DARKNESS;
        if ((o1 hasnt light && o2 has light) || (o2 hasnt light && o1 has light)) rfalse;
#Endif;
        if (o1 ofclass Container && o1.inside_capacity() > 0) {
            if (o2 ofclass Container && o2.inside_capacity() > 0) rfalse;
            if ((o1 hasnt closed && o2 has closed) || (o2 hasnt closed && o1 has closed))
                rfalse;
        }
        else if (o2 ofclass Container && o2.inside_capacity() > 0)
            rfalse;
    }
    return Identical(o1, o2);
];

[ SortTogether obj value;
    ! print "Sorting together possessions of ", (object) obj, " by value ", value, "^";
    ! for (x=child(obj) : x~=0 : x=sibling(x))
    !     print (the) x, " no: ", x, " lt: ", x.list_together, "^";
    while (child(obj) ~= 0) {
        if (child(obj).list_together ~= value) Move(child(obj), out_obj);
        else                                   Move(child(obj), in_obj);
    }
    while (child(in_obj) ~= 0)  Move(child(in_obj), obj);
    while (child(out_obj) ~= 0) Move(child(out_obj), obj);
];

[ SortOutList obj i k l;
    !  print "^^Sorting out list from ", (name) obj, "^  ";
    !  for (i=child(obj.location) : i~=0 : i=sibling(i))
    !      print (name) i, " --> ";
    !  new_line;

  .AP_SOL;

    for (i=obj : i~=0 : i=sibling(i)) {
        k = i.list_together;
        if (k ~= 0) {
            ! print "Scanning ", (name) i, " with lt=", k, "^";
            for (i=sibling(i) : i~=0 && i.list_together == k :) i = sibling(i);
            if (i == 0) rfalse;
            ! print "First not in block is ", (name) i, " with lt=", i.list_together, "^";
            for (l=sibling(i) : l~=0 : l=sibling(l))
                if (l.list_together == k) {
                    SortTogether(parent(obj), k);
                    ! print "^^After ST:^  ";
                    ! for (i=child(obj.location) : i~=0 : i=sibling(i))
                    !     print (name) i, " --> ";
                    ! new_line;
                    obj = child(parent(obj));
                    jump AP_SOL;
                }
        }
    }
];

#Ifdef TARGET_ZCODE;

[ Print__Spaces n;         ! To avoid a bug occurring in Inform 6.01 to 6.10
    if (n == 0) return;
    spaces n;
];

#Ifnot; ! TARGET_GLULX;

[ Print__Spaces n;
    while (n > 0) {
        @streamchar ' ';
        n = n - 1;
    }
];

#Endif; ! TARGET_


[ WriteListFrom o style depth;

    #Ifdef TARGET_ZCODE;
    @push c_style;      @push lt_value;   @push listing_together;
    @push listing_size; @push wlf_indent; @push inventory_stage;
    #Ifnot; ! TARGET_GLULX
    @copy c_style sp;      @copy lt_value sp;   @copy listing_together sp;
    @copy listing_size sp; @copy wlf_indent sp; @copy inventory_stage sp;
    #Endif;

    if (o == child(parent(o))) {
        SortOutList(o);
        o = child(parent(o));
    }
    c_style = style;
    wlf_indent = 0;
    WriteListR(o, depth);

    #Ifdef TARGET_ZCODE;
    @pull inventory_stage;  @pull wlf_indent; @pull listing_size;
    @pull listing_together; @pull lt_value;   @pull c_style;
    #Ifnot; ! TARGET_GLULX
    @copy sp inventory_stage;  @copy sp wlf_indent; @copy sp listing_size;
    @copy sp listing_together; @copy sp lt_value;   @copy sp c_style;
    #Endif;
    rtrue;
];

[ WriteListR o depth stack_pointer  classes_p sizes_p i j k k2 l m n q senc mr;
    if (depth > 0 && o == child(parent(o))) {
        SortOutList(o);
        o = child(parent(o));
    }
    for (::) {
        if (o == 0) rfalse;
        if (c_style & CONCEAL_BIT ~= 0 && (o has concealed || o has scenery)) {
            o = sibling(o);
            continue;
        }
        if (c_style & WORKFLAG_BIT ~= 0 && o hasnt workflag) {
            o = sibling(o);
            continue;
        }
        break;
    }
    classes_p = match_classes + stack_pointer;
    sizes_p   = match_list + stack_pointer;

    for (i=o,j=0 : i~=0 && (j+stack_pointer)<128 : i=NextEntry(i,depth),j++) {
        classes_p->j = 0;
        if (i.plural ~= 0) k++;
    }

    if (c_style & ISARE_BIT ~= 0) {
        if (j == 1 && o hasnt pluralname) print (string) IS__TX;
        else                              print (string) ARE__TX;
        if (c_style & NEWLINE_BIT ~= 0)   print ":^";
        else                              print (char) ' ';
        c_style = c_style - ISARE_BIT;
    }

    stack_pointer = stack_pointer+j+1;

    if (k < 2) jump EconomyVersion;   ! It takes two to plural
    n = 1;
    for (i=o,k=0 : k<j : i=NextEntry(i,depth),k++)
        if (classes_p->k == 0) {
            classes_p->k = n; sizes_p->n = 1;
            for (l=NextEntry(i,depth),m=k+1 : l~=0 && m<j : l=NextEntry(l,depth),m++)
                if (classes_p->m == 0 && i.plural ~= 0 && l.plural ~= 0) {
                    if (ListEqual(i, l) == 1) {
                        sizes_p->n = sizes_p->n + 1;
                        classes_p->m = n;
                    }
                }
            n++;
        }
    n--;

    for (i=1,j=o,k=0 : i<=n : i++,senc++) {
        while (((classes_p->k) ~= i) && ((classes_p->k) ~= -i)) {
            k++; j=NextEntry(j, depth);
        }
        m = sizes_p->i;
        if (j == 0) mr = 0;
        else {
            if (j.list_together ~= 0 or lt_value && ZRegion(j.list_together) == 2 or 3 &&
                j.list_together == mr) senc--;
            mr = j.list_together;
        }
    }
    senc--;

    for (i=1,j=o,k=0,mr=0 : senc>=0 : i++,senc--) {
        while (((classes_p->k) ~= i) && ((classes_p->k) ~= -i)) {
            k++; j=NextEntry(j, depth);
        }
        if (j.list_together ~= 0 or lt_value) {
            if (j.list_together == mr) {
                senc++;
                jump Omit_FL2;
            }
            k2 = NextEntry(j, depth);
            if (k2 == 0 || k2.list_together ~= j.list_together) jump Omit_WL2;
            k2 = ZRegion(j.list_together);
            if (k2 == 2 or 3) {
                q = j; listing_size = 1; l = k; m = i;
                while (m < n && q.list_together == j.list_together) {
                    m++;
                    while (((classes_p->l) ~= m) && ((classes_p->l) ~= -m)) {
                        l++; q = NextEntry(q, depth);
                     }
                    if (q.list_together == j.list_together) listing_size++;
                }
                ! print " [", listing_size, "] ";
                if (listing_size == 1) jump Omit_WL2;
                if (c_style & INDENT_BIT ~= 0) Print__Spaces(2*(depth+wlf_indent));
                if (k2 == 3) {
                    q = 0;
                    for (l=0 : l<listing_size : l++) q = q+sizes_p->(l+i);
                    EnglishNumber(q); print " ";
                    print (string) j.list_together;
                    if (c_style & ENGLISH_BIT ~= 0) print " (";
                    if (c_style & INDENT_BIT ~= 0)  print ":^";
                }
                q = c_style;
                if (k2 ~= 3) {
                    inventory_stage = 1;
                    parser_one = j; parser_two = depth+wlf_indent;
                    if (RunRoutines(j, list_together)) jump Omit__Sublist2;
                }

                #Ifdef TARGET_ZCODE;
                @push lt_value; @push listing_together; @push listing_size;
                #Ifnot; ! TARGET_GLULX;
                @copy lt_value sp; @copy listing_together sp; @copy listing_size sp;
                #Endif; ! TARGET_;

                lt_value = j.list_together; listing_together = j; wlf_indent++;
                WriteListR(j, depth, stack_pointer); wlf_indent--;

                #Ifdef TARGET_ZCODE;
                @pull listing_size; @pull listing_together; @pull lt_value;
                #Ifnot; ! TARGET_GLULX;
                @copy sp listing_size;
                @copy sp listing_together;
                @copy sp lt_value;
                #Endif; ! TARGET_;

                if (k2 == 3) {
                    if (q & ENGLISH_BIT ~= 0) print ")";
                }
                else {
                    inventory_stage = 2;
                    parser_one = j; parser_two = depth+wlf_indent;
                    RunRoutines(j, list_together);
                }

              .Omit__Sublist2;

                if (q & NEWLINE_BIT ~= 0 && c_style & NEWLINE_BIT == 0) new_line;
                c_style = q;
                mr = j.list_together;
                jump Omit_EL2;
            }
        }

      .Omit_WL2;

        if (WriteBeforeEntry(j, depth, senc) == 1) jump Omit_FL2;
        if (sizes_p->i == 1) {
            if (c_style & NOARTICLE_BIT ~= 0) print (name) j;
            else {
                if (c_style & DEFART_BIT ~= 0) print (the) j; else print (a) j;
            }
        }
        else {
            if (c_style & DEFART_BIT ~= 0) PrefaceByArticle(j, 1, sizes_p->i);
            print (number) sizes_p->i, " ";
            PrintOrRun(j, plural, 1);
        }
        if (sizes_p->i > 1 && j hasnt pluralname) {
            give j pluralname;
            WriteAfterEntry(j, depth, stack_pointer);
            give j ~pluralname;
        }
        else WriteAfterEntry(j,depth,stack_pointer);
      .Omit_EL2;

        if (c_style & ENGLISH_BIT ~= 0) {
            if (senc == 1) {
			if (i > 2) print (string) AND__TX;
			else print (string) AND2__TX;
		}
            if (senc > 1) print (string) COMMA__TX;
        }
     .Omit_FL2;
    }
    rtrue;

  .EconomyVersion;

    n = j;
    for (i=1,j=o : i<=n : j=NextEntry(j,depth),i++,senc++) {
        if (j.list_together ~= 0 or lt_value && ZRegion(j.list_together) == 2 or 3 &&
            j.list_together==mr) senc--;
        mr = j.list_together;
    }

    for (i=1,j=o,mr=0 : i<=senc : j=NextEntry(j,depth),i++) {
        if (j.list_together ~= 0 or lt_value) {
            if (j.list_together == mr) {
                i--;
                jump Omit_FL;
            }
            k = NextEntry(j, depth);
            if (k == 0 || k.list_together ~= j.list_together) jump Omit_WL;
            k = ZRegion(j.list_together);
            if (k == 2 or 3) {
                if (c_style & INDENT_BIT ~= 0) Print__Spaces(2*(depth+wlf_indent));
                if (k == 3) {
                    q = j; l = 0;
                    do {
                        q = NextEntry(q, depth); l++;
                    } until (q == 0 || q.list_together ~= j.list_together);
                    EnglishNumber(l); print " ";
                    print (string) j.list_together;
                    if (c_style & ENGLISH_BIT ~= 0) print " (";
                    if (c_style & INDENT_BIT ~= 0) print ":^";
                }
                q = c_style;
                if (k ~= 3) {
                    inventory_stage = 1;
                    parser_one = j; parser_two = depth+wlf_indent;
                    if (RunRoutines(j, list_together)) jump Omit__Sublist;
                }

                #Ifdef TARGET_ZCODE;
                @push lt_value; @push listing_together; @push listing_size;
                #Ifnot; ! TARGET_GLULX;
                @copy lt_value sp; @copy listing_together sp; @copy listing_size sp;
                #Endif; ! TARGET_;

                lt_value = j.list_together; listing_together = j; wlf_indent++;
                WriteListR(j, depth, stack_pointer); wlf_indent--;

                #Ifdef TARGET_ZCODE;
                @pull listing_size; @pull listing_together; @pull lt_value;
                #Ifnot; ! TARGET_GLULX;
                @copy sp listing_size; @copy sp listing_together; @copy sp lt_value;
                #Endif; ! TARGET_;

                if (k == 3) {
                    if (q & ENGLISH_BIT ~= 0) print ")";
                }
                else {
                    inventory_stage = 2;
                    parser_one = j; parser_two = depth+wlf_indent;
                    RunRoutines(j, list_together);
                }

              .Omit__Sublist;

                if (q & NEWLINE_BIT ~= 0 && c_style & NEWLINE_BIT == 0) new_line;
                c_style = q;
                mr = j.list_together;
                jump Omit_EL;
            }
        }

      .Omit_WL;

        if (WriteBeforeEntry(j, depth, i, senc) == 1) jump Omit_FL;
        if (c_style & NOARTICLE_BIT ~= 0) print (name) j;
        else {
            if (c_style & DEFART_BIT ~= 0) print (the) j; else print (a) j;
        }
        WriteAfterEntry(j, depth, stack_pointer);

      .Omit_EL;

        if (c_style & ENGLISH_BIT ~= 0) {
            if (i == senc-1) {
			if (senc > 2) print (string) AND__TX;
			else print (string) AND2__TX;
		}
            if (i < senc-1) print (string) COMMA__TX;
        }

  .Omit_FL;

    }
]; ! end of WriteListR

[ WriteBeforeEntry o depth ipos sentencepos flag;

    inventory_stage = 1;
    if (c_style & INDENT_BIT) Print__Spaces(2*(depth+wlf_indent));
    if (o.invent && (c_style & (PARTINV_BIT|FULLINV_BIT))) {
        flag = PrintOrRun(o, invent, 1);
        if (flag) {
            if (c_style & ENGLISH_BIT) {
		    if (ipos == sentencepos - 1) {
                		if (sentencepos > 2) print (string) AND__TX;
                		else print (string) COMMA__TX;
			}
			if (ipos < sentencepos -1) print (string) COMMA__TX;
            }
            if (c_style & NEWLINE_BIT) new_line;
        }
    }
    return flag;
];

[ WriteAfterEntry o depth stack_p recurse_flag p child_count k n a b c d;

  inventory_stage = 2;

  n = CommonAncestor(actor, o);

  if (IndirectlyContains(n, actor) == 4 && IndirectlyContains(n, o) == 2 && o hasnt transparent)
	n = 'abc';

#Ifdef DEBUG;
    if (action == ##XTree) {
	print " (", o, ")";
    if (parent(o) ~= 0)
        if (parent(o) ofclass Container && o ofclass Thing) {
		L__M(##ListMiscellany, 11, o, true);
	}
    if (o ofclass Person) {
	switch (o.posture) {
		1: print " ("; L__M(##ListMiscellany, 29); print ") ";
		2: print " ("; L__M(##ListMiscellany, 28); print ") ";
		3: print " ("; L__M(##ListMiscellany, 30); print ") ";
	}
     }
    }
#Endif;

    if (c_style & (FULLINV_BIT|PARTINV_BIT)) {
        if (o provides invent && PrintorRun(o, invent))
            { if (c_style & NEWLINE_BIT) ""; else rtrue; }
#Ifdef COMPLEXCLOTHING;
	if (o ofclass Wearable && o.worn_by ~= 0) {
#Ifnot;
	if (o has worn) {
#Endif;
		print " (";
		L__M(##ListMiscellany, 36, o);
		k++;
	}
	if (o has switchable) {
		if (k == 0) print " (";
		else print "; ";
		L__M(##ListMiscellany, 38, o, k); k++;
	}
#Ifndef NO_DARKNESS;
	if (o has light) {
		if (k == 0) print " (";
		else print "; ";
		L__M(##ListMiscellany, 37, o, k); k++;
	}
 #Ifdef GRADUAL_LIGHT;
	if (o has semilight or demilight && k ~= 2) {
		if (k == 0) print " (";
			else print "; ";
		L__M(##ListMiscellany, 37, o, k); k++;
	}
 #Endif;
#Endif;
	if (o has openable && n ~= 'abc') {
		if (k == 0) print " (";
			else print "; ";
		if (o hasnt closed) {
			L__M(##ListMiscellany, 12, o);
			if (ValueorRun(o, inside_capacity) && CountChildren(o, 3) == 0) L__M(##ListMiscellany, 13, k);
			}
			else L__M(##ListMiscellany, 14, o);
		k++;
	}
	}
        if (k) print ")";

    if (c_style & CONCEAL_BIT) {
        child_count = 0;
        objectloop (p in o)
            if (p hasnt concealed && p hasnt scenery) child_count++;
    }
    else child_count = children(o);

    if (child_count && (c_style & ALWAYS_BIT)) {
        if (c_style & ENGLISH_BIT) L__M(##ListMiscellany, 18, o);
	recurse_flag = true;
        }
     if (child_count && (c_style & RECURSE_BIT)) { k = 0;

	if (inventory_stage == 2 && ~~c_style & ENGLISH_BIT) recurse_flag = true;

	if (CountChildren(o, 1, 5)) a++; ! behind
	if (CountChildren(o, 2, 5)) b++; ! beneath
	if (CountChildren(o, 3, 5)) c++; ! inside
	if (CountChildren(o, 5, 5)) d++; ! attached

        if (CountChildren(o, 4, 5) && n ~= 'abc') {
            if (c_style & ENGLISH_BIT) {

                if (c_style & TERSE_BIT) print " (";
     	          else print ", ";
		L__M(##ListMiscellany, 19);

                if (o has animate)       print (string) WHOM__TX;
                else                     print (string) WHICH__TX;

		switch (CountChildren(o, 4, 5)) {
			1: switch (tense) {
				1: if (child(o) has pluralname) print (string) ARE2__TX;
					else print (string) IS2__TX;

				2: print (string) WAS2__TX;
			}

			default: switch (tense) {
				1: print (string) ARE2__TX;

				2: print (string) WERE2__TX;
			}
		}
		DescribeOnTop(o, 2);
		if (a == false && b == false && c == false && d == false) print ")";
			else k++;
		}! if ENGLISH_BIT
        }
        if (CountChildren(o, 3, 5) && o.&hidden_contents-->0 == 2 && n ~= 'abc') {
            if (c_style & ENGLISH_BIT) {

		if (k) print ",", (string) AND__TX;
		  else print " (";
		L__M(##ListMiscellany, 22);

                if (o has animate)       print (string) WHOM__TX;
                else                     print (string) WHICH__TX;

		switch (CountChildren(o, 3, 5)) {
			1: switch (tense) {
				1: if (child(o) has pluralname) print (string) ARE2__TX;
					else print (string) IS2__TX;

				2: print (string) WAS2__TX;
			}

			default: switch (tense) {
				1: print (string) ARE2__TX;

				2: print (string) WERE2__TX;
			}
		}

		DescribeInside(o, 2);
		if (b == false && c == false && d == false) print ")";
			else k++;
		} ! if ENGLISH_BIT
        }
        if (CountChildren(o, 2, 5) && o.&hidden_contents-->1 == 2) {
            if (c_style & ENGLISH_BIT) {

		if (k) print ",", (string) AND__TX;
		  else print " (";
		L__M(##ListMiscellany, 39);

                if (o has animate)       print (string) WHOM__TX;
                else                     print (string) WHICH__TX;

		switch (CountChildren(o, 2, 5)) {
			1: switch (tense) {
				1: if (child(o) has pluralname) print (string) ARE2__TX;
					else print (string) IS2__TX;

				2: print (string) WAS2__TX;
			}

			default: switch (tense) {
				1: print (string) ARE2__TX;

				2: print (string) WERE2__TX;
			}
		}
		DescribeBeneath(o, 2);
		if (c == false && d == false) print ")";
			else k++;
                } ! if ENGLISH_BIT
        }
        if (CountChildren(o, 1, 5) && o.&hidden_contents-->2 == 2) {
            if (c_style & ENGLISH_BIT) {

		if (k) print ",", (string) AND__TX;
		  else print " (";
		L__M(##ListMiscellany, 24);

                if (o has animate)       print (string) WHOM__TX;
                else                     print (string) WHICH__TX;

		switch (CountChildren(o, 1, 5)) {
			1: switch (tense) {
				1: if (child(o) has pluralname) print (string) ARE2__TX;
					else print (string) IS2__TX;

				2: print (string) WAS2__TX;
			}

			default: switch (tense) {
				1: print (string) ARE2__TX;

				2: print (string) WERE2__TX;
			}
		}
		DescribeBehind(o, 2);
		if (d == false) print ")";
			else k++;
                } ! if ENGLISH_BIT
        }
        if (CountChildren(o, 5, 5)) {
            if (c_style & ENGLISH_BIT) {

		if (k) print ",", (string) AND__TX;
		  else print " (";
		L__M(##ListMiscellany, 44);

                if (o has animate)       print (string) WHOM__TX;
                else                     print (string) WHICH__TX;

		switch (CountChildren(o, 5, 5)) {
			1: switch (tense) {
				1: if (child(o) has pluralname) print (string) ARE2__TX;
					else print (string) IS2__TX;

				2: print (string) WAS2__TX;
			}

			default: switch (tense) {
				1: print (string) ARE2__TX;

				2: print (string) WERE2__TX;
			}
		}
		DescribeAttached(o, 2); print ")";
                } ! if ENGLISH_BIT
	}
    }

    if (c_style & NEWLINE_BIT) new_line;

    if (recurse_flag) {
        o = child(o);
        #Ifdef TARGET_ZCODE;
        @push lt_value; @push listing_together; @push listing_size;
        #Ifnot; ! TARGET_GLULX;
        @copy lt_value sp; @copy listing_together sp; @copy listing_size sp;
        #Endif;
        lt_value = 0;   listing_together = 0;   listing_size = 0;
        WriteListR(o, depth+1, stack_p);
        #Ifdef TARGET_ZCODE;
        @pull listing_size; @pull listing_together; @pull lt_value;
        #Ifnot; ! TARGET_GLULX;
        @copy sp listing_size; @copy sp listing_together; @copy sp lt_value;
        #Endif;
    }
];

#Ifndef NO_MENUS;
! ----------------------------------------------------------------------------
!  Much better menus can be created using one of the optional library
!  extensions. These are provided for compatibility with previous practice:
! ----------------------------------------------------------------------------

[ LowKey_Menu menu_choices EntryR ChoiceR lines main_title i j;
    menu_nesting++;

  .LKRD;

    menu_item = 0;
    lines = indirect(EntryR);
    main_title = item_name;

    print "--- "; print (string) main_title; print " ---^^";

    if (menu_choices ofclass Routine) menu_choices.call();
    else                              print (string) menu_choices;

    for (::) {
        L__M(##Miscellany, 52, lines);
        print "> ";

        #Ifdef TARGET_ZCODE;
        #IfV3;
        read buffer parse;
        #Ifnot;
	#Ifndef NO_STATUSLINE;
        read buffer parse DrawStatusLine;
	#Endif; ! NO_STATUSLINE
        #Endif; ! V3
        j = parse->1; ! number of words
        #Ifnot; ! TARGET_GLULX;
        KeyboardPrimitive(buffer, parse);
        j = parse-->0; ! number of words
        #Endif; ! TARGET_

        i = parse-->1;
        if (j == 0 || (i == QUIT1__WD or QUIT2__WD)) {
            menu_nesting--; if (menu_nesting > 0) rfalse;
            if (gameover == 0) <<Look>>;
            rfalse;
        }
        i = TryNumber(1);
        if (i == 0) jump LKRD;
        if (i < 1 || i > lines) continue;
        menu_item = i;
        j = indirect(ChoiceR);
        if (j == 2) jump LKRD;
        if (j == 3) rfalse;
    }
];

#Ifdef TARGET_ZCODE;

#IfV3;

[ DoMenu menu_choices EntryR ChoiceR; LowKey_Menu(menu_choices, EntryR, ChoiceR); ];

#Endif; ! V3

#IfV5;

[ DoMenu menu_choices EntryR ChoiceR
         lines main_title main_wid cl i j oldcl pkey ch cw y x;
    if (pretty_flag == 0) return LowKey_Menu(menu_choices, EntryR, ChoiceR);
    menu_nesting++;
    menu_item = 0;
    lines = indirect(EntryR);
    main_title = item_name; main_wid = item_width;
    cl = 7;

  .ReDisplay;

    oldcl = 0;
    @erase_window $ffff;
    #Iftrue (#version_number == 6);
    @set_cursor -1;
    ch = HDR_FONTWUNITS->0;
    #Ifnot;
    ch = 1;
    #Endif;
    i = ch * (lines+7);
    @split_window i;
    i = HDR_SCREENWCHARS->0;
    if (i == 0) i = 80;
    @set_window 1;
    @set_cursor 1 1;

    #Iftrue (#version_number == 6);
    @set_font 4 -> cw;
    cw = HDR_FONTHUNITS->0;
    #Ifnot;
    cw = 1;
    #Endif;

    style reverse;
    spaces(i); j=1+(i/2-main_wid)*cw;
    @set_cursor 1 j;
    print (string) main_title;
    y=1+ch; @set_cursor y 1; spaces(i);
    x=1+cw; @set_cursor y x; print (string) NKEY__TX;
    j=1+(i-13)*cw; @set_cursor y j; print (string) PKEY__TX;
    y=y+ch; @set_cursor y 1; spaces(i);
    @set_cursor y x; print (string) RKEY__TX;
    j=1+(i-18)*cw; @set_cursor y j;

    if (menu_nesting == 1) print (string) QKEY1__TX;
    else                   print (string) QKEY2__TX;

    style roman;
    y = y+2*ch;
    @set_cursor y x; font off;

    if (menu_choices ofclass String) print (string) menu_choices;
    else                             menu_choices.call();

    x = 1+3*cw;
    for (::) {
        if (cl ~= oldcl) {
            if (oldcl>0) {
                y=1+(oldcl-1)*ch; @set_cursor y x; print " ";
            }
            y=1+(cl-1)*ch; @set_cursor y x; print ">";
        }

        oldcl = cl;
        @read_char 1 -> pkey;
        if (pkey == NKEY1__KY or NKEY2__KY or 130) {
            cl++; if (cl == 7+lines) cl = 7; continue;
        }
        if (pkey == PKEY1__KY or PKEY2__KY or 129) {
            cl--; if (cl == 6) cl = 6+lines; continue;
        }
        if (pkey == QKEY1__KY or QKEY2__KY or 27 or 131) break;
        if (pkey == 10 or 13 or 132) {
            @set_window 0; font on;
            new_line; new_line; new_line;

            menu_item = cl-6;
            EntryR.call();

            @erase_window $ffff;
            @split_window ch;
            i = HDR_SCREENWCHARS->0; if ( i== 0) i = 80;
            @set_window 1; @set_cursor 1 1; style reverse; spaces(i);
            j=1+(i/2-item_width)*cw;
            @set_cursor 1 j;
            print (string) item_name;
            style roman; @set_window 0; new_line;

            i = ChoiceR.call();
            if (i == 2) jump ReDisplay;
            if (i == 3) break;

            L__M(##Miscellany, 53);
            @read_char 1 -> pkey; jump ReDisplay;
        }
    }

    menu_nesting--; if (menu_nesting > 0) rfalse;
    font on; @set_cursor 1 1;
    @erase_window $ffff; @set_window 0;
    #Iftrue (#version_number == 6);
    @set_cursor -2;
    #Endif;
    new_line; new_line; new_line;
    if (gameover == 0) <<Look>>;
];

#Endif; ! V5

#Ifnot; ! TARGET_GLULX

[ DoMenu menu_choices EntryR ChoiceR
    winwid winhgt lines main_title main_wid cl i oldcl pkey;

    if (pretty_flag == 0 || gg_statuswin == 0) return LowKey_Menu(menu_choices, EntryR, ChoiceR);

    menu_nesting++;
    menu_item = 0;
    lines = indirect(EntryR);
    main_title = item_name;
    main_wid = item_width;

    cl = 0;

    ! If we printed "hit arrow keys" here, it would be appropriate to
    ! check for the availability of Glk input keys. But we actually
    ! print "hit N/P/Q". So it's reasonable to silently accept Glk
    ! arrow key codes as secondary options.

  .ReDisplay;

    glk($002A, gg_statuswin); ! window_clear
    glk($002A, gg_mainwin); ! window_clear
    glk($002F, gg_statuswin); ! set_window
    StatusLineHeight(lines+7);
    glk($0025, gg_statuswin, gg_arguments, gg_arguments+4); ! window_get_size
    winwid = gg_arguments-->0;
    winhgt = gg_arguments-->1;
    glk($0086, 4); ! set subheader style
    glk($002B, gg_statuswin, winwid/2-main_wid, 0); ! window_move_cursor
    print (string) main_title;
    glk($002B, gg_statuswin, 1, 1); ! window_move_cursor
    print (string) NKEY__TX;
    glk($002B, gg_statuswin, winwid-13, 1); ! window_move_cursor
    print (string) PKEY__TX;
    glk($002B, gg_statuswin, 1, 2); ! window_move_cursor
    print (string) RKEY__TX;
    glk($002B, gg_statuswin, winwid-18, 2); ! window_move_cursor
    if (menu_nesting == 1) print (string) QKEY1__TX;
    else                   print (string) QKEY2__TX;
    glk($0086, 0); ! set normal style

    glk($002B, gg_statuswin, 1, 4); ! window_move_cursor
    if (menu_choices ofclass String) print (string) menu_choices;
    else                             menu_choices.call();

    oldcl = -1;

    for (::) {
        if (cl ~= oldcl) {
            if (cl < 0 || cl >= lines) cl = 0;
            if (oldcl >= 0) {
                glk($002B, gg_statuswin, 3, oldcl+6);
                print (char) ' ';
            }
            oldcl = cl;
            glk($002B, gg_statuswin, 3, oldcl+6);
            print (char) '>';
        }
        pkey = KeyCharPrimitive(gg_statuswin, true);
        if (pkey == $80000000) jump ReDisplay;
        if (pkey == NKEY1__KY or NKEY2__KY or $fffffffb) {
            cl++;
            if (cl >= lines) cl = 0;
            continue;
        }
        if (pkey == PKEY1__KY or PKEY2__KY or $fffffffc) {
            cl--;
            if (cl < 0) cl = lines-1;
            continue;
        }
        if (pkey == QKEY1__KY or QKEY2__KY or $fffffff8 or $fffffffe) break;
        if (pkey == $fffffffa or $fffffffd) {
            glk($002F, gg_mainwin); ! set_window
            new_line; new_line; new_line;
            menu_item = cl+1;
            EntryR.call();

            glk($002A, gg_statuswin); ! window_clear
            glk($002A, gg_mainwin); ! window_clear
            glk($002F, gg_statuswin); ! set_window
            StatusLineHeight(1);
            glk($0025, gg_statuswin, gg_arguments, gg_arguments+4); ! window_get_size
            winwid = gg_arguments-->0;
            winhgt = gg_arguments-->1;
            glk($0086, 4); ! set subheader style
            glk($002B, gg_statuswin, winwid/2-item_width, 0); ! window_move_cursor
            print (string) item_name;
            glk($0086, 0); ! set normal style

            glk($002F, gg_mainwin); ! set_window
            new_line;
            i = ChoiceR.call();
            if (i == 2) jump ReDisplay;
            if (i == 3) break;
            L__M(##Miscellany, 53);
            pkey = KeyCharPrimitive(gg_mainwin, 1);
            jump ReDisplay;
        }
    }

    ! done with this menu...
    menu_nesting--;
    if (menu_nesting > 0) rfalse;
    glk($002F, gg_mainwin); ! set_window
    glk($002A, gg_mainwin); ! window_clear
    new_line; new_line; new_line;
    if (gameover == 0) <<Look>>;
];

#Endif; ! TARGET_

#Endif; ! NO_MENUS

! To use CheckBeforeImplicit:
! obj = object on which to perform the implicit action
! act = the implicit action
! m1, n1, i = used for printing the "(first... )" message
! m2, n2, x = used for printing a refusal message in case
! the before_implicit property of the obj rejects the
! action
[ CheckBeforeImplicit obj act m1 n1 i m2 n2 x;

  x = keep_silent; failed_action = 0;
  if (actor == player) action_mode = 1;
  if (action_mode == 2) action_mode = 3;
  if (action_mode == 0 && actor ~= player) action_mode = 4;

	switch (RunRoutines(obj, before_implicit)) {
		0: if (action_mode == 1 or 3) {
			if (x ~= 2) keep_silent = 1;
			L__M(m1, n1, i);
			if (multiflag == false && multiflag2 == false) new_line;
			}
		   informlibrary.actor_act(actor, act, obj);
		   if (action_mode == 1 or 3) action_mode--;
		   if (action_mode == 4) action_mode = 0;
		   if (failed_action) { keep_silent = 2; rfalse; }
		   keep_silent = x;

		1: if (x ~= 2) keep_silent = 1;
	   	   informlibrary.actor_act(actor, act, obj);
		   if (action_mode == 1 or 3) action_mode--;
		   if (action_mode == 4) action_mode = 0;
   		   keep_silent = x; if (failed_action) rfalse;

		2: failed_action = 1; L__M(m2, n2, noun); rfalse;

		3: failed_action = 1;
		   if (actor == player) { L__M(m2, n2, i, obj); } 
		   if (action_mode == 1 or 3) action_mode--; rfalse;
	}
];

! ----------------------------------------------------------------------------
!   The handy YesOrNo routine, and some "meta" verbs
! ----------------------------------------------------------------------------

[ YesOrNo i j;
    for (::) {
        #Ifdef TARGET_ZCODE;
	#Ifndef NO_STATUSLINE;
        if (player.location == nothing || parent(player) == nothing) read buffer parse;
        else read buffer parse DrawStatusLine;
	#Ifnot;
	read buffer parse;
	#Endif; ! NO_STATUSLINE;
        j = parse->1;
        #Ifnot; ! TARGET_GLULX;
        KeyboardPrimitive(buffer, parse);
        j = parse-->0;
        #Endif; ! TARGET_
        if (j) { ! at least one word entered
            i = parse-->1;
            if (i == YES1__WD or YES2__WD or YES3__WD) rtrue;
            if (i == NO1__WD or NO2__WD or NO3__WD) rfalse;
        }
        L__M(##Quit, 1); print "> ";
    }
];

#Ifdef TARGET_ZCODE;

[ QuitSub; L__M(##Quit, 2); if (YesOrNo() ~= 0) quit; ];

[ RestartSub;
    L__M(##Restart,1);
    if (YesOrNo() ~= 0) { @restart; L__M(##Restart, 2); }
];

[ RestoreSub;
    restore Rmaybe;
    return L__M(##Restore, 1);
  .RMaybe;
    L__M(##Restore, 2);
];

[ SaveSub flag;
    #IfV5;
    @save -> flag;
    switch (flag) {
      0: L__M(##Save, 1);
      1: L__M(##Save, 2);
      2:
        RestoreColours();
        L__M(##Restore, 2);
    }
    #Ifnot;
    save Smaybe;
    return L__M(##Save, 1);
  .SMaybe;
    L__M(##Save, 2);
    #Endif; ! V
];

[ VerifySub;
    @verify ?Vmaybe;
    jump Vwrong;
  .Vmaybe;
    return L__M(##Verify, 1);
  .Vwrong;
    L__M(##Verify, 2);
];

[ ScriptOnSub;
    transcript_mode = ((HDR_GAMEFLAGS-->0) & 1);
    if (transcript_mode) return L__M(##ScriptOn, 1);
    @output_stream 2;
    if (((HDR_GAMEFLAGS-->0) & 1) == 0) return L__M(##ScriptOn, 3);
    L__M(##ScriptOn, 2); VersionSub();
    transcript_mode = true;
];

[ ScriptOffSub;
    transcript_mode = ((HDR_GAMEFLAGS-->0) & 1);
    if (transcript_mode == false) return L__M(##ScriptOff, 1);
    L__M(##ScriptOff, 2);
    @output_stream -2;
    if ((HDR_GAMEFLAGS-->0) & 1) return L__M(##ScriptOff, 3);
    transcript_mode = false;
];

[ CommandsOnSub;
    @output_stream 4;
    xcommsdir = 1;
    L__M(##CommandsOn, 1);
];

[ CommandsOffSub;
    if (xcommsdir == 1) @output_stream -4;
    xcommsdir = 0;
    L__M(##CommandsOff, 1);
];

[ CommandsReadSub;
    @input_stream 1;
    xcommsdir = 2;
    L__M(##CommandsRead, 1);
];

#Ifnot; ! TARGET_GLULX;

[ QuitSub;
    L__M(##Quit, 2);
    if (YesOrNo() ~= 0) quit;
];

[ RestartSub;
    L__M(##Restart,1);
    if (YesOrNo() ~= 0) {
        @restart;
        L__M(##Restart, 2);
    }
];

[ RestoreSub res fref;
    fref = glk($0062, $01, $02, 0); ! fileref_create_by_prompt
    if (fref == 0) jump RFailed;
    gg_savestr = glk($0042, fref, $02, GG_SAVESTR_ROCK); ! stream_open_file
    glk($0063, fref); ! fileref_destroy
    if (gg_savestr == 0) jump RFailed;
    @restore gg_savestr res;
    glk($0044, gg_savestr, 0); ! stream_close
    gg_savestr = 0;
  .RFailed;
    L__M(##Restore, 1);
];

[ SaveSub res fref;
    fref = glk($0062, $01, $01, 0); ! fileref_create_by_prompt
    if (fref == 0) jump SFailed;
    gg_savestr = glk($0042, fref, $01, GG_SAVESTR_ROCK); ! stream_open_file
    glk($0063, fref); ! fileref_destroy
    if (gg_savestr == 0) jump SFailed;
    @save gg_savestr res;
    if (res == -1) {
        ! The player actually just typed "restore". We're going to print
        !  L__M(##Restore,2); the Z-Code Inform library does this correctly
        ! now. But first, we have to recover all the Glk objects; the values
        ! in our global variables are all wrong.
        GGRecoverObjects();
        glk($0044, gg_savestr, 0); ! stream_close
        gg_savestr = 0;
        return L__M(##Restore, 2);
    }
    glk($0044, gg_savestr, 0); ! stream_close
    gg_savestr = 0;
    if (res == 0) return L__M(##Save, 2);
  .SFailed;
    L__M(##Save, 1);
];

[ VerifySub res;
    @verify res;
    if (res == 0) return L__M(##Verify, 1);
    L__M(##Verify, 2);
];

[ ScriptOnSub;
    if (gg_scriptstr ~= 0) return L__M(##ScriptOn, 1);
    if (gg_scriptfref == 0) {
        ! fileref_create_by_prompt
        gg_scriptfref = glk($0062, $102, $05, GG_SCRIPTFREF_ROCK);
        if (gg_scriptfref == 0) jump S1Failed;
    }
    ! stream_open_file
    gg_scriptstr = glk($0042, gg_scriptfref, $05, GG_SCRIPTSTR_ROCK);
    if (gg_scriptstr == 0) jump S1Failed;
    glk($002D, gg_mainwin, gg_scriptstr); ! window_set_echo_stream
    L__M(##ScriptOn, 2);
    VersionSub();
    return;
  .S1Failed;
    L__M(##ScriptOn, 3);
];

[ ScriptOffSub;
    if (gg_scriptstr == 0) return L__M(##ScriptOff,1);
    L__M(##ScriptOff, 2);
    glk($0044, gg_scriptstr, 0); ! stream_close
    gg_scriptstr = 0;
];

[ CommandsOnSub fref;
    if (gg_commandstr ~= 0) {
        if (gg_command_reading)
            L__M(##CommandsOn, 2);
        else
            L__M(##CommandsOn, 3);
        return;
    }
    ! fileref_create_by_prompt
    fref = glk($0062, $103, $01, 0);
    if (fref == 0) return L__M(##CommandsOn, 4);
    gg_command_reading = false;
    ! stream_open_file
    gg_commandstr = glk($0042, fref, $01, GG_COMMANDWSTR_ROCK);
    glk($0063, fref); ! fileref_destroy
    if (gg_commandstr == 0) return L__M(##CommandsOn, 4);
    L__M(##CommandsOn, 1);
];

[ CommandsOffSub;
    if (gg_commandstr == 0) return L__M(##CommandsOff, 2);
    if (gg_command_reading) return L__M(##CommandsRead, 5); ! was L__M(##CommandsOn, 2);
    glk($0044, gg_commandstr, 0); ! stream_close
    gg_commandstr = 0;
    gg_command_reading = false;
    L__M(##CommandsOff, 1);
];

[ CommandsReadSub fref;
    if (gg_commandstr ~= 0) {
        if (gg_command_reading)
            L__M(##CommandsRead, 2);
        else
            L__M(##CommandsRead, 3);
        return;
    }
    ! fileref_create_by_prompt
    fref = glk($0062, $103, $02, 0);
    if (fref == 0) return L__M(##CommandsRead, 4);
    gg_command_reading = true;
    ! stream_open_file
    gg_commandstr = glk($0042, fref, $02, GG_COMMANDRSTR_ROCK);
    glk($0063, fref); ! fileref_destroy
    if (gg_commandstr == 0) return L__M(##CommandsRead, 4);
    return L__M(##CommandsRead, 1);
];

#Endif; ! TARGET_;

#Ifndef NO_SCORE;
[ NotifyOnSub;  if (notify_mode == -1) notify_mode = 2; else notify_mode = 1; L__M(##NotifyOn);  ];
[ NotifyOffSub; if (notify_mode == 2) notify_mode = -1; else notify_mode = 0; L__M(##NotifyOff); ];
#Endif;

[ Places1Sub i j k;
    L__M(##Places, 1);
    objectloop (i ofclass Room && i.visited == true) j++;
    objectloop (i ofclass Room && i.visited == true) {
        print (name) i; k++;
        if (k == j) { L__M(##Places, 2); return; }
        if (k == j-1) {
		if (j > 2) print (string) AND__TX;
		else print (string) AND2__TX;
	  }
        else          print (string) COMMA__TX;
    }
];

[ Objects1Sub i j f;
    L__M(##Objects, 1);
    objectloop (i has moved) {
       f = 1; print (the) i; j = parent(i);
#Ifdef COMPLEXCLOTHING;
        if (j) {
           if (j == player) {
               if (i ofclass Wearable && i.worn_by ~= 0) L__M(##Objects, 3);
               else            L__M(##Objects, 4);
                jump Obj__Ptd;
            }
#Ifnot;
        if (j) {
           if (j == player) {
               if (i has worn) L__M(##Objects, 3);
               else            L__M(##Objects, 4);
                jump Obj__Ptd;
            }
#Endif;

            if (j has animate)   { L__M(##Objects, 5);    jump Obj__Ptd; }

            if (j ofclass Room && j.visited == true)   { L__M(##Objects, 6, j); jump Obj__Ptd; }

		if (i.insideofparent==true)
					   { L__M(##Objects, 8, j); jump Obj__Ptd; }
		if (i.ontopofparent==true)
					   { L__M(##Objects, 9, j); jump Obj__Ptd; }
		if (i.behindparent==true)
					   { L__M(##Objects, 11, j); jump Obj__Ptd; }
		if (i.beneathparent==true)
					   { L__M(##Objects, 12, j); jump Obj__Ptd; }
		if (i.attachedtoparent==true)
					   { L__M(##Objects, 13, j); jump OBJ__Ptd; }
        }
        L__M(##Objects, 10);

      .Obj__Ptd;

        new_line;
    }
    if (f == 0) L__M(##Objects, 2);
];

! ----------------------------------------------------------------------------
!   The scoring system
! ----------------------------------------------------------------------------

#Ifndef NO_SCORE;
[ ScoreSub;
    L__M(##Score, 1);
#IFDEF USE_LIBRARY_EXTENSIONS;
    if(PrintRank() == false) LibraryExtensions.RunAll(ext_printrank);
#IFNOT;
    PrintRank();
#ENDIF;
];

#Ifndef TaskScore;
[ TaskScore i n;
    if (n) return n;
    return task_scores-->i;
];
#Endif; ! TaskScore

[ Achieved n1 n2 n3;
  if (n2) task_scores-->n1 = task_scores-->n1 + n2;
	else task_done->n1 = 1;
  if (n3 == 0) score = score + TaskScore(n1, n2);
	else score = score + n3;
];

[ PANum m n;
    print "  ";
    n = m;
    if (n < 0)    { n = -m; n = n*10; }
    if (n < 10)   { print "   "; jump Panuml; }
    if (n < 100)  { print "  "; jump Panuml; }
    if (n < 1000) { print " "; }

  .Panuml;

    print m, " ";
];

[ FullScoreSub i;
    ScoreSub();
    if ((score == 0 && notify_mode ~= 2 or -1) || TASKS_PROVIDED == 1) rfalse;
    new_line;
    L__M(##FullScore, 1);
    for (i=0 : i<NUMBER_TASKS : i++)
        if (task_done->i == 1) {
            PANum(TaskScore(i));
	#IFDEF USE_LIBRARY_EXTENSIONS;
            if(PrintTaskName(i) == false)
                LibraryExtensions.RunAll(ext_printtaskname,i);
	#IFNOT;
            PrintTaskName(i);
	#ENDIF;
        }
    if (things_score ~= 0) {
        PANum(things_score);
        L__M(##FullScore, 2);
    }
    if (places_score ~= 0) {
        PANum(places_score);
        L__M(##FullScore, 3);
    }
    new_line; PANum(score); L__M(##FullScore, 4);
];

#Endif; ! NO_SCORE

! ----------------------------------------------------------------------------
!   Real verbs start here: Inventory
! ----------------------------------------------------------------------------

[ InvWideSub;
    inventory_style = ENGLISH_BIT + RECURSE_BIT + FULLINV_BIT + WORKFLAG_BIT;
    <Inv>;
];

[ InvTallSub;
    inventory_style = NEWLINE_BIT + INDENT_BIT + RECURSE_BIT + FULLINV_BIT + WORKFLAG_BIT;
    <Inv>;
];

[ InvSub x y z;

    if (actor ~= player) return L__M(##Miscellany, 68);

    objectloop (x in player) {
        if (x has anatomy && x.attachedtoparent == true) give x ~workflag;
		else { y = true; give x workflag; }
	if (x ofclass Container)
		{ objectloop (z && IndirectlyContains(x, z, 8) ~= 0 or 8)
			{ if (z has topic) give z workflag; else give z ~workflag; }
		}
    }

    if (y == false) return L__M(##Miscellany, 44);

    if (inventory_style == 0) return InvTallSub();

    L__M(##Inv, 2);
    if (inventory_style & NEWLINE_BIT ~= 0) L__M(##Inv, 3); else print " ";

    WriteListFrom(child(player), inventory_style, 0);
    if (inventory_style & ENGLISH_BIT ~= 0) L__M(##Inv, 4);

    #Ifndef MANUAL_PRONOUNS;
    objectloop (x in player) PronounNotice(x);
    #Endif;
    AfterRoutines();
];

! ----------------------------------------------------------------------------
!   The object tree and determining the possibility of moves
! ----------------------------------------------------------------------------

[ CommonAncestor o1 o2 i j;
    ! Find the nearest object indirectly containing o1 and o2,
    ! or return 0 if there is no common ancestor.
    i = o1;
    while (i ~= 0) {
        j = o2;
        while (j ~= 0) {
            if (j == i) return i;
            j = parent(j);
        }
        i = parent(i);
    }
    return 0;
];

! Will return the way in which o2 is indirectly contained by o1.
! 0 = no hierarchical relationship exists
! 1 = inside
! 2 = on top
! 3 = behind
! 4 = beneath
! 5 = generically attached
! 6 = being held by an actor or on the floor in a Room
! So, if o1 is inside a briefcase which is on top of a box which
! is under a desk, IndirectlyContains(desk, o2) will return 4.
[ IndirectlyContains o1 o2 flag;
    ! Does o1 indirectly contain o2?  (Same as testing if their common ancestor is o1.)
    while (o2 ~= 0) {
        if (o1 == o2) if (flag) return flag; else rtrue;
        if (o2 ofclass Class) rfalse;
	if (o2 ofclass Thing) {
		if (SimpleAttach(o2)) flag = 5;
		if (parent(o2) && (parent(o2) has animate || parent(o2) ofclass Room)) flag = 6;
		if (o2.insideofparent) flag = 1;
		if (o2.ontopofparent) flag = 2;
		if (o2.behindparent) flag = 3;
		if (o2.beneathparent) flag = 4;
	}
        o2 = parent(o2);
    }
    rfalse;
];

[ ObjectScopedBySomething item i j k l m;
    i = item;
    objectloop (j .& add_to_scope) {
        l = j.&add_to_scope;
        k = (j.#add_to_scope)/WORDSIZE;
        if (l-->0 ofclass Routine) continue;
        for (m=0 : m<k : m++)
            if (l-->m == i) return j;
    }
    rfalse;
];

[ IsSmellable item person i;
  i = parent(item);

  if (i ofclass Container && i.smellproof() && ObjectIsUntouchable(item, person, true)) rfalse;

  rtrue;
];

[ IsAudible item i;
  i = parent(item);
  if (i ofclass Container && i has closed && i.soundproof) rfalse;
  rtrue;
];

[ ObjectIsEnterable obj i;
  if (obj == d_obj && action == ##GetOn) rtrue;

  if (~~obj ofclass Container) {
	failed_action = 1;
	if (obj has animate) L__M(##Miscellany, 68);
	 else L__M(##Enter, 2, obj);
	rfalse;
  }
  if (parent(obj) == 0) { L__M(##Enter, 4); rfalse; }
  if (IndirectlyContains(actor, obj)) { L__M(##Enter, 1, obj); rfalse; }

	if (ObjectIsUntouchable(obj, actor)) rfalse;
	  switch (action) {
		##GetInside:
			if (obj.inside_capacity() < 1) { L__M(##Enter, 2, obj); rfalse; }
			if (obj has closed) {
				CheckBeforeImplicit(obj, ##Open, ##Miscellany, 65, obj, ##Go, 10);
				if (failed_action) rfalse;
				}
			i = CountChildren(obj, 3, 1);
			i = obj.inside_capacity() - i;
			if (i < actor.volume) { L__M(##Enter, 8, obj); rfalse; }

		##GetOn:
			if (obj.ontop_capacity() < 1) { L__M(##Enter, 2, obj); rfalse; }
			i = CountChildren(obj, 4, 1);
			i = obj.ontop_capacity() - i;
			if (i < actor.volume){ L__M(##Enter, 8, obj); rfalse; }

		##GetBehind:
			if (obj.behind_capacity() < 1) { L__M(##Enter, 2, obj); rfalse; }
			i = CountChildren(obj, 1, 1);
			i = obj.behind_capacity() - i;
			if (i < actor.volume) { L__M(##Enter, 8, obj); rfalse; }

		##GetBeneath:
			if (obj.beneath_capacity() < 1) { L__M(##Enter, 2, obj); rfalse; }
			i = CountChildren(obj, 2, 1);
			i = obj.beneath_capacity() - i;
			if (i < actor.volume) { L__M(##Enter, 8, obj); rfalse; }
		}

  rtrue;
];

[ ImpliedEnter i j;

  ! First, the actor might be contained and thus need to get out of
  ! whatever is containing her.

  i = parent(actor); j = IndirectlyContains(i, noun);

  if (i ofclass Container && j == false) {
		CheckBeforeImplicit(i, ##Exit, ##Enter, 10, i, ##Go, 1);
		if (failed_action) rfalse; rtrue;
  }

  i = LanguageVerbIsPosture();
  
  if (actor in noun) switch (action)
	{ ##GetInside:
		if (actor.insideofparent) {
			if (i == actor.posture or 0)
				{ L__M(##Enter, 1, noun); rfalse; }
		}

	  ##GetOn:
		if (actor.ontopofparent) {
			if (i == actor.posture or 0)
				{ L__M(##Enter, 1, noun); rfalse; }
		}

	  ##GetBehind:
		if (actor.behindparent) {
			if (i == actor.posture or 0)
				{ L__M(##Enter, 1, noun); rfalse; }
		}

	  ##GetBeneath:
		if (actor.beneathparent) {
			if (i == actor.posture or 0)
				{ L__M(##Enter, 1, noun); rfalse; }
		}

	  default: L__M(##Enter, 1, noun); rfalse;
	}

  ! The actor might be trying to go on top of something which she is currently under (for example).

  j = 0; i = parent(actor);
  if (i == noun)
	switch (action) {
		##GetBeneath: if (actor.beneathparent == false) j = 3;

		##GetBehind: if (actor.behindparent == false) j = 3;

		##GetInside: if (actor.insideofparent == false) j = 3;

		##GetOn: if (actor.ontopofparent == false) j = 3;
	}

  if (j == 3) {
		CheckBeforeImplicit(i, ##Exit, ##Enter, 10, i, ##Go, 1);
		if (failed_action) rfalse;
  }

  ! Last, the actor must be in the parent of whatever container she wants to enter.

  i = parent(noun); j = IndirectlyContains(i, noun);

  if (i ofclass Container && IndirectlyContains(i, actor) == 0) {
	original_noun = noun;

	switch (j) {
		1: CheckBeforeImplicit(i, ##GetInside, ##Enter, 6, i, ##Go, 1);
		2: CheckBeforeImplicit(i, ##GetOn, ##Enter, 6, i, ##Go, 1);
		3: CheckBeforeImplicit(i, ##GetBehind, ##Enter, 6, i, ##Go, 1);
		4: CheckBeforeImplicit(i, ##GetBeneath, ##Enter, 6, i, ##Go, 1);
	}
  }
  if (failed_action) rfalse;
  rtrue;
];

! Preference order is inside, on top of, behind, beneath.
!
! flag = 0 returns value of preferred action. If it returns 0 there is not enough space.
! flag ~= 0 automatically generates action
[ ChooseHowToEnter obj flag spaceleft;
  if (flag == 0) {
	if (obj.inside_capacity())
		{ spaceleft = obj.inside_capacity() - CountChildren(obj, 1, 1);
		   if (spaceleft >= actor.volume) return 1;
		}
	if (obj.ontop_capacity())
		{ spaceleft = obj.ontop_capacity() - CountChildren(obj, 2, 1);
		  if (spaceleft >= actor.volume) return 2;
		}
	if (obj.behind_capacity())
		{ spaceleft = obj.behind_capacity() - CountChildren(obj, 3, 1);
		  if (spaceleft >= actor.volume) return 3;
		}
	if (obj.beneath_capacity())
		{ spaceleft = obj.beneath_capacity() - CountChildren(obj, 4, 1);
		  if (spaceleft >= actor.volume) return 4;
		}
	else rfalse;
  }
  else {
	if (obj.inside_capacity())
		{ informlibrary.actor_act(actor, ##GetInside, noun); rtrue; }
	if (obj.ontop_capacity())
		{ informlibrary.actor_act(actor, ##GetOn, noun); rtrue; }
	if (obj.behind_capacity())
		{ informlibrary.actor_act(actor, ##GetBehind, noun); rtrue; }
	if (obj.beneath_capacity())
		{ informlibrary.actor_act(actor, ##GetBeneath, noun); rtrue; }
  }
];

[ ObjectIsUntouchable item person flag1 flag2 flag3 ancestor i j k;

    if (person == 0) person = actor;

    ! Determine if there's any barrier preventing the player from moving
    ! things to "item".  Return false if no barrier; otherwise print a
    ! suitable message and return true.
    ! If flag1 is set, do not print any message.
    ! If flag2 is set, also apply ##Take restrictions.
    ! If flag3 is set, implicit ##Open actions will be generated,
    !  though not if flag1 is also.

    ! The compass can't be acted upon, except that putting something
    ! "on the floor" is allowed.

    if (item in compass) {
	if (item == d_obj && action == ##PutOn) rfalse;
	if (flag1) rtrue; return L__M(##Miscellany, 68);
    }

    ancestor = CommonAncestor(person, item);

    ! If the item has been added to scope by something, it's first necessary
    ! for that something to be touchable.

    if (ancestor == 0) {
        ancestor = item;
        while (ancestor && (i = ObjectScopedBySomething(ancestor)) == 0)
            ancestor = parent(ancestor);
        if (i ~= 0) {
            if (ObjectIsUntouchable(i, person, flag1, flag2)) { failed_action = true; rtrue; }
            ! An item immediately added to scope
        }
    }
    else

    ! First, a barrier between the person and the ancestor. The person
    ! can only be in a sequence of enterable objects, and only closed
    ! containers make a barrier.

    if (person ~= ancestor) {
        i = parent(person);
        while (i ~= ancestor) {
            if (IndirectlyContains(i, person) == 1 && i has closed) {
		if (flag1) {
			failed_action = 1;
			cant_touch_reason-->0 = i; cant_touch_reason-->1 = 2;
			rtrue;
		}
		  if (flag3) CheckBeforeImplicit(i, ##Open, ##Miscellany, 65, i, ##Go, 10);
                  if (failed_action) {
			L__M(##Take, 9, i);
			cant_touch_reason-->0 = i; cant_touch_reason-->1 = 2;
		}
            }
            i = parent(i);
        }
    }

	i = CommonAncestor(person, item);

	if (i ofclass Container && (IndirectlyContains(i, person) == 4 && IndirectlyContains(i, item) == 2) ||
		(IndirectlyContains(i, person) == 2 && IndirectlyContains(i, item) == 4)) {
			failed_action = true; cant_touch_reason-->0 = i; cant_touch_reason-->1 = 2;
			print " 3 "; if (flag1) rtrue; return L__M(##Touch, 4, i);
	}

    ! Second, a barrier between the item and the ancestor. The item can
    ! be carried by someone, part of a piece of machinery, in or on top
    ! of something and so on.

    if (item ~= ancestor) {
        i = parent(item); j = item;
        while (i ~= ancestor) {
            if (flag2 && ~~i ofclass Container) {
                if (i has animate) {
                    failed_action = true; cant_touch_reason-->0 = i; cant_touch_reason-->1 = 4;
		    if (flag1) rtrue;
                    return L__M(##Take, 6, i);
                }
#Ifdef COMPLEXCLOTHING;
       if (i ofclass Wearable && i.covered_by ~= 0) {
	    failed_action = true; cant_touch_reason-->0 = i.covered_by; cant_touch_reason-->1 = 3;
	    if (flag1) rtrue;
	    return L__M(##Disrobe, 4, i);
	}
#Endif; ! Complex clothing
            } ! Begin ##Take restrictions
            else { k = parent(i);
#Ifdef COMPLEXCLOTHING;
		if (k ofclass Wearable && k.covered_by) {
		    failed_action = true; cant_touch_reason-->0 = k.covered_by; cant_touch_reason-->1 = 3;
		    if (flag1) rtrue;
		    return L__M(##Disrobe, 4, k);
		}
#Endif; ! Complex clothing
            if (i has closed && j.insideofparent) {
			cant_touch_reason-->0 = i; cant_touch_reason-->1 = 1;
			if (flag1) { failed_action = true; rtrue; }
			if (flag3) CheckBeforeImplicit(i, ##Open, ##Miscellany, 65, i, ##Go, 10);
               		if (failed_action) return L__M(##Take, 9, i);
			}
            }
            j = i;
            i = parent(i);
        }
    }

#Ifdef COMPLEXCLOTHING;
! Finally, an item of clothing could be covered by something else.

	if (item ofclass Wearable && item.covered_by && action ~= ##Wear or ##Disrobe) {
		failed_action = 1; cant_touch_reason-->0 = noun.covered_by; cant_touch_reason-->1 = 3;
		if (flag1) rtrue; return L__M(##Disrobe, 4, noun.covered_by);
	}
#Endif;

  rfalse;
];

! flag = preferred sack object.
! obj = item to be made room for.
! obj2 = object to be put away.
! k = space left in (potential) sack object.
! If k is zero, set failed_action to -1 to prevent trying a bunch more
! objects that just won't fit.
[ ChooseSackObject person obj obj2 j k m flag;

  objectloop(m && m in person && m ofclass Container && m.inside_capacity() > 0)
	{ if (m ~= flag) {
		if (m.locked && m has openable && m has closed) break;
	  	if (flag && m.sack_object > flag.sack_object) { flag = m; break; }
		if (~~flag) flag = m;
		else if (m.inside_capacity() > flag.inside_capacity()) flag = m;
	  }
	}

  if (flag)
	{ k = flag.inside_capacity() - CountChildren(flag, 3, 1);
#Ifdef COMPLEXCLOTHING;
	  objectloop(j in person && (~~j has anatomy && j.attachedtoparent)
			&& j ~= flag && ~~(j ofclass Wearable && j.worn_by))
		{ if (obj2 == 0 || j.volume >= obj.volume) obj2 = j; }
#Ifnot;
	  objectloop(j in person && (~~j has anatomy && j.attachedtoparent)
			&& j ~= flag && ~~j has worn)
		{ if (obj2 == 0 || j.volume >= obj.volume) obj2 = j; }
#Endif;
	}
  else { failed_action = 1; rfalse; }

  if (~~obj2) { failed_action = 1; rfalse; }
  if (k == 0) {failed_action = -1; rfalse; }

  L__M(##Take, 13, obj2, flag);
  keep_silent = 1; InformLibrary.actor_act(actor, ##Insert, obj2, flag); keep_silent = 0;
  if (failed_action) rfalse; rtrue;
];

[ AttemptToTakeObject item ancestor after_recipient i j k;

    i = parent(item);

    ! Try to transfer the given item to the actor: return false
    ! if successful, true if unsuccessful, printing a suitable message
    ! in the latter case.

    ! People cannot ordinarily be taken.
    if (item has animate) { failed_action = 1; return L__M(##Take, 3, item); }

    ancestor = CommonAncestor(actor, item);

    if (ancestor == 0) {
        i = ObjectScopedBySomething(item);
        if (i ~= 0) ancestor = CommonAncestor(actor, i);
	
    }

    ! Is the actor indirectly inside the item?
    if (ancestor == item) { failed_action = 1; return L__M(##Go, 1, item); }

    ! Does the actor already directly contain the item?
    if ( (action == ##Give && parent(item) == second) || item in actor)
	{ failed_action = 1; return L__M(##Take, 5, item, actor); }

    ! Can the actor touch the item, or is there (e.g.) a closed container
    ! in the way?

    if (ObjectIsUntouchable(item, actor, false, true, true)) rtrue;

    ! The item is now known to be accessible.

    ! Consult the immediate possessor of the item.

    ! Some items must be disconnected before being taken.
    if (item ofclass Thing && item.attachedtoparent == true)
	{ failed_action = 1; return L__M(##Take, 7, item, i); }

#Ifdef GRADUAL_LIGHT;
	if (i ofclass Container) {
        	after_recipient = i;
        	k = action;
		action = ##LetGo;
        	if (RunRoutines(i, before)) { action = k; rtrue; }
        	action = k;
	}
	else
	if (i has transparent or semitransparent && ~~i ofclass Person) {
		failed_action = 1; return L__M(##Take, 7, i);
	}
#Ifnot;
	if (i ofclass Container) {
        	after_recipient = i;
        	k = action;
		action = ##LetGo;
        	if (RunRoutines(i, before)) { action = k; rtrue; }
        	action = k;
	}
	else
	if (i has transparent && ~~i ofclass Person) {
		failed_action = 1; return L__M(##Take, 7, i);
	}
#Endif;

    if (item has scenery) { failed_action = 1; return L__M(##Take, 10, item); }
    if (item has static)  { failed_action = 1; return L__M(##Take, 11, item); }

    ! The item is now known to be available for taking.  Is the player
    ! carrying too much? If so, possibly juggle items into a container
    ! to make room.

    k = noun.volume;
#Ifdef COMPLEXCLOTHING;
    objectloop (j in actor && j provides volume)
	{ if (j ofclass Wearable && j.worn_by == actor) k = k;
	  if (j.attachedtoparent == true) k = k;
	  else k = k + j.volume;
	}
#Ifnot;
    objectloop (j in actor && j provides volume)
	{ if (j has worn || j.attachedtoparent) k = k;
	  else k = k + j.volume;
	}
#Endif;
    while (k > ValueOrRun(actor, capacity)) {
	if (ChooseSackObject(actor, noun) == false) {
		return L__M(##Take, 12);
	}
    k = noun.volume;
#Ifdef COMPLEXCLOTHING;
    objectloop (j in actor && j provides volume)
	{ if (j ofclass Wearable && j.worn_by == actor) k = k;
	  if (j.attachedtoparent == true) k = k;
	  else k = k + j.volume;
	}
#Ifnot;
    objectloop (j in actor && j provides volume)
	{ if (j has worn || j.attachedtoparent) k = k;
	  else k = k + j.volume;
	}
#Endif;
    }

    if (MiddleRoutines()) rtrue;

    ! Take care of some administrative matters.

    if (CountChildren(item, 1) ~= 0 && item.&hidden_contents-->2 == false ||
	CountChildren(item, 2) ~= 0 && item.&hidden_contents-->1 == false)
	{  objectloop (i in item && i hasnt concealed)
	  	{ if (i.behindparent || i.beneathparent) {
			behindorbeneath = true; give i workflag;
			}
		}
		objectloop (i in parent(item)) give i ~workflag;
	}

    Move(item, actor);

    if (item.insideofparent)	item.insideofparent = false;
    if (item.ontopofparent)	item.ontopofparent = false;
    if (item.behindparent)	item.behindparent = false;
    if (item.beneathparent)	item.beneathparent = false;
    if (item.attachedtoparent)	item.attachedtoparent = false;

    ! Send "after" message to the object letting go of the item, if any.

    if (after_recipient ~= 0) {
        k = action;
	action = ##LetGo;
        if (RunRoutines(after_recipient, after)) { action = k; rtrue; }
        action = k;
    }

    rfalse;
];

! ----------------------------------------------------------------------------
!   Object movement verbs
! ----------------------------------------------------------------------------

[ TakeSub i;

  i = parent(noun);

#Ifdef COMPLEXCLOTHING;
  if (verb_word == REMOVE__WD && noun in actor && noun ofclass Wearable) <<Disrobe noun>>;
#Ifnot;
  if (verb_word == REMOVE__WD && noun in actor && noun has clothing) <<Disrobe noun>>;
#Endif;

  if (onotheld_mode == 0 || noun notin actor)
      if (AttemptToTakeObject(noun)) return;

  if (AfterRoutines()) rtrue;
failed_action = 0;
  if (~~keep_silent) L__M(##Take, 1, noun, i);
  notheld_mode = onotheld_mode;
  if (notheld_mode || keep_silent) rtrue;
];

[ DropSub;

   if (noun == actor) { failed_action = 1; return L__M(##PutOn, 4); }
   if (noun has anatomy && noun.attachedtoparent) { failed_action = 1; return L__M(##Take, 7, noun, parent(noun)); }
   if (noun in parent(actor)) { failed_action = 1; return L__M(##Drop, 1, noun); }

   if (noun notin actor) {
	if (IndirectlyContains(actor, noun)) {
		CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
		if (failed_action) rfalse;
	}

   else { failed_action = 1; return L__M(##Drop, 2, noun); }
   }

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Endif;

   if (MiddleRoutines()) rtrue;

   if (actor.insideofparent)	noun.insideofparent = true;
   if (actor.ontopofparent)	noun.ontopofparent = true;
   if (actor.behindparent)	noun.behindparent = true;
   if (actor.beneathparent)	noun.beneathparent = true;

   Move(noun, parent(actor)); CalcWeight(actor);
   if (parent(actor) ofclass Container) CalcWeight(parent(actor));

   if (AfterRoutines()) rtrue;
   if (~~keep_silent) L__M(##Drop, 4, noun);
];

[ PutBehindSub;

  if (~~(second ofclass Container)) { failed_action = 1; return L__M(##PutOn, 3, second, "behind"); }

  if (second.behind_capacity() == 0) { failed_action = 1; return L__M(##PutOn, 3, second, "behind"); }

  if (second == actor) { 
	if (noun == actor) { failed_action =1; return L__M(##Miscellany, 32); }
	failed_action = 1; return L__M(##Miscellany, 58);
  }
  if (noun == actor) <<GetBehind second>>;

  receive_action = ##PutBehind;
  if (second has animate) { failed_action = 1; return L__M(##Miscellany, 59, second); }
  if (noun in second && noun.behindparent) { failed_action = 1; return L__M(##Drop, 1, noun); }
  if (noun == second) { failed_action = 1; return L__M(##PutOn, 12, "behind"); }

   if (noun notin actor) {
	CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
	if (failed_action) rfalse;
   }

  if (parent(second) == actor) { failed_action = 1; return L__M(##PutOn, 8, noun, "behind"); }
  if (parent(player) == second && player.insideofparent)
	{ failed_action = 1; return L__M(##PutOn, 9, second, "behind"); }

  if (second in noun) { failed_action = 1; return L__M(##PutOn, 3, second, "behind"); }
  if (parent(second) && ObjectIsUntouchable(second, actor, false, true, true)) rtrue;

	action = ##Receive;
        if(RunRoutines(second,before)) { action = ##PutOn; rtrue; }
        action = ##PutBehind;

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Endif;

  if (noun.volume > second.behind_capacity()) { failed_action = 1; return L__M(##PutOn, 10, "behind"); }

  if (CountChildren(second, 1, 1) >= second.behind_capacity())
        { failed_action = -1; return L__M(##PutOn, 5, second, "behind"); }

  if (MiddleRoutines()) rtrue;

  noun.behindparent = true; Move(noun, second);

  if (AfterRoutines()) rtrue;

  action = ##Receive;
  if(RunRoutines(second, after)) { action = ##PutBehind; rtrue; }
  action = ##PutBehind;

  if (~~keep_silent) {
  	if (multiflag) L__M(##Insert, 8);
	else L__M(##PutOn, 8, noun, "behind");
  }
];

[ PutOnSub;

  if (second ~= d_obj) if ((~~(second ofclass Container)) || second.ontop_capacity() == 0)
	{ failed_action = 1; return L__M(##PutOn, 3, second, "on top of"); }

  if (second == actor) { 
	if (noun == actor) { failed_action =1; return L__M(##Miscellany, 32); }
	failed_action = 1; return L__M(##Miscellany, 58);
  }
  if (noun == actor) <<GetOn second>>;

  receive_action = ##PutOn;

  if (second has animate) { failed_action = 1; return L__M(##Miscellany, 59, second); }
  if (noun in second && noun.ontopofparent) { failed_action = 1; return L__M(##Drop, 1, noun); }
  if (second == d_obj) {
	if (noun in parent(actor)) { failed_action = 1; return L__M(##Drop, 1, noun); }
	if (IndirectlyContains(noun, actor)) <<Drop noun>>;
  }
  if (noun == second) { failed_action = 1; return L__M(##PutOn, 12, "on"); }

  if (noun notin actor) {
	CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
	if (failed_action) rfalse;
  }

  if (second in actor) { failed_action = 1; return L__M(##PutOn, 11, "on"); }

  if (second in noun)
	{ failed_action = 1;
	  if (second.insideofparent) return L__M(##PutOn, 2, second, noun, "in");
	  if (second.ontopofparent) return L__M(##PutOn, 2, second, noun, "on");
	}

  if (parent(second) && ObjectIsUntouchable(second, actor, false, true, true)) return;

      action = ##Receive;
      if (RunRoutines(second, before)) { action = ##PutOn; return; }
      action = ##PutOn;

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Endif;

  if (second ~= d_obj) {

  	if (noun.volume > second.ontop_capacity()) { failed_action = 1; return L__M(##PutOn, 10, "on"); }

  	if (CountChildren(second, 4, 1) >= second.ontop_capacity())
      		{ failed_action = -1; return L__M(##PutOn, 5, second, "on"); }

  	if (MiddleRoutines()) rtrue; noun.ontopofparent = true; Move(noun, second);
  }

  if (second == d_obj) { if (MiddleRoutines()) rtrue; Move(noun, actor.location); }

  if (AfterRoutines()) return;

  action = ##Receive;
  if (RunRoutines(second, after)) { action = ##PutOn; return; }
  action = ##PutOn;

  if (~~keep_silent) {
  	if (multiflag) L__M(##Insert, 8);
	else L__M(##PutOn, 8, noun, "on");
  }
];

[ PutUnderSub;

  if (~~(second ofclass Container)) { failed_action = 1; return L__M(##PutUnder, 1, second); }

  if (second.beneath_capacity() == 0) { failed_action = 1; return L__M(##PutUnder, 1, second); }

  if (second == actor) { 
	if (noun == actor) { failed_action =1; return L__M(##Miscellany, 32); }
	failed_action = 1; return L__M(##Miscellany, 58);
  }
  if (noun == actor) <<GetBeneath second>>;
  if (second == d_obj) return L__M(##PutOn, 2, second, "underneath");

  receive_action = ##PutUnder;
  if (second has animate) { failed_action = 1; return L__M(##Miscellany, 59, second); }
  if (noun in second && noun.beneathparent) { failed_action = 1; return L__M(##Drop, 1, noun); }
  if (noun == second) { failed_action = 1; return L__M(##PutOn, 12, "under"); }

   if (noun notin actor) {
	CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
	if (failed_action) rfalse;
   }

  if (second in actor) { failed_action = 1; return L__M(##PutOn, 8, noun, "under"); }
  if (parent(actor) == second && actor.insideofparent)
	{ failed_action = 1; return L__M(##PutOn, 9, second, "under"); }

  if (second in noun && second.beneathparent) { failed_action = 1; return L__M(##PutOn, 2, second, noun, "underneath"); }
  if (parent(second) && ObjectIsUntouchable(second, actor, false, true, true)) rtrue;

	action = ##Receive;
        if(RunRoutines(second, before)) { action = ##PutUnder; rtrue; }
        action = ##PutUnder;

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Endif;

  if (noun.volume > second.beneath_capacity()) { failed_action = 1; return L__M(##PutOn, 10, "under"); }

  if (CountChildren(second, 2, 1) >= second.beneath_capacity())
        { failed_action = -1; return L__M(##PutOn, 5, second, "under"); }

  if (MiddleRoutines()) rtrue;

  noun.beneathparent = true; Move(noun, second);

  if (AfterRoutines()) rtrue;

  action = ##Receive;
  if(RunRoutines(second, after)) { action = ##PutUnder; rtrue; }
  action = ##PutUnder;

  if (~~keep_silent) {
  	if (multiflag) L__M(##Insert, 8);
	else L__M(##PutOn, 8, noun, "under");
  }
];

[ InsertSub;

  if (~~second ofclass Container) { failed_action = 1; return L__M(##Insert, 2, second); }

  if ( second.inside_capacity() == 0) { failed_action = 1; return L__M(##Insert, 2, second); }

  if (second == actor) { 
	if (noun == actor) { failed_action = 1; return L__M(##Miscellany, 32); }
	failed_action = 1; return L__M(##Miscellany, 58);
  }
  if (noun == actor) <<GetInside second>>;
  if (second == d_obj) return L__M(##Insert, 3, second);

  receive_action = ##Insert;

  if (second has animate) { failed_action = 1; return L__M(##Miscellany, 59, second); }

  if (parent(noun) == second && noun.insideofparent) { failed_action = 1; return L__M(##Drop, 1, noun); }
  if (noun == second) { failed_action = 1; return L__M(##PutOn, 12, "inside"); }

  if (noun notin actor) {
	CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
	if (failed_action) rfalse;
  }

  if (second in noun)
	{ failed_action = 1;
	  if (second.insideofparent) return L__M(##PutOn, 2, second, noun, "in");
	  if (second.ontopofparent) return L__M(##PutOn, 2, second, noun, "on");
	}

  if (parent(second) && ObjectIsUntouchable(second, actor, false, true, true)) return;

      action = ##Receive;
      if (RunRoutines(second, before)) { action = ##Insert; rtrue; }
      action = ##Insert;
      if (second ofclass Container && second has openable && second has closed) {
		CheckBeforeImplicit(second, ##Open, ##Miscellany, 65, second, ##Lock, 6);
		if (failed_action) rfalse;
       }

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
   }
#Endif;

  if (noun.volume > second.inside_capacity())
	{ failed_action = 1; return L__M(##Insert, 10, noun, second); }

  if (CountChildren(second, 3, 1) >= second.inside_capacity())
      { failed_action = -1; return L__M(##PutOn, 5, second, "in"); }

  if (MiddleRoutines()) rtrue;

  noun.insideofparent = true; Move(noun, second);

  if (AfterRoutines()) rtrue;

  action = ##Receive;
  if (RunRoutines(second, after)) { action = ##Insert; rtrue; }
  action = ##Insert;

  if (~~keep_silent) {
  	if (multiflag) L__M(##Insert, 8);
	else L__M(##PutOn, 8, noun, "inside");
  }
];

! ----------------------------------------------------------------------------
!   Empties and transfers are routed through the actions above
! ----------------------------------------------------------------------------

[ TransferSub;

  if (second == d_obj) <<Drop noun>>;
  if (second has animate) <<Give noun second>>;
  if (second provides inside_capacity && second.inside_capacity() > 0) <<Insert noun second>>;
  if (second provides ontop_capacity && second.ontop_capacity() > 0) <<PutOn noun second>>;
  if (second provides beneath_capacity && second.ontop_capacity() > 0) <<PutUnder noun second>>;
  if (second provides behind_capacity && second.ontop_capacity() > 0) <<PutBehind noun second>>;
  failed_action = 1;
  L__M(##EmptyT, 1, second);
];

[ EmptySub;

  second = d_obj;
  EmptyTSub();
];

[ EmptyTSub i j k flag;

  if (noun == second) { failed_action = 1; return L__M(##Miscellany, 68); }
  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if ( ~~noun ofclass Container) { failed_action = 1; return L__M(##Miscellany, 68); }
  if (noun has openable && noun has closed) { failed_action = 1; return L__M(##EmptyT, 2, noun); }
  if (second ~= d_obj && second.ontop_capacity() == 0) {
	if (second.inside_capacity() == 0) { failed_action = 1; return L__M(##EmptyT, 1, second); }
	if (second has openable && second has closed) { failed_action = 1; return L__M(##EmptyT, 2, second); }
  }
  i = child(noun); k = children(noun);
  if (i == 0) return L__M(##EmptyT, 3, noun);
  while (i ~= 0) {
      j = sibling(i);
      flag = 0;
      if (ObjectIsUntouchable(noun, actor, false, true, true)) flag = 1;
      if (noun provides inside_capacity && noun.inside_capacity() == 0) flag = 1;
      if (noun has openable && noun has closed) flag = 1;
      if (second ~= d_obj) {
          if (second.ontop_capacity() == 0) {
              if (second.inside_capacity() == 0) flag = 1;
              if (second has openable && second has closed) flag = 1;
          }
      }
      if (k-- == 0) flag = 1;
      if (flag) break;
      if (keep_silent == 0) print (name) i, (string) COLON__TX;
      <Transfer i second>;
      i = j;
  }
];

! ----------------------------------------------------------------------------
!   Gifts
! ----------------------------------------------------------------------------

[ GiveSub;

   if (actor == second) { informlibrary.actor_act(actor, ##Take, noun); rtrue; }
   if (noun == second) { failed_action = 1; return L__M(##Miscellany, 68); }
   if (IndirectlyContains(second, noun)) { failed_action = 1; return L__M(##Take, 5, noun, second); }

   if (noun notin actor) {
	if (noun == actor) { failed_action = 1; return L__M(##Miscellany, 68); }
	CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
	if (failed_action) rfalse;
   }

#Ifdef COMPLEXCLOTHING;
  if (noun ofclass Wearable && noun.worn_by == actor) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
  }
#Ifnot;
  if (noun has worn) {
	CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
	if (failed_action) rfalse;
  }
#Endif;

  if (MiddleRoutines()) rtrue;

  if (RunLife(second, ##Give)) rfalse;
  if (action_mode == 2) {
	Move(noun, second);
	return L__M(##Give, 4, noun);
  }
  if (~~keep_silent) L__M(##Give, 3, second);
];

[ GiveRSub; <Give second noun>; ];

[ ShowSub obj person;
  if (obj && person) { noun = obj; actor = person; }

  if (second == actor) <<Examine noun>>;
  if (MiddleRoutines()) rtrue;
  if (RunLife(second, ##Show)) rfalse;

  if (~~keep_silent) L__M(##Show, 2, second);
];

[ ShowRSub; <Show second noun>; ];

! ----------------------------------------------------------------------------
!   Travelling around verbs
! ----------------------------------------------------------------------------

[ LieSub i;

  if (actor.posture == 3) { failed_action = 1; return L__M(##Miscellany, 62); }

  if (MiddleRoutines()) rtrue;

  if (noun == 0) {
	objectloop (i in actor.location && i ofclass Container && i.preferred_posture == 3)
		{ switch (ChooseHowToEnter(i)) {
			1: L__M(##Objects, 7, i);
			2: L__M(##Objects, 9, i);
			3: L__M(##Objects, 11, i);
			4: L__M(##Objects, 12, i);
		  }
		  new_line; new_line;
		  informlibrary.actor_act(actor, ##Enter, i); return;
		}
  }

  actor.posture = 3;
  L__M(##Lie, 1);
];

[ SitSub i;

  if (actor.posture == 2)  { failed_action = 1; return L__M(##Miscellany, 62); }

  if (noun == 0) {
	objectloop (i in actor.location && i ofclass Container && i.preferred_posture == 2)
		{ switch (ChooseHowToEnter(i)) {
			1: L__M(##Objects, 7, i);
			2: L__M(##Objects, 9, i);
			3: L__M(##Objects, 11, i);
			4: L__M(##Objects, 12, i);
		  }
		  new_line; new_line;
		  informlibrary.actor_act(actor, ##Enter, i); return;
		}
  }

  if (MiddleRoutines()) rtrue;

  if (actor.posture == 1) { L__M(##Sit, 1); new_line; } 
  if (actor.posture == 3)  { L__M(##Sit, 2); new_line; }

  actor.posture = 2;
];

[ StandSub;

  if (actor.posture == 1)  { failed_action = 1; return L__M(##Stand, 2); }
  if (MiddleRoutines()) rtrue;
  actor.posture = 1;
  L__M(##Stand, 1);
];

[ EnterSub;

  if (noun ofclass Door || noun in compass) <<Go noun>>;
  if (ObjectIsEnterable(noun) == false) rfalse;
  if (MiddleRoutines()) rtrue;
  ChooseHowToEnter(noun, 1);
  if (original_noun && actor in parent(original_noun)) { keep_silent = 0; original_noun = 0; }
];

[ GetInsideSub;
  if (parent(noun) == 0) { failed_action = 1; return L__M(##Enter, 2, noun); }
  if (ObjectIsEnterable(noun) == false) { failed_action = 1; rfalse; }

  switch (ImpliedEnter()) {
	false: return;
	true: keep_silent = 0;
  }

  if (MiddleRoutines()) rtrue;

  actor.insideofparent = true; Move(actor, noun);
  actor.ontopofparent = false;
  actor.beneathparent = false;
  actor.behindparent = false;
  switch (LanguageVerbIsPosture()) {
	2: actor.posture = 2;
	1: actor.posture = 1;
	3: actor.posture = 3;
	default: actor.posture = noun.preferred_posture();
  }
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
	L__M(##Enter, 5, noun);
  	if (action_mode == false) Locale(noun);
  }
];

[ GetOnSub;
  if (parent(noun) == 0) { failed_action = 1; return L__M(##Enter, 2, noun); }
  if (noun == d_obj && parent(actor) ofclass Room) return L__M(##Drop, 1, actor);
  if (ObjectIsEnterable(noun) == false) { failed_action = 1; rfalse; }

  switch (ImpliedEnter()) {
	false: return;
	true: keep_silent = 0;
  }

  if (MiddleRoutines()) rtrue;

  if (noun == d_obj) jump Done;

  actor.ontopofparent = true; Move(actor, noun);
  actor.insideofparent = false;
  actor.beneathparent = false;
  actor.behindparent = false;
  .Done;
  switch (LanguageVerbIsPosture()) {
	2: actor.posture = 2;
	1: actor.posture = 1;
	3: actor.posture = 3;
	default: if (noun provides preferred_posture) actor.posture = noun.preferred_posture();
  }
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
	L__M(##Enter, 5, noun);
	if (action_mode == false) Locale(noun);
  }
];

[ GetBehindSub;
  if (parent(noun) == 0) { failed_action = 1; return L__M(##Enter, 2, noun); }
  if (ObjectIsEnterable(noun) == false) { failed_action = 1; rfalse; }

  switch (ImpliedEnter()) {
	false: return;
	true: keep_silent = 0;
  }

  if (MiddleRoutines()) rtrue;

  actor.behindparent = true; Move(actor, noun);
  actor.insideofparent = false;
  actor.ontopofparent = false;
  actor.beneathparent = false;
  switch (LanguageVerbIsPosture()) {
	2: actor.posture = 2;
	1: actor.posture = 1;
	3: actor.posture = 3;
	default: actor.posture = noun.preferred_posture();
  }
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
	L__M(##Enter, 5, noun);
	if (action_mode == false) Locale(noun);
  }
];

[ GetBeneathSub;
  if (parent(noun) == 0) { failed_action = 1; return L__M(##Enter, 2, noun); }
  if (ObjectIsEnterable(noun) == false) { failed_action = 1; rfalse; }

  switch (ImpliedEnter()) {
	false: return;
	true: keep_silent = 0;
  }

  if (MiddleRoutines()) rtrue;

  actor.beneathparent = true; Move(actor, noun);
  actor.insideofparent = false;
  actor.ontopofparent = false;
  actor.behindparent = false;
  switch (LanguageVerbIsPosture()) {
	2: actor.posture = 2;
	1: actor.posture = 1;
	3: actor.posture = 3;
	default: actor.posture = noun.preferred_posture();
  }
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
	L__M(##Enter, 5, noun);
	if (action_mode == false) Locale(noun);
  }
];

[ ExitSub p q r;
.Start;
  p = parent(actor); q = actor.location;
  if (noun == 0) {
	if (p == q)
		{ if (p.out_to ~= 0)
			{ action = ##Go; noun = out_obj; GoSub(); rfalse; }
		  return L__M(##Exit, 1);
		}
	informlibrary.actor_act(actor, ##Exit, p); return;
  }

  if (noun ~= p) {
	if (noun has animate) { failed_action = 1; return L__M(##Miscellany, 68); }
	if(IndirectlyContains(noun, actor)) {
		CheckBeforeImplicit(p, ##Exit, ##Enter, 10, p, ##Go, 1);
		if (failed_action) rfalse;
  		jump Start;
	}
	failed_action = 1; return L__M(##Exit, 4, noun);
  }

  if (actor.insideofparent == true && p has openable && p has closed) {
	CheckBeforeImplicit(p, ##Open, ##Miscellany, 65, p, ##Go, 1);
	if (failed_action) rfalse;
  }

  if (MiddleRoutines()) rtrue;

  if (actor.insideofparent) { actor.insideofparent = false; r = 1; }
  if (actor.ontopofparent)  { actor.ontopofparent = false; r = 2; }
  if (actor.behindparent)   { actor.behindparent = false; r = 3; }
  if (actor.beneathparent)  { actor.beneathparent = false; r = 4; }


  q = parent(p);
  if (~~(q ofclass Room)) {
	if (p.insideofparent) actor.insideofparent = true;
	if (p.ontopofparent) actor.ontopofparent = true;
	if (p.behindparent) actor.behindparent = true;
	if (p.beneathparent) actor.beneathparent = true;
  }

  Move(actor, parent(p));
  if (parent(actor) ofclass Room) actor.posture = 1; else actor.posture = p.preferred_posture;

  if (AfterRoutines()) rtrue;
  if (keep_silent == 0) {
	L__M(##Exit, 3, p, r);
	if (action_mode == false && actor == player) LookSub(1);
  }
];

[ VagueGoSub; L__M(##VagueGo); ];

[ GoSub i j k l movewith thedir;
    ! First, check if any PushDir object is touchable.
    if (second ~= 0 && second notin Compass && ObjectIsUntouchable(second, actor, false, true, true)) return;

    l = actor.location;
    i = parent(actor);
    if (LightToSeeBy(actor) ~= false && i ~= l) {
        k = RunRoutines(i, before);
        if (k) {
           movewith = i; i = parent(i);
        }
        else {
		CheckBeforeImplicit(i, ##Exit, ##Enter, 10, i, ##Go, 1);
		if (failed_action) rfalse;
		i = actor.location;
        }
    }

    if (noun == left_obj or right_obj) { failed_action = 1; return L__M(##Go, 11); }
    if (noun == back_obj) switch (actor.last_direction) {
	u_obj: noun = d_obj;
	d_obj: noun = u_obj;
	n_obj: noun = s_obj;
	s_obj: noun = n_obj;
	e_obj: noun = w_obj;
	w_obj: noun = e_obj;
	ne_obj: noun = sw_obj;
	se_obj: noun = nw_obj;
	nw_obj: noun = se_obj;
	sw_obj: noun = ne_obj;
	0: return L__M(##Go, 12);
    }

    thedir = noun.door_dir;
    if (ZRegion(thedir) == 2) thedir = RunRoutines(noun, door_dir);

    j = i.thedir; k = ZRegion(j);
    if (k == 3) { print (string) j; new_line; rfalse; }
    if (k == 2) {
        j = RunRoutines(i, thedir);
        if (j == 1) rtrue;
    }

    if (k == 0 || j == 0) {
        if (i provides cant_go) {
		if (i.cant_go() ~= 0) { failed_action = 1; rfalse; }
	}
	failed_action = 1; return L__M(##Go, 2);
    }

    if (j ofclass Door) {
        if (j has concealed) { failed_action = 1; return L__M(##Go, 2); }
        if (j has openable && j has closed) {
		CheckBeforeImplicit(j, ##Open, ##Miscellany, 65, j, ##Lock, 6);
		if (failed_action) rfalse;
	  }
        	
        k = RunRoutines(j, door_to);
        if (k == 0) { failed_action = 1; return L__M(##Go, 6, j); }
        if (k == 1) rtrue;
        j = k;
    }
    actor.old_loc = actor.location; 
    if (movewith == 0) Move(actor, j); else Move(movewith, j);

#Ifndef NO_DARKNESS;
    if (player == actor && LightToSeeBy(player) == false) {
 #Ifdef GRADUAL_LIGHT;
        if (InformLibrary hasnt light or semilight or demilight) {
		#IFDEF USE_LIBRARY_EXTENSIONS;
		if(DarkToDark() == false)
			LibraryExtensions.RunAll(ext_darktodark);
		#IFNOT;
		DarkToDark();
		#ENDIF;
		if (gameover ~= 0) rtrue;
	}
 #Ifnot;
        if (InformLibrary hasnt light) {
		#IFDEF USE_LIBRARY_EXTENSIONS;
		if(DarkToDark() == false)
			LibraryExtensions.RunAll(ext_darktodark);
		#IFNOT;
		DarkToDark();
		#ENDIF;
		if (gameover ~= 0) rtrue;
	}
 #Endif;
    }
#Endif;

    action = ##GoneFrom;
    if (AfterRoutines(actor.old_loc)) { action = ##Go; rtrue; }
    action = ##Go;
    if (AfterRoutines()) rtrue;

    if (actor ~= player && ~~keep_silent) {
	if (actor.location ~= player.location) L__M(##Go, 7, noun);
	else L__M(##Go, 8, noun);
      return;
    }
    LookSub(1);
    if (actor == player) arrived = true;
    actor.last_direction = noun;
];

! ----------------------------------------------------------------------------
!   Describing the world.
!   Locale(object) runs through the "tail end" of a Look-style room
!   description for the contents of the object, printing up suitable
!   descriptions as it goes.
! ----------------------------------------------------------------------------

[ NotSupportingThePlayer o i;
    i = parent(player);
    while (i ~= player.visibility_ceiling) {
        if (i == o) rfalse;
        i = parent(i);
        if (i ~= 0 && player.ontopofparent == false) rtrue;
    }
    rtrue;
];

! i = 1 includes children behind
! i = 2 includes children beneath
! i = 3 includes children inside
! i = 4 includes children on top
! i = 5 includes children attached
! i = 6 includes all children

! j = 0 returns absolute # of children
! j = 1 returns combined volume of children
! j = 2 returns combined weight of children (including indirect weights)
! j = 3 returns only visible children
! j = 4 returns only invisible children
! j = 5 returns only visible children which have neither -scenery- nor -concealed- nor -animate-
!  (this makes Locale() correctly choose "is" or "are")
! j = 7 returns only children with -topic-
[ CountChildren obj i j k m;
  if (child(obj) == 0) rfalse;
  m = 0;
  if (i ~= 6 && ~~obj ofclass Container) rfalse;
  switch(i)
	{ 1: objectloop (k in obj && k.behindparent)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k) && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     7: if (k has topic && k ~= actor) m++;
			     }
	  2: objectloop (k in obj && k.beneathparent)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k) && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     7: if (k has topic && k ~= actor) m++;
			     }
	  3: objectloop (k in obj && k.insideofparent)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k) && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     7: if (k has topic && k ~= actor) m++;
			     }
	  4: objectloop (k in obj && k.ontopofparent)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k)  && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     7: if (k has topic && k ~= actor) m++;
			    }
	  5: objectloop (k in obj && k.attachedtoparent)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k) && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     6: if (k.ontopofparent == 0 && k.insideofparent == 0 &&
				    k.behindparent == 0 && k.beneathparent && k.ontopofparent == 0 &&
				    k hasnt workflag) m++;
			     7: if (k has topic && k ~= actor) m++;
			     }
	  6: objectloop (k in obj)
		switch (j) { 0: m++;
			     1: m = m + k.volume;
			     2: if (k ofclass Container) m = m + k.indirect_weight;
				     m = m + k.weight;
			     3: if (IsVisible(k) && k ~= actor) m++;
			     4: if (~~IsVisible(k)) m++;
			     5: if (IsVisible(k) && k hasnt scenery or concealed or animate) m++;
			     7: if (k has topic && k ~= actor) m++;
			     }

	  default: return RunTimeError(28, obj);
	}
   return m;
];

! flag = 1 for SearchSub
! flag = 2 for Locale
! flag = 3 for ExamineSub
[ DescribeChildren j flag a b c d e f;
  a = 0; b = 0; c = 0; d = 0; e = 0; f = 0;
  if (~~(j ofclass Container)) rfalse;
  switch (flag) {
	1, 3:
  if (j.ontop_capacity() > 0 && ~~(IndirectlyContains(noun, actor) == 4 && noun hasnt transparent) )
	{ DescribeOnTop(j); print " "; a++; }

  if (j.inside_capacity() > 0)
	{ DescribeInside(j); print " "; a++; }

  if (j.beneath_capacity() > 0 && ~~((IndirectlyContains(noun, actor) == 2 && noun hasnt transparent) || (noun.&hidden_contents-->1 == false && IndirectlyContains(noun, actor) == 0)) )
	{ DescribeBeneath(j); print " "; a++; }

  if (j.behind_capacity() > 0 && ~~(noun.&hidden_contents-->2 == false && IndirectlyContains(noun, actor) == 0) )
	{ DescribeBehind(j); print " "; a++; }

  if (CountChildren(j, 5, 3) > 0)
	{ DescribeAttached(j, 1); a++; }

  objectloop (f in j && f has animate && f ~= player) { print " "; L__M(##Look, 11, f); a++; }

  if (flag == 1) { if (a == 0) L__M(##Miscellany, 71); else new_line; }
  return a;

	2:
  if (CountChildren(j, 1, 5)) { a++; f++; }
  if (CountChildren(j, 2, 5)) { b++; f++; }
  if (CountChildren(j, 3, 5)) { c++; f++; }
  if (CountChildren(j, 4, 5)) { d++; f++; }

  if (f) { f = 0;

  if (d) { new_line; L__M(##LookOnTop, 3, j); if (DescribeOnTop(j, 2) == 3) f++; 
	 }

  if (c) { if (f) L__M(##ListMiscellany, 33, j);
	   else { new_line; L__M(##LookInside, 3, j); }
	   DescribeInside(j, 2); f++;
	 }

  if (b) { if (f) L__M(##ListMiscellany, 34, j);
	   else { new_line; L__M(##LookUnder, 6, j); }
	   DescribeBeneath(j, 2); f++;
	 }

  if (a) { if (f) L__M(##ListMiscellany, 35, j);
	   else { new_line; L__M(##LookBehind, 5, j); }
	   DescribeBehind(j, 2); f++;
	 }

  if (f) ".";
  }

  }
];

[ DescribeAttached parentobj flag j k;

  objectloop(j in parentobj)
	{ if (j && j.attachedtoparent &&
	     (~~(j has concealed or scenery))
	     && ~~(flag == 1 && j has anatomy) )
		{ give j workflag; k++; }
	  else give j ~workflag;
	}

  if (flag == 2) { give player ~workflag;
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
    return;
  }

  if (k == 0) return L__M(##LookAttached, 1, parentobj);

  L__M(##LookAttached, 2, parentobj);
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
  print ".";
];

[ DescribeBehind parentobj flag obj1 n;

  n = 0;

  objectloop (obj1 in parentobj)
	{ if (obj1 && obj1.behindparent && ~~(obj1 has concealed or scenery or animate))
		{ give obj1 workflag; n++; }
	  else give obj1 ~workflag;
	}

  if (flag == 2) { give player ~workflag;
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
    return;
  }

  if (n == 0) return L__M(##LookBehind, 3, parentobj);

  L__M(##LookBehind, 5, parentobj);
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
  print ".";
];

[ DescribeBeneath parentobj flag obj1 n;

  objectloop(obj1 in parentobj)
	{ if(obj1 && obj1.beneathparent && ~~(obj1 has concealed or scenery or animate))
		{ give obj1 workflag; n++; }
	  else give obj1 ~workflag;
	}

  if (flag == 2) { give player ~workflag;
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
    return;
  }

  if (n == 0) return L__M(##LookUnder, 4, parentobj);

  L__M(##LookUnder, 6, parentobj);
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + RECURSE_BIT + WORKFLAG_BIT);
   print ".";
];

[ DescribeInside parentobj flag obj1 n;

  n = CommonAncestor(actor, parentobj);

  if (IndirectlyContains(n, actor) == 4 && IndirectlyContains(n, parentobj) == 2 && parentobj hasnt transparent)
	return L__M(##LookInside, 4, parentobj);

#Ifndef GRADUAL_LIGHT;
  if (parentobj hasnt transparent && parentobj has closed)
	if (~~(actor in parentobj && actor.insideofparent))
		return L__M(##Search, 5, parentobj);
#Ifnot;
  if (parentobj hasnt transparent or semitransparent && parentobj has closed)
	if (~~(actor in parentobj && actor.insideofparent))
		return L__M(##Search, 5, parentobj);
#Endif;

  n = 0;

  objectloop(obj1 in parentobj)
	{ if(obj1.insideofparent && ~~(obj1 has concealed or scenery or animate))
		{ give obj1 workflag; n++; }
	  else give obj1 ~workflag;
	}

  if (flag == 2) { give player ~workflag;
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
    return;
  }

  if (n == 0) return L__M(##LookInside, 1, parentobj);

  L__M(##LookInside, 3, parentobj);
  WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
   print ".";
];

[ DescribeOnTop parentobj flag obj1 n;

  n = 0;

  objectloop(obj1 in parentobj)
    { if (obj1 && obj1.ontopofparent && ~~(obj1 has concealed or scenery or animate))
		{ give obj1 workflag; n++; }
	else give obj1 ~workflag;
    }

  if (flag == 2) { give player ~workflag;
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
    return 3;
  }

  if (n == 0) return L__M(##LookOnTop, 1, parentobj);

 L__M(##LookOnTop, 3, parentobj);
    WriteListFrom( child(parentobj),
       ENGLISH_BIT + TERSE_BIT + PARTINV_BIT + RECURSE_BIT + WORKFLAG_BIT);
 print ".";
];

[ DescribeClothes subject flag n m;
  m = 0;

#Ifdef COMPLEXCLOTHING;
  objectloop(n in subject) {
	if (n ofclass Wearable && n.worn_by == subject && IsVisible(n, player))
		{ give n workflag; m++; }
	else give n ~workflag;
    }
#Ifnot;
  objectloop(n in subject)
    {	if (n has worn && IsVisible(n, player))
		{ give n workflag; m++; }
	else give n ~workflag;
    }
#Endif;

  if (m == 0) rfalse;
  L__M(##Wear, 15, subject, flag);
     WriteListFrom(child(subject),
     ENGLISH_BIT + RECURSE_BIT + WORKFLAG_BIT);
     ".";
];

#Ifdef COMPLEXCLOTHING;
[ CheckArea subject test_type skirt_test flag i;
  flag = 0;
  if (skirt_test == 1)
  objectloop (i ofclass Wearable && i.worn_by == subject && i.skirtlike == test_type)
	{ if (flag == 0) flag = i;
	  else if (flag.layer < i.layer) flag = i;
	}
  else
  objectloop (i ofclass Wearable && i.worn_by == subject && i.clothing_type == test_type)
     { if (flag == 0) flag = i;
	 else if (flag.layer < i.layer) flag = i;
     }
  return flag;
];

[ CheckAreaLow subject test_type skirt_test flag i j;
  flag = 0;
  if (skirt_test == 1)
  objectloop (i ofclass Wearable && i.worn_by == subject && i.skirtlike == test_type)
	{ if (flag == 0) flag = i;
	  else { j = i.covered_by; if (i.layer < flag.layer && j == 0 || j.skirtlike) flag = i; }
	}
  else
  objectloop (i ofclass Wearable && i.worn_by == subject && i.clothing_type == test_type)
     { if (flag == 0) flag = i;
	 else if (i.layer >= flag.layer) flag = i;
     }
  return flag;
];

[ IncreaseLayers subject min type amount i;
  objectloop (i ofclass Wearable && i.worn_by == subject && (i.layer >= min || i.skirt_layer >= min))
    { if (i == 0) rtrue;
	if (i.skirtlike == type && i.skirtlike ~= i.clothing_type) i.skirt_layer = i.skirt_layer + amount;
	else if (i.clothing_type == type) i.layer = i.layer + amount;
    }
];
#Endif;

[ Locale descin o;
    if (LightToSeeBy(player) == 0) rfalse;
    objectloop (o in descin) give o ~workflag;

    objectloop (o in descin)
        if (o hasnt concealed && NotSupportingThePlayer(o)) {
            #Ifndef MANUAL_PRONOUNS;
            PronounNotice(o);
            #Endif;

	    if (o hasnt topic) give o topic;
	    if (o hasnt scenery or animate) give o workflag;

            if (o has workflag && o.&describe ~= 0 && o hasnt animate) {
                    if (RunRoutines(o, describe)) give o ~workflag;
        }
    }

    L__M(##Look, 6, descin);
];

! ----------------------------------------------------------------------------
!   Looking.  LookSub(1) is allowed to abbreviate long descriptions, but
!     LookSub(0) (which is what happens when the Look action is generated)
!     isn't.  (Except that these are over-ridden by the player-set lookmode.)
! ----------------------------------------------------------------------------

[ LookModeSub;
  switch (LanguageVerbIsLookmode(1))
	{ 1 :
		if (lookmode == 1)
		{ L__M(##Miscellany, 66); if (normalmode == 1) print " ", (string) NORMAL__TX; L__M(##LookMode, 1); }

		else { lookmode = 1;
			 L__M(##Miscellany, 67); if (normalmode == 3) print " ", (string) NORMAL__TX; L__M(##LookMode, 1); }

	  3:
		if (lookmode == 2)
		{ L__M(##Miscellany, 66); if (normalmode == 2) print " ", (string) NORMAL__TX; L__M(##LookMode, 2); }

		else { lookmode = 2;
		L__M(##Miscellany, 67); if (normalmode == 2) print " ", (string) NORMAL__TX; L__M(##LookMode, 2); }

	  2:
		if (lookmode == 3)
		{ L__M(##Miscellany, 66); if (normalmode == 3) print " ", (string) NORMAL__TX; L__M(##LookMode, 3); }

		else { lookmode = 3;
		L__M(##Miscellany, 67); if (normalmode == 3) print " ", (string) NORMAL__TX; L__M(##LookMode, 3); }

	  4:
		switch (normalmode)
		{ 1:
		     if (lookmode == 1)
		     { print (string) Story, (string) ALREADY__TX, (string) NORMAL__TX; L__M(##LookMode, 1); }

		     else { lookmode = 1;
		     print (string) Story, (string) ISNOW__TX, (string) NORMAL__TX; L__M(##LookMode, 1); }

		  2:
		     if (lookmode == 2)
		     { print (string) Story, (string) ALREADY__TX, (string) NORMAL__TX; L__M(##LookMode, 2); }

		     else { lookmode = 2;
		     print (string) Story, (string) ISNOW__TX, (string) NORMAL__TX; L__M(##LookMode, 2); }

		  3:
		     if (lookmode == 3)
		     { print (string) Story, (string) ALREADY__TX, (string) NORMAL__TX; L__M(##LookMode, 3); }

		     else { lookmode = 3;
		     print (string) Story, (string) ISNOW__TX, (string) NORMAL__TX; L__M(##LookMode, 3); "]"; }
		}
	}
];

[ NoteArrival descin j;
  if (player.location ~= lastdesc) {
	j = player.location;
      if (j.initial ~= 0) PrintOrRun(j, initial);
      descin = j;
#IFDEF USE_LIBRARY_EXTENSIONS;
      if(NewRoom() == false) LibraryExtensions.RunAll(ext_newroom);
#IFNOT;
      NewRoom();
#ENDIF;
      lastdesc = descin;
  }
];

#Ifndef NO_SCORE;
[ ScoreArrival j;
  if (j.visited == false) {
      j.visited = true; give j topic;
      if (LightToSeeBy(player) ~= 0 && j.points ~= 0) {
          score = score + j.points();
          places_score = places_score + j.points();
      }
  }
];
#Endif;

[ LookSub allow_abbrev i j k nl_flag m n;
  n = 0;
    if (parent(player) == 0) return RunTimeError(10);

  .MovedByInitial;

    if (player.visibility_ceiling == player.location) {
            NoteArrival();
    }

    ! Printing the top line: e.g.
    ! Octagonal Room (on the table) (as Frodo)
    new_line;
    #Ifdef TARGET_ZCODE;
    style bold;
    #Ifnot; ! TARGET_GLULX;
    glk($0086, 4); ! set subheader style
    #Endif; ! TARGET_
    if (LightToSeeBy(player) == false) print (string) DARKNESS__TX;
    else {
        if (player.visibility_ceiling ~= player.location) 
		{ L__M(##Miscellany, 70); print (the) player.visibility_ceiling; }
        else print (name) player.visibility_ceiling;
    }
    #Ifdef TARGET_ZCODE;
    style roman;
    #Ifnot; ! TARGET_GLULX;
    glk($0086, 0); ! set normal style
    #Endif; ! TARGET_
    i = parent(player);
    if (i ~= player.visibility_ceiling) {
	  if (i provides entered_desc) PrintorRun(i, entered_desc, true);
	  else {
		if (player.insideofparent)		L__M(##Look, 2, i);
		if (player.ontopofparent)		L__M(##Look, 1, i);
		if (player.behindparent)			L__M(##Look, 8, i);
		if (player.beneathparent)		L__M(##Look, 9, i);
	}
    }
    if (i == player.visibility_ceiling && player.posture ~= 1) {
	print " (";
	switch (player.posture) {
		2: L__M(##ListMiscellany, 28);
		3: L__M(##ListMiscellany, 30);
	}
	print ")";
    }
    if (print_player_flag == 1) L__M(##Look, 3, player);
    new_line;

    ! Description of the visibility ceiling.

    m = player.visibility_ceiling;
    if (lookmode < 3) {
        if ((allow_abbrev ~= 1) || (lookmode == 2) || (m ofclass Room && m.visited == false)) {
            if (m.&describe ~= 0) RunRoutines(m, describe);
            else {
		    if (LightToSeeBy(player) == false) {
			if (m provides when_dark) PrintOrRun(m, when_dark);
			#Ifdef GRADUAL_LIGHT;
			DescribeQuasilight(m);
			#Endif;
			}
                else if (m provides description) PrintOrRun(m, description);
            }
        }
    }

    if (player.visibility_ceiling == m) nl_flag = 1;

    if (player.visibility_levels == 0) Locale(player);
    else {
        for (i=player,j=player.visibility_levels : j>0: j--,i=parent(i)) give i workflag;

        for (j=player.visibility_levels : j>0 : j--) {
            for (i=player,k=0 : k<j : k++) i=parent(i);
            if (i.inside_description ~= 0) {
                if (nl_flag) new_line; else nl_flag = 1;
                PrintOrRun(i, inside_description); }
            if (Locale(i) ~= 0) nl_flag = 1;
        }
    }

    DescribeActors(player.location);

    #IFDEF USE_LIBRARY_EXTENSIONS;
    if(LookRoutine() == false) LibraryExtensions.RunAll(ext_lookroutine);
    #IFNOT;
    LookRoutine();
    #ENDIF;
    #Ifndef NO_SCORE;
    ScoreArrival(player.location);
    #Endif;

    i = action;
    action = ##Look;
    if (AfterRoutines()) { action = i; rtrue; }
    action = i;
];

[ DescribeActors loc p k;

  objectloop (p has animate && p.location == loc && p ~= player)
	{ if (IsVisible(p) && p hasnt scenery)
		{ if (RunRoutines(p, describe) == 0)
			{ if (k == 0) new_line;
		  	  L__M(##Look, 11, p);
		  	  k++; print " ";
			}
		}
	}

  if (k) new_line;
];

[ LookOnTopSub;

  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Examine, 1); }

  if (noun ofclass Container) {
  		if (IndirectlyContains(noun, actor) == 4 && noun hasnt transparent)
			{ failed_action = 1; L__M(##Go, 1, noun); }
		else { DescribeOntop(noun); new_line; }
	}

  else L__M(##PutOn, 3, noun);
];

[ LookInsideSub;

  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Examine, 1); }
  if (noun hasnt transparent && noun has closed) {
	CheckBeforeImplicit(noun, ##Open, ##Miscellany, 65, noun, ##Lock, 6);
	if (failed_action) rfalse;
  }

  if (noun ofclass Container) { DescribeInside(noun); new_line; }

  else L__M(##Insert, 2, noun);
];

[ LookBehindSub;

  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Examine, 1); }

  if (noun ofclass Container) {
		if (noun.&hidden_contents-->2 == false && IndirectlyContains(noun, actor) == 0)
			{ failed_action = 1; return L__M(##LookBehind, 1, noun); }
		else { DescribeBehind(noun); new_line; }
	}

  else L__M(##LookBehind, 2, noun);
];

[ LookUnderSub;

  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Examine, 1); }

  if (noun ofclass Container) {
	if (IndirectlyContains(noun, actor) == 2 && noun hasnt transparent)
		{ failed_action = 1; return L__M(##Miscellany, 72, noun); }
	if (noun.&hidden_contents-->1 == false && IndirectlyContains(noun, actor) == 0)
		{ failed_action = 1; return L__M(##LookUnder, 5, noun); }
	else { DescribeBeneath(noun); new_line; }
	}

  else L__M(##Miscellany, 71);
];

[ ExamineSub;

#Ifndef NO_DARKNESS;
#Ifdef GRADUAL_LIGHT;
  if (LightToSeeBy(actor) == false && noun hasnt quasilight) { failed_action = 1; return L__M(##Examine, 1); }
#Ifnot;
  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Examine, 1); }
#Endif;
#Endif;

#Ifdef COMPLEXCLOTHING;
#Ifdef GRADUAL_LIGHT;
  if (noun ofclass Wearable && noun.covered_by && noun.covered_by hasnt transparent or semitransparent)
	{ failed_action = 1; return L__M(##Disrobe, 4, noun.covered_by); }
#Ifnot;
  if (noun ofclass Wearable && noun.covered_by && noun.covered_by hasnt transparent)
	{ failed_action = 1; return L__M(##Disrobe, 4, noun.covered_by); }
#Endif; #Endif;

  if (MiddleRoutines()) rtrue;

  if (keep_silent ~= 2 && IsVisible(actor, player))
	{	if (PrintOrRun(noun, description, true) == false) { L__M(##Examine, 2, noun);
		print " ";
	 	if (noun has switchable) { L__M(##Examine, 3, noun); print " "; }
		if (noun ofclass Container) { if (DescribeChildren(noun, 3) > 0) print " "; }
		new_line;
		}
		else if (metaclass(noun.description) == String) new_line;
	}
  if (AfterRoutines()) rtrue;
];

[ SearchSub;

  if (LightToSeeBy(actor) == false) { failed_action = 1; return L__M(##Search, 1, noun); }
  if (noun hasnt transparent && ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun ~= actor && noun has animate) { failed_action = 1; return L__M(##Miscellany, 59, noun); }

  if (MiddleRoutines()) rtrue;

  if (keep_silent == 0 && ~~noun ofclass Container) return L__M(##Miscellany, 71);
  
  if (actor == player || action_mode == 2) DescribeChildren(noun, 1);

  if (noun hasnt transparent && noun has closed) {
	CheckBeforeImplicit(noun, ##Open, ##Miscellany, 65, noun, ##Lock, 6);
	if (failed_action && actor == player) new_line;
  }
  if (actor ~= player) return L__M(##Search, 2, noun);

  if (AfterRoutines()) rtrue;
];

[ ReadSub;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Miscellany, 71);
];

! ----------------------------------------------------------------------------
!   Verbs which change the states of objects without moving them
! ----------------------------------------------------------------------------

[ ChooseKey obj1 obj2 result priority i;

  if (metaclass(obj1.with_key) == Object && IsVisible(obj1.with_key)) result = obj1.with_key;

  else objectloop (obj2 ofclass Thing && IsVisible(obj2, actor)) {
		i = ValueorRun(obj1, with_key, obj2);
		switch (i) {
			-1, 0, 5: ;

			1, 2: if (~~priority) result = obj2;

			3, 4: result = obj2; priority = 1;

			6: result = obj2; priority = 6;
		}
		if (priority == 6) break;
	}

  return result;
];

[ UnlockSub i j;

  if (~~noun ofclass Lockable) {
	failed_action = 1;
	if (noun has animate) return L__M(##Miscellany, 68);
	return L__M(##Lock, 1, noun);
  }

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;

  if (noun.locked == false) { failed_action = 1; return L__M(##Unlock, 2, noun); }

  switch (noun.lockstate()) {
	0: failed_action = 1; return L__M(##Lock, 1, noun);
	1, 11: if (noun hasnt closed) {
		CheckBeforeImplicit(noun, ##Close, ##Miscellany, 74, noun, ##Lock, 3);
		if (failed_action) rfalse;
		}
	2, 12: if (noun has closed) {
		CheckBeforeImplicit(noun, ##Open, ##Miscellany, 65, noun, ##Lock, 6);
		if (failed_action) rfalse;
		}
  }

  if (second == 0) second = ChooseKey(noun); else i = second;

  if (second && second notin actor) {
	CheckBeforeImplicit(second, ##Take, ##Miscellany, 26, second, ##Drop, 2);
	if (failed_action) rfalse;
  }


  if (MiddleRoutines()) rtrue;

  if (metaclass(noun.with_key) == Routine) {
	j = ValueorRun(noun, with_key, second);

	switch (j) {

		0:	failed_action = 1; if (AfterRoutines()) rtrue;
			if (second == 0) {
				if (action_mode == 1) return L__M(##Unlock, 3, second);
				else return L__M(##Unlock, 7);
			}

		1:	if (~~i) L__M(##UnLock, 6, second);
		   	failed_action = 1;
			if (AfterRoutines()) rtrue;
			if (action_mode == 1) return L__M(##Unlock, 3, second);
			else return L__M(##Unlock, 7);

		2: 	if (~~i) L__M(##UnLock, 6, second);

		3: 	if (~~i) L__M(##UnLock, 6, second);
			if (AfterRoutines()) rtrue;
			failed_action = 1;
			if (action_mode == 1) return L__M(##Unlock, 3, second);
			else return L__M(##Unlock, 7);

		4:	if (~~i) L__M(##UnLock, 6, second);

		5:	;

		6:	if (i == 0) L__M(##UnLock, 5, second);
	}
  }

  else {
	if (second ~= i) L__M(##Unlock, 5, second);
	if (noun.with_key ~= second) {
		failed_action = 1;
		if (actor ~= player) return L__M(##Unlock, 7, second);
		return L__M(##Miscellany, 69);
	}
  }

  noun.locked = false;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Unlock, 4, noun, second);
];

[ LockSub i j;

  if (~~noun ofclass Lockable) {
	failed_action = 1;
	if (noun has animate) return L__M(##Miscellany, 68);
	return L__M(##Lock, 1, noun);
  }

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;

  if (second && second notin actor) {
		CheckBeforeImplicit(second, ##Take, ##Miscellany, 26, second, ##Drop, 2);
		if (failed_action) rfalse;
  }

  if (noun.locked == true)     { failed_action = 1; return L__M(##Lock, 2 ,noun); }

  i = second;
  if (second == 0) second = ChooseKey(noun);

  if (second && second notin actor) {
		CheckBeforeImplicit(second, ##Take, ##Miscellany, 26, second, ##Drop, 2);
		if (failed_action) rfalse;
  }

  switch (noun.lockstate()) {
	0: failed_action = 1; return L__M(##Lock, 1, noun);
	1, 11: if (noun hasnt closed) {
		CheckBeforeImplicit(noun, ##Close, ##Miscellany, 74, noun, ##Lock, 3);
		if (failed_action) rfalse;
		}
	2, 12: if (noun has closed) {
		CheckBeforeImplicit(noun, ##Open, ##Miscellany, 65, noun, ##Lock, 6);
		if (failed_action) rfalse;
		}
  }

  if (MiddleRoutines()) rtrue;

  if (metaclass(noun.with_key) == Routine) {
	j = ValueorRun(noun, with_key, second);

	switch (j) {

	0: failed_action = 1; if (AfterRoutines()) rtrue;
	   if (second == 0) return L__M(##Miscellany, 69);
	   else return L__M(##Unlock, 3, second);

	1: if (~~i) L__M(##UnLock, 6, second);
	   failed_action = 1;
	   if (AfterRoutines()) rtrue;
	   return L__M(##Unlock, 3, second);

	2: if (~~i) L__M(##UnLock, 6, second);

	3: if (~~i) L__M(##UnLock, 6, second);
	   if (AfterRoutines()) rtrue;
	   failed_action = 1;
	   return L__M(##Unlock, 3, second);

	4: if (~~i) L__M(##UnLock, 6, second);

	5: ;

	6: if (i == 0) L__M(##UnLock, 5, second);
	}
  }

  else {  if (second ~= i) L__M(##Unlock, 5, second);
	  if (noun.with_key ~= second) { failed_action = 1; return L__M(##Miscellany, 69); }
  }

  noun.locked = true;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Lock, 5, noun);
];

[ SwitchSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun hasnt switchable) { failed_action = 1; return L__M(##SwitchOff, 1, noun); }

  if (noun has on) <<SwitchOff noun>>;
  <<SwitchOn noun>>;
];

[ SwitchOnSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun hasnt switchable) { failed_action = 1; return L__M(##SwitchOn, 1, noun); }

  if (noun provides switch_for)
	{ if (noun.switch_for has on) { failed_action = 1; return L__M(##SwitchOn, 2, noun); }
	  else give noun.switch_for on;
	}
  if (noun provides switched_by)
	{ if (IsVisible(noun.switched_by) == false)
		{ failed_action = 1; return L__M(##SwitchOn, 4, noun.switched_by); }
	  if (ObjectIsUntouchable(noun.switched_by, actor, false, true, true))
		return L__M(##Miscellany, 63, noun.switched_by);
	  <<SwitchOn noun.switched_by>>;
	}


  if (MiddleRoutines()) rtrue;

  if (noun has on)  return L__M(##SwitchOn, 2, noun);

  give noun on;
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##SwitchOn, 3, noun);
];

[ SwitchOffSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun hasnt switchable) { failed_action = 1; return L__M(##SwitchOff, 1, noun); }

  if (noun provides switch_for)
	{ if (noun.switch_for hasnt on) { failed_action = 1; return L__M(##SwitchOff, 2, noun); }
	  else give noun.switch_for ~on;
	}
  if (noun provides switched_by)
	{ if (IsVisible(noun.switched_by) == false)
		{ failed_action = 1; return L__M(##SwitchOn, 4, noun.switched_by); }
	  if (ObjectIsUntouchable(noun.switched_by, actor, false, true, true))
		return L__M(##Miscellany, 63, noun.switched_by);
	  <<SwitchOff noun.switched_by>>;
	}


  if (MiddleRoutines()) rtrue;

  if (noun hasnt on) return L__M(##SwitchOff, 2, noun);

  give noun ~on;
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##SwitchOff, 3, noun);
];

[ OpenSub i;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rfalse;
  if (noun hasnt openable) { failed_action = 1; return L__M(##Open, 1, noun); }
  if (noun hasnt closed) { failed_action = 1; return L__M(##Open, 3, noun); }
  if (noun ofclass Lockable) {
	if (noun.locked == true && noun.lockstate() < 11) {
		CheckBeforeImplicit(noun, ##Unlock, ##Unlock, 1, noun, ##Open, 2);
		if (failed_action) rfalse;
	}
	if (noun.locked) { failed_action = 1; L__M(##Open, 2, noun); rfalse; }
  }

  if (MiddleRoutines()) rtrue;

  give noun ~closed; objectloop(i && IndirectlyContains(noun, i)) FindVisibilityLevels(i);

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
  	if (noun ofclass Container && noun hasnt transparent && LightToSeeBy(actor)
      	&& IndirectlyContains(noun, actor) == 0) {
      		L__M(##Open, 4, noun);
  	}
  	else L__M(##Open, 5, noun);
  }
];

[ CloseSub i;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun hasnt openable) { failed_action = 1; return L__M(##Close, 1, noun); }
  if (noun has closed)     { failed_action = 1; return L__M(##Close, 2, noun); }
  if (noun ofclass Lockable) {
	if (noun.locked == true)
		CheckBeforeImplicit(noun, ##Unlock, ##Unlock, 1, noun, ##Open, 2);
		if (failed_action) rfalse;
	}

  if (MiddleRoutines()) rtrue;

  give noun closed; objectloop(i && IndirectlyContains(noun, i)) FindVisibilityLevels(i);

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Close, 3, noun);
];

#Ifdef COMPLEXCLOTHING;
[ DisrobeSub i k;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (~~(noun ofclass Wearable)) { failed_action = 1; return L__M(##Disrobe, 6, noun); }
  if (noun.worn_by ~= actor) { failed_action = 1; return L__M(##Disrobe, 1, noun); }
  if (noun provides locked) {
  	if (noun.manipulable_when_locked == 0)
		{  if (noun.locked)
			{ failed_action = 1; return L__M(##Disrobe, 3, noun); }
		}
	}

    i = noun.covered_by;

    if (i && i.skirtlike ~= noun.clothing_type) { failed_action = 1; return L__M(##Disrobe, 4, noun.covered_by); }

    if (children(actor) >= actor.capacity) { failed_action = 1; return L__M(##Disrobe, 5); }


    if (MiddleRoutines()) rtrue;

    if (i && i.skirtlike == noun.clothing_type)
	{ IncreaseLayers(actor, i.layer, noun.clothing_type, -1);
	  i.covering = noun.covering;
	}

    if (noun.clothing_type == 10)
	{ objectloop (k ofclass Wearable && k.covered_by == noun)
		k.covered_by = 0;
	}

  k = noun.covering;
  noun.worn_by = 0; noun.covering = 0; noun.layer = 0; noun.covered_by = 0;
  noun.visibility_ceiling = actor.visibility_ceiling;
  if (k) k.covered_by = i;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Disrobe, 2, noun);
];
#Ifnot;
[ DisrobeSub;

  if (noun has animate) { failed_action = 1; return L__M(##Miscellany, 68); }
  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;

  if (noun hasnt clothing) { failed_action = 1; return L__M(##Disrobe, 6, noun); }
  if (noun notin actor || noun hasnt worn) { failed_action = 1; return L__M(##Disrobe, 1, noun); }

  if (MiddleRoutines()) rtrue;

  give noun ~worn;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Disrobe, 2, noun);
];
#Endif;

#Ifdef COMPLEXCLOTHING;
[ WearSub i j k m n skirtflag;

  if (noun has animate) { failed_action = 1; return L__M(##Miscellany, 68); }

  if (noun notin actor) {
		CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
		if (failed_action) rfalse;
  }

  if (~~(noun ofclass Wearable))	{ failed_action = 1; return L__M(##Wear, 1, noun); }
  if (parent(noun) ~= actor)		{ failed_action = 1; return L__M(##Drop, 2, noun); }
  if (noun.worn_by == actor)		{ failed_action = 1; return L__M(##Wear, 3, noun); }
  if (noun.gendered == female && actor hasnt female)    { failed_action = 1; return L__M(##Wear, 5, noun); }
  if (noun.gendered == male && actor hasnt male)        { failed_action = 1; return L__M(##Wear, 6, noun); }
  else if (noun.gendered == neuter)			{ failed_action = 1; return L__M(##Wear, 7, noun); }
  if (noun ofclass Lockable && noun.manipulable_when_locked == 0) {
	if (noun.locked) {
		failed_action = 1; return L__M(##Disrobe, 3, noun);
	}
  }
  skirtflag = 0; ! This will work for now, but it might not be able to handle more complex situations.
    objectloop (m ofclass Wearable && m.worn_by == actor && m.skirtlike == noun.clothing_type)
			skirtflag = 1;

    i = CheckArea(actor, noun.clothing_type, skirtflag);

    if (i > 0) {

! Return the appropriate message if the maximum layer
! for that clothing type has been reached.
! This still needs to be tweaked for same_layer articles of clothing.
	 if (i.layer >= noun.max_layer)
	     { failed_action = 1; cant_touch_reason-->0 = i; return L__M(##Wear, 9, noun); }

! Minimum layer test. The item to be worn must be able to be
! at at least its min_layer.
! This test should be simpler.
	 if ( i.layer < noun.min_layer-1 || i == 0 && noun.min_layer > 0)
	     { failed_action = 1; cant_touch_reason-->0 = i; return L__M(##Wear, 10); }

! Return the appropriate message if the player is trying to put something on
! under a skirtlike, but the skirtlike is already at its max_layer.
	 if (skirtflag) {
       j=CheckAreaLow(actor, noun.clothing_type, 1);
       if (j.layer==j.max_layer or j.skirt_maxlayer) {
		failed_action = 1; cant_touch_reason-->0 = j; return L__M(##Wear, 11, j);
	}
		}

! Return the appropriate message if it won't fit over
! a bulky piece of clothing being worn.
	 if (i.bulky > 0) { failed_action = 1; cant_touch_reason-->0 = i; return L__M(##Wear, 12, i); }
	}


  if (MiddleRoutines()) rtrue;

! Now sort through deciding which items
! of clothing get what layer, etc.
       if (i > 0) {
		if (skirtflag)
		{ if (j.skirtlike == j.clothing_type)
			{ n = j.covering; if (n) n.covered_by = noun; n.visibility_ceiling = noun;
			  noun.layer =j .layer; noun.covering = j.covering; j.covering = noun; noun.covered_by = j;
			  noun.visibility_ceiling = j;
		  	  IncreaseLayers(actor, j.layer, noun.clothing_type, 1);
			}
		  else
			{ noun.layer = j.skirt_layer; noun.covering = j.skirt_covering; j.skirt_covering = noun;
			  noun.covered_by = j; noun.visibility_ceiling = j;
			  IncreaseLayers(actor, j.skirt_layer, noun.clothing_type, 1);
			}
		}
    		else
		{ if (noun.clothing_type == 10)
		  { objectloop (k ofclass Wearable && k.covered_by == 0)
			k.covered_by = noun;
		  }
		  else if (noun.same_layer == 1 && i.same_layer == 1) noun.layer = i.layer;
		  else { noun.layer = i.layer + 1; noun.covering = i; i.covered_by = noun; i.visibility_ceiling = noun; }
		}
	}
      else if (noun.skirtlike ~= noun.clothing_type or 0)
			{ j = CheckArea(actor, noun.skirtlike);
			  if (j) { noun.skirt_layer = j.layer + 1;
				     noun.skirt_covering = j;
				     j.covered_by = noun;
				   }
			  noun.layer = 1;
			}
		else noun.layer = 1;

  noun.worn_by = actor;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) {
  	if (skirtflag == 1) L__M(##Wear, 13, noun.covered_by);
  	else	{ if (noun.covering) L__M(##Wear, 14, noun.covering);
  		  else L__M(##Wear, 4, noun);
		}
  }
];
#Ifnot;
[ WearSub;

  if (noun has animate) { failed_action = 1; return L__M(##Miscellany, 68); }

  if (noun notin actor) {
		CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
		if (failed_action) rfalse;
  }

  if (noun hasnt clothing) { failed_action = 1; return L__M(##Wear, 1, noun); }
  if (noun in actor && noun has worn) { failed_action = 1; return L__M(##Wear, 3, noun); }


  if (MiddleRoutines()) rtrue;

  give noun worn;

  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Wear, 4, noun);
];
#Endif;

[ EatSub;

  if (noun hasnt edible) { failed_action = 1; return L__M(##Eat, 1, noun); }

  if (noun notin actor) {
		CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, noun, ##Drop, 2);
		if (failed_action) rfalse;
  }

#Ifdef COMPLEXCLOTHING;
   if (noun ofclass Wearable && noun.worn_by == actor) {
		CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
		if (failed_action) rfalse;
   }
#Ifnot;
   if (noun has worn) {
		CheckBeforeImplicit(noun, ##Disrobe, ##Drop, 3, noun, ##Insert, 4);
		if (failed_action) rfalse;
   }
#Endif;

  if (MiddleRoutines()) rtrue;

  Remove(noun);
  if (AfterRoutines()) rtrue;

  if (~~keep_silent) L__M(##Eat, 2, noun);
];

[ UseSub o;

  if (MiddleRoutines()) return;
  objectloop (o ofclass Lockable && IsVisible(o)) {
	if (ChooseKey(o) == noun) {
		second = noun; noun = o;
		if (o.locked == true) <<Unlock o second>>;
		<<Lock o second>>;
	}
  }
  if (AfterRoutines()) return;
  L__M(##Use);
];

[ FaceSub;
  L__M(##Face);
];

! ----------------------------------------------------------------------------
!   Verbs which are really just stubs -- any practical consequence of them
!   will have to take place in a reaction property.
! ----------------------------------------------------------------------------

[ AllowPushDir i;
  if (parent(second) ~= compass) return L__M(##PushDir, 2, noun);
  if (second == u_obj or d_obj)  return L__M(##PushDir, 3, noun);
  AfterRoutines(); i = noun; Move(i, player);
  <Go second>;
  Move(i, player.location);
];

[ AnswerSub;
  if (second == 0 && lastspoken) second = lastspoken;
  if (second) {
	if (second == actor) return L__M(##JumpOver);
	if (second hasnt animate or talkable) return L__M(##Miscellany, 24, second);
	if (RunLife(second, ##Answer) ~= 0) rfalse;
  }

  L__M(##Answer);
];

[ AskSub;
  if (noun == actor) return L__M(##JumpOver);
  if (lastspoken ~= noun) lastspoken = noun;
  if (RunLife(noun, ##Ask) ~= 0) rfalse;
  L__M(##Ask);
];

[ VagueAskSub x y;
  if (lastspoken) y = lastspoken;
   else objectloop (x has animate or talkable && x ~= actor && IsVisible(x)) { y = x; }
  if (~~y) { failed_action = 1; return L__M(##Miscellany, 23); }
  if (IsVisible(y) == false) return L__M(##Miscellany, 73, y);
  if (RunLife(y, ##Ask) ~= 0) rfalse;
  L__M(##Ask);
];

[ VagueConsultSub x y;
  if (lastconsulted) y = lastconsulted;
   else objectloop (x has animate && IsVisible(x) && x ~= actor) { y = x; lastconsulted = x; }
  if (~~y) { failed_action = 1; return L__M(##Miscellany, 23); }
  if (IsVisible(y) == false) return L__M(##Miscellany, 73, y);
  if (y has animate or talkable && verb_word ~= 'read') <<Ask y noun>>;
  L__M(##Miscellany, 71);
];

[ AskForSub;
  if (noun == player) <<Inv>>;
  if (noun hasnt animate) return L__M(##Answer);
  L__M(##Order, noun);
];

[ AskToSub;
  L__M(##Order, noun);
];

[ TalkTosub;

  "To talk to someone, try PERSON, HELLO or somesuch.";
];


[ ScreamSub;

  "It would be of no use.";
];

[ AttackSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun == player) return L__M(##Attack, 2);
  if (noun has animate && RunLife(noun, ##Attack) ~= 0) rfalse;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Attack, 1);
];

[ BiteSub;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##ThrowAt);
];

[ BlowSub;

  if (noun ofclass Person) return L__M(##Strong);
  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Blow, 1, noun);
];

[ BreakSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Attack, 1);
];

[ BurnSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Burn, 1, noun);
];

[ BuySub;

  if (noun == player) return L__M(##Miscellany, 68);
  if (noun ofclass Person) return L__M(##Buy, 2);
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Buy, 1);
];

[ ClimbSub;

  if (noun == actor) return L__M(##Miscellany, 68);
  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Climb, 1, noun);
];

[ ConsultSub;

  if (lastconsulted ~= noun) lastconsulted = noun;
  if (noun has animate) <<Ask noun second>>;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Miscellany, 71);
];

[ CutSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Cut, 1, noun);
];

[ DigSub;

  if (noun ofclass Person) return L__M(##Miscellany, 68);
  L__M(##Dig, 1, noun);
];

[ DrinkSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Drink, 1, noun);
];

[ FillSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Fill, 1, noun);
];

[ HugSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun == actor) return L__M(##Rub);
  if (noun hasnt animate) return L__M(##Miscellany, 37);
  if (noun has animate && RunLife(noun, ##Hug)) rfalse;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (action_mode == 2 && noun == player) L__M(##Miscellany, 59, actor);
	else L__M(##Miscellany, 59, noun);
];

[ JumpSub person;
  if (person) actor = person;
  if (MiddleRoutines()) rtrue;
  L__M(##Jump, 1, noun);
];

[ JumpOverSub;

  if (noun == actor) { failed_action = 1; return L__M(##Miscellany, 32); }
  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##JumpOver, 1, noun);
];

[ KickSub;

  if(ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (noun has animate && noun ~= player && RunLife(noun, ##Attack) ~= 0) rfalse;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun == player) return L__M(##Kick, 3);
  if(noun has animate) return L__M(##Kick, 1, noun);
  L__M(##Kick, 2, noun);
];

[ KillSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (noun has animate && RunLife(noun, ##Attack)) rfalse;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has animate) return L__M(##Kill, 1, noun);
  L__M(##Kill, 2, noun);
];

[ KissSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun == actor) return L__M(##Rub);
  if (noun hasnt animate) return L__M(##Miscellany, 37);
  if (MiddleRoutines()) rtrue;
  if (noun has animate && RunLife(noun, ##Kiss)) rfalse;
  if (AfterRoutines()) rtrue;
  if (action_mode == 2 && noun == player) L__M(##Miscellany, 59, actor);
	else L__M(##Miscellany, 59, noun);
];

[ KnockSub;
  if (noun ofclass Door) return L__M(##Answer);
  L__M(##ThrowAt);
];

[ ListenSub;

  if (noun && IsAudible(noun, actor) == false)
	{ failed_action = 1; return L__M(##Listen, 2); }
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Listen, 1);
];

[ MildSub; L__M(##Mild, 1, noun); ];

[ NoSub; L__M(##No); ];

[ PraySub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Pray, 1, noun);
];

[ PullSub;

  if (noun == actor) { failed_action = 1; return L__M(##Miscellany, 68); }
  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has static)  return L__M(##Pull, 1, noun);
  if (noun has scenery) return L__M(##Pull, 2, noun);
  if (noun has animate) return L__M(##Pull, 4, noun);
  L__M(##Pull, 3, noun);
];

[ PunchSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun == actor) return L__M(##Punch, 3);
  if (noun has animate) return L__M(##Punch, 2, noun);
  L__M(##Punch, 1, noun);
];

[ PushSub;

  if (noun == actor) { failed_action = 1; return L__M(##Miscellany, 68); }
  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has static)  return L__M(##Push, 1, noun);
  if (noun has scenery) return L__M(##Push, 2, noun);
  if (noun has animate) return L__M(##Push, 4, noun);
  L__M(##Push, 3, noun);
];

[ PushDirSub;
  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  L__M(##PushDir, 1, noun);
];

[ PushOverSub;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##ThrowAt);
];

[ RipSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##ThrowAt);
];

[ RubSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (noun == actor) return L__M(##Rub);
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun == actor) return L__M(##Touch, 2);
  if (noun has animate) {
	if (action_mode == 2 && noun == player) return L__M(##Miscellany, 59, actor);
	else return L__M(##Touch, 1);
  }
  L__M(##Rub);
];

[ SetSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Set, 1, noun);
];

[ SetToSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##SetTo, 1, noun);
];

[ SingSub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Sing, 1, noun);
];

[ SleepSub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Sleep, 1, noun);
];

[ SmellSub;

  if (noun && IsSmellable(noun, actor) == false)
	{ failed_action = 1; return L__M(##Smell, 2, noun); }
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Smell, 1);
];

[ SorrySub; L__M(##Sorry, 1, noun); ];

[ SqueezeSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (noun == actor) return L__M(##Touch, 3);
  if (AfterRoutines()) rtrue;
  if (noun has animate) return L__M(##Squeeze, 1, noun);
  L__M(##Squeeze, 2, noun);
];

[ StrongSub; L__M(##Strong); ];

[ SwimSub; L__M(##Swim, 1, noun); ];

[ SwingSub;

  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Swing, 1, noun);
];

[ TasteSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has animate) return L__M(##Miscellany, 59, noun);
  L__M(##Taste, 1, noun);
];

[ TellSub;
  if (noun == player) return L__M(##Tell, 1, noun);
  if (RunLife(noun, ##Tell) ~= 0) rfalse;
  L__M(##Tell, 2, noun);
];

[ ThinkSub; L__M(##Think, 1, noun); ];

[ ThrowAtSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (second > 1) {
      action = ##ThrownAt;
      if (RunRoutines(second, before)) { action = ##ThrowAt; rtrue; }
      action = ##ThrowAt;
  }
#Ifdef COMPLEXCLOTHING;
  if (noun ofclass Wearable && noun.worn_by == actor) {
      L__M(##Drop, 3, noun);
      <Disrobe noun>;
      if (noun.worn_by == actor) rtrue;
  }
#Ifnot;
  if (noun has worn) {
      L__M(##Drop, 3, noun);
      <Disrobe noun>;
      if (noun has worn) rtrue;
  }
#Endif;
  if (second has animate && RunLife(second, ##ThrowAt) ~= 0) rfalse;
  L__M(##ThrowAt);
];

[ TortureSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (noun has animate && RunLife(noun, ##Attack) ~= 0) rfalse;
  if (AfterRoutines()) rtrue;
  L__M(##Torture, 1);
];

[ TieSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Tie, 1, noun);
];

[ UntieSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) rtrue;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Tie, 1, noun);
];

[ TouchSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (noun == actor) return L__M(##Rub);
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has animate) {
	if (action_mode == 2 && noun == player) return L__M(##Miscellany, 59, actor);
	else return L__M(##Touch, 1);
  }
  L__M(##Touch, 2, noun);
];

[ TurnSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  if (noun has static)   return L__M(##Turn, 1, noun);
  if (noun has scenery)  return L__M(##Turn, 2, noun);
  if (noun has animate)  return L__M(##Turn, 4, noun);
  L__M(##Turn, 3, noun);
];

[ WaitSub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Wait, 1, noun);
];

[ WakeSub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Wake);
];

[ WakeOtherSub;

  if (ObjectIsUntouchable(noun, actor, false, true, true)) return;
  if (MiddleRoutines()) rtrue;

  if (RunLife(noun, ##WakeOther)) rfalse;
  if (noun == actor or player) return L__M(##Wake);
  L__M(##WakeOther);
];

[ WaveSub;

  if (noun == actor) <<WaveHands>>;
  if (noun notin actor) {
		CheckBeforeImplicit(noun, ##Take, ##Miscellany, 26, 0, ##Drop, 2);
		if (failed_action) rfalse;
   }
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##Wave, 2, noun);
];

[ WaveHandsSub;
  if (MiddleRoutines()) rtrue;
  if (AfterRoutines()) rtrue;
  L__M(##WaveHands, 1, noun);
];

[ YesSub; L__M(##Yes); ];

! ----------------------------------------------------------------------------
!   Debugging verbs
! ----------------------------------------------------------------------------

#Ifdef DEBUG;

[ TraceOnSub; parser_trace=1; "[Trace on.]"; ];

[ TraceLevelSub;
    parser_trace = noun;
    print "[Parser tracing set to level ", parser_trace, ".]^";
];

[ TraceOffSub; parser_trace=0; "Trace off."; ];

[ RoutinesOnSub;  debug_flag = debug_flag | 1;  "[Message listing on.]"; ];

[ RoutinesOffSub; debug_flag = debug_flag & 14; "[Message listing off.]"; ];

[ ActionsOnSub;   debug_flag = debug_flag | 2;  "[Action listing on.]"; ];

[ ActionsOffSub;  debug_flag = debug_flag & 13; "[Action listing off.]"; ];

[ TimersOnSub;    debug_flag = debug_flag | 4;  "[Timers listing on.]"; ];

[ TimersOffSub;   debug_flag = debug_flag & 11; "[Timers listing off.]"; ];

#Ifdef VN_1610;

[ ChangesOnSub;   debug_flag = debug_flag | 8;  "[Changes listing on.]"; ];

[ ChangesOffSub;  debug_flag = debug_flag & 7;  "[Changes listing off.]"; ];

#Ifnot;

[ ChangesOnSub; "[Changes listing available only from Inform 6.2 onwards.]"; ];

[ ChangesOffSub; "[Changes listing available only from Inform 6.2 onwards.]"; ];

#Endif; ! VN_1610

#Ifdef TARGET_ZCODE;

[ PredictableSub i;
    i = random(-100);
    "[Random number generator now predictable.]";
];

#Ifnot; ! TARGET_GLULX;

[ PredictableSub;
    @setrandom 100;
    "[Random number generator now predictable.]";
];

#Endif; ! TARGET_;

[ XTestMove obj dest;
    if ((obj <= InformLibrary) || (obj == LibraryMessages) || (obj in 1))
        "[Can't move ", (name) obj, ": it's a system object.]";
    while (dest ~= 0) {
        if (dest == obj) "[Can't move ", (name) obj, ": it would contain itself.]";
        dest = parent(dest);
    }
    rfalse;
];

[ XPurloinSub;
    if (XTestMove(noun, player)) return;
    Move(noun, player); give noun moved ~concealed;
    "[Purloined.]";
];

[ XAbstractSub;
    if (XTestMove(noun, second)) return;
    Move(noun, second);
    "[Abstracted.]";
];

[ XObj obj;
    if (parent(obj) == 0) print (name) obj; else print (a) obj;
    print " (", obj, ") ";

    new_line;

    if (child(obj) == 0) rtrue;
    if (obj == Class)
        WriteListFrom(child(obj), NEWLINE_BIT+INDENT_BIT+ALWAYS_BIT+NOARTICLE_BIT, 1);
    else WriteListFrom(child(obj), NEWLINE_BIT+INDENT_BIT+ALWAYS_BIT+FULLINV_BIT, 1);
];

[ Parents obj flag n;
  n = 0;
  while (parent(obj) ~= 0) {
	n++; obj = parent(obj); if (flag) print "  ";
  }
  return n;
];

[ XTreeSub i;
    if (noun == 0) {
        objectloop (i)
            if (i ofclass Object && parent(i) == 0) XObj(i);
    }
    else XObj(noun);
];

[ GotoSub;
    if (~~(noun ofclass Object) || (parent(noun)~=0)) "[Not a safe place.]";
    Move(player, noun);
];

[ GonearSub x;
    x = noun;
    while (parent(x) ~= 0) x = parent(x);
    Move(player, x);
];

[ Print_ScL obj; print_ret ++x_scope_count, ": ", (a) obj, " (", obj, ")"; ];

[ ScopeSub;
    x_scope_count = 0;
    LoopOverScope(Print_ScL, noun);
    if (x_scope_count == 0) "Nothing is in scope.";
];

#Ifdef TARGET_GLULX;

[ GlkListSub id val;
    id = glk($0020, 0, gg_arguments); ! window_iterate
    while (id) {
        print "Window ", id, " (", gg_arguments-->0, "): ";
        val = glk($0028, id); ! window_get_type
        switch (val) {
          1: print "pair";
          2: print "blank";
          3: print "textbuffer";
          4: print "textgrid";
          5: print "graphics";
          default: print "unknown";
        }
        val = glk($0029, id); ! window_get_parent
        if (val) print ", parent is window ", val;
        else     print ", no parent (root)";
        val = glk($002C, id); ! window_get_stream
        print ", stream ", val;
        val = glk($002E, id); ! window_get_echo_stream
        if (val) print ", echo stream ", val;
        print "^";
        id = glk($0020, id, gg_arguments); ! window_iterate
    }
    id = glk($0040, 0, gg_arguments); ! stream_iterate
    while (id) {
        print "Stream ", id, " (", gg_arguments-->0, ")^";
        id = glk($0040, id, gg_arguments); ! stream_iterate
    }
    id = glk($0064, 0, gg_arguments); ! fileref_iterate
    while (id) {
        print "Fileref ", id, " (", gg_arguments-->0, ")^";
        id = glk($0064, id, gg_arguments); ! fileref_iterate
    }
    val = glk($0004, 8, 0); ! gestalt, Sound
    if (val) {
        id = glk($00F0, 0, gg_arguments); ! schannel_iterate
        while (id) {
            print "Soundchannel ", id, " (", gg_arguments-->0, ")^";
            id = glk($00F0, id, gg_arguments); ! schannel_iterate
        }
    }
];

#Endif; ! TARGET_;

#Endif; ! DEBUG

! ----------------------------------------------------------------------------
!   Finally: the mechanism for library text (the text is in the language defn)
! ----------------------------------------------------------------------------

[ L__M act n x1 x2 i s;
    s = sw__var;
    sw__var = act;
    if (n == 0) n = 1;
    L___M(n, x1, x2, i);
    sw__var = s;
];

[ L___M n x1 x2 i s;
    s = action;
    lm_n = n;
    lm_o = x1;
    action = sw__var;
    if (RunRoutines(LibraryMessages, before))        { action = s; rfalse; }

#IFDEF USE_LIBRARY_EXTENSIONS;
    if (LibraryExtensions.RunWhile(ext_messages, 0) ~= 0) { action = s; rfalse; }
#ENDIF;
    action = s;
    LanguageLM(n, x1, x2, i);
];

! ==============================================================================

Constant LIBRARY_VERBLIB;       ! for dependency checking

! ==============================================================================