! ============================================================================
! Infit (Italian Inform Library)
! ============================================================================
!        Author: Giovanni Riccardi (giovanni@composizioni.com)
!       Version: 2.0
!      Released: 9 October 2002
! Serial Number: 021009
!   Description: "An Inform library to write Interactive Fiction in Italian."
!          Note: For use with Inform 6. (Tested with Inform compiler
!                version 6.21 and Inform library 6/10).
! ============================================================================
!
! FILES IN THE INFIT DISTRIBUTION:
!
!     Italian.h - The Inform Language Definition File for Italian.
!    ItalianG.h - The Italian Grammar File.
!     Replace.h - Some functions in the standard library are replaced
!                 here.
!   leggimi.txt - Informations in Italian.
! copyright.txt - Copyright informations (also in Italian). 
!    guida.html - An INFIT guide in Italian
!
! ============================================================================
!
! COPYRIGHT INFORMATIONS:
!
! Infit copyright (c) 1997 - 2002 by Giovanni Riccardi.
! Some part of the code in these files are copyright 
! (c) 1996 - 1999 by Graham Nelson
!
! Infit is free software. You can freely distribute it with these
! restrictions:
! (a) distributed copies are not substantially different from the
!     original copy archived in the Infit Web Site (see below).
! (b) distributed copies contain this copyright message.
! (c) no profit is involved in the distribution.
!
! Infit is distributed WITHOUT ANY WARRANTY.
!
! ============================================================================
!
! MORE INFO:
!
!   Inform Web Site: http://www.inform-fiction.org
!    Infit Web Site: http://inform.composizioni.com
!       Infit Email: inform@composizioni.com
! My personal Email: giovanni@composizioni.com
!
! ===========================================================================

! LANGUAGE NOTE:
! Since Infit is intended for use of Italian IF Designers, code comments are
! written in Italian.


! Italian.h (Italian Language Definition File).
! Numero di Serie: 021009

System_file;
Replace Banner;
Replace VersionSub;
Replace Objects1Sub;


! ============================================================================
!   Parte I.   Preliminari
! ============================================================================

Constant LanguageVersion =
    "Infit Versione 2.0/ Numero di serie 021009 / (c) 2002 by Giovanni
    Riccardi";

! ----------------------------------------------------------------------------
! Lettere accentate 
! ----------------------------------------------------------------------------

Zcharacter '@`a';
Zcharacter '@`e';		
Zcharacter '@`i';		
Zcharacter '@`o';		
Zcharacter '@`u';		
Zcharacter '@`E';

! ----------------------------------------------------------------------------
! La Bussola
! ----------------------------------------------------------------------------

Class CompassDirection
	with article "il", number 0
	has	scenery;

Object Compass "bussola"
	has	concealed female;

IFNDEF WITHOUT_DIRECTIONS;
CompassDirection -> n_obj "muro nord"
	with name 'n//' 'nord' 'muro' 'north',
		 door_dir n_to;
CompassDirection -> s_obj "muro sud"
	with name 's//' 'sud' 'muro' 'south',
		 door_dir s_to;
CompassDirection -> e_obj "muro est"
	with name 'e//' 'est' 'muro' 'east',
		 door_dir e_to;
CompassDirection -> w_obj "muro ovest"
	with name 'o//' 'ovest' 'muro' 'west' 'w//',
		 door_dir w_to;
CompassDirection -> ne_obj "muro nordest"
	with name 'ne' 'nordest' 'muro' 'northeast',
		 door_dir ne_to;
CompassDirection -> nw_obj "muro nordovest"
	with name 'no//' 'nov' 'nordovest' 'muro' 'northwest' 'nw',
		 door_dir nw_to;
CompassDirection -> se_obj "muro sudest"
	with name 'se' 'sudest' 'muro' 'southeast',
		 door_dir se_to;
CompassDirection -> sw_obj "muro sudovest"
	with name 'so' 'sudovest' 'muro' 'southwest' 'sw',
		 door_dir sw_to;
CompassDirection -> u_obj "soffitto"
	with name 'su' 'sopra' 'soffitto' 'alto' 'a//' 'up' 'u//',
		 door_dir u_to;
CompassDirection -> d_obj "pavimento"
	with name 'gi@`u' 'giu' 'sotto' 'pavimento' 'basso' 'b//' 'down' 'd//',
		 door_dir d_to;
ENDIF;

CompassDirection -> out_obj "fuori"
	with door_dir out_to;
CompassDirection -> in_obj "dentro"
	with door_dir in_to;


! ============================================================================
!   Parte II.   Vocabolario
! ============================================================================

! ----------------------------------------------------------------------------
! Miscellanea
! ----------------------------------------------------------------------------
Constant AGAIN1__WD		= 'ancora';
Constant AGAIN2__WD		= 'ancora';
Constant AGAIN3__WD		= 'rifai';
Constant OOPS1__WD		= 'oops';
Constant OOPS2__WD		= 'oops';
Constant OOPS3__WD		= 'oops';
Constant UNDO1__WD		= 'annulla';
Constant UNDO2__WD		= 'a';
Constant UNDO3__WD		= 'undo';

Constant ALL1__WD		= 'tutto';
Constant ALL2__WD		= 'ogni';
Constant ALL3__WD		= 'tutti';
Constant ALL4__WD		= 'ognuno';
Constant ALL5__WD		= 'entrambi';
Constant AND1__WD		= 'e//';
Constant AND2__WD		= 'e//';
Constant AND3__WD		= 'e//';
Constant BUT1__WD		= 'ma';
Constant BUT2__WD		= 'eccetto';
Constant BUT3__WD		= 'per@`o';
Constant ME1__WD		= 'me';
Constant ME2__WD		= 'stesso';
Constant ME3__WD		= 'stesso';
Constant OF1__WD		= 'di';
Constant OF2__WD		= 'dello';
Constant OF3__WD		= 'della';
Constant OF4__WD		= 'degli';
Constant OTHER1__WD		= 'altra';
Constant OTHER2__WD		= 'un^altra';
Constant OTHER3__WD		= 'altro';
Constant THEN1__WD		= 'allora';
Constant THEN2__WD		= 'poi';
Constant THEN3__WD		= 'quindi';

Constant NO1__WD		= 'n//';
Constant NO2__WD		= 'no//';
Constant NO3__WD		= 'no';
Constant YES1__WD		= 's//';
Constant YES2__WD		= 'si';
Constant YES3__WD		= 's@`i';

Constant AMUSING__WD	= 'divertenti';
Constant FULLSCORE1__WD	= 'completo';
Constant FULLSCORE2__WD	= 'fullscore';
Constant QUIT1__WD		= 'quit';
Constant QUIT2__WD		= 'uscire';
Constant RESTART__WD	= 'ricominciare';
Constant RESTORE__WD	= 'caricare';


! ----------------------------------------------------------------------------
! Pronomi
! ----------------------------------------------------------------------------
Array LanguagePronouns table

   ! word     possible GNAs	connected
   !          to follow:	to:
   !          a     i
   !          s  p  s  p
   !          mfnmfnmfnmfn               

     'lui'  $$100000000000  NULL  
     'lei'  $$010000000000  NULL
     'esso' $$100000100000  NULL      
     'essa' $$010000010000  NULL      
     'gli'  $$100000000000  NULL 
     'essi' $$000110000110  NULL
     'esse' $$000010000010  NULL
     'loro' $$000110000110  NULL; 
  

! ----------------------------------------------------------------------------
! Descrittori (articoli, pronomi possessivi, ecc.)
! ----------------------------------------------------------------------------
Array LanguageDescriptors table

   !  word		 possible GNAs		descriptor		connected
   !             to follow:			type:           to:
   !             a     i
   !             s  p  s  p
   !             mfnmfnmfnmfn               

      'mio'    $$100000100000		POSSESS_PK      0
      'mia'    $$010000010000		POSSESS_PK      0
      'miei'   $$000100000100		POSSESS_PK      0
      'mie'    $$000010000010		POSSESS_PK      0
    
      'questo' $$100000100000		POSSESS_PK      0
      'questa' $$010000010000		POSSESS_PK      0
      'questi' $$000100000100		POSSESS_PK      0
      'queste' $$000010000010		POSSESS_PK      0	
    
      'quello' $$100000100000		POSSESS_PK      1
      'quella' $$010000010000		POSSESS_PK      1
      'quell^' $$110000110000		POSSESS_PK      1
      'quelli' $$000100000100		POSSESS_PK      1
      'quegli' $$000100000100		POSSESS_PK      1
      'quelle' $$000010000010		POSSESS_PK      1

      'suo'    $$100000100000		POSSESS_PK      'lui'
      'suoi'   $$000100000100		POSSESS_PK      'lui'
      'sua'    $$010000010000		POSSESS_PK      'lei'
      'sue'    $$000010000010		POSSESS_PK      'lei'
      'loro'   $$000110000110		POSSESS_PK      'loro'
    
      'il'     $$100000100000		DEFART_PK       NULL
      'lo'     $$100000100000		DEFART_PK       NULL
      'la'     $$010000010000		DEFART_PK       NULL
      'l^'     $$110000110000		DEFART_PK       NULL
      'i//'    $$000100000100		DEFART_PK       NULL
      'gli'    $$000100000100		DEFART_PK       NULL
      'le'     $$000010000010		DEFART_PK       NULL
    
      'un'     $$100000100000		INDEFART_PK     NULL
      'uno'    $$100000100000		INDEFART_PK     NULL
      'una'    $$010000010000		INDEFART_PK     NULL
      'un^'    $$010000010000		INDEFART_PK     NULL
      'dei'    $$000100000100		INDEFART_PK     NULL
      'degli'  $$000100000100		INDEFART_PK     NULL
      'delle'  $$000010000010		INDEFART_PK     NULL
      'alcuni' $$000100000100		INDEFART_PK     NULL
      'alcune' $$000010000010		INDEFART_PK     NULL
    
    
      'illuminato' $$100000100000	light			NULL
      'illuminata' $$010000010000	light			NULL
      'illuminati' $$000100000100	light			NULL
      'illuminate' $$000010000010	light			NULL
      'buio'       $$100000100000	(-light)		NULL
      'buia'       $$010000010000	(-light)		NULL
      'bui'        $$000100000100	(-light)		NULL
      'buie'       $$000010000010	(-light)		NULL
    
    
      'acceso' $$100000100000		light			NULL
      'accesa' $$010000010000		light			NULL
      'accesi' $$000100000100		light			NULL
      'accese' $$000010000010		light			NULL
      'spento' $$100000100000		(-light)		NULL
      'spenta' $$010000010000		(-light)		NULL
      'spenti' $$000100000100		(-light)		NULL
      'spente' $$000010000010		(-light)		NULL;
          
    
    
! ----------------------------------------------------------------------------
! Numeri
! ----------------------------------------------------------------------------
Array LanguageNumbers table
    'uno' 1 'due' 2 'tre' 3 'quattro' 4 'cinque' 5
    'sei' 6 'sette' 7 'otto' 8 'nove' 9 'dieci' 10
    'undici' 11 'dodici' 12 'tredici' 13 'quattordici' 14 'quindici' 15
    'sedici' 16 'diciassette' 17 'diciotto' 18 'diciannove' 19 'venti' 20;

! ============================================================================
!   Parte III.   Traduzione
! ============================================================================

[LanguageToInformese x word at word1 len;

! Questa routine aggiunge uno spazio dopo ogni apostrofo.

	for (x=2:x<(2+buffer->1):x++)
	{
		if (buffer->x == ''') 
		{
			LTI_Insert(x+1, ' ');
			@tokenise buffer parse;
			continue;
		}
	}

! Inizio del ciclo sull'array parse per la sostituzione di alcune parole
! non riconosciute dal parser o riconosciute con difficolt.
	
	for (x=0:x<parse->1:x++)
    {
		word = parse-->(x*2 + 1);
		word1 = parse-->((x+1)*2 + 1);
		at = parse->(x*4 + 5);
		len = parse->(x*2 + 4);

! La seguente routine traduce le parole "tutta, tutte, ognuna, entrambe", che
! non ho potuto dichiarare come ALL*_WD, in altre parole conosciute dal parser
! (ci sono solo 5 costanti di questo tipo disponibili).


		if (word == 'tutta' or 'tutte')     
      	{
			buffer->(at+4) = 'o';                                        
            @tokenise buffer parse;                                       
            x=-1; continue;                                                
      	}

		if (word == 'ognuna')                    
        {	
			buffer->(at+5) = 'o';                 
            @tokenise buffer parse;           
            x=-1; continue;                    
     	}

		if (word == 'entrambe')                                           
      	{
			buffer->(at+7) = 'i';                                          
            @tokenise buffer parse;                                        
            x=-1; continue;                                                 
		}

! Lo stesso di sopra ma per OF*_WD (le parole "del, dell', delle").
	
		if (word == 'del')                  
     	{
     	    buffer->(at+1) = 'i';           
            buffer->(at+2) = ' ';
            @tokenise buffer parse;          
            x=-1; continue;
		}
	
        if (word == 'dell^' or 'delle')     
        {
			buffer->(at+4) = 'o';           
            @tokenise buffer parse;         
            x=-1; continue;                  
     	}
     	
     	if (word == 'd^')
     	{
			buffer->(at+1) = 'i';           
            @tokenise buffer parse;         
            x=-1; continue;                  
     	}
     	
	
! Poich non ho potuto dichiarare "me stesso" come ME*_WD (le costanti
! sono fatte di una sola parola), allora questa routine elimina semplicemente
! la parola "me": Infatti "stesso"  conosciuta dal parser.
  
  		if (word == 'me' && word1 == 'stesso')
      	{
			buffer->at = ' ';            
            buffer->(at+1) = ' ';
            @tokenise buffer parse;         
            x=-1; continue;                     
   		}

! La stessa cosa di sopra ma per "punteggio completo" in cui la parola
! "punteggio" viene semplicemente eliminata. In questo modo si risolve un
! bug con la routine AfterGameOver di parserm.h che richiama le parole
! FULLSCORE1_WD e FULLSCORE2_WD

  		if (word == 'punteggio' && word1 == 'completo')
      	{
			buffer->at = ' ';            
            buffer->(at+1) = ' ';
			buffer->(at+2) = ' ';
			buffer->(at+3) = ' ';
			buffer->(at+4) = ' ';
			buffer->(at+5) = ' ';
			buffer->(at+6) = ' ';
			buffer->(at+7) = ' ';
			buffer->(at+8) = ' ';
            @tokenise buffer parse;         
            x=-1; continue;                     
   		}



! Gestisce il problema con la direzione NordOvest (abbreviata con 'no')
! che veniva confusa dal parser con la risposta negativa.
! Notare che nelle domande la risposta negativa  gestita correttamente
! grazie alla chiamata alla routine YesOrNo. 

		if (word == 'no')
		{
			LTI_Insert(at+2, 'v');
			@tokenise buffer parse;
			x=-1; continue;
		}


! Gestisce alcuni comandi non troppo belli da vedersi ma a quanto pare molto
! utilizzati tipo 'xlo' per 'esaminalo' e 'llo' per 'guardalo'
         
        if (word == 0							!"llo" or "lla" or "lli" or "lle" 
			&& buffer->at == 'l' && 
			buffer->(at+1) == 'l' && 
			(buffer->(at+2) == 'o' or 'a' or 'i' or 'e'))                    
        {
			buffer->at = 'g';
            LTI_Insert(at+1, 'u');
            LTI_Insert(at+2, 'a');
            LTI_Insert(at+3, 'r');
            LTI_Insert(at+4, 'd');
            LTI_Insert(at+5, 'a');
            @tokenise buffer parse;
            x=-1; continue;
        }

        if (word == 0							!"xlo" or "xla" or "xli" or "xle" 
			&& buffer->at == 'x' && 
			buffer->(at+1) == 'l' && 
			(buffer->(at+2) == 'o' or 'a' or 'i' or 'e'))
        {
			buffer->at = 'e';
            LTI_Insert(at+1, 's');
            LTI_Insert(at+2, 'a');
            LTI_Insert(at+3, 'm');
            LTI_Insert(at+4, 'i');
            LTI_Insert(at+5, 'n');
            LTI_Insert(at+6, 'a');
            @tokenise buffer parse;
            x=-1; continue;
        }                     


! Questa routine per prima cosa riconosce se un pronome  attaccato ad un verbo
! quindi separa le due parole. Riconosce anche alcune forme irregolari
! (per esempio "daglielo" --> "da esso a lui).

 
		if (word == 0 && buffer->(at+len-3) == 'g' &&
			buffer->(at+len-2) == 'l' && buffer->(at+len-1) == 'i')
  		{
			LTI_Insert(at+len-3, ' ');
            buffer->(at+len-2) = 'l';
            buffer->(at+len-1) = 'u';
            !buffer->(at+len) = 'i';
            @tokenise buffer parse;
            x=-1; continue;
   		}
        
		if (word == 0 && buffer->(at+len-2) == 'l' &&
			(buffer->(at+len-1) == 'a' or 'o' or 'i' or 'e'))
   		{
			buffer->(at+len-2) = ' ';
            LTI_Insert(at+len-1, 's');
            LTI_Insert(at+len-1, 's');
            LTI_Insert(at+len-1, 'e');
      	    if (word == 0 && buffer->(at+len-6) == 'g' &&
				buffer->(at+len-5) == 'l' && buffer->(at+len-4) == 'i'
				&& buffer->(at+len-3) == 'e')
      	    {
				LTI_Insert(at+len-6, ' ');
                buffer->(at+len-5) = 'a';
                buffer->(at+len-4) = 'l';
                buffer->(at+len-3) = 'u';
                buffer->(at+len-2)   = 'i';
                LTI_Insert(at+len-4, ' ');
                x=-1; continue;
 			}
			@tokenise buffer parse;         
            x=-1; continue;
		}
    }


! Questa routine  solo per testare se tutto funziona bene.
! infatti riscrive semplicemente il comando dopo che  stato modificato da
! LanguageToInformese. Per il test togliere i commenti.
!
!       
!	print "[";
!	for (x=2:x<2+buffer->1:x++)
!	print (char) buffer->x;  
!	print  "]^^";
!
];



! ============================================================================
!   Parte IV.  Stampa
! ============================================================================

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = male;

Constant LanguageContractionForms = 3;   


! ----------------------------------------------------------------------------
! Qualche regola per gli articoli e una precisazione.
! ----------------------------------------------------------------------------
! Ci sono tre casi che dipendono dalla lettera iniziale di una parola:
! 1. Parola che comincia con vocale
! 2. Parola che comincia con z oppure s + consonante (oppure ps, pn, gn, x)
! 3. Parola che comincia con altra consonante.
!
! N.B. Le parole che cominciano con ps, pn, gn e x (molto poche) dovrebbero
!      seguire la regola 2 (secondo la grammatica italiana). Nell'uso reale
!      della lingua si tende a seguire la regola 3. Questa libreria
!      segue la regola grammaticale. Se vuoi cambiarla, per accordarla
!      all'uso reale basta semplicemente specificare l'articolo nella
!      definizione dell'oggetto (has article ""). Per esempio:
!      	    da:  "lo pneumatico, uno pneumatico" (default)
!            a:  "il pneumatico, un pneumatico"  (has article "il")
! ---------------------------------------------------------------------------- 

[ LanguageContraction text;

    if (text->0 == 'a' or 'e' or 'i' or 'o' or 'u'
	or 'A' or 'E' or 'I' or 'O' or 'U') return 0;
    if (text->0 == 'z' or 'Z') return 1;
    if (text->0 == 's' or 'S')
    {
     	if (text->1 == 'a' or 'e' or 'i' or 'o' or 'u'
	    or 'A' or 'E' or 'I' or 'O' or 'U') return 2;
	else return 1;
    }
    if (text->0 == 'p' or 'P')
    {
     	if (text->1 == 'n' or 's') return 1;
	else return 2;
    }
    if (text->0 == 'g' or 'G')
    {
  	if (text->1 == 'n') return 1;
	else return 2;
    }
    return 2;
   
];

Array LanguageArticles -->

 !   Contraction form 0:     Contraction form 1:     Contraction form 2:
 !   Cdef   Def    Indef     Cdef   Def    Indef     Cdef   Def    Indef

     "L'"   "l'"  "un "     "Lo "  "lo "   "uno "    "Il "  "il "  "un "  
     "L'"   "l'"  "un'"     "La "  "la "   "una "    "La "  "la "  "una "
   
     "Gli " "gli" "degli "  "Gli " "gli "  "degli "  "I "   "i "   "dei "  
     "Le "  "le " "delle "  "Le "  "le "   "delle "  "Le "  "le "  "delle ";

                   !             a           i
                   !             s     p     s     p
                   !             m f n m f n m f n m f n               

Array LanguageGNAsToArticles --> 0 1 0 2 3 0 0 1 0 2 3 0;

! ----------------------------------------------------------------------------
! Le direzioni della bussola.
! ----------------------------------------------------------------------------
[ LanguageDirection d;
    switch(d)
    {
        n_to: print "nord";
        s_to: print "sud";
        e_to: print "est";
        w_to: print "ovest";
        ne_to: print "nordest";
        nw_to: print "nordovest";
        se_to: print "sudest";
        sw_to: print "sudovest";
        u_to: print "sopra";
        d_to: print "sotto";
        in_to: print "dentro";
        out_to: print "fuori";
        default: return RunTimeError(9,d);
    }
];

! ----------------------------------------------------------------------------
! Stampa dei numeri con gestione di alcune forme irregolari. 
! ----------------------------------------------------------------------------
[ LanguageNumber n ;
      if (n==0)    { print "zero"; rfalse; }
      if (n<0)     { print "meno "; n=-n; }
	  if (n>=1000 && n<2000) { print " mille"; n=n%1000; }
      if (n>=2000 && n<1000000) { print (LanguageNumber) n/1000, "mila"; n=n%1000; }
	  if (n>=100 && n<200) { print "cento"; n=n%100;}
	  if (n>=200 && n<1000) { print (LanguageNumber) n/100, "cento"; n=n%100; }

      if (n==0) rfalse;
      switch(n)
      {     1:  print "uno";
            2:  print "due";
            3:  print "tre";
            4:  print "quattro";
            5:  print "cinque";
            6:  print "sei";
            7:  print "sette";
            8:  print "otto";
            9:  print "nove";
            10: print "dieci";
            11: print "undici";
            12: print "dodici";
            13: print "tredici";
            14: print "quattordici";
            15: print "quindici";
            16: print "sedici";
            17: print "diciassette";
            18: print "diciotto";
            19: print "diciannove";
            20 to 99: switch(n/10)
                  {     2: print "vent";
                        3: print "trent";
                        4: print "quarant";
                        5: print "cinquant";
                        6: print "sessant";
                        7: print "settant";
                        8: print "ottant";
                        9: print "novant";
                  }
            if (n/10 == 2)
            {if (n%10 ~= 1 or 8) print "i";
          	 if (n%10 ~= 0) print (LanguageNumber) n%10;
          	}
          	else
          	{if (n%10 ~= 1 or 8) print "a";
          	 if (n%10 ~= 0) print (LanguageNumber) n%10;
          	}
      }
];

! ----------------------------------------------------------------------------
! Stampa dell'ora del giorno.
! ----------------------------------------------------------------------------

[ LanguageTimeOfDay hours mins i;
	print (string) TIME__TX;
	i=hours%12; if (i<10) print " ";
	if (i==0) i=12;
	print i, ":", mins/10, mins%10;
	if ((hours/12) > 0) print " pm"; else print " am";
];

! ----------------------------------------------------------------------------
! Qualche abbreviazione
! ----------------------------------------------------------------------------

[ LanguageVerb i;
	if (i==#n$g) { print "guarda"; rtrue; }
	if (i==#n$z) { print "attendi"; rtrue; }
	if (i==#n$x) { print "esamina"; rtrue; }
	if (i==#n$i or 'inv' or 'inventario') { print "inventario"; rtrue; }
	rfalse;
];

! ----------------------------------------------------------------------------
! Costanti della libreria.
! ----------------------------------------------------------------------------

Constant NKEY__TX     = "S = successivo";
Constant PKEY__TX     = "P = precedente";
Constant QKEY1__TX    = " R = riprendi gioco";
Constant QKEY2__TX    = "R = menu precedente";
Constant RKEY__TX     = "RETURN = leggi argomento";

Constant NKEY1__KY    = 'S';
Constant NKEY2__KY    = 's';
Constant PKEY1__KY    = 'P';
Constant PKEY2__KY    = 'p';
Constant QKEY1__KY    = 'R';
Constant QKEY2__KY    = 'r';

Constant SCORE__TX    = "Punti: ";
Constant MOVES__TX    = " Azioni: ";
Constant TIME__TX     = "Tempo: ";
Constant CANTGO__TX   = "Non puoi andare in quella direzione.";
Constant FORMER__TX   = "quello che eri";
Constant YOURSELF__TX = "te stesso";
Constant DARKNESS__TX = "Oscurit@`a";

Constant THOSET__TX   = "ci@`o"; 	!"quelle cose";
Constant THAT__TX     = "ci@`o"; 	!"quello";
Constant OR__TX       = " oppure ";
Constant NOTHING__TX  = "niente";
Constant IS__TX       = " @`e ";
Constant ARE__TX      = " sono ";
Constant IS2__TX      = " c'@`e ";
Constant ARE2__TX     = " ci sono ";
Constant AND__TX      = " e ";
Constant WHOM__TX     = "";
Constant WHICH__TX    = "";

! ----------------------------------------------------------------------------
! Qualche routine per stampare le parole giuste.
! ----------------------------------------------------------------------------
! NOTA 1: 
! Nella definizione degli oggetti basta specificare l'attributo female
! (has female) se l'oggetto  femminile, pluralname (has pluralname) se
!  plurale. Tutti gli altri casi vengono riconosciuti automaticamente e
! si possono usare le routine che seguono senza problemi.
! NOTA 2: 
! (thatorthose) Non  usata nella libreria; L'ho messa per uso dei game
! designer. Tutti i messaggi usano (itorthem), (citorthem) oppure
! (cthatorthose) per indicare gli oggetti.
! ----------------------------------------------------------------------------



! (thatorthose): stampa "quello, quella, quelli, quelle"


[ ThatorThose obj;
	if (obj == player) {print "tu"; return; }
	if (obj has pluralname)
	{	if (obj has female) print "quelle"; else print "quelli"; }
    else
	{	if (obj has female) print "quella"; else print "quello"; }
];


! (itorthem): stampa "lo, la, li, le"

[ ItorThem obj;
	if (obj == player) { print "te stesso"; return; }
	if (obj has pluralname)
    {	if (obj has female) print "le"; else print "li"; }
    else
	{	if (obj has female) print "la"; else print "lo"; }
];


! (citorthem): stampa "Lo, La, Li, Le"

[ CItorThem obj;
	if (obj has pluralname)
	{	if (obj has female) print "Le"; else print "Li"; }
	else
	{ 	if (obj has female) print "La"; else print "Lo"; }
];


! (cthatorthose): stampa "Quello, Quella, Quelli, Quelle"


[ CThatorThose obj;
	if (obj has pluralname)
	{	if (obj has female) print "Quelle"; else print "Quelli"; }
	else
	{	if (obj has female) print "Quella"; else print "Quello"; }
];


! (isorare): stampa "sono, "


[ IsorAre obj; 
	if (obj has pluralname) print "sono"; else print "@`e";
];


! (cisorare): stampa "Sono, E'"


[ CIsorAre obj; 
	if (obj has pluralname) print "Sono"; else print "@`E";
];



! (genderandnumber) stampa la lettera finale per aggettivi e participi passati


[ GenderandNumber obj;
	if (obj has pluralname)
	{	if (obj has female) print "e"; else print "i"; }
	else
	{	if (obj has female) print "a"; else print "o"; }
];



! (whomorwhich1) e (whomorwhich2) stampa la forma corretta di pronomi relativi.
! Sono usate al posto delle costanti WHOM_TX e WHICH_TX che ho invece dichiarato
! come stringhe vuote
! Sono usate nei messaggi ListMiscellany 19, 20, 21 e 22.


[ WhomorWhich1 obj;
	if (obj has pluralname)
	{	if (obj has female) print "lle quali"; else print "i quali"; }
	else
	{	if (obj has female) print "lla quale"; else print "l quale"; }
];

[ WhomorWhich2 obj;
	if (obj has pluralname)
	{	if (obj has female) print "le quali"; else print "i quali"; }
	else
    {	if (obj has female) print "la quale"; else print "il quale"; }
];


! Stampa delle preposizioni articolate

[ Articolo o pluralise;  !i artform findout;

   StorageForShortName-->0 = 160;
   @output_stream 3 StorageForShortName;
   if (pluralise) print (number) pluralise; else print (PSN__) o;
   @output_stream -3;
   !acode = acode + 3*LanguageContraction(StorageForShortName + 2);

	if ((o has pluralname) && (o has male))
	{	print (the) o; return; } 
	else
	{	print "l";
		if ((o has male) && (LanguageContraction(StorageForShortName + 2) == 2))
		{	print " ", (name) o;
		}
		else 
		{	print (the) o; }
	}

   !if (acode == 1 or 3 or 4)
   !{ print "l";
   !}
   !else ;
   !if (pluralise) return;
   !print (PSN__) o;
];

[ ArtDa o i;
   print "da";
   i = indef_mode; indef_mode = false;
   if (o has proper)
   { indef_mode = NULL; print (PSN__) o; indef_mode = i; return; }
   Articolo(o); indef_mode = i;
];

[ArtSu o i;
   print "su";
   i = indef_mode; indef_mode = false;
   if (o has proper)
   { indef_mode = NULL; print (PSN__) o; indef_mode = i; return; }
   Articolo(o); indef_mode = i;
];

[ ArtIn o i;
   print "ne";
   i = indef_mode; indef_mode = false;
   if (o has proper)
   { indef_mode = NULL; print (PSN__) o; indef_mode = i; return; }
   Articolo(o); indef_mode = i;
];



! PrintPrep() e PrintInfinitive() sostituiscono nei messaggi Miscellany
! #48 & #49 la routine del parser PrintCommand(). Esse stampano la preposizione
! e la corretta forma di infinito per ogni verbo dato come comando.
! PrintInfinitive() gestisce anche alcune forme irregolari.

Global verb_flag = false;
Global verb_acc = THOSET__TX;

[ PrintPrep i j k prep_flag prepos p;
	for (k=1:k<pcount:k++)
	{	i=pattern-->k;
        if (i==PATTERN_NULL) continue;
        if (prep_flag) print (char) ' ';
      	if (i==0)
      	{	!print (string) THOSET__TX;
      		verb_flag = true;
      		verb_acc = THOSET__TX;
      	}
      	if (i==1)
      	{	!print (string)
      		verb_flag = true;
      		verb_acc = THAT__TX;
      	}
        if (i>=REPARSE_CODE)
        {	i = i - REPARSE_CODE;
			
			@output_stream 3 prepos;		! L'assembly qui a fianco copia sull'array prepos
			print (address) No__Dword(i);	! i caratteri della preposizione all'indirizzo
			@output_stream -3;				! No_Dword(i) del dizionario.
			
			p = prepos->2;
			if (p=='i')						! gestisce il comando "vai in" stampando 
			{	print "Dentro";				! "Dentro cosa vuoi andare?" al posto di
				prep_flag = true;			! "In cosa vuoi andare?"
				jump PrepOk;				! NOTA: da correggere in "Dove vuoi..."
			}
			if (p<'v')						! Risolve il bug con "fai vedere", in quanto
			{								! la parola 'vedere' era riconosciuta come una
				if (p >= 'a' && p <= 'z')	! preposizione e veniva stampata una cosa del 
        		{	p = p - ('a' - 'A');	! genere 'Vedere cosa vuoi fare?'. Nel caso la
        		};							! preposizione non  vedere (inizia con 'v')
 				print (char) p;				! converte l'iniziale in maiuscolo.
				for (j=1:j<prepos->1:j++)
				{	print (char) prepos->(2+j);
				}
				prep_flag = true;
			}
		}
    }
	.PrepOk;
    if (prep_flag==false) print "C";
    if (prep_flag==true ) print " c";
];

[ PrintInfinitive i n l t x j;
	i=verb_word;
	n = verb_wordnum;
	l=WordLength(n);
	t=WordAddress(n);
	if (t->0 == 'b' &&
		t->1 == 'e' &&
		t->2 == 'v' &&
		t->3 == 'i')
	{   print "bere";
        rfalse;
    }
	if (t->0 == 'd' &&
		t->1 == 'i')
	{	print "dire";
		rfalse;
	}
	if (t->0 == 'x') !! && t->1 == 0)
	{	print "esaminare";
		rfalse;
	}
	if (t->0 == 'l' or 'g' && t->1 == 0)
	{	print "guardare";
		rfalse;
    }
	if (t->0 == 'f' &&
		t->1 == 'a' &&
		t->2 == 'i' &&
		t->3 == ' ' &&
		t->4 == 'v' &&
		t->5 == 'e' &&
		t->6 == 'd')
	{	print "far vedere";
		rfalse;
	}
	if (t->0 == 'f' &&
		t->1 == 'a' &&
		t->2 == ' ' &&
		t->3 == 'v' &&
		t->4 == 'e' &&
		t->5 == 'd')
	{	print "far vedere";
		rfalse;
	}
	if (t->0 == 's' &&
		t->1 == 'a' &&
		t->2 == 'l' &&
		t->3 == 'i')
	{	print "salire";
		rfalse;
	}
	if (t->0 == 'a' &&
		t->1 == 'r' &&
		t->2 == 'r' &&
		t->3 == 'a' &&
		t->4 == 'm')
	{	print "arrampicarti";
		rfalse;
	}

	if (t->0 == 'v' &&
		t->1 == 'a' &&
		t->2 == 'i')
	{	print "andare";
		rfalse;
	}
	if (t->(l-1) == 'i' &&
		t->(l-2) == 'l' &&
		t->(l-3) == 'g')
	{ 	print (address) i;
		print "ere";
		rfalse;
	}    
	if (t->0 == 's' &&
		t->1 == 'i' &&
		t->2 == 'e')
	{	print "sederti";
		rfalse;
	}
	if (t->0 == 's' && 
		t->1 == 'd' && 
		t->2 == 'r')
	{	print "sdraiarti";
		rfalse;
	}
	if (t->(l-1) == 'a')
	{	print (address) i;
		print "re";
		jump Accusative;
	}
	if (t->(l-1) == 'i' &&
		t->(l-2) == 'c' &&
		t->(l-3) == 's')
	{	t->(l-3) = 'r';
		t->(l-2) = 'e';
		t->(l-1) = ' ';
		for (x=0: x<l: x++) print (char) t->x;
		t->(l-3) = 's';
		t->(l-2) = 'c';
		t->(l-1) = 'i';
		rfalse;
	}
	if (t->(l-1) == 'i' &&
		t->(l-2) == 'r' &&
		t->(l-3) == 'p' or 'f')
	{	print (address) i;
		print "re";
		rfalse;
	}
	if (t->(l-1) == 'i' &&
		t->(l-2) == 'a')
	{	j = t->(l-1);
		t->(l-1) = 'r';
		for (x=0: x<l: x++) print (char) t->x;
		print "e";
		t->(l-1) = j;
		rfalse;
	}
	else
	{	j = t->(l-1);
		t->(l-1) = 'e';
		for (x=0: x<l: x++) print (char) t->x;
		print  "re";
		t->(l-1) = j;
		rfalse;
	}
    
	.Accusative;
	if (verb_flag == true)
	{	print " ";
		print (string) verb_acc; rfalse;
		!if (acc_bit == 1) {print (string) THAT__TX;}
		!if (acc_bit == 2) {print (string) THOSET__TX;}
		!else print "ERRORE!!!";
	}
  
];



! ----------------------------------------------------------------------------
! Messaggi della libreria
! ----------------------------------------------------------------------------
[ LanguageLM n x1;
	Prompt:
	#ifdef PROMPT;
	switch(random(15))
	{	1: print "^Adesso?";
		2: print "^E adesso?";
		3: print "^Allora?";
		4: print "^Ora?";
		5: print "^E ora?";
		6: print "^Quindi?";
		7: print "^Che si fa?";
		8: print "^Che suggerisci di fare?";
		9: print "^Che dici di fare?";
		10: print "^E ora che si fa?";
		11: print "^Cosa devo fare ora?";
		12: print "^S@`i?";
		13: print "^Poi?";
		14: print "^Dimmi:";
		15: print "^Aspetto un tuo comando:";
	}
	#endif;
	print "^>";
    
	Miscellany: switch(n)
	{	1: "(considero solo i primi sedici oggetti)^";
		2: "Niente da fare!";
		3: print " Sei morto ";
		4: print " Hai vinto ";
		5: print "^Vuoi RICOMINCIARE, CARICARE una partita salvata";
		#IFDEF DEATH_MENTION_UNDO;
		   print ", ANNULLARE il tuo ultimo comando";
		#ENDIF;
		   if (TASKS_PROVIDED==0)
				print ", avere il PUNTEGGIO COMPLETO della partita";
		   if (deadflag==2 && AMUSING_PROVIDED==0)
				print ", avere suggerimenti per cose DIVERTENTI da fare";
		   " o USCIRE ?";
		6: "[L'interprete non pu@`o gestire il comando ~cancella~.]";
		7: "~Cancella~ non ha funzionato. [Non tutti gli interpreti lo supportano.]";
		8: "Per favore, dai una delle risposte elencate.";
		9: "^@`E completamente buio qui!";
		10: "Scusa!!??";
		11: "[Non puoi cancellare ci@`o che non hai fatto!]";
		12: "[Non puoi cancellare due volte di seguito. Spiacente!]";
		13: "[Azione precedente cancellata.]";
		14: "Spiacente, questo non pu@`o essere corretto.";
		15: "Non c'@`e di che.";
		16: "Il comando ~oops~ pu@`o correggere solo una parola.";
		17: "@`E completamente buio, e non riesci a vedere niente.";
		18: print "te stesso";
		19: "Hai sempre lo stesso bell'aspetto.";
		20: "Per ripetere un comando come ~rana, salta~, basta solamente ~ancora~, non ~rana, ancora~.";
		21: "Difficilmente potrai ripetere quello che hai appena fatto.";
		22: "Non puoi iniziare un comando con una virgola.";
		23: "Sembra che tu voglia parlare con qualcuno, ma non capisco con chi.";
		24: "Non puoi parlare con ", (the) x1, ".";
		25: "Per parlare a qualcuno prova ~qualcuno, ciao~ o qualcosa di simile.";
		26: "(naturalmente, prima prendi ", (the) not_holding, ")";
		27: "Non riesco a capire la frase.";
		28: print "Ho capito la frase solo fino a: ";
		29: "Non riesco a capire il numero.";
		30: "Non vedi nulla del genere.";
		31: "Mi sembra che tu abbia detto troppo poco!";
		32: "Non possiedi questa cosa!";
		33: "Non puoi usare oggetti multipli con quel verbo.";
		34: "Puoi usare oggetti multipli solo una volta per comando.";
		35: "Non riesco a capire a cosa ~", (address) pronoun_word, "~ si riferisca.";
		36: "Non puoi escludere qualcosa che non hai incluso!";
		37: "Hey! Puoi farlo solo con esseri viventi.";
		38: "Questo @`e un verbo che non conosco.";
		39: "Non @`e importante ai fini del gioco.";
		40: "(", (the) pronoun_obj, ")^Non ", (itorthem) pronoun_obj, " vedi.";
		41: "Non ho capito la fine del comando.";
		42: if (x1==0) print "Nessuno";
			else print "Solamente ", (number) x1;
			print " ne ";
			if (x1==1 || x1==0) { print "@`e disponibile.";}
			else print "sono disponibili.";
		43: "Niente da fare!";
		44: "Non ce ne sono disponibili!";
		45: print "Chi intendi, ";
		46: print "Cosa intendi, ";
		47: print "Spiacente, ne puoi avere solo uno. Quale esattamente?";
		48: PrintPrep(); print "hi ";
			if (actor==player) { print "vuoi "; PrintInfinitive(); }
			else 
			{	print "dovrebbe";
				if (actor has pluralname) print "ro";
				print " ";
				PrintInfinitive();
				print " ", (the) actor;
			}
			print "?^";
		49: PrintPrep(); print "osa ";
			if (actor==player) { print "vuoi "; PrintInfinitive(); }
			else 
			{	print "dovrebbe";
				if (actor has pluralname) print "ro";
				print " ";
				PrintInfinitive();
				print " ", (the) actor;
			}
			print "?^";
		50: print "Il tuo punteggio @`e appena ";
			if (x1 > 0) print "aumentato"; else { x1 = -x1; print "diminuito"; }
			print " di ";
		    if (x1 == 1) print "un punto";
			if (x1 > 1) print (number) x1, " punti";
		51: "(@`E accaduto qualcosa di drammatico, i comandi disponibili sono stati ridotti.)";
		52: "^Inserisci un numero da 1 a ", x1, ", 0 per rivedere o premi INVIO.";
		53: "^[Per favore premi SPAZIO.]";
	}
 
	ListMiscellany: switch(n)
	{	1: print " (acces", (genderandnumber) x1, ") ";
		2: print " (che ", (isorare) x1, " chius", (genderandnumber) x1, ")";
		3: print " (chius", (genderandnumber) x1, " e acces", (genderandnumber) x1, ")";
		4: print " (che ", (isorare) x1, " vuot", (genderandnumber) x1, ")";
		5: print " (vuot", (genderandnumber) x1, " e acces", (genderandnumber) x1, ")";
		6: print " (che ", (isorare) x1, " chius", (genderandnumber) x1, " e vuot", (genderandnumber) x1, ")";
		7: print " (chius", (genderandnumber) x1, ", vuot", (genderandnumber) x1, " e acces", (genderandnumber) x1, ")";
		8: print " (acces", (genderandnumber) x1, " e  indossat", (genderandnumber) x1, ")";
		9: print " (acces", (genderandnumber) x1;
		10: print " (indossat", (genderandnumber) x1;
		11: print " (che ", (isorare) x1, " ";
		12: print "apert", (genderandnumber) x1;
		13: print "apert", (genderandnumber) x1, " ma vuot", (genderandnumber) x1;
		14: print "chius", (genderandnumber) x1;
		15: print "chius", (genderandnumber) x1, " a chiave";
		16: print " e vuot", (genderandnumber) x1;
		17: print " (che ", (isorare) x1, " vuot", (genderandnumber) x1, ")";
		18: if (x1 has pluralname) print " che contengono ";
			else print " che contiene ";
		19: print " (su", (whomorwhich1) x1, " ";
		20: print ", sopra ", (whomorwhich2) x1, " ";
		21: print " (ne", (whomorwhich1) x1, " ";
		22: print ", dentro ", (whomorwhich2) x1, " ";
	}

	Pronouns: switch(n)
	{	1: print "Al momento, ";
		2: print "significa ";
		3: print "@`e disattivato";
		4: "nessun pronome @`e conosciuto dal gioco.";
	}
	
	Order:
		print (The) x1;
		if (x1 has pluralname) print " hanno"; else print " ha";
		" altre cose da fare.";
	
	Quit: switch(n)
	{	1: print "Per favore, rispondi SI o NO.";
		2: print "Sei sicuro di voler uscire? ";
	}
	
	Restart: switch(n)
	{	1: print "Sei sicuro di voler ricominciare? ";
		2: "Tentativo fallito.";
	}

	Restore: switch(n)
	{	1: "Caricamento fallito.";
		2: "Ok.";
	}

	Save: switch(n)
	{	1: "Salvataggio della partita fallito.";
		2: "Ok.";
	}

	Verify: switch(n)
	{	1: "Il file di gioco @`e intatto.";
		2: "Il file di gioco non @`e stato verificato come intatto, e potrebbe essere danneggiato.";
	}

	ScriptOn: switch(n)
	{	1: "La trascrizione @`e gi@`a attivata.";
		2: "Inizio della trascrizione di ";
		3: "@`E fallito il tentativo di iniziare la trascrizione.";
	}

	ScriptOff: switch(n)
	{	1: "La trascrizione @`e gi@`a disattivata.";
		2: "^Fine della trascrizione.";
		3: "@`E fallito il tentativo di terminare la trascrizione";
	}

	NotifyOn: "Notifica del punteggio attivata.";
	
	NotifyOff: "Notifica del punteggio disattivata.";

	Places: print "Hai gi@`a visitato: ";

	Objects: switch(n)
	{	1: "Oggetti posseduti:^";
		2: "Nessuno.";
		3: print "   (indossat", (genderandnumber) x1, ")";
		4: print "   (in tuo possesso)";
		5: print "   (dat", (genderandnumber) x1, " via)";
		6: print "   (si trova ", (name) x1, ")";
		7: print "   (ne", (whomorwhich1) x1, " ", (name) x1, ".)";
		8: print "   (dentro ", (the) x1, ")";
		9: print "   (sopra ", (the) x1, ")";
		10: print "   (pers", (genderandnumber) x1, ")";
	}

	Score: 
		if (deadflag) print "In questa partita hai totalizzato ";
		else print "Finora hai totalizzato ";
		print score;
		if (score == 1) print " punto"; else print " punti";
		print " su ", MAX_SCORE, " possibili, in ", turns, " turn";
		if (turns == 1) print "o"; else print "i";
		return;
	

	FullScore: switch(n)
	{	1: if (deadflag) print "Il punteggio era ";
		   else print "Il punteggio @`e ";
		   "cos@`i composto:^";
		2: "in  vari oggetti trovati";
		3: "visitando vari luoghi";
		4: print "in totale (su ", MAX_SCORE; " possibili)";
	}

	Inv: switch(n)
	{	1: "Non stai portando niente.";
	    2: print "Stai portando";
	}

	Take: switch(n)
	{	1: "Pres", (genderandnumber) noun, ".";
		2: "Sei sempre il possessore di te stesso.";
		3: print "Non credo che ", (the) x1, " abbia";
		   if (x1 has pluralname) print "no";
		   " intenzione di farsi prendere in braccio.";
		4: print "Dovresti toglierti da ";
		   if (x1 has supporter) print "sopra "; else print "dentro ";
		   print_ret (the) x1, " prima.";
		5: "Gi@`a l", (genderandnumber) x1, " possiedi.";
		6: if (noun has pluralname) print "Sembrano appartenere ";
		   else print "Sembra che appartenga ";
		   "a ", (the) x1, ".";
		7: if (noun has pluralname) print "Sembrano ";
		   else print "Sembra ";
		   "essere parte di ", (the) x1, ".";
		8: if (x1 has pluralname) print_ret (Cthatorthose) x1, " non sono disponibili.";
		   else print_ret (Cthatorthose) x1, " non @`e disponibile.";
		9: print (The) x1, " non  ", (isorare) x1, "apert", (genderandnumber) x1, ".";
		10: print (The) x1;
			if (x1 has pluralname) print_ret " sono difficilmente trasportabili.";
			else print_ret " @`e difficilmente trasportabile.";
		11: if (x1 has pluralname) print_ret "Sono fiss", (genderandnumber) x1, " al loro posto.";
			else print_ret "@`E fiss", (genderandnumber) x1, " al suo posto.";
		12: "Stai trasportando gi@`a troppe cose.";
		13: "(metti ", (the) x1, " dentro ", (the) SACK_OBJECT, " per fare spazio)";
	}

	Drop: switch(n)
	{	1: print_ret (The) x1, " ", (isorare) x1, " gi@`a posat", (genderandnumber) x1, " qui.";
		2: "Non possiedi ", (thatorthose) x1, ".";
		3: "(Prima ti togli ", (the) x1, ")";
		4: "Posat", (genderandnumber) x1, ".";
	}

	Remove: switch(n)
	{	1: if (x1 has pluralname) print "Sono "; else print "@`E ";
		   " chius", (genderandnumber) x1, ".";
		2: if (x1 has pluralname) print "Ma non sono"; else print "Ma non @`e";
		   " l@`i ora.";
		3: "Rimoss", (genderandnumber) x1, ".";
	}

	PutOn: switch(n)
	{	1: "@`E necessario che tu possieda ", (the) x1, " prima di poterl", (genderandnumber) x1, " mettere sopra ", (the) second, ".";
		2: "Non puoi mettere qualcosa su se stessa.";
		3: "Mettere cose sopra ", (the) x1, " non porter@`a a niente.";
		4: "Manchi di destrezza.";
		5: "(prima ", (itorthem) x1, " lasci)^";
		6: "Non c'@`e pi@`u spazio sopra ", (the) x1, ".";
		7: "Fatto.";
		8: "Hai messo ", (the) x1, " sopra ", (the) second, ".";
	}

	Insert: switch(n)
	{	1: "@`E necessario che tu possieda ", (the) x1, " prima di poterl", (genderandnumber) x1, " mettere dentro ", (the) second, ".";
		2: if (x1 has pluralname) print_ret (Cthatorthose) x1, " non sono contenitori.";
		   else print_ret (Cthatorthose) x1, " non @`e un contenitore.";
		3: print_ret (The) x1, " ", (isorare) x1, " chius", (genderandnumber) x1, ".";
		4: "Sar@`a necessario che tu ", (itorthem) x1, " lasci prima.";
		5: "Non puoi mettere una cosa dentro se stessa.";
		6: "(prima ", (itorthem) x1, " lasci)^";
        7: "Non c'@`e pi@`u spazio dentro ", (the) x1, ".";
		8: "Fatto.";
		9: "Hai messo ", (the) x1, " dentro ", (the) second, ".";
	}

	EmptyT: switch(n)
	{	1: if (x1 has pluralname) print_ret (The) x1, " non sono contenitori.";
		   else print_ret " non @`e un contenitore.";
	    2: print_ret (The) x1, " ", (isorare) x1, " chius", (genderandnumber) x1, ".";
		3: print_ret (The) x1, " ", (isorare) x1, " gi@`a vuot", (genderandnumber) x1, ".";
		4: "In questo modo probabilmente non svuoteresti nulla.";
	}

	Give: switch(n)
	{	1: "Non possiedi ", (the) x1, ".";
		2: "Vuoi dare ", (the) x1, " a te stesso? Non ti seguo.";
		3: print (The) x1;
		   if (x1 has pluralname) print " non sembrano";
		   else print " non sembra";
		   " interessat", (genderandnumber) x1, ".";
	}

	Show: switch(n)
	{	1: "Non possiedi ", (the) x1, ".";
		2: print (The) x1;
		   if (x1 has pluralname) print " non sembrano";
		   else print " non sembra";
		   " interessat", (genderandnumber) x1, ".";
	}

	Enter: switch(n)
	{   1: print "Ma gi@`a sei ";
		   if (x1 has supporter) print "sopra "; else print "dentro ";
		   print_ret (the) x1, ".";
		2: if (x1 has pluralname) print "Non sono"; else print "Non @`e";
		   print " qualcosa ";
		   switch (verb_word)
		   {	'stai': "su cui poter stare.";
				'sta': "su cui poter stare.";
				'sdraiati': "su cui ti puoi sdraiare.";
				'siediti': "su cui ti puoi sedere.";
				'siedi': "su cui ti puoi sedere.";
				default: "in cui puoi entrare.";
			}
		3: "Non puoi entrare dentro ", (the) x1, "chius", (genderandnumber) x1, ".";
		4: "Puoi entrare solo in qualcosa di libero.";
		5: print "Ti trovi ";
		   if (x1 has supporter) print "sopra "; else print "dentro ";
		   print_ret (the) x1, ".";
		6: print "(ti togli da ";
		   if (x1 has supporter) print "sopra "; else print "dentro ";
		   print (the) x1; ")";
		7: if (x1 has supporter) "(sali sopra ", (the) x1, ")^";
		   if (x1 has container) "(entri dentro ", (the) x1, ")^";
		   "(entri dentro ", (the) x1, ")^";
	}

	GetOff: "Ma non sei sopra ", (the) x1, " in questo momento.";

	Exit: switch(n)
	{	1: "Esci? E da dove? Dovresti spiegarti meglio.";
		2: "Non puoi uscire fuori, ", (the) x1, " ", (isorare) x1, " chius", (genderandnumber) x1, ".";
		3: print "Sei ";
		   if (x1 has supporter) print "sceso "; else print "uscito "; print_ret (artda) x1, ".";
	}

	VagueGo: "Dovresti indicare l'esatta direzione in cui vuoi andare.";

	Go: switch(n)
	{	1: print "Dovresti toglierti da ";
		   if (x1 has supporter) print "sopra "; else print "dentro ";
		   print_ret (the) x1, " prima.";
		2: "Non puoi andare in quella direzione.";
		3: "Non riesci a salire sopra ", (the) x1, ".";
		4: "Non riesci a scendere da sopra ", (the) x1, ".";
		5: "Non puoi, ", (the) x1, " ", (isorare) x1, " in quella direzione.";
		6: print "Non puoi, ", (the) x1;
		   if (x1 has pluralname) print " non conducono ";
		   else print " non conduce ";
		   "da nessuna parte.";
	}

	LMode1: " @`e ora in modalit@`a ~normale~, che d@`a descrizioni 
			lunghe per i luoghi mai visitati prima e brevi se gi@`a visitati.";
	
	LMode2: " @`e ora in modalit@`a ~completa~, che d@`a descrizioni
			lunghe per tutti i luoghi (anche se gi@`a visitati).";
	
	LMode3: " @`e ora in modalit@`a ~breve~, che d@`a descrizioni
			brevi per tutti i luoghi (anche se mai visitati).";

	Look: switch(n)
	{	1: print " (sopra ", (the) x1, ")";
		2: print " (dentro ", (the) x1, ")";
		3: print " (come "; @print_obj x1; print ")";
		4: print "^Sopra ", (the) x1;
           WriteListFrom(child(x1), ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
           ".";
		default: 
			if (x1~=location)
			{	if (x1 has supporter) print "^Sopra ";
				else print "^Dentro ";
				print (the) x1, " puoi";
			}
			else print "^Puoi";
            if (n==5) print " anche"; 
			print " vedere ";
            WriteListFrom(child(x1), ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
			if (x1~=location) ".";
			" qui.";
	}

	Examine: switch(n)
	{	1: "Oscurit@`a, sost. femminile . Assenza della luce necessaria per vedere. Buio. Tenebre.";
		2: "Esamini ", (the) x1, ", ma non noti niente di speciale.";
		3: print (The) x1, " ", (isorare) x1;
		   if (x1 has on) " acceso", (genderandnumber) x1, ".";
		   else " spent", (genderandnumber) x1, ".";
	}

	LookUnder: switch(n)
	{	1: "Ma @`e buio.";
		2: "Non trovi niente di interessante.";
	}

	Search: switch(n)
	{	1: "Ma @`e buio.";
		2: "Non c'@`e niente sopra ", (the) x1, ".";
		3: print "Sopra ", (the) x1, " vedi ";
		   WriteListFrom(child(x1), TERSE_BIT + ENGLISH_BIT + CONCEAL_BIT);
		   ".";
		4: "Non hai trovato niente di interessante.";
		5: "Non puoi vedere dentro, perch@'e ", (the) x1, " ", (isorare) x1, " chius", (genderandnumber) x1, ".";
		6: print_ret (The) x1, " ", (isorare) x1, " vuot", (genderandnumber) x1, ".";
		7: print "Dentro ", (the) x1, " vedi ";
		   WriteListFrom(child(x1), TERSE_BIT + ENGLISH_BIT + CONCEAL_BIT);
		   ".";
	}

	Unlock:  switch(n)
    {	1: "Cerca un'altra soluzione.";
		2: " Non ", (isorare) x1, " chius", (genderandnumber) x1, " a chiave in questo momento.";
		3: if (x1 has pluralname) print "Non sembrano ";
		   else print "Non sembra ";
		   "entrare nella serratura.";
		4: "Ora hai aperto ", (the) x1, ".";
	}

	Lock: switch(n)
	{	1: if (x1 has pluralname) print "Non sembrano ";
		   else print "Non sembra ";
		   "essere qualcosa che possa essere chiusa a chiave.";
		2: print_ret (cisorare) x1, "chius", (genderandnumber) x1, " a chiave in questo momento.";
		3: "Prima dovresti chiudere ", (the) x1, ".";
		4: if (x1 has pluralname) print "Non sembrano ";
		   else print "Non sembra ";
		   "entrare nella serratura.";
		5: "Ora hai chiuso a chiave ", (the) x1, ".";
	}

	SwitchOn: switch(n)
	{	1: "Non puoi accendere ", (the) x1;
		2: print_ret (cisorare) x1, " gi@`a acceso", (genderandnumber) x1, ".";
		3: "Hai acceso ", (the) x1, ".";
	}

	SwitchOff: switch(n)
	{	1: "Non puoi spegnere ", (the) x1;
		2: print_ret (cisorare) x1, " gi@`a spent", (genderandnumber) x1, ".";
		3: "Hai spento ", (the) x1, ".";
	}

	Open: switch(n)
	{	1: "Non puoi aprire ", (the) x1;
		2: if (x1 has pluralname) print "Sembrano ";
		   else print "Sembra ";
		   "essere chius", (genderandnumber) x1, " a chiave.";
		3: print_ret (cisorare) x1, " gi@`a apert", (genderandnumber) x1, ".";
		4: print "Hai aperto ", (the) x1, ", trovando ";
		   if (WriteListFrom(child(x1), ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0) "un bel nulla.";
		   ".";
		5: "Ora hai aperto ", (the) x1, ".";
	}
	
	Close: switch(n)
	{	1: "Non puoi chiudere ", (the) x1;
		2: print_ret (cisorare) x1, " gi@`a chius", (genderandnumber) x1, ".";
		3: "Ora hai chiuso ", (the) x1, ".";
	}

	Disrobe: switch(n)
	{   1: "Non ", (itorthem) x1, " stai indossando.";
		2: "Ti sei tolto ", (the) x1, ".";
	}

	Wear: switch(n)
	{   1: "Non ", (itorthem) x1, " puoi indossare!";
		2: "Non ", (itorthem) x1, " possiedi!";
		3: print_ret (citorthem) x1, " stai gi@`a indossando!";
		4: "Hai indossato ", (the) x1, ".";
	}
	
	Eat: switch(n)
	{	1: if (x1 has pluralname) print_ret (cisorare) x1, " praticamente immangiabili";
		   else print_ret (cisorare) x1, " praticamente immangiabile.";
		2: "Mangi ", (the) x1, ". Niente male.";
	}

	Yes, No: "Era una domanda retorica.";

	Burn: "Con questo atto pericoloso non concluderai niente";

	Pray: "Sembra che le tue preghiere non siano state esaudite.";

	Wake: "Questo non @`e un sogno, @`E la spaventosa verit@`a.";

	WakeOther: "Non sembra necessario."; 
	
	Kiss: "Concentrati sul gioco.";

	Think: "Questa si che @`e una buona idea.";

	Smell: "Non senti alcun odore particolare.";
	
	Listen: "Non si sente niente di particolare.";

	Taste: "Nessun sapore particolare.";

	Touch: switch(n)
	{	1: "Tieni lontane le tue mani!";
		2: "Non succede niente di particolare.";
		3: "Se pensi che ci@`o sia utile.";
	}

	Dig: "Scavare non serve a niente qui.";

	Cut: "Tagliar", (itorthem) x1, " a pezzi servir@`a a poco.";

	Jump: "Salti sul posto, senza risultato.";
	
	JumpOver, Tie: "Non raggiungerai niente con questo.";

	Drink: "Non c'@`e niente che puoi bere qui.";
	
	Fill: "Ma non c'@`e acqua qui da trasportare.";

	Sorry: "Oh, non scusarti.";

	Strong: "I veri avventurieri non usano un simile linguaggio.";

	Mild: "Proprio cos@`i.";

	Attack: "La violenza non @`e la giusta risposta a questo.";

	Swim: "Non c'@`e abbastanza acqua in cui poter nuotare.";

	Swing: "Non c'@`e niente da poter scuotere qui.";

	Blow: "Non c'@`e niente di utile nel distrugger", (itorthem) x1, ".";

	Rub: "Non otterrai niente con questo.";

	Set: "No, non puoi metter", (itorthem) x1, ".";

	SetTo: "No, non puoi impostarl", (itorthem) x1, " a nulla.";

	WaveHands: "Ti agiti, sentendoti stupido.";

	Wave: switch(n)
	{	1: "Ma non ", (itorthem) x1, " possiedi.";
		2: "Sembri ridicolo, agitando ", (the) x1, ".";
	}

	Pull, Push, Turn: switch(n)
	{	1: print "", (cisorare) x1, " fiss", (genderandnumber) x1, " al ";
		   if (x1 has pluralname) print "loro";
		   else print "suo";
		   " posto.";
		2: "Non sei capace di farlo.";
		3: "Non succede niente di particolare.";
		4: "Questo sarebbe meno che cortese.";
	}

	PushDir: switch(n)
	{	1: "Questo @`e il meglio che ti viene in mente?";
		2: "Non @`e una direzione.";
		3: "Non puoi in quella direzione.";
	}

	Squeeze: switch(n)
	{	1: "Tieni lontane le tue mani.";
		2: "Non hai ottenuto niente con questo.";
	}

	ThrowAt: switch(n)
	{	1: "Senza successo.";
		2: "Al momento cruciale ti saltano i nervi.";
	}

	Tell: switch(n)
	{	1: "Stai parlando a te stesso.";
		2: "Proprio nessuna reazione.";
	}

	Answer, Ask: "Nessuna risposta.";

	Buy: "Non c'@`e niente in vendita.";
	
	Sing: "Sei stonatissimo.";

	Climb: "Non penso si possa raggiungere qualcosa da qui.";
	
	Wait: "Il tempo passa.";

	Sleep: "Non sei per niente assonnato.";

	Consult: "Non hai scoperto niente di interessante, consultando ", (the) x1, ".";

	GenericVerb: "Cosa vuoi fare? Potresti essere pi@`u preciso?";
	
];

! ---------------------------------------------------------------------------
