/*
 * 	sample.t				version 2.0
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *	Demonstration game for the doorItem class
 *
 *  This file requires HTML TADS 2.3.0 or later and dooritem.t version 2.0.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		31-Mar-99:	Creation.
 *		10-Jun-99: 	Added reference to the door's condition in the room
 *					description.
 */

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

#include    <adv.t>         // Adventure Library
#include	<std.t>			// Standard definitions required by the system & library
#include	<dooritem.t>	// The doorItem class definition and function.

/*
 *	Notice that the room directions point to the doorItem object.
 *	This allows us to create doors without having to code the complexities
 *	of TADS doorways.
 */
startroom: room
	sdesc = "Outside Cave"
	ldesc = "This room demonstrates a doorItem. <<woodenDoor.isopen ? "The 
		wooden door stands open" : "A wooden door leads south">>."
	south = woodenDoor
	in = woodenDoor
;


cave: room
	sdesc = "Cave"
	ldesc = "This room introduces a lockableDoorItem. 
		<<woodenDoor.isopen ? "The wooden door 
		stands open" : "There is an exit to the north">>. 
		To the west you see a massive stone door<<stoneDoor.islocked ? 
		", which appears to be locked." : ".">>"
	north = woodenDoor
	out = woodenDoor
	west = stoneDoor
;

key: keyItem
	location = cave
	sdesc = "key"
	noun = 'key'
;

greatHall: room
	sdesc = "Great Hall"
	ldesc = "The expanse stretches out before you, a massive underground chamber
		that stretches as far as the eye can see. There is a massive stone door
		leading east. <<stoneDoor.islocked ? "The door is locked" : "The door 
		is unlocked">>."
	east = stoneDoor
;

/*
 *	Notice that doorItem and lockableDoorItem are coded as a single object. 
 *	They do not have locations (as this is assigned by the doorItem class), but 
 *	have a foundIn list that should contain the locations you want to have the 
 *	doorways in. 
 *
 *	Two doorways will be dynamically created from this door object and will 
 *	be assigned their doordest and otherside, along with all the vocabulary and 
 *	sdesc properties.
 *
 *	Also, the location properties that point to this object will be modified by
 *	the doorItem class to point to the dynamically created doorways. Any
 *	reference made to the door's open or locked state will be accurately
 *	reflected by the doorItem object. Hence there is no need to reference the
 *	individual doorways.
 */
woodenDoor: doorItem
	sdesc = "wooden door"
	noun = 'door'
	adjective = 'wooden' 'oak'
	foundIn = [ startroom cave ]
;

stoneDoor: lockableDoorItem
	sdesc = "stone door"
	noun = 'door'
	adjective = 'stone' 'carved' 'massive'
	mykey = key
	foundIn = [ cave greatHall ]
;

replace commonInit: function
{
	/*
	 *	createMulitloc() should be coded with the (), for some reason both
	 *	init() and commonInit() require this. Coding createMultiloc() in the
	 *	preinit() gives a stack overflow, due to the dynamic object creation. It
	 *	may be possible to avoid this by increasing memory, but it works fine
	 *	here.
	 */
	createMultiloc();
	"\H+";
}
;
