#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "AHA.h"

/* 
 *   demon.t
 *
 *   The code for the workdemon NPC encountered at the gates of hell.
 */

demon : PresentLater, Person 'workdemon/demon*demons' 'demon' @woodenLadder
    "The demon is dressed in workdemon's blue overalls, with the letters DISS
    DISTRICT COUNCIL stamped across the back. His tail pokes out through the
    back of the overalls, and joins his cloven hooves in steadying him on the
    ladder. His horns look a little shabby, as might be expected on a labouring
    demon, but his face is suitably gargoylish, complete with fiendish grin and
    glowing red eyes. "
    isHim = true
    postureDesc() { }
    uselessToAttackMsg = 'You look at those hooves and horns, and the tough
        demonic frame, and decide that you <i>really</i> don\'t want to provoke
        him. '
    cannotKissActorMsg = 'You\'d like that even less than he would. '
    cannotTakeMsg = 'You hardly want to be seen wandering around with a demon
        tucked under your arm. Besides, he looks too big for you to carry --
        and he doesn\'t exactly look like the cuddly, cosy sort of demon that
        would be happy to be picked up by a passing stranger. '
    feelDesc = "You don't fancy touching him, and you suspect he wouldn\'t
        appreciate it either. "
    initiallyPresent = true
    plKey = 'demon'
    cutNoEffectMsg = (uselessToAttackMsg)
;

+ Noise 'loud banging hammering/sound' 'hammering'
    soundPresence = (demon.curState == demonWorking)
    emanationHereDesc()
    {
        if(soundPresence)      
            inherited;
    }
    sourceDesc = "<<gActionIs(ListenTo) ? 'You hear the demon hammering away at
        the inscription. ' : nil>>"
    descWithSource = "It's the sound of the demon hammering away at the
        inscription. "
    hereWithSource = "There's a loud banging sound, made by the demon hammering
        away at the inscription. "
    displaySchedule = [1, 2, 4, 8]
;

+ SimpleOdor 'faint whiff sulphur/sulfur' 'faint whiff of sulphur'
    "There's a faint whiff of sulphur about the demon. "
;

+ demonTail: Component 'forked tail*tails' 'forked tail'
    "It\'s just the standard kind of forked tail you'd expect to see on a
    demon. "
    dobjFor(Pull)
    {
        verify() { illogical('How would you like it if someone pulled yours?
            Anyway, you assume it would annoy him more than you care to. '); }
    }
;

+ Decoration 'blue faded worn workdemon\'s overalls*coveralls' 'blue overalls'
    "They look a bit worn, if not rather faded. The words DISS DISTRICT COUNCIL
    can still be seen clearly stamped on the back, however. "
    notImportantMsg = 'It would probably be wiser to leave them alone. '
    isPlural = true
;

+ demonHooves: Component 'cloven hoof/hooves/hoofs' 'cloven hooves'
    "As you\'d expect, the demon's hooves look rather like goat's hooves. "
    isPlural = true
;

+ Component 'shabby stubby pair/horn*horns' 'horns'
    "The demon sports a pair of stubby horns protruding from the top of his
    head, one on each side. "
    isPlural = true
;

+ Component 'gargoylish ugly grotesque gargoyle face/head*faces*heads' 
    'demon\'s face'
    "The demon's face is grotesquely ugly -- almost comically so. "
;

++ Component 'fiendish amused (friendly) grin/mouth*mouths*grins' 'fiendish grin'
    "The demon\'s mouth seems fixed in a permanent grin, which could be
    interpreted as friendly, amused, or simply fiendish. "
;

++ Component 'glowing red eyes' 'glowing red eyes'
    "The demon's eyes seem to have a red glow all of their own, and not simply
    as a reflection of the light from the brazier. "
    isPlural = true
;


+ demonTalking: InConversationState
    specialDesc = "The demon is standing on top of the ladder, looking down at
        you, loosely grasping his tools. "
    stateDesc = "He's looking down at you from the top of his ladder. "
    afterAction()
    {
        if(gActionIs(Yell))
            "<.p><q>There's no need to shout, mate, I can hear you perfectly
            well from up here,</q> the demon assures you.<.p>";
        inherited;
    }
;

++ demonWorking: ConversationReadyState
    isInitState = true
    specialDesc = "A workdemon is standing on top of the ladder, chiselling
        away at the lettering above the gate, but seemingly making very slow
        progress in removing it. So far as you can see he's still chipping away
        at the final E that's no longer there. "
    stateDesc = "He's standing on the ladder slowly chipping away at the
        lettering over the gate. "
    afterAction()
    {
        if(gActionIs(Yell))
            getActor.initiateConversation(demonTalking, 'yell-demon');
        inherited;  
    }
;

+++ HelloTopic, StopEventList
    [ 
        '<q>Hello there!</q> you call up at the demon.\b
        The demon looks down from the ladder and gives you a cheery wave,
        <q>Why, hello mate!</q> he replies, <q>I don\'t see many folk round
        here these days!</q><.reveal demon-speak>',
        
        '<q>Hello again!</q> you call.\b
        The workdemon lowers his tools once more, seemingly glad of the excuse
        for doing so, <q>Oh, hello, it\'s you again, old mate!</q> he beams. '
    ]
;

+++ ImpByeTopic
    "The demon turns back to the lintel and resumes slowly chipping away at the
    lettering.<.p>"
;

+++ ByeTopic
    "<q>Cheerio, then,</q> you say, <q>I must be off.</q><.p>
    <q>Have a nice day!</q> the demon replies, returning to his labours.<.p>"
;

++ AskTopic, StopEventList, SuggestedAskTopic @tDemythologization
    [
        {: "<q>What\'s all this about demythologization?</q> you ask.<.p>
            In reply, the demon starts to warble:\n
            <q>Hark, the herald angels sing:\n
            <q>Bultmann is the latest thing!</q>\n
            Or they would if he had not\n
            demythologized the lot!\b
            Unfortunately the demythologization didn\'t stop with the
            angels,</q> he adds darkly, <q>Most of me best mates have been
            demythologized. Terrible, terrible.</q>" },
        
        '<q>Is demythologization so very terrible for a demon?</q> you
        wonder.<.p>
        <q>Ghastly,</q> he assures you, <q>I mean, it would be bad enough if
        you were demythologized into a terrorist or a tax-collector or
        something suitably nasty like that, but I\'ll probably be
        transmogrified into Market Forces or Marxist Ideology -- something
        abstract and impersonal. What kind of reward is that for centuries of
        faithful service to hell?</q> He shakes his head, <q>Terrible!</q> he
        repeats. '
    ]
    name = 'demythologization'
    isActive = gRevealed('demyth')
;

++ AskTellTopic, SuggestedAskTopic, StopEventList @distantGlow
    [
        '<q>What\'s that distant golden glow I can see across the chasm to the
        west?</q> you ask.\b
        <q>Ah,</q> he nods knowingly, <q>the golden glow. It\'s a long time
        since I\'ve heard tell of that golden glow, but time was when all sorts
        of people fell under its spell.</q>',
        
        '<q>What <i>is</i> that golden glow?</q> you want to know, <q>sometimes
        it looks like some glorious heavenly city, but it won\'t stay in focus
        -- so what is it?</q>\b
        <q>I\'ve no idea, mate, I\'ve never been there,</q> he shrugs. ',
        
        '<q>Do you know if anyone has ever found a way to that golden glow?</q>
        you ask.\b
        <q>Not that I know of,</q> he replies, <q>at least, no one\'s ever come
        back to tell the tale. But there could be several reasons for that,
        couldn\'t there? I mean, it could be that you simply can\'t get there,
        or it could be that it\'s so dangerous that everyone who tries comes to
        a sticky end, or it could mean that the golden glow is so wonderful
        that when you get there you just don\'t want to come back. So, mate,
        you pays your money and you takes your choice.</q>',
        
        '<q>Is there anything else you can tell me about that distant golden
        glow?</q> you ask.\b
        <q>Not really, mate, I\'ve told you all I know,</q> the demon replies,
        <q>I\'ve never been there, and I don\'t know anyone who has.</q>'
        
    ]
    name = 'the distant golden glow'  
;

++ AskTellGiveShowTopic, SuggestedAskTopic, StopEventList [knife, wintryTree]
    [
        '<q>I found this knife stuck into the side of a tree, up on a terrace
        overlooking the chasm,</q> you remark.\b
        <q>So?</q> the demon replies.\b
        <q>So I was wondering how it got there,</q> you say.\b
        <q>Nothing to do with me, mate!</q> he shrugs. ',
        
        '<q>It looks as if the knife I found in the tree may have been used to
        cut the rope bridge,</q> you point out.\b
        <q>Well, mate, you get all sorts round here -- at least we used to,</q>
        the demon observes, <q>and not a few of the more unsavoury sorts, if
        you take my meaning, so I suppose it\'s not too surprising to come
        across the odd act of mindless vandalism.</q>\b
        You wish you were better at reading demonic expressions, for something
        in the demon\'s eyes strikes you as especially shifty when he gives
        that reply. ',
        
        '<q>The knife in the tree looked a bit too calculated to be an act of
        <q>mindless vandalism</q>,</q> you remark, <q>can you think of any
        reason it might have got there?</q>\b
        <q>Not that I know of, mate,</q> he shrugs, <q>I don\'t go wandering
        round there, see -- my work\'s right here.</q>',
        
        '<q>So you know nothing about either the knife or the tree?</q> you
        ask.\b
        <q>That\'s right, mate, nothing,</q> he agrees, perhaps a little too
        readily. '     
        
    ]
    name = 'the knife'
;

+++ AltTopic
    "<q>I've just come across something rather strange -- this knife stuck into
    a tree!</q> you declare.\b
    <q>You\'ll come across all sorts of strange things round here, mate,</q>
    the demons shrugs, <q>you\'re not in normal life now, you know!</q>
    <<advanceTopic()>>"
    isActive = !ropeBridge.described
    advanceTopic()
    { 
        location.curScriptState = 2;
    }
;

++ AskTellTopic @tAnnihilation
    "<q>Why has total annihilation become so popular?</q> you want to know.\b
    <q>Good question, mate!</q> the demon replies, <q>They say it's meant to be
    a less painful method of punishment, but why <i>that</i> makes it a good
    thing beats me!</q> "
    isActive = gRevealed('annihilation')
;

++ AskTellTopic, SuggestedAskTopic @pipeCable
    "<q>There's a wire cable stretched across the inside of that pipe to the
    east,</q> you observe, <q>any idea what it's for?</q>\b
    <q>Yep -- I remember installing it myself,</q> he replies briskly, <q>it's
    to keep people out, see; after all, that's a flue pipe, and even when the
    boiler was first installed we didn\'t want anyone getting fried by
    <i>accident</i>.</q><<gSetKnown(boiler)>>"   
    name = 'the thin wire cable'
;

++ AskTellTopic, SuggestedAskTopic @chasm
    "<q>Is there a way over that lava-filled chasm?</q> you ask.\b
    <q>Not that I know of,</q> the demon tells you, <q>As I understand it, the
    chasm is there to stop people getting to the other side.</q>"
    name = 'the chasm'
;

++ AskTellTopic, SuggestedAskTopic @ropeBridge
    "<q>There's a broken rope-bridge that crosses the chasm,</q> you tell
    him.\b
    <q>It's probably a trap, mate,</q> the demon opines, <q>designed to pitch
    people into the chasm if they're stupid enough to try to cross. No one's
    <i>meant</i> to cross that chasm, I'm sure of that.</q>"
    name = 'the rope bridge'
;

+++ AltTopic, SuggestedAskTopic
    "<q>The rope-bridge across the chasm looks like it's been deliberately cut
    to make it unusable,</q> you remark.\b
    <q>Well, that would be one reason for cutting it, certainly,</q> the demon
    agrees." 
    name = 'the rope bridge'
    isActive = ropeBridge.described
;


++ AskTopic, SuggestedAskTopic @tGod
    "<q>Tell me, do you believe in God?</q> you enquire.\b
    <q>And shudder!</q> he shudders. "
    name = 'God'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @pipe
    [
        {: "<q>What\'s that pipe sticking out of the hillside to the east?</q>
            you wonder,\b
            <q>Pipe? Pipe?</q> the workdemon queries, <q>Oh, you mean the old
            flue pipe! Oh, that brings back memories! It\'s the flue pipe for
            the old boiler -- I remember helping to service it once myself --
            but it hasn\'t been used for, ooh, let me see, well over a century,
            I reckon.</q><<gSetKnown(boiler)>>" },
        
        '<q>So that pipe to the east is a disused flue pipe?</q> you ask.\b
        <q>That\'s right, mate,</q> the demon confirms. '
    ]
    name = 'the pipe'
;

++ AskTopic, SuggestedAskTopic @boiler
    "<q>What's this about a boiler?</q> you ask.\b
    <q>We used to use it to keep hell nice and hot,</q> he tells you, <q>until
    the meddlers came along and said that wasn't Theologically
    Correct.</q><.reveal meddlers>"
    name = 'the boiler'
;

++ AskTopic @gPlayerChar
    "<q>What am I doing here?</q> you want to know.\b
    The demon frowns thoughtfully for a moment, then replies, <q>Talking
    to me!</q>. "
;

++ AskAboutForTopic @woodenLadder
    "<q>Is there any chance I could borrow that ladder?</q> you enquire.\b
    <q>No, there isn't,</q> grunts the demon, <q>sorry, mate, but I'm using it,
    as you can see.</q>"
;



++ AskTopic, StopEventList, SuggestedAskTopic @tHell
    [
        '<q>What\'s happened to hell?</q> you ask, nodding towards the sign on
        the gate.<.p>
        <q>Closed for good, mate.</q> he informs you sadly, <q>So if it\'s
        eternal torment you\'re after, you\'re out of luck, I\'m afraid.
        Apparently it\'s no longer Theologically Correct.</q>',
        
        '<q>So what happened to all the people in hell?</q> you wonder.<.p>
        <q>Well, they were all shipped out, decades ago.</q> he tells you,
        <q>Rumour has it that some of them were snuffed out altogether -- gone,
        obliterated, just like that. Horrible, if you ask me, but apparently
        total annihilation has become all the rage. As for the rest, who
        knows?</q> he shrugs.<.reveal annihilation>',
        
        '<q>So hell\'s closed for good?</q> you ask.\b
        <q>Closed for good,</q> he affirms sadly, with a tear glistening in his
        demonic little eye, <q>These fine old gates will never open again!</q>'
    ]
    name = 'hell'
;

++ AskTopic, StopEventList, SuggestedAskTopic @tHeaven
    [
        '<q>How do you get to heaven from here?</q> you ask.\b
        <q>Heaven?</q> he repeats, <q>What would I know about heaven? I\'m just
        an ordinary working demon. Besides, if there ever was a heaven, I
        expect it\'s been demythologized by now.</q><.reveal demyth>',
        
        '<q>So there\'s no way I can get to heaven?</q> you enquire.\b
        <q>Well, it probably wouldn\'t be too much fun if you could,</q> the
        demon muses, <q>All that sickening morality and piety, day upon day of
        hymning the glory of God, and having to smile and be happy and nice to
        everyone all the time. The very thought of it\'s enough to make an
        honest demon weep. If you ask me, you\'re well out of it, mate.</q>',
        
        '<q>So you reckon heaven\'s not all it\'s cracked up to be,</q> you
        surmise.\b
        <q>Dead right, mate,</q> the demon concurs, <q>besides, like I said,
        it\'s probably been demythologized by now.</q>'   
    ]
    name = 'heaven'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @studdedGate
    [
        '<q>This gate appears to be closed,</q> you remark.\b
        <q>That\'s right, mate,</q> the demon agrees, <q>firmly and finally
        closed.</q>',
        
        '<q>Will this gate ever be opened?</q> you wonder.\b
        <q>Not so far as I know,</q> he replies, <q>Mind you, I wouldn\'t be so
        keen to get through it if I were you, mate. Hell\'s not all it\'s
        cracked up to be -- it just hasn\'t been the same since the bleeding
        heart liberals abolished corporal punishment for the Damned -- not
        Theologically Correct, apparently.</q>',
        
        '<q>So this gate\'s permanently closed now?</q> you surmise.\b
        <q>Permanently,</q> the demon affirms. '  
    ]
    name = 'the gate'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @tSatan
    [
        '<q>Is Satan around anywhere?</q> you ask.\b
        <q>Don\'t ask,</q> he replies, <q>you don\'t want to meet
        <i>him</i></q>.',
        
        '<q>Have you ever met Satan?</q> you enquire.\b
        <q>Mercifully no,</q> he answers, <q>I\'m far too junior to mess with
        the boss.</q>',
        
        '<q>But Satan does exist?</q> you ask.\b
        <q>Oh yes,</q> he tells you, <q>he exists all too well!</q> ' 
    ]
    name = 'Satan'
;

++ AskTopic @tBultmann
    "<q>What do you know about Bultmann?</q> you ask.\b
    <q>Bultmann?</q> he echoes, <q>One of these intellectual theologian types.
    Way above my head. All I know is that most of my mates blame him for
    putting the final boot in round here. All that demythologization, you
    see.</q><.reveal demyth>"
;

++ AskTopic @felicity
    "<q>The last thing I saw before coming here was a woman called Felicity
    Hope,</q> you remark, <q>What do you suppose that means?</q>\b
    The demon's grin broadens as he taps the lettering with his chisel, <q>I
    reckon it means you've just abandoned her, mate!</q> he quips. "
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @tDeath
    [
        '<q>Am I dead? Is this death?</q> you ask.\b
        <q>Well, there\'s death and then there\'s <i>death</i>, if you catch my
        meaning,</q> the demon answers enigmatically. ',
        
        '<q>What\'s the difference between death and <i>death</i>?</q> you
        want to know.\b
        <q>Finality,</q> he replies briskly. '
    ]
    name = 'death'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic @tLife
    [
        '<q>Am I still alive?</q> you want to know, <q>I still seem to be
        conscious, and able to feel and think.</q>\b
        <q>If that\'s your definition of life, then you must be still alive,
        mate,</q> he replies.\b ',
        
        '<q>What\'s your definition of life?</q> you ask.\b
        <q>Ah well, mate, I\'m just an ordinary working demon, see? I never
        bother myself with abstract definitions.</q>',
        
        '<q>Is there any way I can return to life from here?</q> you inquire.\b
        <q>That depends what you mean by life, mate,</q> the demon replies
        enigmatically. '     
        
    ]
    name = 'life'
;


++ AskTopic @tMeddlers
    "<q>Who were these meddlers who said things weren\'t Theologically
    Correct?</q> you ask.\b
    <q>Meddlers,</q> grunts the demon, <q>diabolical meddlers, satanic
    bureaucrats.</q>" 
    isActive = (gRevealed('meddlers'))
;

++ DefaultTellTopic, ShuffledEventList
    [
        'The demon grins at your lurid account. ',
        
        'The demon listens attentively, obviously glad of the excuse not to get
        on with his work. ',
        
        'The demon nods understandingly. ',
        
        '<q>Is that so?</q> he asks, <q>Well, well!</q> ' 
    ]
;



++ sdTopic: SemiDefaultAskTopic, ShuffledEventList 
    eventList = 
    [
        {: "<q>What about <<gTopicText>>?</q> you ask.\b
            <q>What indeed?</q> he replies. " },
        
        {: "<q>What can you tell me about <<gTopicText>>?</q> you inquire.\b
            <q>Well, put it this way, mate,</q> he answers, <q>I'm just an
            ordinary working demon, so you can't be sure I know much about
            that, or that I'd give you an honest answer even if I did. I am a
            demon, after all!</q>" },
        
        {: "<q>Tell me about <<gTopicText>></q> you request.\b
            The demon ponders your request for a few moments, then grins
            fiendishly and replies, <q>No, I don't think I will!</q>" },
        
        {: "<q>What do you think about <<gTopicText>>?</q> you ask.\b
            <q>I'm just a demon, mate; I never think,</q> he replies,
            <q>thinking's for humans.</q> " },
        
        {: "<q>I'm looking for some information on <<gTopicText>></q> you
            announce.\b
            <q>Then I hope you find it, mate,</q> the demon replies, <q>but
            don't expect <i>me</i> to give it to you -- I'm a demon!</q> " } 
        
    ]  
;

++ DefaultAskTopic, ShuffledEventList
    [
        'You ask your question; the demon considers it for a moment and then
        replies, <q>I don\'t think I care to answer that right now!</q>',
        
        'The demon ponders your question but declines to answer. ',
        
        '<q>What can you tell me about...</q> you begin.\b
        <q>Look, mate,</q> he interrupts you, <q>I\'m not a flaming
        encyclopedia!</q>',
        
        '<q>I was hoping you could tell me something about...</q> you say.\b
        <q>Hoping?</q> the demon echoes, <q>Look mate, I may be removing this
        here inscription, but hope\'s totally out of place here, believe
        me!</q> '  
    ]
;


++ AskTellGiveShowTopic, StopEventList, SuggestedAskTopic @gateNotice
    [
        '<q>What\'s this notice on the gate all about?</q> you ask.\b
        <q>Like it says, mate,</q> he tells you, <q>Hell\'s closed for
        demythologization. And before you ask, no, there aren\'t any plans to
        open it again.</q><.reveal demyth>',
        
        '<q>Who put this notice here?</q> you ask.\b
        The demon looks round furtively, then replies in a tone as mysterious
        as it is sinister, <q>He who must be obeyed but never named!</q>'
    ]
    name = 'the notice'
;

++ AskTellTopic, StopEventList, SuggestedAskTopic [gateLettering, demon]
    [
        '<q>What are you doing with that lettering?</q> you ask, nodding up at
        the inscription over the gate.\b
        <q>Removing it,</q> the demon replies laconically. ',
        
        '<q>Why are you chiselling out that inscription?</q> you wonder.\b
        <q>Orders,</q> he tells you, <q>Apparently it\'s not Theologically
        Correct any more -- whatever that\'s supposed to mean.</q>',
        
        '<q>You don\'t seem to be making much progress with that lettering,</q>
        you observe critically.\b    
        <q>What\'s the hurry, mate?</q> he replies, <q>It\'s not as if I\'ve
        got a train to catch -- in fact I reckon I\'ve got all eternity!</q>',
        
        '<q>How long have you been chipping away at that inscription?</q> you
        ask<.p>
        <q>Oh, only about fifty years or so,</q> he replies, <q>I\'m in no
        hurry to be demythologized, you see, so I reckon I might as well take
        my time.</q> <.reveal demyth>'
    ]
    name = 'himself'
;

++ AskTellTopic, StopEventList @tE
    [
        '<q>What\'s happened to the final E on that inscription?</q> you ask.\b
        <q>I\'m removing it,</q> he replies.',
        
        '<q>It looks to me like the final E is entirely gone; so why are you
        still working on it?</q> you want to know.\b
        <q>I like to do a thorough job,</q> he tells you. ',
        
        '<q>It looks like you\'re taking forever over that final E!</q> you
        complain.\b
        <q>What\'s the hurry?</q> he replies, <q>I\'ve got twenty-eight letters
        to remove here and all eternity to do it in; one twenty-eighth of
        eternity is -- well, a jolly long time. Any time you think I\'ve spent
        more than one twenty-ninth of eternity on this one letter, let me know
        and I\'ll switch to the next!</q>',
        
        '<q>So you plan to spend one twenty-eighth of eternity on that final
        E?</q> you enquire.\b
        <q>That\'s right,</q> he grins. '  
    ]
;


++ AskTellTopic @tCorporalPunishment
    "<q>So, what kind of punishment did they use to have in Hell?</q> you
    ask.\b
    <q>Oh, all sorts of fun things,</q> the demon reminisces nostalgically,
    <q>flogging, boiling, amputation, racks, thumbscrews, red hot-pokers up
    people's posteriors -- but my personal favourite was flaying alive,</q> he
    shakes his head sadly, <q>but it\'s all gone now, of course.</q>"
;

++ AskTellTopic @tLiberals
    "<q>How on earth did any liberals come to affect the policy of Hell?</q>
    you wonder.\b
    <q>Well might you ask, mate,</q> the demon sighs, <q>I reckon it has to do
    with the Powers that Be not wanting to seem behind the times.</q>"
;

++ AskTellTopic @tDamned
    "<q>So what happens to the Damned these days?</q> you want to know.\b
    <q>Terrible, terrible!</q> the demon shakes his head, <q>I've heard all
    sorts of rumours you know, mate, and they're not nice, believe me!</q> he
    looks round furtively, then lowers his voice, staring at you with his red
    eyes glowing even more fiercely, <q>I hear tell that these days the damned
    go straight to <i>total annihilation</i>! Boom! Zap! Oblivion!
    Nothing!</q><.reveal annihilation> "
;

++ AskTopic @tTorment
    "<q>Wasn't eternal torment something pretty dreadful to inflict on
    people?</q> you ask.\b
    <q>Pretty dreadful, yes,</q> he agrees, <q>but then, mate, that's what the
    damned <i>deserved</i> and deep down that's what they really <i>wanted</i>
    -- so we used to get great job satisfaction out of giving it to them.</q>"
;

++ AskTopic @tMates
    "<q>So, what happened to your mates?</q> you ask.\b
    <q>Most of them got demythologized,</q> he replies sadly, <q>terrible, it
    was, terrible!</q><.reveal demyth>"
;

++ AskTopic @tTheology
    "<q>What is all this about theological correctness?</q> you ask.\b
    <q>How would I know?</q> he shrugs, <q>I'm just an ordinary working demon,
    not a theologian, for hell's sake!</q>"
;

++ AskTellTopic, StopEventList @tPerdition
    [
        '<q>So what\'s happened to perdition\'s flames?</q> you wonder.\b
        <q>They went out years ago, mate,</q> the demon shakes his head sadly,
        <q>Hell got upgraded, see?</q>',
        
        '<q>Hell without Perdition\'s Flames! Whatever next?</q> you wonder.\b
        <q>What indeed?</q> the demon agrees. ' 
    ]
;

++ AskTellTopic @tEternity
    "<q>Eternity sounds like a very long time,</q> you remark.\b
    <q>It is, mate,</q> the demon agrees, <q>last thing I heard, it
    goes on forever.</q> "
;

++ AskTopic, SuggestedAskTopic, StopEventList @tWork
    [
        '<q>Do you enjoy your work?</q> you enquire.\b
        <q>It\'s okay -- beats being demythologized, anyway!</q> he replies.
        <.reveal demyth>',
        
        '<q>Have you been working here long?</q> you wonder.\b
        <q>Long enough,</q> he grunts. ',
        
        '<q>Will you be working here much longer?</q> you enquire.\b
        <q>As long as it takes to finish the job,</q> he replies. ' 
        
    ]
    name = 'work'
;

++ AskTopic @tDiss
    "<q>Where's Diss?</q> you inquire.\b
    <q>What do you want to know for?</q> he replies suspiciously, <q>You can't
    go there anyway -- it's off limits to humans.</q> "
;

++ AskTellTopic @demonTail
    "<q>That's a splendid tail you've got,</q> you remark, <q>so useful for
    steadying yourself on the ladder!</q>\b
    <q>It's just the tail I was born with,</q> he shrugs. "
;

++ AskTellTopic @demonHooves
    "<q>How do you find having hooves instead of feet?</q> you enquire
    tactlessly.</q>\b
    <q>I've never had feet, so how would I know the difference, mate?</q> he
    points out, <q>My hooves have served me well enough up to now, at any
    rate.</q>"
;

++ DefaultGiveShowTopic
    "The demon seems quite unimpressed by your offer of {a dobj/him}. "
;

++ CommandTopic @TopicActionBase
    "It probably doesn't make much sense to tell him to do that. "
    isConversational = nil
;


++ DefaultTCommandTopic
    "<q>\^<<cmdPhrase>>!</q> you command.\b
    <q>I don't take orders from humans,</q> he tells you. "
;

++ DefaultAskForTopic
    "<q>I'm afraid I can't help you there, mate,</q> he replies. "
;

+ ConvNode 'yell-demon'
    npcGreetingMsg = "<.p>The demon stops chipping away and turns to look at
        you. <q>Oh, hello mate!</q> he says, <q>Was there something you
        wanted?</q>"
;

++ NoTopic
    "<q>No, not really,</q> you confess, <q>I was just exercising my
    lungs.</q>\b
    <q>Well, in that case, perhaps you could go and exercise them somewhere
    else,</q> he complains. "
;

+ YesTopic
    "<q>Yes, I was trying to get your attention,</q> you tell him.\b
    <q>Well, you've certainly managed that!</q> he assures you, <q>I'm all
    ears!</q>"
;


//+ AgendaItem
//  initiallyActive = true
//  isReady = (getActor.canTalkTo(gPlayerChar))
//  invokeItem
//  {
//    isDone = true;
//    "The demon looks down from his ladder at your approach.\b
//     <q>Hello, mate!</q> he calls cheerfully, <q>I haven't seen anyone
//     round here for a while!</q><.p>";
//    getActor.setCurState(demonTalking);
//  }
//;

