#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ericchrs.t: Eric's Gift characters.
 */

#include <adv3.h>
#include <en_us.h>

#include <jmmmconv.h>

/******************************************************************************/

me: JmmmPlayer, Person
    location = plaza
    isHim = true

    canSingNow = 0
    hasSung = nil
    doSing()
    {
        switch ( location )
        {
        case apartment:
            reportFailure('Usually, you like to go out when you want to think
                           about new jingles.');
            break;

        case street:
            mainReport('You hum a little ditty, trying to fit it to some
                        lyrics you have been toying with.');
            if ( !theHat.location )
            {
                "\bThe wind blows your hat off.";
                theHat.moveInto(street);
                setIt([theHat]);
            }
            break;

        case streetJB:
            mainReport('You hum a little ditty, a college pep tune you and JB
                        used to sing.');
            break;

        case chairs:
            switch ( canSingNow )
            {
            case 0:
                reportFailure('Though the wine is making you tipsy, you are
                               still in no mood to sing.');
                hasSung = true;
                break;
            case 1:
                askAboutLove();
                break;
            case 2:
                reportFailure('You have already sung to your heart\'s content.');
                break;
            }
            break;

        default:
            reportFailure('You are in no mood to sing, right now.');
        }
    }

    dobjFor(Hug) asDobjFor(Kiss)

    dobjFor(Kiss)
    {
        verify
        {
            illogical('{You/he} can\'t do that to {yourself/himself}.');
        }
    }
;

/******************************************************************************/

cappellaNight: JmmmPerson
    'mrs. mrs cappella woman/chandler'
    'woman'
    @plaza

    desc = ( isTopicRepeat(_GreetTopic) ? greetedDesc : unknownDesc )
    greetedDesc = "Cappella Chandler is as beautiful as you remember her. The
                   light that used to shine in her eyes is gone, however."
    unknownDesc = "The woman is wearing a dark cape and hood, making her
                   difficult to identify. Her stature and build look somewhat
                   familiar, but you cannot tell for sure if this is who you
                   have been looking for."

    myHereDesc = 'A woman is slowly crossing the plaza, looking about, as if
                  lost.'
    actorHereDesc = "<<myHereDesc>>"
    isHer = true

    withTopic(_Greet)
    {
        Greet
        {
            greetCappella();
        }
        Recall
        {
            "<q>Hello, again, <<self.name>>,</q> you say.\b<<self.name>>
             smiles in return.";
        }
    }
    withTopic(me)
    {
        Ask
        {
            askCappellaAboutMe();
        }
        Tell
        {
            redirectTo(meTopic, Ask, nil);
        }
        Recall
        {
            "Cappella still remembers you, after all this time.";
        }
    }
    withTopic(cappella)
    {
        Ask
        {
            redirectTo(lifeTopic, Ask, true);
        }
        Tell
        {
            deleteFromHistory(cappellaTopic);
            "But you have nothing to say.";
        }
        Recall
        {
            redirectTo(lifeTopic, Recall, true);
        }
    }
    withTopic(life)
    {
        Ask
        {
            addToHistory(cappellaTopic);
            "<q>And how has life been treating you? It's been... almost four
             years,</q> you say.\bShe nods, smile widening. <q>I've been
             fine, actually. The first year was bad, but I'm over it.</q>\bNot
             quite, you think to yourself, recalling the light that used to
             shine in her eyes.";
        }
        Tell
        {
            addToHistory(cappellaTopic);
            "<q>You know, life must go on. It's been... almost four
             years,</q> you say.\bShe nods, smile widening. <q>I've been
             fine, actually. The first year was bad, but I'm over it.</q>\bNot
             quite, you think to yourself, recalling the light that used to
             shine in her eyes.";
        }
        Recall
        {
            "\^<<actor.theName>> has been doing fine. The first year was bad for
             her, but she is over it... of sorts.";
        }
    }
    withTopic(plaza)
    {
        Ask
        {
            "<q>I'm glad to finally find you, but... what are you doing here
             at this hour?</q> you ask.\b<q>I don't know.</q> She shrugs.
             <q>I like to take long walks late at night, but I don't usually
             come to this part of town.</q>";
        }
        Tell
        {
            "<q>You know, I've been coming to this plaza at this hour every
             night, ever since that day...</q> you say.\bShe shrugs. <q>I
             like to take long walks late at night, but I don't usually come
             to this part of town.</q>";
        }
        Recall
        {
            "\^<<actor.theName>> likes to take long walks late at night, but she
            doesn't usually come to this part of town.";
        }
    }
    withTopic(moon)
    {
        Ask
        {
            "<q>It is a lovely moon, tonight,</q> you say.\b<<actor.name>>'s
             smile warms a bit. <q>Yes, I always liked the full moon.</q>";
        }
        Tell
        {
            redirectTo(moonTopic, Ask, nil);
        }
        Recall
        {
            "\^<<actor.theName>> has always liked the full moon.";
        }
        Init
        {
            "<q>You know, I have always liked the full moon,</q> Cappella
             says.\bYou can't help but smile in reply.";
        }
    }
    withTopic(weather)
    {
        Ask
        {
            "<q>The weather has been kind to us of late,</q> you
             say.\b<q>Indeed,</q> she replies.";
        }
        Tell
        {
            redirectTo(weatherTopic, Ask, nil);
        }
        Recall
        {
            "\^<<actor.theName>> agrees that the weather has been kind to us lately.";
        }
        Init
        {
            "<q>The weather has been kind to us of late,</q> Cappella
             says.\b<q>Indeed,</q> you reply.";
        }
    }
    withTopic(work)
    {
        Ask
        {
            "<q>How has work been?</q> you ask.\bShe shrugs. <q>Nothing's
             changed, really,</q> she says. <q>How about you, you used to be
             in advertising, didn't you?</q>\b<q>Still am,</q> you reply,
             tersely.";
        }
        Tell
        {
            redirectTo(workTopic, Ask, nil);
        }
        Recall
        {
            "\^<<actor.theName>> is still a saleswoman in the same store.";
        }
        Init
        {
            "<q>You used to be in advertising, didn't you?</q> Cappella
             asks.\b<q>Still am,</q> you reply, tersely.\b<q>Nothing's
             changed for me either.</q>";
        }
    }
    withTopic(jb)
    {
        Ask
        {
            "<q>Did you ever see JB again?</q> you ask.\bShe seems puzzled
             for a bit, then nods. <q>You mean your friend, Mr. Brown, don't
             you? No, I didn't. How is he?</q>\b<q>You know, I never did find
             out.</q>";
        }
        Tell
        {
            "<q>You know, I never did see JB again,</q> you say.\bShe seems
             puzzled for a bit, then nods. <q>You mean your friend, Mr. Brown,
             don't you? Never have I, come to think of it.</q>";
        }
        Recall
        {
            "\^<<actor.theName>> never did see or hear from JB again, ever
             since she bought his house. Come to think of it, neither did you.";
        }
    }
    withTopic(panel)
    {
        Ask
        {
            deleteFromHistory(panelTopic);
            "You are about to ask her about the paintings, but stop yourself
             short.";
        }
        Tell
        {
            deleteFromHistory(panelTopic);
            "You have nothing to say about the paintings.";
        }
    }
    withTopic(paintings)
    {
        Ask
        {
            deleteFromHistory(paintingsTopic);
            "You are about to ask her about the paintings, but stop yourself
             short.";
        }
        Tell
        {
            deleteFromHistory(paintingsTopic);
            "You have nothing to say about the paintings.";
        }
    }
    withTopic(eric)
    {
        Ask
        {
            deleteFromHistory(ericTopic);
            "You are about to ask her about her husband, but stop yourself
             short.";
        }
        Tell
        {
            deleteFromHistory(ericTopic);
            "You have nothing to say about her husband.";
        }
    }
    withTopic(love)
    {
        Ask
        {
            deleteFromHistory(loveTopic);
            "You are about to ask her something about love, but stop yourself
             short.";
        }
        Tell
        {
            deleteFromHistory(loveTopic);
            "You have nothing to say to her about love.";
        }
    }
    withTopic(coffee)
    {
        Ask
        {
            "<q>How is your coffee?</q> you ask.\bShe sips her cup. <q>You
             know,</q> she says, <q>it's one of the best I've ever
             had.</q>\bYou nod in agreement.";
        }
        Tell
        {
            "<q>You know, this is one of the best places to get coffee in
             town,</q> you say.\bShe sips her cup, then nods in agreement.
             <q>Yes,</q> she says, <q>it's one of the best I've ever had.</q>";
        }
        Recall
        {
            "\^<<actor.theName>> agrees with you that this is come of the best
             coffee in town.";
        }
        Init
        {
            "Cappella sips her cup, then says, <q>You know, this is some of
             the best coffee I've ever had.</q>\bYou nod in agreement.";
        }
    }

    canImplicitGreet = nil
    notTalking()
    {
        return 'The woman is all the way across the plaza. You should at least
                greet her first.';
    }

    topicLst = [workTopic, moonTopic, weatherTopic, coffeeTopic]
    promptNow = true
    filterDaemon()
    {
        promptNow = !promptNow;
        return promptNow;
    }
    idleDaemon()
    {
        if ( rand(2) == 0 )
            "Cappella stares vacantly at you.";
        else
            "Cappella stares out the window.";
    }

    dobjFor(Hug)
    {
        action
        {
            reportFailure('That\'s not really what it was about.');
        }
    }

    dobjFor(Kiss)
    {
        action
        {
            reportFailure('That\'s not really what it was about.');
        }
    }
;

+ Decoration
    'cape/hood/clothing/clothes'
    'her clothes'
    "She is wearing a dark cape and hood, making her difficult to identify
     from afar."

    isPlural = true
    isProperName = true
;

+ Decoration
    'eyes'
    'her eyes'
    "They used to shine with a light of their own, but that light is gone."

    isPlural = true
    isProperName = true
;

/******************************************************************************/

cappellaHallway: JmmmPerson
    'mrs. mrs cappella woman/chandler'
    'woman'

    unknownDesc = "The woman <<descCount == 0 ? 'that came to the door as you
                   knocked ' : ''>>is the most beautiful thing you have ever
                   seen. She is almost as tall as you and as well built as you
                   can imagine. Her long blond hair is smooth down to her
                   shoulders where it goes into a series of wild curls that
                   glimmer in the light. That which strikes you most, however,
                   are her eyes. They are shining with a light of their own,
                   with an intensity that almost blinds you."
    eyesDesc = "\bHer eyes are blue, you finally realise."
    descCount = 0
    desc
    {
        unknownDesc;
        if ( (descCount++) == 4 )
            eyesDesc;
    }

    actorHereDesc = "A woman is standing in the open doorway, smiling at you
                     in a kind and honest manner, her eyes shining with a
                     light of their own."
    isHer = true

    isTalking = true

    withTopic(jb)
    {
        Ask
        {
            askAboutJB();
        }
        Tell
        {
            redirectTo(jbTopic, Ask, nil);
        }
    }
    withTopic(eric)
    {
        Ask
        {
            "<q>What can you tell me about your husband?</q> you ask.\bHer
             smile widens. <q>That is an odd question to ask. Do you knock on
             random people's doors to ask things like that?</q>";
        }
        Tell
        {
            "<q>I could tell you some things about your husband,</q> you
             say.\bHer smile widens. <q>That is an odd thing to say. Do you
             knock on random people's doors to say things like that?</q>";
        }
        Recall
        {
            "When last you mentioned her husband, she thought it was an odd
             thing to say and asked you if you knocked on random people's
             doors.";
        }
    }
    withTopic(me)
    {
        Ask
        {
            "<q>What can you tell me about myself?</q> you ask.\bHer
             smile widens. <q>That is an odd question to ask. Do you knock on
             random people's doors to ask things like that?</q>";
        }
        Tell
        {
            "<q>I could tell you some things about myself,</q> you
             say.\bHer smile widens. <q>That is an odd thing to say. Do you
             knock on random people's doors to say things like that?</q>";
        }
        Recall
        {
            "When last you talked about yourself, she thought it was an odd
             thing to say and asked you if you knocked on random people's
             doors.";
        }
    }
    withTopic(cappella)
    {
        Tell
        {
            deleteFromHistory(cappellaTopic);
            "But you have nothing to say.";
        }
    }
    withTopic(_)
    {
        Ask
        {
            "<q>What can you tell me about <<topic.theName>>?</q> you
             ask.\bHer smile widens. <q>That is an odd question to ask. Do you
             knock on random people's doors to ask things like that?</q>";
        }
        Tell
        {
            "<q>I could tell you some things about <<topic.theName>>,</q> you
             say.\bHer smile widens. <q>That is an odd thing to say. Do you
             knock on random people's doors to say things like that?</q>";
        }
        Show
        {
            "<q>Take a look at this,</q> you say, showing <<itObj>>
             <<topic.theName>>.\bHer smile widens. <q>That is an odd thing to
             do. Do you knock on random people's doors to do things like
             that?</q>";
        }
        Give
        {
            "<q>Would you like to have this?</q> you ask, showing <<itObj>>
             <<topic.theName>>.\bHer smile widens. <q>That is an odd thing to
             do. Do you knock on random people's doors to do things like
             that?</q>";
        }
        AskFor
        {
            "<q>Could I please have <<topic.aName>>?</q> you ask.\bHer smile
             widens. <q>That is an odd thing to ask for. Do you knock on
             random people's doors to ask for things like that?</q>";
        }
        Recall
        {
            "When last you mentioned <<topic.theName>> to her, she thought it
             was an odd thing to say and asked you if you knocked on random
             people's doors.";
        }
    }

    dobjFor(Hug)
    {
        verify
        {
            illogical('She\'s a complete stranger.');
        }
    }

    dobjFor(Kiss)
    {
        verify
        {
            illogical('She\'s a complete stranger.');
        }
    }
;

+ Decoration
    'eyes'
    'woman\'s eyes'

    desc
    {
        "You find yourself gazing into her eyes, trying to figure out what
         color they are. As it turns out, they are blue.";
        cappellaHallway.descCount = 5;
    }
    isPlural = true
    isProperName = true
;

cappellaEarly: JmmmPerson
    'mrs. mrs cappella woman/chandler'
    'woman'

    location = sofa
    posture = sitting
    greetedDesc = "Cappella is almost as tall as you and as well built as you
                   can imagine. Her long blond hair is smooth down to her
                   shoulders where it goes into a series of wild curls that
                   glimmer in the light. Her eyes shine with a light of their
                   own, with an intensity that almost blinds you."
    unknownDesc = "The woman <<descCount == 0 ? 'that came to the door as you
                   knocked ' : ''>>is the most beautiful thing you have ever
                   seen. She is almost as tall as you and as well built as you
                   can imagine. Her long blond hair is smooth down to her
                   shoulders where it goes into a series of wild curls that
                   glimmer in the light. That which strikes you most, however,
                   are her eyes. They are shining with a light of their own,
                   with an intensity that almost blinds you."
    eyesDesc = " Her eyes are blue, you finally realise."
    nameKnown = nil
    descCount = 0
    desc
    {
        nameKnown ? greetedDesc : unknownDesc;
        if ( (descCount++) == 4 )
            eyesDesc;
    }

    myHereDesc = 'The woman who now lives in JB\'s old apartment is idly
                  chatting with you, her eyes shining as brightly as ever.'
    actorHereDesc = "<<myHereDesc>>"
    isHer = true

    isTalking = true

    withTopic(cappella)
    {
        Ask
        {
            "<q>Please,</q> you say, <q> I don't even know your
             name.</q>\b<q>Oh! I'm sorry. ";
            askName();
            if ( panelBuildings.isExxed )
               new Fuse(panelBuildings, &myFuse, 1);

        }
        Recall
        {
            "Her name is Cappella Chandler. She and her husband Eric bought
             JB's apartment not long ago.";
        }
        Init
        {
            "<q>Oh! How silly of me! You don't even know my name! ";
            askName();
            if ( panelBuildings.isExxed )
               new Fuse(panelBuildings, &myFuse, 1);
        }
    }
    withTopic(life)
    {
        Ask
        {
            "<q>So how has life been treating you?</q> you ask.\bHer smile
             widens. <q>Oh, we've been doing great! This house is just so
             perfect for us. And you know, Eric is painting better than
             ever!</q> she replies.";
        }
        Tell
        {
            "<q>Life sure is odd,</q> you say.\bHer smile widens. <q>Well, for
             us, it's been great! This house is just so perfect for us. And
             Eric, he's painting better than ever!</q> she replies.";
        }
        Recall
        {
            "Cappella and Eric are doing great. This house is perfect for
             them and Eric is painting better than ever.";
        }
        After
        {
            addToHistory(lifeTopic);
            "\bCappella steps in, smile windening. <q>Well, for us, it's been
             great!</q> she says. <q>This house is just so perfect for us.
             And Eric, he's painting better than ever!</q>;";
        }
    }
    withTopic(work)
    {
        Ask
        {
            "<q>So... what do you do?</q> you ask.\b<q>I sell clothes in a
             store,</q> she says, unassumingly. <q>And you?</q>\b<q>I'm in
             advertising. I write jingles.</q>\b<q>No kidding! That must be a
             lot of fun.</q>";
        }
        Tell
        {
            "<q>You know, I'm in advertising,</q> you say, <q>I write
             jingles.</q>\b<q>No kidding! That must be a lot of
             fun.</q>\b<q>It's ok. What about you, what do you do?</q>\b<q>I
             sell clothes in a store,</q> she says, unassumingly.";
        }
        Recall
        {
            "She sells clothes in a store. She is under the impression that
             writing jingles must be a lot of fun.";
        }
        After
        {
            addToHistory(workTopic);
            if ( gActor == me )
                "\b<q>As for me,</q> Cappella says, <q>I sell clothes in a
                 store. And you?</q>\b<q>I'm in advertising. I write
                 jingles.</q>\b<q>No kidding! That must be a lot of fun.</q>";
            else
                "\b<q>Jingles, eh?</q> Cappella asks, stepping in, <q>That
                 must be a lot of fun.</q>\b<q>It's ok. What about you, what
                 do you do?</q>\b<q>I sell clothes in a store,</q> she says,
                 unassumingly.";
        }

    }
    withTopic(love)
    {
        Ask
        {
            deleteFromHistory(loveTopic);
            "You are about to ask <<actor.theName>> something about love, but
             decide against it.";
        }
        Tell
        {
            deleteFromHistory(loveTopic);
            "You are about to tell <<actor.theName>> something about love,
             but decide against it.";
        }
        Recall
        {
            "Cappella laughed when Eric said love was a kind of wonderful
             torture.";
        }
    }
    withTopic(me)
    {
        Ask
        {
            redirectTo(meTopic, Tell, nil);
        }
        Tell
        {
            "<q>You don't know anything about me,</q> you say, still amazed
             at her ease.\b<q>You are a friend of Mr. Brown's,</q> she says,
             her smile brightening a bit, <q>and that's good enough for me.</q>";
        }
        Recall
        {
            "Apparently, the fact that you and JB are buddies is all the
             credentials she needs to trust you.";
        }
    }
    withTopic(jb)
    {
        Ask
        {
            "<q>You wouldn't happen to know where JB is, would you?</q> you
             ask.\b<q>No, I don't. I haven't seen him since we bought the
             house. A pity, too. Mr. Brown seemed quite the nice fellow,</q>
             she replies.\b<q>JB? Heh! He's a wild one. The nicest guy you
             ever could think of, and never one to pass up a good party...</q>
             You pause for a bit. <q>We met in college. Same major and all...
             We used to have the most troublesome double dates on the whole
             campus,</q> you chuckle as you recall fondly.";
        }
        Tell
        {
            "<q>You know, JB's a wild one! The nicest guy you ever could think
             of, and never one to pass up a good party...</q> you say, then
             pause for a bit. <q>We met in college. Same major and all... We
             used to have the most troublesome double dates on the whole
             campus,</q> you chuckle as you recall fondly.\b<q>You know, I
             got just that impression from him. I haven't seen him since we
             bought this house, though. Pity,</q> she replies, then smiles
             again.";
        }
        Recall
        {
            "JB moved without telling you, for no apparent reason. She hasn't
             seen him since, but he made a nice impression on her.";
        }
        Init
        {
            "<q>So... tell me more about Mr. Brown,</q> <<actor.theName>>
             asks, <q>we haven't seen him since we bought
             the house, which is a pity, as he seemed quite the decent
             fellow.</q>\b<q>JB? Heh! He's a wild one. The nicest guy you ever
             could think of, and never one to pass up a good party...</q> You
             pause for a bit. <q>We met in college. Same major and all... We
             used to have the most troublesome double dates on the whole
             campus,</q> you chuckle as you recall fondly.";
        }
        After
        {
            addToHistory(jbTopic);
            "\bCappella then asks, <q>So... tell me more about Mr. Brown. We
             haven't seen him since we bought the house, which is a pity, as
             he seemed quite the decent fellow.</q>\b<q>JB? Heh! He's a wild
             one. The nicest guy you ever could think of, and never one to
             pass up a good party...</q> You pause for a bit. <q>We met in
             college. Same major and all... Heh heh, we used to have the most
             troublesome double dates on the whole campus,</q> you recall
             fondly.";
        }
    }
    withTopic(paintings)
    {
        Before
        {
            addToHistory(ericTopic);
            addToHistory(paintingsTopic);
            "<q>These paintings are actually quite good. Where did you get
             them?</q> you ask.\bCappella steps in, giggling a bit. <q>They
             are his. He's a jet-painter. The best! Well, in my eyes,
             anyway.</q> Her eyes are positively beaming. <q>Eric and I met in
             college, you see, and it was love at first
             sight!</q>\b<q>Really?</q> You turn to Eric. ";
        }
        Ask
        {
            redirectTo(paintingsTopic, Tell, nil);
        }
        Tell
        {
            addToHistory(ericTopic);
            "<q>These paintings are actually quite good. Where did you get
             them?</q> you ask.\bShe giggles a bit. <q>They are my husband's.
             He's a jet-painter. The best! Well, in my eyes, anyway.</q> Her
             eyes are positively beaming. <q>Eric and I met in college, you
             see, and it was love at first sight!</q>\bYou can't help but
             smile.";
        }
        Recall
        {
            "Her husband Eric painted these. Hyper-realism. They are quite
             good, actually. She thinks Eric is just about the best jet
             painter possible.";
        }
        Init
        {
            addToHistory(ericTopic);
            "<q>You know, my husband Eric and I met in college,</q>
             <<actor.theName>> says, <q>It was love at first sight!</q> Her
             eyes are positively beaming. <q>Eric's an artist, you know? All
             these jet-paintings are his.</q>\b<q>They are actually quite
             good,</q> you reply, glancing at the paintings.\b<q>I know. He's
             the best!</q>\bYou can't help but smile.";
        }
    }
    withTopic(eric)
    {
        Ask
        {
            addToHistory(paintingsTopic);
            "<q>Tell me about Eric, then,</q> you say.\bHer eyes positively
             beam. <q>Eric and I met in college. It was love at first
             sight!</q> She giggles a bit. <q>Eric's an artist, you know? All
             these jet-paintings are his.</q>\b<q>They are actualy quite
             good!</q> you reply, glancing at the paintings.\b<q>I know. He's
             the best!</q>\bYou can't help but smile.";
        }
        Tell
        {
            deleteFromHistory(ericTopic);
            "But you have nothing to say.";
        }
        Recall
        {
            "Eric and <<actor.theName>> met in college. He is a jet-painter.
             Hyper-realism. He is quite good, actually. She thinks he is just
             about the best jet-painter possible.";
        }
        After
        {
            addToHistory(ericTopic);
            addToHistory(paintingsTopic);
            "\b<q>College is where we met, Eric and I,</q> Cappella says, her
             eyes positively beaming. <q>It was love at first sight!</q> She
             giggles a bit. <q>You know, all these jet-paintings are
             his.</q>\b<q>They are actualy quite good!</q> you reply,
             glancing at the paintings.\b<q>I know. He's the best!</q>\bYou
             can't help but smile.";
        }
    }
    withTopic(panel)
    {
        Ask
        {
            redirectTo(panelTopic, Tell, nil);
        }
        Tell
        {
            "<q>That larger panel is intriguing,</q> you say, <q>What can you
             tell me about it?</q>\b<q>Not much, actually,</q> she replies,
             shrugging.";
        }
        Recall
        {
            "\^<<actor.theName>> didn't have much to say about the larger panel.";
        }
        After
        {
            addToHistory(panelTopic);
            "\bCappella eyes the panel for a while, then shrugs as well.";
        }
    }
    withTopic(jingles)
    {
        Init
        {
            "Cappella turns to you and says, <q>Say, won't you sing us one of
             your jingles?</q>\b";
            if ( hasSung )
                "You had already thought about bursting into song, so you
                 blush a bit, wondering whether to do it. Apparently, the wine
                 is just strong enough to make you want to.";
            else
                "You blush a bit and think about refusing, but apparently, the
                 wine is just strong enough to make you want to do it.";
            me.canSingNow = 1;
        }
    }
    withTopic(gift)
    {
        Init
        {
            doGift1();
        }
    }
    withTopic(gift2)
    {
        Init
        {
            doGift2();
        }
    }
    withTopic(gift3)
    {
        Init
        {
            doGift3();
        }
    }
    withTopic(_)
    {
        Ask
        {
            "<q>What can you tell me about <<topic.theName>>?</q> you
             ask.\b<q>I'm afraid I wouldn't know much about that,</q> she
             says, smiling, as always.";
        }
        Tell
        {
            "<q>I could tell you some things about <<topic.theName>>,</q> you
             say.\b<q>I'm afraid I wouldn't have much use for that,</q> she
             says, smiling, as always.";
        }
        Show
        {
            "<q>Take a look at this,</q> you say, showing <<itObj>>
             <<topic.theName>>.\b<q>What about it?</q> she asks, smiling, as
             always.";
        }
        Give
        {
            "<q>Would you like to have this?</q> you ask, showing <<itObj>>
             <<topic.theName>>.\b<q>No, not really. Thanks, though,</q> she
             replies, smiling, as always.";
        }
        AskFor
        {
            "<q>Could I please have <<topic.aName>>?</q> you ask.\b<q>I'm
             afraid I couldn't offer any... My appologies,</q> she replies,
             smiling, as always.";
        }
        Recall
        {
            "When last you mentioned <<topic.theName>> to her, she didn't have
             much to say on the subject, though she did smile, as always.";
        }
    }

    spokeThisTurn = nil
    countSitStand = 0
    beforeAction()
    {
        spokeThisTurn = nil;
        inherited();
    }
    afterAction()
    {
        inherited();

        if ( gAction.ofKind(StandAction) || gAction.ofKind(SitOnAction) )
        {
            if ( gTranscript.isFailure )
                return;

            countSitStand++;
            if ( countSitStand < 4 )
                return;

            switch( countSitStand )
            {
            case 4:
                extraReport('\b\^');
                extraReport(theName);
                extraReport(' smiles and says, <q>You know, you\'re quite
                             welcome to sit anywhere.</q>');
                spokeThisTurn = true;
                break;

            case 5:
                break;

            case 6:
                extraReport('\b<q>My, my,</q> ');
                extraReport(theName);
                extraReport(' says, <q>aren\'t you undecisive.</q>\bYou might
                             even be insulted, but she is much too charming
                             for that.');
                spokeThisTurn = true;
                break;

            case 7:
                extraReport('\b\^');
                extraReport(theName);
                extraReport(' giggles a bit.');
                spokeThisTurn = true;
                break;

            default:
                if ( rand(2) == 0 )
                {
                    extraReport('\b\^');
                    extraReport(theName);
                    extraReport(' just shakes her head, smiling to herself.');
                    spokeThisTurn = true;
                }
                break;
            }

            return;
        }

        if ( gAction.ofKind(TopicAction) )
        {
            spokeThisTurn = true;
            return;
        }
    }

    topicLst = [jbTopic, paintingsTopic, cappellaTopic]
    waitCount = 2
    filterDaemon()
    {
        if ( spokeThisTurn )
            return nil;
        if ( waitCount > 0 )
        {
            waitCount--;
            return nil;
        }
        waitCount++;
        spokeThisTurn = true;
        return true;
    }

    idleDaemon()
    {
        cappellaEarly.spokeThisTurn = nil;
    }

    dobjFor(Hug)
    {
        verify
        {
            illogical('The mood just isn\'t there.');
        }
    }

    dobjFor(Kiss)
    {
        verify
        {
            illogical('The mood just isn\'t there.');
        }
    }
;

Decoration
    vocabWords_ = 'eyes'
    name { return location.theName + '\'s eyes'; }
    location = cappellaEarly
    desc
    {
        "You find yourself gazing into her eyes, trying to figure out what
         color they are. As it turns out, they are blue.";
        cappellaEarly.descCount = 5;
    }
    isPlural = true
    isProperName = true
;

/******************************************************************************/

Eric: JmmmPerson
    'mr eric man/eric/chandler'
    'Eric'
    "Eric is rather tall and, you must admit, quite handsome. His beard, short
     and well trimmed, is the same fiery red as his hair, which is also short
     and well trimmed. His green eyes shine with an inner light of their own,
     though not as bright as Cappella's."

    isProperName = true
    isHim = true

    myHereDesc = 'Eric is here, idly chatting with you.'
    actorHereDesc = "<<myHereDesc>>"

    isTalking = true
    canAskNoGreet = true

    withTopic(cappella)
    {
        Ask
        {
            "<q>How long have you been married?</q> you ask.\b<q>Going on
             three months, now,</q> he replies.\b<q>Newlyweds, hey? So how
             goes it?</q>\b<q>Actually, even better than I dreamed.</q>\bYou
             smile and nod in return.";
        }
        Tell
        {
            "<q>Cappella tells me you have just married,</q> you say, then
             ask, <q>What's is like being a newlywed?</q>\b<q>Well,</q> he
             replies with a smile, <q>actually, these past three months have
             been even better than I dreamed.</q>\bYou smile and nod in
             return.";
        }
        Recall
        {
            "Eric and Cappella have been married for just three months. Their
             marriage is going even better than he dreamed.";
        }
    }
    withTopic(life)
    {
        Ask
        {
            "<q>So how has life been treating you?</q> you ask.\bHe smiles.
             <q>We've been doing all right. My painting is coming along
             nicely, and I am even beginning to sell, finally. How about
             yourself?</q>\bYou smile in reply. <q>You know, same old, same
             old. No complaints, I suppose.</q>";
        }
        Tell
        {
            deleteFromHistory(ericTopic);
            "You search around for meaningful things to say, but elect to
             remain still instead.";
        }
        Recall
        {
            "Eric has finally beginning to sell his paintings. You, as
             always, have no complaints.";
        }
        After
        {
            addToHistory(lifeTopic);
            "\b<q>Indeed,</q> Eric adds, <q>my painting is coming along
             nicely, and I am even beginning to sell, finally. How about
             yourself?</q>\bYou smile in reply. <q>You know, same old, same
             old. No complaints, I suppose.</q>";
        }
    }
    withTopic(work)
    {
        Ask
        {
            "<q>Do you do anything beside painting?</q> you ask.\bHe nods.
             <q>I'm an automobile designer. Painting is something I do in my
             spare time.</q>";
        }
        Tell
        {
            deleteFromHistory(workTopic);
            redirectTo(meTopic, Tell, true);
        }
        Recall
        {
            "Eric is an automobile designer. Painting is something he does in
             his spare time.";
        }
        Init
        {
            "<q>Well, then, old chap,</q> Eric says, <q>tell me about
             yourself.</q>\b<q>Not much to tell, really,</q> you reply, <q>I'm
             in advertising. I write jingles. That's about it. How about
             you?</q> you ask. <q>Do you do anything else beside
             painting?</q>\bHe nods. <q>I'm an automobile designer.
             Painting is something I do in my spare time.</q>";
        }
        After
        {
            addToHistory(workTopic);
            "\b<q>What about you, Eric?</q> you ask, turning to him. <q>Do
             you do do anything beside painting?</q> you ask.\bHe nods.
             <q>I'm an automobile designer. Painting is something I do in my
             spare time.</q>";
        }
    }
    withTopic(love)
    {
        Ask
        {
            deleteFromHistory(loveTopic);
            topicLst = [loveTopic];
            "You are about to ask Eric something about love, but decide
             against it.";
        }
        Tell
        {
            deleteFromHistory(loveTopic);
            topicLst = [loveTopic];
            "You are about to tell Eric something about love, but decide
             against it.";
        }
        Recall
        {
            "Eric feels that being in love is a kind of wonderful torture.";
        }
    }
    withTopic(jb)
    {
        Ask
        {
            "<q>You wouldn't happen to know where JB is, would you?</q> you
             ask.\b<q>JB?</q> he inquires.\b<q>Eh... Jack Brown. Or rather,
             Samuel Jackson Brown, this apartment's previous owner.</q>\bHe
             nods. <q>Ah, yes. Mr. Brown. No, I don't. Unfortunate. I quite
             enjoyed meeting him. Of course, Cappella had more contact with
             him, as she was the one that handled the purchase. Was he an
             acquaintance of yours?</q>\b<q>Yes, we were in college together.
             In fact, I came here looking for him.</q>";
        }
        Tell
        {
            "<q>I came here looking for JB,</q> you say.\b<q>JB?</q> he
             inquires.\b<q>Eh... Jack Brown. Or rather, Samuel Jackson Brown,
             this apartment's previous owner.</q>\bHe nods. <q>Ah, yes. Mr.
             Brown. I quite enjoyed meeting him. Of course, Cappella had more
             contact with him, as she was the one that handled the purchase.
             Was he an acquaintance of yours?</q>\b<q>Yes, we were in college
             together. In fact, I came here looking for him.</q>";
        }
        Recall
        {
            "Eric already knows you came here looking for JB. He quite enjoyed
             meeting him, but they didn't have much contact, as Cappella was
             the one who handled the purchase of the apartment.";
        }
        Init
        {
            "<q>What exactly brings you here, anyway?</q> Eric asks.\b<q>I
             came here looking for JB,</q> you say.\b<q>JB?</q> he
             inquires.\b<q>Eh... Jack Brown. Or rather, Samuel Jackson Brown,
             this apartment's previous owner.</q>\bHe nods. <q>Ah, yes. Mr.
             Brown. I quite enjoyed meeting him. Of course, Cappella had more
             contact with him, as she was the one that handled the purchase.
             Was he an acquaintance of yours?</q>\b<q>Yes, we were in college
             together.</q>";
        }
        After
        {
            addToHistory(jbTopic);
            "\bEric shakes his head as well. <q>You know, I greatly enjoyed
             meeting Mr. Brown,</q> he says, <q>but I didn't have much contact
             with him, as Cappella was the one who handled the purchase.</q>";
        }
    }
    withTopic(paintings)
    {
        Ask
        {
            "<q>Are you working on any new paintings?</q> you ask.\b<q>As a
             matter of fact, I am,</q> he says, <q>would you like to see
             it?</q>";
            showPainting();
        }
        Tell
        {
            "<q>You know, your paintings are quite good,</q> you
             say.\b<q>Thank you,</q> he replies, then adds, <q>I'm working on
             a new one. Would you like to see it?</q>";
            showPainting();
        }
        Recall
        {
            if ( location == study )
                "Eric is already showing you his work in progress.";
            else
                "Eric is working on a portrait of Cappella, but can't quite
                 seem to capture the inner light in her eyes.";
        }
        Init
        {
            "<q>Hey, I am working on a new painting,</q> Eric says, <q>would
             you like to see it?</q>";
            showPainting();
        }
        After
        {
            if ( gActor == cappellaEarly )
                return;

            addToHistory(paintingsTopic);
            "\b<q>Hey, I am working on a new one,</q> Eric says, <q>would you
             like to see it?</q>";
            showPainting();
        }
    }
    withTopic(eric)
    {
        Ask
        {
            "<q>How long have you been a jet-artist?</q> you ask.\bEric
             shrugs. <q>A couple of years,</q> he says. <q>I started during
             school. I really couldn't see myself having a schedule or a boss
             unless I had something else to take my mind off them.</q>";
         }
         Tell
         {
             deleteFromHistory(ericTopic);
             "But you have nothing to say.";
         }
         Recall
         {
             "Eric started painting a couple of years ago, when he was still
              in college. It's a way for him to get his mind off shcedules
              and bosses.";
         }
         After
         {
             addToHistory(ericTopic);
            "\bEric smiles as well. <q>I've been painting for a couple of
             years, now,</q> he says. <q>I started during school. I really
             couldn't see myself having a schedule or a boss unless I had
             something else to take my mind off them.</q>";
         }
    }
    withTopic(panel)
    {
        Ask
        {
            redirectTo(panelTopic, Tell, nil);
        }
        Tell
        {
            "<q>That larger panel is intriguing,</q> you say, <q>What can you
             tell me about it?</q>\bEric shrugs. <q>Not much, really,</q> he
             replies. <q>I just sort of felt like drawing that.</q>";
        }
        Recall
        {
            "Eric just sort of felt like drawing it.";
        }
        After
        {
            addToHistory(panelTopic);
            "\bEric also shrugs. <q>I just sort of felt like drawing
             that,</q> he says.";
        }
    }
    withTopic(me)
    {
        Ask
        {
            redirectTo(meTopic, Tell, nil);
        }
        Tell
        {
            "<q>I really appreciate your hospitality,</q> you say, <q>It's a
             rare thing these days.</q>\b<q>Don't mention it,</q> he replies.";
        }
        Recall
        {
            "Eric already knows you appreciate their hospitality. He was rather
             modest about it.";
        }
    }

    topicLst = [jbTopic, workTopic, paintingsTopic]
    activeLst = [1, 2, 5]
    goCount = 0
    filterDaemon()
    {
        if ( cappellaEarly.spokeThisTurn )
            return nil;
        if ( activeLst.indexOf(goCount++) )
        {
            cappellaEarly.spokeThisTurn = true;
            return true;
        }
        return nil;
    }

    idleDaemon()
    {
        cappellaEarly.spokeThisTurn = nil;
    }

    dobjFor(Hug)
    {
        verify
        {
            illogical('That\'s not really called for.');
        }
    }

    dobjFor(Kiss)
    {
        verify
        {
            illogical('That\'s not really called for.');
        }
    }
;
