/* Perdition's Flames - suburbs */
// copyright (c) 1993, 2002 by Michael J. Roberts.

minimall: room
    sdesc = "Minimall Parking Lot"
    ldesc = "You're in the parking lot of a suburban mini-mall.
        The street is to the south.  To the east is a store
        labeled \"Just Mirrors\", and to the west is
        The Amulette Shoppe."
    south = suburbWest
    east = mirrorStore
    west = amuletShop
;

amuletCase: fixeditem, qcontainer, transparentItem
    location = amuletShop
    isopen = nil
    sdesc = "display case"
    noun = 'case' 'cases'
    adjective = 'glass' 'display'
    ldesc = "The display cases contain a number of different amulets.
        Most look like they're to be worn around the neck:  one is
        a big gold disk with complex etchings; a second one is a clear,
        light blue jewel stone; a third is an ivory carving of a
        boat.  Some look like other types of jewelry:  one is a
        simple silver ring, and another is a bracelet."
;

shopAmulets: fixeditem
    location = amuletCase
    noun = 'amulets' 'amulet'
    sdesc = "amulet"
    adesc = "an amulet"
    ldesc = { amuletCase.ldesc; }
;

class fakeAmuletItem: item
    location = amuletCase
    verDoBuy(actor) =
    { 
        "You can't possibly afford it. Besides, it's only a genuine
        replica; you would probably find the real thing more useful.";
    }
    doSynonym('Buy') = 'Take'
    adjective = 'imitation' 'fake'
;

amulet1: fakeAmuletItem
    sdesc = "imitation gold disk"
    noun = 'disk'
    adjective = 'big' 'large' 'gold'
    ldesc = "It's a large gold disk with complex etchings.  The
        pattern of etchings resembles a starburst:  a central circle
        with lines radiating.  The disk is attached to a gold chain,
        for wearing the amulet around the neck."
;

amulet2: fakeAmuletItem
    sdesc = "imitation jewel stone"
    noun = 'stone'
    adjective = 'jewel' 'light' 'blue' 'clear'
    ldesc = "It's a large, multi-faceted, clear blue jewel stone.
        It's attached to a gold chain, for wearing it around the neck."
;

amulet3: fakeAmuletItem
    sdesc = "imitation ivory carving"
    adesc = "an ivory carving"
    noun = 'carving' 'boat'
    adjective = 'ivory'
    ldesc = "The carving depicts what looks like a rowboat.  It's
        attached to a gold chain for wearing it around the neck."
;

amulet4: fakeAmuletItem
    sdesc = "imitation silver ring"
    noun = 'ring'
    adjective = 'simple' 'silver'
    ldesc = "It's a simple silver ring."
;

amulet5: fakeAmuletItem
    sdesc = "imitation bracelet"
    noun = 'bracelet'
    adjective = 'gold'
    ldesc = "It's a gold bracelet, made up of little loops of gold
        wire all linked together."
;

amuletKeeper: Actor
    isHim = true
    sdesc = "shopkeeper"
    noun = 'shopkeeper' 'keeper' 'man'
    adjective = 'shop'
    location = amuletShop
    actorDesc = "A shopkeeper is here waiting to help you."
    ldesc = "He's an older man with gray hair and glasses.  He
        is standing ready to answer your questions."
    verDoAskFor(actor, iobj) = {}
    doAskFor(actor, iobj) =
    {
        if (isclass(iobj, fakeAmuletItem))
            "\"Oh, I'm afraid this one has already been sold.
            Besides, you're probably much more interested in
            the real thing, and these are all imitation.\"";
        else
            "He just shrugs and shakes his head.";
    }
    actorAction(v, d, p, i) = { "He just smiles and nods."; exit; }
    disavow = "\"I'd prefer to talk about amulets.\""
    askWord(word, lst) =
    {
        switch(word)
        {
        case 'shopkeeper':
        case 'himself':
            "\"I'm just a humble storeowner.\"";
            break;

        case 'shop':
            "\"What you see is what you get.\"";
            break;

        case 'amulet':
        case 'amulets':
            "\"I have a very nice selection of authentic reproductions
            of actual amulets.  Of course, these amulets don't have the
            magical protective powers of the real amulets, but they
            make very nice jewelry.\"";
            break;

        case 'disk':
            "\"This is a replica of an amulet that is said to provide
            protection against great heat.  I think the story is that
            it resembles the Sun, which is the source of all heat.
            This one's been sold.\"";
            break;

        case 'jewel':
        case 'stone':
            "\"This is a very nice jewel, don't you think?  The amulet
            that it's based upon supposedly provides protection against
            extreme cold. The jewel looks a little like a block of ice,
            you see.  This one's been sold.\"";
            break;

        case 'ivory':
        case 'carving':
        case 'boat':
            "\"This is real ivory, which is very hard to find these days.
            The original amulet was said to provide protection against
            sickness.  I think the idea is that you might become ill in
            a rowboat.  This one's been sold.\"";
            break;

        case 'silver':
        case 'ring':
            "\"This was is supposed to provide protection against
            blinding light.  I'm not sure why it's a ring.
            This one's been sold.\"";
            break;

        case 'bracelet':
            "\"The original amulet upon which this is based is said to provide
            protection against deafening sound.  This one's been sold.\"";
            break;

        default:
            return(nil);
        }
        return(true);
    }
;

amuletShop: room
    sdesc = "Amulette Shoppe"
    ldesc = "You're in a small store that sells amulets of various kinds.
        Glass display cases contain the amulets, which look like
        assorted types of jewelry."
    east = minimall
    out = minimall
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);
        "\n\tThe shop keeper greets you as you walk in. \"How
        may I help you?\" he asks cheerfully.";
    }
;

storeMirrors: fixeditem
    sdesc = "mirror"
    noun = 'mirror' 'mirrors' 'tag' 'small'
    adjective = 'price' 'medium-sized' 'medium-size' 'large' 'larger'
    location = mirrorStore
    ldesc = "There are mirrors of all sizes, large and small.
        Each is labeled with a price tag; you see small mirrors
        for twenty-five hellmids, medium-sized mirrors for fifty
        hellmids, and larger mirrors for anything from seventy-five
        to several hundred hellmids.  Unfortunately, they're all
        too expensive for you."
    verDoTake(actor) = { "You can't afford any of these mirrors."; }
    verDoLookin(actor) = {}
    doLookin(actor) = { "You see a multitude of goofy faces looking
        back at you."; }
;

mirrorCounter: fixeditem, surface
    sdesc = "counter"
    noun = 'counter'
    location = mirrorStore
;

mirrorTeen: Actor
    isHim = true
    sdesc = "sullen teen"
    noun = 'teen' 'teenager' 'shopkeeper' 'keeper'
    adjective = 'sullen' 'shop'
    location = mirrorStore
    ldesc =
    {
        "He's wearing a t-shirt covered with Satanic symbols
        promoting some heavy-metal band; for some reason, it
        seems out of place in Hell. ";
        if (cigaret.location = self)
            "He's smoking a cigarette, filling the store with
            clouds of smoke.";
        else
            "He smells overpoweringly of cigarette smoke, although
            no cigarettes are in evidence.  He taps his fingers
            nervously on the counter.";
    }
    actorAction(v, d, p, i) = { "He ignores you."; exit; }
    verDoAskAbout(actor, iobj) = { "He ignores you."; }
    doSynonym('AskAbout') = 'TellAbout'
    actorDesc = nil
    actorDaemon =
    {
        if (programmer.location <> self.location)
        {
            if (cigaret.location = mirrorTeen)
                "\bThe teenager puffs away at a cigarette.";
            else
                "\bThe teenager taps his fingers nervously
                on the counter and tries to avoid eye contact
                with you.";
        }
    }
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = cigaret or (dobj = cigaretBox and cigaret.isIn(dobj)))
        {
            "He snatches the cigarette and sticks it
            in his mouth.  He fumbles in his pockets for a lighter,
            finds one, and lights the cigarette.  \"Thanks, man,\"
            he says, not really looking at you.  He drops the lighter
            on the counter and puffs on the cigarette contentedly.";

            lighter.moveInto(mirrorCounter);
            cigaret.moveInto(mirrorTeen);
        }
        else
            "He doesn't seem very interested.";
    }
    ioSynonym('GiveTo') = 'ShowTo'
;

mirrorStore: room
    sdesc = "Just Mirrors"
    ldesc = "You're inside Just Mirrors, which seems to sell just
        mirrors.  Lots of mirrors are available for sale.  The shopkeeper
        seems to be a sullen
        teen, sitting behind the counter trying hard to ignore you.
        The exit is to the west."
    west = minimall
    out = (self.west)
    enterRoom(actor) =
    {
        notify(mirrorTeen, &actorDaemon, 0);
        pass enterRoom;
    }
    leaveRoom(actor) =
    {
        unnotify(mirrorTeen, &actorDaemon);
        pass leaveRoom;
    }
;

suburbWest: room
    sdesc = "Suburbs"
    ldesc = "You're on a quiet, pleasant suburban street to the west of
        the city.  Somehow, you always knew there would be suburbs in
        hell.  The street is lined with the type of tract housing
        they built copiously in California in the 1950's:  one-story
        buildings with flat roofs, horizontal lines, lots of windows,
        and poor construction quality.  A drab, faded blue-green house
        lies to the south, and a mini-mall lies to the north.
        The street leads east back into the city.  To the west, the
        street fades to a gravel path."
    east = downtown
    west = gravelpath
    south = eichlerYard
    north = minimall
;

eichlerHouse: fixeditem
    sdesc = "house"
    noun = 'house' 'cardboard' 'gap' 'gaps'
    ldesc = "It's a pretty sad looking house. The entrance is to the south."
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(eichlerYard.south); }
    location = eichlerYard
;

eichlerYard: room
    sdesc = "North of House"
    ldesc = "You're in the poorly-tended, mostly dead yard of a house
        that lies to the south.  Now that you're closer to the house,
        you can see just how poorly built the house really is:  the
        primary building material seems to be cardboard stapled
        onto a rotting wooden frame.  The cardboard is ill-fitting
        and poorly aligned, leaving large gaps here and there.
        You can enter the house to the south, and you can leave
        the yard to the north."
    north = suburbWest
    firsttime = true
    actorDaemon = nil
    south =
    {
        if (firsttime)
        {
            "As you start to open the door, you suddenly realize that it was
            locked.  However, the construction quality of the house
            is so poor that the door pops open anyway.\b";
            notify(programmer, &actorDaemon, 0);
        }
        firsttime := nil;
        return(eichlerKitchen);
    }
;

eichlerAppliances: fixeditem
    sdesc = "appliance"
    adesc = "an applicance"
    noun = 'appliance' 'appliances'
    location = eichlerKitchen
    ldesc = "The usual appliances are here:  an oven, an electric
        range, and a refrigerator."
;

eichlerOven: fixeditem, openable
    sdesc = "oven"
    adesc = "an oven"
    location = eichlerKitchen
    noun = 'oven' 'stove'
    isopen = nil
;

eichlerRange: fixeditem, surface
    sdesc = "range"
    noun = 'range'
    adjective = 'electric'
    location = eichlerKitchen
;

eichlerFridge: fixeditem, openable
    sdesc = "refrigerator"
    noun = 'refrigerator' 'fridge'
    location = eichlerKitchen
    isopen = nil
;

bolognaSandwich: fooditem
    noun = 'sandwich' 'food'
    plural = 'sandwiches'
    adjective = 'bologna'
    sdesc = "bologna sandwich"
    ldesc = "It looks like a bologna sandwich, but it smells like a ham
        sandwich.  Despite that, it looks edible enough. "
    location = eichlerFridge
;

hamSandwich: fooditem
    noun = 'sandwich' 'food'
    plural = 'sandwiches'
    adjective = 'ham'
    sdesc = "ham sandwich"
    ldesc = "It looks like a ham sandwich, but it smells like a bologna
        sandwich.  Despite that, it looks edible enough. "
    location = eichlerFridge
;

recycleBin: container
    sdesc = "paper recycling bin"
    noun = 'bin'
    adjective = 'paper' 'recycling' 'blue' 'plastic'
    location = eichlerKitchen
    ldesc =
    {
        "It's a blue plastic bin, labeled \"Paper\", with the familiar
        recycling symbol underneath. ";
        pass ldesc;
    }
;

eichlerFloor: decoration
    location = eichlerKitchen
    sdesc = "linoleum"
    noun = 'linoleum' 'gash' 'gashes' 'plastic'
;

eichlerKitchen: room
    sdesc = "Kitchen"
    ldesc = "You're in an old, dilapidated kitchen.  The appliances
        are all ancient and appear to be in poor condition; the
        linoleum floor has large gashes here and there where the
        plastic is curled back.  There's a sink, with a small
        cabinet underneath.  An exit leads north out into the
        yard, and passages lead west and south."
    north = eichlerYard
    south = eichlerHall
    west = eichlerDR
;

kitchenSink: fixeditem
    sdesc = "sink"
    noun = 'sink'
    location = eichlerKitchen
;

kitchenCabinet: fixeditem, openable
    sdesc = "cabinet"
    noun = 'cabinet'
    location = eichlerKitchen
    isopen = nil
;

rubberGloves: clothingItem
    sdesc = "pair of rubber gloves"
    noun = 'pair' 'gloves'
    adjective = 'rubber'
    location = kitchenCabinet
;

eichlerDR: room
    sdesc = "Dining Room"
    ldesc = "You're in the dining room, which isn't really a separate
        room but just the northwest corner of the living room.  A table
        dominates the area.  A six-foot
        partition
        separates the dining room and living room from the kitchen,
        which is to the east (evidently, building a wall all the way up
        to the ceiling would have been too expensive).  The living
        room lies to the south."
    east = eichlerKitchen
    south = eichlerLR
    se = eichlerLR
;

drTable: surface, fixeditem
    sdesc = "table"
    noun = 'table'
    location = eichlerDR
    verDoStandon(actor) = {}
    doStandon(actor) =
    {
        "You get up on the table, have a look around, and realize
        that there's nothing to look at up here.  Realizing that
        you look ridiculous, you step back down off the table.";
    }
;

junkmail: readable
    location = drTable
    noun = 'mail' 'envelope' 'letter'
    adjective = 'junk' 'bulk'
    sdesc = "junk mail"
    adesc = "some junk mail"
    ldesc =
    {
        "It's one of those obvious pieces of junk mail that's
        been made up to look like something important, with phrases
        such as \"Extremely Urgent!\" and \"Dated Material!\"
        and \"Super-Express-Gram\" stamped on the outside, but
        addressed to \"Resident (Deceased)\".  The letter reads:
        \b\bHello, Decedent!
        \bAre you tired of the banality of everyday death in Hell?
        Have you been to Heaven, but couldn't stand the boring
        \"cultural\" activities?  Do you long for the danger and
        excitement that you had when you were alive?
        \bThen join the Hades Explorers' Society!
        \bIn the HES, we go to the parts of the underworld that
        ordinary people have never heard of, and we perform amazing
        feats that others wouldn't dream of, then we get together
        in our luxurious clubhouse and exchange stories over fine
        imported cognac and brandy.
        \bBecause of your excellent credit history, you're
        PRE-APPROVED for membership in the HES.  All you need to
        do is to bring the enclosed Certificate of Invitation
        to our Headquarters.
        \bAs far as we're concerned, you're as good as joined.
        However, there's one catch.  The way to our headquarters
        is guarded by an evil Troll.  The Troll will let none pass
        except for card-carrying members of the HES, or those who
        the Troll believes are worthy of membership.   The Troll
        unfortunately does not read, so the enclosed certificate
        will not help you.  Instead, you must prove yourself an
        accomplished Adventurer by bringing the Troll a great
        treasure.  For this we can offer you no guidance, but
        if you are truly an Adventurer, you will be up to the quest.
        \bGood luck!  We look forward to welcoming you!";

        if (not self.isseen)
        {
            "\bA piece of paper that was attached to the letter
            falls out onto the <<
            Me.location = eichlerDR ? "table" : "floor" >>. You see
            that it's the Certificate of Invitation.";

            isseen := true;
            invitation.moveInto(Me.location = eichlerDR ?
                                drTable : Me.location);
        }
    }
;

invitation: readable
    noun = 'certificate' 'invitation' 'paper' 'piece'
    sdesc = "certificate"
    ldesc = "It's an elaborate certificate, personalized in
        frilly script letters for \"BEARER\", certifying
        that the named individual has been pre-approved for
        membership in the Hades Explorers' Society and all of
        the privileges and responsibilities pertaining thereunto."
;

eichlerLR: room
    sdesc = "Living Room"
    ldesc = "You're in the living room, which is long and narrow,
        with a brick fireplace on the south wall; next to the
        fireplace is a tool holder.
        A six-foot partition to the north separates the living room
        and kitchen.  The northwest corner of the room serves as
        the dining room.  A hallway leads east."
    north = eichlerDR
    nw = eichlerDR
    east = eichlerHall
;

fireplace: fixeditem, container
    sdesc = "fireplace"
    noun = 'fireplace' 'place' 'hearth'
    adjective = 'fire' 'brick'
    location = eichlerLR
;

eichlerHall: room
    sdesc = "West end of hall"
    ldesc = "You're in a short hallway connecting the bedrooms to
        the living room and kitchen area.  The kitchen lies to the
        north, the living room is to the west, and the hall continues
        to the east."
    north = eichlerKitchen
    west = eichlerLR
    east = eichlerHall2
;

eichlerHall2: room
    sdesc = "East end of hall"
    ldesc = "You're at the east end of the hall.  Bedrooms are to
        the east and south, and a bathroom is to the north.
        The hall continues to the west."
    east = eichlerBR1
    south = eichlerBR2
    west = eichlerHall
    north = eichlerBath1
;

eichlerBath1: room
    sdesc = "Bathroom"
    ldesc = "You're in a small bathroom. In the center of a room
        is a sink, and over the sink is a medicine cabinet
        (which is << medicineCabinet.isopen ? "open" : "closed" >>).
        The exit is to the south."
    south = eichlerHall2
;

mirror2: fixeditem
    sdesc = "mirror"
    noun = 'mirror'
    ldesc = "In the mirror, you can easily see what the
        people in the cubes on either side are doing."
    verDoLookin(actor) = {}
    doLookin(actor) = { self.ldesc; }
;

class mirrorItem: item
    noun = 'mirror'
    sdesc = "mirror"
    ldesc = "It's a small mirror, about two feet by a foot and a half."
    verIoCoverWith(actor) = {}
    ioCoverWith(actor, dobj) =
    {
        if (dobj = smallPanel)
            dobj.doCoverWith(actor, self);
        else
            "You can't cover << dobj.thedesc >> with the mirror.";
    }
    verDoLookin(actor) = {}
    doLookin(actor) = { "You see a goofy face looking back at you."; }
;

/* the actual mirror */
mirror: mirrorItem
    location = medicineFrame
    verDoPryWith(actor, iobj) =
    {
        if (self.location = medicineFrame)
            "If you want to pry open the cabinet, just say so. ";
        else
            "You can't pry that. ";
    }
;

/* a fake mirror, for the programmer to carry around */
mirror1: item
;

medicineFrame: fixeditem
    isqcontainer = true
    noun = 'frame'
    verGrab(obj) =
    {
        if (obj = mirror)
            "The mirror is attached to the medicine cabinet.";
    }
    location = eichlerBath1
    sdesc = "frame"
    ldesc =
    {
        if (medicineCabinet.isbroken)
            "The frame used to contain a mirror, but the mirror
            has fallen out.";
        else
            "The frame contains a mirror.";
    }
    verIoPutIn(ator) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = mirror)
        {
            if (medicineCabinet.isopen)
            {
                "(Closing the medicine first)\n";
                medicineCabinet.isopen := nil;
            }
            "You carefully put the mirror back in the frame. It
            doesn't fit all that well, but it you manage to wedge
            it into place.";

            mirror.moveInto(medicineFrame);
            medicineCabinet.isbroken := nil;
        }
        else
            "That doesn't fit in the frame.";
    }
;

crowbar: rodItem
    sdesc = "crowbar"
    noun = 'crowbar'
    location = toolbox
    ldesc =
    {
        "It's a couple of feet long, and perhaps three quarters
        of an inch in diameter.  It's made out of good solid steel.
        On one end, the bar is bent and sharpened to make it useful
        for prying things open.";
        pass ldesc;
    }
    verIoPryWith(actor) = {}
    ioPryWith(actor, dobj) = { dobj.doPryWith(actor, self); }
    ioSynonym('PryWith') = 'OpenWith'
    verIoTakeWith(actor) = {}
    ioTakeWith(actor, dobj) = { dobj.doTakeWith(actor, self); }
    ioSynonym('TakeWith') = 'MoveWith' 'PullWith' 'PushWith'
;

fireHolder: fixeditem, qcontainer
    location = eichlerLR
    sdesc = "fireplace tool holder" 
    noun = 'holder' 'caddy'
    adjective = 'fireplace' 'tool'
    ioPutIn(actor, dobj) =
    {
        if (dobj = firePoker or dobj = fireBrush or dobj = fireShovel)
            pass ioPutIn;
        else
            "There's no place for that in the tool holder.";
    }
    ldesc =
    {
        "It's a black metal caddy for holding fireplace tools.
        It has space for three specific tools. ";
        pass ldesc;
    }
;

firePoker: rodItem
    location = fireHolder
    noun = 'poker' 
    plural = 'tools'
    adjective = 'black' 'wrought' 'iron' 'wrought-iron' 'fireplace'
    sdesc = "poker"
    ldesc =
    {
        "It's a black wrought-iron fireplace poker. It's about
        half an inch in diameter, and a couple of feet long.";
        pass ldesc;
    }
    verIoPryWith(actor) = {}
    ioPryWith(actor, dobj) =
    {
        "The poker is too blunt, and you probably couldn't get
        any leverage with it anyway.";
    }
    ioSynonym('PryWith') = 'OpenWith'
    verDoSharpenWith(actor, iobj) = {}
;

fireBrush: item
    location = fireHolder
    noun = 'brush'
    plural = 'tools'
    sdesc = "brush"
    ldesc = "It's a black brush with a two-foot metal handle, useful
        for sweeping ashes out of a fireplace."
;

fireShovel: item
    location = fireHolder
    noun = 'shovel'
    plural = 'tools'
    sdesc = "shovel"
    ldesc = "It's a small black shovel with a two-foot metal handle,
        useful for collecting ashes out of a fireplace."
    verDoDigWith(actor, iobj) =
    {
        "It's far too flimsy for digging. It's only useful for
        cleaning out fireplaces.";
    }
;

medicineCabinet: fixeditem, openable
    isopen = nil
    sdesc = "medicine cabinet"
    noun = 'cabinet'
    adjective = 'medicine'
    location = eichlerBath1
    ldesc =
    {
        if (self.isbroken)
            "The front is the cabinet is bare, unpainted metal.
            It has a frame, where it used to hold a mirror. ";
        else
            "It's a small medicine cabinet, the door of which
            is covered by a mirror. ";
        pass ldesc;
    }
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        // treat put mirror in cabinet as put mirror in frame
        if (dobj = mirror)
            medicineFrame.ioPutIn(actor, dobj);
        else if (self.isopen)  // we bypassed normal test - must check this
        {
            if (dobj = crowbar)
                "\^<<dobj.thedesc>> won't fit in the cabinet.";
            else
                pass ioPutIn;
        }
        else
            "You'll have to open <<thedesc>> first.";
    }
    doOpen(actor) =
    {
        if (isbroken) pass doOpen;
        "You try to open it, but it's stuck.";
    }
    verDoPryWith(actor, iobj) =
    {
        if (self.isopen)
            "It's already open!";
        else if (self.isbroken)
            "You don't need to pry it; you can just open it.";
    }
    doPryWith(actor, iobj) =
    {
        if (iobj <> crowbar)
            "That doesn't seem to work.";
        else
        {
            "The jammed frame creaks and moans, but it's no match
            for the crowbar, and it quickly opens with a loud cracking
            sound.  As it comes open, the mirror suddenly snaps out of
            the frame, and ";

            if (pillow.location = eichlerSink)
            {
                "lands gently on the pillow.";
                mirror.moveInto(self.location);
                awardPoints(13, pillow);
            }
            else
            {
                "and crashes down onto the sink.  Glass flies everywhere.
                \n\tThe programmer walks in, evidently having
                heard the commotion.
                \"It looks like you tried to open the medicine cabinet,\"
                he says. \"I should have warned you about that. It's yet
                another of the high-quality accessories of this house.
                The mirror always pops out when the medicine cabinet is
                opened.\"
                \n\tHe walks out, and returns with a broom.  \"I'll have
                to go get another mirror,\" he says as he sweeps up the
                glass. \"I'll just be a few minutes. There's a mirror
                store right across the street.\"";

                programmer.moveInto(eichlerBath1);
                programmer.state := 1;
                programmer.state1pos := 1;

                mirror.moveInto(nil);
                awardPoints(13, medicineCabinet);
            }

            isbroken := true;
            isopen := true;
        }
    }
    doSynonym('PryWith') = 'OpenWith'
;

eichlerSink: fixeditem, surface
    sdesc = "sink"
    noun = 'sink' 'faucet' 'tap'
    location = eichlerBath1
    ldesc = "It's a small sink made of cheap plastic, intended to
        look like it's made of marble."
    ioSynonym('PutOn') = 'PutIn'
    verDoTurnon(actor) =
    {
        "There's probably a water shortage in Hell. You shouldn't
        run up someone else's water bill.";
    }
    verDoTurnoff(actor) = { "It's already off."; }
;

programmerShadow: follower
    noun = 'programmer'
    myactor = programmer
;

programmer: Actor
    isHim = true
    myfollower = programmerShadow
    sdesc = "programmer"
    noun = 'programmer'
    location = eichlerBR1
    ldesc =
    {
        "You can tell just looking at him that he does nothing
        but program all day:  he looks pale, even for a dead guy,
        and he's dressed in jeans and a t-shirt, the canonical
        uniform of the software developer.";
        if (infernoBadge.isIn(self))
            " Clipped to one of his pockets is a small plastic card.";
        if (mirror1.isIn(self)) " He's carrying a mirror.";
    }
    actorDesc =
    {
        switch(location)
        {
        case eichlerBR1:
            "A programmer is sitting in front of the computer, looking at
            a screenful of C code.";

            if (not self.ridiculed and
                parachute.isworn and flippers.isworn)
            {
                "\n\tThe programmer looks up at you. \"What's with the
                ridiculous outfit?\" he asks, as though he didn't know.";
                ridiculed := true;
            }
            break;

        default:
            "A programmer is here";
            if (mirror1.isIn(self)) ", carrying a mirror."; else ".";
        }
    }
    state = 0
    state1pos = 0
    state1travelName =
    [
        'out into the hall'
        'west down the hall'
        'north into the kitchen'
        'out the door'
        'out into the street'
        'north into the mini-mall parking lot'
        'into the "Just Mirrors" store'
        'out into the parking lot'
        'back into the "Just Mirrors" store'
        'back out into the parking lot'
        'south into the street'
        'into his yard'
        'into his house'
        'into the hall'
        'down the hall to the east'
        'into the bathroom, and carefully pops the mirror into
        the frame and closes the medicine cabinet. "I\'ll have
        to get this medicine cabinet fixed at some point", he says'
        'out into the hall'
        'into his office, and sits down'
    ]
    state1travelDest =
    [
        eichlerHall2, eichlerHall, eichlerKitchen, eichlerYard,
        suburbWest, minimall, mirrorStore, minimall, mirrorStore,
        minimall, suburbWest,
        eichlerYard, eichlerKitchen, eichlerHall, eichlerHall2,
        eichlerBath1, eichlerHall2, eichlerBR1
    ]
    report(msg) =
    {
        if (location = Me.location) say(msg);
    }
    lookForCard = true     // go back and look for the card if dropped
    actorDaemon =
    {
        switch(state)
        {
        case 0:
            self.report(
              ['\bThe programmer types a bunch of code into the computer.'
               '\bThe programmer makes a few notes on some scratch paper.'
               '\bThe programmer looks pensively at the screen.'][rand(3)]);
            break;

        case 1:
            self.report('\bThe programmer travels '
                        + state1travelName[state1pos] + '.');

            self.moveInto(state1travelDest[state1pos]);
            if (location = eichlerBath1)
                self.report('\bThe programmer walks in carrying a new mirror.
                            He carefully pops the mirror into the frame
                            and closes the medicine cabinet. "I\'ll
                            have to get this medicine cabinet fixed
                            at some point," he says.');
            else if (location = minimall)
                self.report('\bThe programmer walks into the lot.');
            else if (location = suburbWest or location = eichlerYard)
                self.report('\bThe programmer walks into the area.');
            else
                self.report('\bThe programmer walks into the room.');

            // move on to next position on track
            ++state1pos;
            if (state1pos > length(state1travelDest))
            {
                self.report(' He sits down and goes back to work.');
                state := 0;
                if (eichlerDrawer.isopen)
                {
                    self.report(' He notices the desk drawer is open.
                      "You haven\'t been looking through my things, have
                      you?" he asks accusingly as he closes the drawer.');
                    eichlerDrawer.isopen := nil;
                }
            }

            if (location = mirrorStore)
            {
                if (mirror1.isIn(self))
                {
                    if (infernoBadge.location = self.location)
                    {
                        self.report(' He starts looking around. He spots
                               his ID card, picks it up, and fastens
                               it to his pocket again.');
                        infernoBadge.moveInto(programmer);
                    }
                    else
                        self.report(' He walks around the store, looking
                               for something.');
                }
                else
                    state := 2;
            }
            
            /*
               if we didn't drop the card, or if we picked it up again,
               don't go back and look for it
            */
            if (location = minimall and mirror1.isIn(self)
                and (not lookForCard or infernoBadge.isIn(self)))
                state1pos += 2;
            
            if (location = eichlerBath1)
            {
                mirror.moveInto(medicineFrame);
                mirror1.moveInto(nil);
                medicineCabinet.isopen := nil;
                medicineCabinet.isbroken := nil;
            }
            break;

        case 2:
            self.report('\bThe programmer looks around the store. He finds
                         a suitable replacement mirror and takes
                         it up to the counter.');
            ++state;
            break;

        case 3:
            self.report('\bThe programmer reaches into his pocket and gets out
                        some money.');
            if (infernoBadge.isIn(self))
            {
                self.report(' As he does, you notice that his
                              ID card drops to the floor.');
                infernoBadge.moveInto(self.location);
            }
            else
                lookForCard := nil;
            self.report(' He pays the shopkeeper for the mirror.');

            mirror1.moveInto(programmer);
            state := 1;                    // resume travel on next turn
            break;
        }
    }
    actorAction(v, d, p, i) =
    {
        "\"Sorry, I'm in the middle of something.\"";
        exit;
    }
    askWord(word, lst) =
    {
        switch(word)
        {
        case 'himself':
        case 'programmer':
        case 'him':
            "\"Unfortunately, I didn't have time to type in my
            autobiography here.\"";
            break;

        case 'id':
        case 'badge':
            "\"I used to work at Infernolab. I guess I never
            turned in my ID badge.";
            if (infernoBadge.isIn(self))
                " Have you seen it? I seem to have lost it.";
            "\"";
            break;

        case 'infernolab':
        case 'lab':
            "\"I used to work there, but I quit. They just never seem
            to get anything done around there. The Dimensional Networking
            guys in particular are total losers -- get them anywhere near
            alcohol, and they'll be gone for the day.\"";
            break;
        default:
            return(nil);
        }
        return(true);
    }
    disavow = "\"I'd love to chat, but I'm busy.\""
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        if (dobj = infernoBadge)
        {
            "\"Thanks!  I've been looking all over for that!\" He takes
            it back and clips it to his pocket.";
            dobj.moveInto(self);
        }
        else
            "\"No, thanks.\"";
    }
    ioSynonym('GiveTo') = 'ShowTo'
;

infernoBadge: clothingItem
    location = programmer
    iscard = true  // it's a card - can put it into the infernolab slot
    sdesc = "ID card"
    adesc = "an ID card"
    noun = 'card' 'badge' 'clip'
    adjective = 'ID' 'small' 'plastic'
    ldesc =
    {
        if (location = programmer)
            "You can't get a very good look (not without being
            impolite, at least).  You can see \"INFERNOLAB\" spelled
            out in large letters.";
        else
            "It's a little larger than a credit card, and it looks
            quite a lot thicker.  It's labeled \"INFERNOLAB\" in large
            letters, and \"ID/Access Card\" below in smaller letters.
            It has a low-resolution picture of the programmer on it.  It's
            attached with a small plastic strip to a metal clip,
            suitable for attaching it to clothing.";
    }
    doTake(actor) =
    {
        if (location = programmer.location)
        {
            "The programmer notices you picking up the card. \"Thanks! I
            must have dropped it.\" He snatches it out of your
            hands and clips it to his pocket.";
            self.moveInto(programmer);
        }
        else
        {
            inherited.doTake(actor);
            awardPoints(25, self);
        }
    }
    verDoClipTo(actor, iobj) = {}
    doClipTo(actor, iobj) =
    {
        if (iobj = actor) self.doWear(actor);
        else "You can't clip <<thedesc>> to that.";
    }
    doSynonym('ClipTo') = 'AttachTo'
    verDoPutIn(actor, iobj) =
    {
        if (not self.isIn(actor))
            "You're not carrying << thedesc >>.";
    }
;

eichlerBR1: room
    sdesc = "Master Bedroom"
    ldesc = "You're in a large bedroom that's set up as an office.
        In the center of the room is a large desk, on which is a
        personal computer and a big pile of paper.
        \n\tThe hallway lies to the west."
    west = eichlerHall2
;

eichlerComputer: fixeditem
    noun = 'computer' 'monitor' 'keyboard' 'mouse' 'screen' 'display' 'cpu'
    adjective = 'personal'
    sdesc = "computer"
    location = eichlerBR1
    ldesc = "It's a personal computer with the traditional accoutrements:
        mouse, keyboard, monitor, and system CPU unit. The screen is
        displaying a bunch of C code."
    verDoTurnoff(actor) = { "The programmer probably wouldn't like that."; }
    verDoTurnon(actor) = { "It's already on!"; }
;

eichlerCCode: fixeditem, readable
    location = eichlerBR1
    noun = 'code'
    adjective = 'c'
    sdesc = "C code"
    adesc = "a page of C code"
    ldesc = "It doesn't shed much light on what to do next."
;

pencil: item
    sdesc = "pencil"
    noun = 'pencil'
    issharp = nil
    ldesc =
    {
        "It's a standard number 2 pencil. ";
        if (self.issharp)
            "It has a fine point and is ready to write.";
        else
            "It's brand new, and hasn't been sharpened yet.";
    }
    verDoSharpenWith(actor, iobj) = {}
    location = eichlerDrawer
;

eichlerDrawer: fixeditem, openable
    sdesc = "drawer"
    noun = 'drawer'
    adjective = 'desk'
    location = eichlerBR1
    isopen = nil
    doOpen(actor) =
    {
        if (programmer.location = self.location)
            "The programmer stops you. \"Hey! Leave that alone! What do you
            think? That this is your own private hell?\"";
        else
            pass doOpen;
    }
;

pencilSharpener: item
    noun = 'sharpener'
    adjective = 'electric' 'pencil'
    location = eichlerDesk
    sdesc = "pencil sharpener"
    ldesc = "It's an electric pencil sharpener.  It has a pencil-sized
        hole on one end.  There's also a small compartment (which
        is << sharpenerCompartment.isopen ? "open" : "closed" >>)."

    // sharpen x with sharpener is the same as put x in hole
    verIoSharpenWith(actor) = {}
    ioSharpenWith(actor, dobj) = { sharpenerHole.ioPutIn(actor, dobj); }

    // redirect open and close to the compartment
    verDoOpen(actor) = { sharpenerCompartment.verDoOpen(actor); }
    doOpen(actor) = { sharpenerCompartment.doOpen(actor); }
    verDoClose(actor) = { sharpenerCompartment.verDoClose(actor); }
    doClose(actor) = { sharpenerCompartment.doClose(actor); }

    // put x in sharpener gets redirected to either the compartment or hole
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (isclass(dobj, batteryItem))
        {
            // explicitly run verification now, but hide it first time
            outhide(true);
            sharpenerCompartment.verIoPutIn(actor);
            if (outhide(nil))
                sharpenerCompartment.verIoPutIn(actor);
            else
                sharpenerCompartment.ioPutIn(actor, dobj);
        }
        else
            sharpenerHole.ioPutIn(actor, dobj);
    }
;

sharpenerHole: fixeditem
    noun = 'hole'
    adjective = 'pencil' 'sharpener' 'size' 'sized'
        'pencil-sized'  'pencil-size'
    sdesc = "pencil-sized hole"
    location = pencilSharpener
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = pencil)
        {
            if (goodBattery.location = sharpenerCompartment)
            {
                if (dobj.issharp)
                    "It doesn't need any more sharpening.";
                else
                {
                    "The pencil sharpener whirs for several seconds
                    as you feed the pencil in.  You take the pencil
                    out and find it sharpened and ready for writing.";

                    dobj.issharp := true;
                }
            }
            else
                "The pencil sharpener doesn't do anything.
                You withdraw the pencil from the hole and
                find it exactly as sharp as when you inserted it.";
        }
        else if (dobj = firePoker)
            "That's way too big.  Besides, this is a pencil sharpener --
            you can't seriously expect that it could sharpen wrought
            iron.";
        else
            "You can't sharpen that.";
    }
;

sharpenerCompartment: fixeditem, batteryCompartment
    noun = 'compartment'
    adjective = 'small' 'sharpener'
    location = pencilSharpener
    sdesc = "sharpener compartment"
    isopen = nil
;

deadBattery: batteryItem
    location = sharpenerCompartment
    sdesc = "Infern-O-Vac battery"
    adesc = "an Infern-O-Vac battery"
    ldesc = "It's an Infern-O-Vac type HH battery."
    adjective = 'infern-o-vac' 'infernovac' 'type' 'hh'
;

eichlerDesk: fixeditem, surface
    noun = 'desk'
    sdesc = "desk"
    location = eichlerBR1
    ldesc = 
    {
        "It's a very large desk, perhaps six feet wide by three
        feet deep, made from dark wood and done in Danish Modern
        style.  One half of the desk is occupied by a computer,
        and most of the rest of the desk is covered with papers.
        The desk has a drawer, which is << eichlerDrawer.isopen ?
        "open" : "closed" >>. ";
        pass ldesc;
    }
;

eichlerChair: fixeditem
    location = eichlerBR1
    noun = 'chair'
    sdesc = "chair"
    ldesc =
    {
        "It's a high-backed black leather chair. ";
        if (programmer.location = self.location)
            "A programmer is already sitting in the chair.";
    }
    verDoSiton(actor) =
    {
        if (programmer.location = self.location)
            "A programmer is already sitting in the chair.";
        else
            "That's the programmer's chair; he'll probably want to sit
            there when he gets back.";
    }
;
        
cheezDoodles: container
    location = eichlerDesk
    sdesc = "bag of Cheese-Doodles"
    noun = 'doodle' 'doodles' 'bag' 'cheese-doodle' 'cheese-doodles'
           'cheez-doodle' 'cheez-doodles'
    adjective = 'cheez' 'cheese' 'empty'
;

toxicola: item
    location = eichlerDesk
    sdesc = "empty can of ToxiCola"
    adesc = "an empty can of ToxiCola"
    noun = 'toxicola' 'can'
    adjective = 'empty'
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) =
    {
        if (dobj = lakeWater or dobj = bucketWater)
        {
            "As you put the water in the can, some sort of chemical
            reaction starts taking place:  you can hear bubbling and
            popping from within the can.  The can starts to grow hot --
            so hot that you're forced to drop it.  As you watch, the
            metal of the can starts to dissolve, and the can quickly
            disappears in a puff of smoke.";

            self.moveInto(nil);
            if (dobj = bucketWater) dobj.moveInto(nil);
        }
        else
            "That doesn't fit through the tiny opening.";
    }
    verDoFillWith(actor, iobj) = { self.verIoPutIn(actor); }
    doFillWith(actor, iobj) = { self.ioPutIn(actor, iobj); }
    verIoPourIn(actor) = {}
    ioPourIn(actor, dobj) = { dobj.doPourIn(actor, self); }
;

eichlerPaper: fixeditem, readable
    location = eichlerBR1
    noun = 'paper' 'pile' 'note' 'notes'
    adjective = 'big'
    sdesc = "pile of paper"
    ldesc = "There's pieces of scratch paper spread out all over the
        desk, except for the half of the desk occupied by the computer.
        Some of the pieces have a bunch of hex numbers with little
        arrows next to them; others have strange maps consisting of
        little squares (each with a label such as \"Hall East\")
        connected by lines, and others have lists with about half of
        the items crossed off and the other half squeezed into the
        last inch at the top of the page."
    verDoTake(actor) = { "You don't need those."; }
;

eichlerBR2: room
    sdesc = "Small Bedroom"
    ldesc = "You're in a small bedroom.  The room is almost entirely
        filled by the bed.  The hall is to the north."
    nw = eichlerHall2
    north = eichlerHall2
;

dollar: item
    sdesc = "dollar bill"
    noun = 'bill'
    adjective = 'dollar'
    ldesc = "It looks like real United States currency. You
        can't imagine how it got into this game."
;    

eichlerBed: beditem
    sdesc = "bed"
    ldesc =
    {
        "The bed almost fills the room. ";
        pass ldesc;
    }
    noun = 'bed'
    location = eichlerBR2
    verDoLookunder(actor) = {}
    doLookunder(actor) =
    {
        if (self.issearched)
            "You don't find anything more.";
        else
        {
            "You find a dollar bill!  It's too bad that US currency
            is totally useless in this game.";
            dollar.moveInto(Me);
            issearched := true;
        }
    }
    doSynonym('Board') = 'Enter'
    reachable = ( [] + self )
;

pillow: item
    sdesc = "pillow"
    location = eichlerBed
    noun = 'pillow'
;

bedspread: item
    sdesc = "bedspread"
    location = eichlerBed
    noun = 'bedspread' 'blanket' 'comforter'
    verIoCoverWith(actor) = { self.verDoPutOn(actor, nil); }
    ioCoverWith(actor, dobj) = { dobj.ioPutOn(actor, self); }
;

