/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *
 *      551-point extensions:
 *      djp     In real life:   David J. Picton
 *
 *      Chaser code:
 *      bjs     In real life:   Bennett J. Standeven
 *
 * Modification History
 *
 *
 * AD551
 * =====
 *
 * 14-Apr-99    djp     Initial release of Adventure 551 (1.01)
 *
 * 23-Apr-99    djp     New release (1.10) of Adventure 551.
 *                      Changes since version 1.01:
 *                      * added code for drinking wine from a container
 *                      * changed the coding for the crystal ball.  The
 *                        puzzle had unintentionally been made harder because
 *                        the ball worked only in dark rooms, whereas in the
 *                        Fortran version it worked anywhere inside the cave.
 *                        Now things have been made a little easier; the ball
 *                        works within the cave and in indoor locations outside
 *                        the cave.
 *
 * 30-Apr-99    djp     New release (1.11) of Adventure 551.
 *                      Changes since version 1.10
 *                      * adjusted vocab. for canister
 *
 * 17-May-99    djp     New release (1.20)
 *                      Changes since version 1.11
 *                      * Corrected doWear method for crown to issue messages
 *                        in the right order.
 *                      * The crystal ball now works in all locations inside
 *                        the cave, as in the original.
 *                      * Changed the spelling of canister to cannister in the
 *                        sdesc.
 *
 * 20-May-99    djp     New release (1.21)
 *
 * 15-Jul-99    djp     New release (2.00)
 *                      Changes since version 1.21
 *                      * Added two new rings and a cryptic note for the
 *                        revised dwarf protection.
 *                      * Changed canister back to one 'n' (following
 *                        feedback from r.a.i.f. which suggested that this
 *                        is the preferred spelling on both sides of the Pond.
 c                        A few dictionaries list 'cannister' but most don't.)
 *                      * Added checks to stop the cloak being taken off
 *                        in the Hall of Ice.
 *                      * Made the Mountain King's sign into a portable object
 *                        (and moved it to ccr_item - now in ccr-itm2)
 *
 * 3-Aug-99     djp     Bugfix release - Version 2.01
 *                        Changes in this version
 *                      * Corrected the coding for examining and putting things
 *                        into the canister.
 *                      * Added a verDoPutIn check to stop the cloak being
 *                        put in a container when you're in the Hall of Ice.
 *
 *              djp     New release - Version 2.02
 *                        Changes in this version
 *                      * Reworked the checks to stop the cloak being
 *                        put in a container when you're in the Hall of Ice.
 *
 * 9-Nov-99     djp     New release - Version 2.10
 *                      * Split ccr-item.t and ccr-npc.t into two files to
 *                        facilitate integration of ad551 updates into
 *                        Bennett Standeven's 550-point game.
 *                      * Incorporated some of Bennet Standeven's mods into
 *                        the code for easier integration of new versions.
 *
 * 17-Feb-00    djp     New release - Version 2.20
 *                        Changes in this version
 *                      * Further generalization of version handling
 *
 * POLYADV
 * =======
 *
 * 24-Aug-99    bjs     Pre-release version 0.00
 *              bjs     Added 550-point extensions, split up items and npcs
 *                      into 3 files; 1 for each version.
 *
 *          djp+bjs     Incorporated ad551 mods up to 2.20
 *
 * 3-Mar-00     djp     Initial beta release - Version 1.00
 *
 * 4-Apr-00     djp     Version 1.01: bugfix release
 *                      Changes in this version
 *                      * Systematically added isThem properties to plural
 *                        objects (i.e. where sdesc is a plural phrase)
 *                      * Added code to make the mushrooms regrow after
 *                        being eaten in the wrong place.
 *                      * flowers.dobjGen changed to dobjCheck (to tighten
 *                        up on allowed interactions.)
 *                      * Changed the scrap of paper to appear in the
 *                        550-point game as well.
 *                      * Adjusted the doRub code in protect_ring to do
 *                        nothing unless protection is nonzero.  (To disable
 *                        protection in a given game version, set protection
 *                        to 0 in that version).
 *                      * Added 'star' as a noun for the sapphire (but this
 *                        will cause prompting if the rod is also present)
 *                      * Changed the code for blowing the horn to accommodate
 *                        the fact that it is now possible in the dark.
 *                      * Used moveLoclist to move the sideHole into position.
 *                        (loclists should not be modified directly).
 *
 * 4-May-00     djp     Version 1.02: bugfix release
 *                      Changes in this version
 *                      * Corrected a coding error which caused comments
 *                        to appear when the scrap of paper is read.
 *
 * 15-May-00    djp     Version 1.03: bugfix release
 *                      Changes in this version
 *                      * Corrected a minor bug in the code to check whether
 *                        a cage can't be put into the sack.
 *                      * Removed explicit takepoints/depositpoints for crown.
 *
 * 18-Sep-00    djp     Version 2.00: New version with 701-point game
 *                      Changes in this version:
 *                      * Changed scrap of paper for 701-point version (only
 *                        rings provide protection)
 *                      * Changed rare book text for 701-point game.
 *                      * Changed crystal ball code to cater for the
 *                        Catacombs and for the possibility of more
 *                        Chasers (blob, goblins).
 *              
 * 17-Aug-01    djp     Version 2.06: bugfix release with e-mail address update
 *                      Changes in this version:
 *                      * Added method for clicking the slippers.
 *                      * Corrected message when rubbing rings etc. to 
 *                        allow for two swords.
 *                      * Deleted the noun 'mushroom' from the colored
 *                        mushrooms to make it easier to distinguish them
 *                        from the small mushroom in the 701-point game.
 *
 * 22-Nov-01    djp     Version 2.08: bugfix release
 *                      Changes in this version:
 *                      * Corrected the message when the horn is blown 
 *                        at east end of corridor (this can occur after the
 *                        player sat on the throne without royal credentials)
 *                      * Changes to the rare book text.
 *
 * 13-Jan-03    djp     Version 2.09 rev C: bugfixes and code tidy-up
 *                      Changes in this version:
 *                      * Eliminated 'yanking' property.
 *                      * Moved sack_of_holding into ccr-fun.t
 *                      * Made the handling of SEARCH and LOOK IN more
 *                        consistent with current adv.t practice - see comments
 *                        in history.t.  Eliminated the use of unnecessary
 *                        doLookin/doSearch methods for containers.
 *                      * Adjustment to the throne sign description.
 *                      * Changes to the mushroom and cake code so that the
 *                        player can return to Cramped_Chamber, particularly
 *                        after the key has been left on the shelf.  The 
 *                        mushroom is always regrown after being eaten, and
 *                        the player is allowed to find another cake.
 *                      * Objects which weren't in the original 501-point
 *                        game have now been moved to ccr-it11.t.
 *                      * Correction to the crown vocab ('gold' should be
 *                        an adjective)
 *
 * 31-May-03    djp     Version 2.10: minor bugfixes and enhancements
 *                      Changes in this version:
 *                      * Changes to the mushroom/cake code (eating the 
 *                        mushrooms is now always the trigger for regrowth,
 *                        rather than eating the cake.)  Cases with the
 *                        player in a nested room are now handled better.
 *                      * Change to the crystal ball code.  If the player 
 *                        is wearing the gold ring, the sapphire is now
 *                        teleported along with the elves.
 *                      * Correction to the crown vocab ('gold' is now
 *                        an adjective).
 *                      * Correction to the code for counting the cakes.
 *
 * 12-Aug-03    bjs     Version 2.11: added 580-point mode.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Changed the crystal ball code to show the top-level
 *                        location if there is one.
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Simplified the response to attempting to blow the
 *                        horn in the presence of Wumpi.  (Tailoring this
 *                        response to every situation would now require
 *                        complex code, so a fixed reply is given).
 *                      * Corrections to the code to stop the player from
 *                        eating mushrooms when no cakes are available.
 *                        The new code requires that the cakes be inside 
 *                        the player's top-level location or Cramped_Chamber,
 *                        but not on the steps.
 *
 * 16-Jul-06    djp     Version 3.20: Bugfixes and extensions
 *                      * Modified code for cask.doDrink. The players' new
 *                        location is changed to At_Fork_In_Path if the
 *                        troll would block the route to the normal location.
 *                        Care is taken not to turn on the lamp if it has
 *                        run out of power.  The safe door is closed if
 *                        it was open.  Some rooms and areas now have 
 *                        properties to prevent drinking where this would be 
 *                        inappropriate, e.g. the far side of the Wheat-stone 
 *                        Bridge.
 *                      * New code associated with the availability of the 
 *                        "phleece" command in the 701+ point game (when the
 *                        bracelet has been found).  It is now possible to 
 *                        use the sapphire to spy more than once on the
 *                        Castle Room.  If this happens, the elves send the
 *                        sapphire to the Troll.
 * 21-Nov-10      djp     Version 3.21
 *                      * Adjustments to the text after the emerald has
 *                        been transported to the Octagonal Castle Room.
 *                        (The PC refuses to repeat the word "kata" and tries
 *                        to do the same with "plugh", but a hollow voice
 *                        says the word anyway.)
 */


/* 9 */

pole: initmess, item
    game551 = true
    mass = 2
    sdesc = "wooden pole"
    ldesc = {"It's just a simple wooden pole";
        if (not self.moved)
            ", stuck in the mud.  %You% can probably take it. ";
        else
            ". ";
    }
    noun = 'pole'
    adjective = 'wooden'
    location = Salt_Marsh_Edge
    islong = true
    initdesc = "A wooden pole has been stuck in the mud here. "
    fromloc = Saltmud
    verDoSpinOver(actor,io) = {} // attempt to spin over fissure
;

/* 46 */
flowers: canpick
    game551 = true
    mass = 1
    isThem = true
    sdesc = "beautiful flowers"
    adesc = {self.sdesc;}
    ldesc = {
        if (not Bees.arefed)
            "I don't really know what species they are, but they are
            attractive blue and yellow flowers.  ";
        else
            "The bees are swarming around the flowers, and %you% can't get
            close to them now!";
    }
    noun = 'flowers'
    adjective = 'attractive' 'beautiful' 'yellow' 'blue' 'wild'
    location = Ocean_Vista
    isfixed = (Bees.arefed)
    isListed = (not Bees.arefed)

    doSmell(actor) = {
        "The fresh flowers have a fragrant scent.";
    }

    heredesc = {
        if (Bees.arefed) {
            P(); I();
            "The bees are eagerly swarming over the fresh flowers, collecting
            nectar to take back to the hive.";
        }
    }

    verDoCount(actor) = {self.verDoSmell(actor);}
    doCount(actor) = {
        "You have roughly 20 flowers. ";
    }

    dobjCheck(a, v, i, p) = {
        if ((v <> inspectVerb) and (v <> gonearVerb) and Bees.arefed) {
            "The hum of the bees rises to an angry buzz as %you%
            move%s% towards the flowers.";
            exit;
        }
    }

    iobjCheck(a, v, d, p) = {
        if (v = askVerb or v = tellVerb or v = waveVerb) return;
        self.dobjCheck(a, v, d, p);
    }

;
/* 71 */
cask: liquidcont  // Not a treasure in this implementation - the wine
              // in the cask is now the treasure.
    game551 = true
    mass = 3
    noun = 'cask'
    adjective = 'oak' 'oaken' 'wooden' 'wood'

    islarge = true  // too large to go into the safe
    contname = "cask"
    sdescbase = "oaken cask"
    emptydesc = "empty oaken cask"
    adesc = {"an ";self.sdesc;}

    location = Ledge_Above_Pinnacles

/* if the plant is small, water it twice */
    doPourOn(actor, io) = {

        if (self.haswater and (io = Plant) and (Plant.size = 0)) {
            inherited.doPourOn(actor,io);
            self.haswater := true;
            inherited.doPourOn(actor,io);
        }
        else inherited.doPourOn(actor,io);
    }
    // Code for drinking wine from the container.  The adventurer
    // ends up somewhere, with only the lamp and axe; other stuff is
    // dropped in the top location.  Embellishments added in the TADS
    // port are:  the lucky clover also ends up with the adventurer, and
    // having the clover stops you from ending up in a maze.  All pendants
    // stay on if worn.
    //
    // Note that the general liquidcont.verDoDrink method prevents this code
    // from being called in some circumstances (e.g. during the player's
    // encounters with Wumpi.)

    winocode = {
        local toploc := toplocation(Me);
        local newloc,inv,o,i,l,newturns;
        "The wine goes right to your head.  You reel around in a
        drunken stupor and finally pass out.  You awaken with a
        splitting headache, and try to focus your eyes.... "; P();
        Me.health := (Me.health*80)/100;
        if(Me.health < 20) Me.health := 20;
        if(isclass(toploc,Outside))
            newloc := In_Forest_1;
        else if (toploc.wino_trollstop and not (Troll.location = nil))
            newloc := At_Fork_In_Path; // player blocked by troll
                           // N.B a drunken player loses the slippers and is
                           // incapable of using the boat, so
                           // this condition applies in the areas of the
                           // Winery, Crystal Palace and Lost River.
        else if (clover.isInside(Me)) {
            newloc := Cloak_Pits;
        }
        else {
            if(rand(100) < 15) newloc := Alike_Maze_9;
            else if(rand(100) < 25) newloc := Different_Maze_4;
            else newloc := Cloak_Pits;
        }
        if (brass_lantern.isIn(Me) and (brass_lantern.turnsleft > 0))
            brass_lantern.turnon;
        // shorten the lamp life
        if (brass_lantern.turnsleft > 25 and brass_lantern.ison) {
            newturns := brass_lantern.turnsleft -
            rand(brass_lantern.turnsleft)/ 10;
            if (newturns < 25) newturns := 25;
            brass_lantern.setlife(newturns);
        }
        inv := Me.contents;
        l := length(inv);
        for (i := 1; i <= l; i++) {
            o := inv[i];
            if (isclass(o,pendantItem) and o.isworn) 
            continue;
            if (o = brass_lantern or o = axe or o = clover)
                o.moveInto(newloc);
            else
                o.moveInto(toploc);
        }
        // close the 550-point safe
        In_Safe.isopen := nil;
        In_Safe.out := nil;
        // move the player
        Me.travelTo(newloc);
    }
;

/* 80 */

coal: item
    // This item was stolen from Funadv.  Its use is somewhat surprising, but
    // it is in keeping with the original 350-point game.
    game551 = true
    mass = 2
    sdesc = "bag of coal"
    ldesc = "It's just a small bag of coal.  I expect it will be useful
            for something, though."
    noun = 'coal' 'coals' 'bag'
    adjective = 'bag' 'coal'
    location = Hall_Of_Ice
    verIoTakeOut(actor) = {}
    verDoTakeOut(actor,io) = {
        if (io = self) "%You%'d better leave the coal
            in the bag.  ";
        else pass verDoTakeOut;
    }
    verIoPutIn(actor) = {"The bag is full of coal and there's no room
    for anything else. ";}
    verDoLookin(actor) = {}
    verDoSearch(actor) = {}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = "%You% see coal inside the bag."
;

/* The following are contliquids for the 551-point version. */

/* 82 */
water_in_the_cask: contliquid
    game551 = true
    mycont = cask
    myflag = &haswater

    sdesc = "water in the cask"
    adesc = "water"
    ldesc = "It looks like ordinary water to me."
    thedesc = "the in-cask water"
    adjective = 'in-cask' 'water'
    noun = 'water'
;
/* 84 */
oil_in_the_cask: contliquid
    game551 = true
    mycont = cask
    myflag = &hasoil

    sdesc = "oil in the cask"
    adesc = "oil"
    ldesc = "It looks like ordinary oil to me."
    thedesc = "the in-cask oil"
    adjective = 'in-cask' 'oil'
    noun = 'oil'
;

/* 86 (wine_in_the_cask) is a treasure item */


/* 90 */
/* Most possessions shrink or expand with the player, but the tiny key
   must stay the same size. */

/* seen when large */
tiny_key: keyItem
    game551 = true
    mass = 1
    sdesc = "tiny brass key"
    ldesc = "It's a minute brass key, for a tiny lock."
    location = nil
    noun = 'key'
    adjective = 'tiny' 'brass'
;

/* seen when normal size */
small_key: keyItem
    game551 = true
    mass = 1
    sdesc = "small brass key"
    ldesc = "It's a small brass key. It looks larger than when
            you took it.  You realize that you've shrunk (together
            with your possessions), but the key has stayed the same
            size!"
    location = Shelf
    noun = 'key'
    adjective = 'small' 'brass'
;

/* seen when small */
large_key: keyItem
    game551 = true
    mass = 2
    sdesc = "large brass key"
    ldesc = "It's a large brass key. It looks far larger than when
            you took it.  You realize that you've shrunk (together
            with your possessions), but the key has stayed the same
            size!"
    location = nil
    noun = 'key'
    adjective = 'large' 'brass'
;


/* 95 */
slugs: coinitem, initmess
    game551 = true
    mass = 3
    isThem = true
    sdesc = "lead slugs"
    adesc = "some lead slugs"
    ldesc = "They look similar to coins, and have a crude design stamped
        on them.  Maybe they are actually used as a form of currency 
        within the cave. "
    initdesc = "There are some lead slugs here!"
    noun = 'slugs'
    adjective = 'lead'
;

/* 96 */

honeycomb: fooditem
    game551 = true
    mass = 2
    sdesc = "sweet honeycomb"
    ldesc = "It looks delicious, but something in the back of your mind
        cautions you against eating it - you may need it for something else. "
        noun = 'honeycomb' 'comb' 'honey'
    adjective = 'sweet' 'honey'
    location = nil /* moved into hive when bees are fed */
;

/* 106 */

mushrooms: fooditem, canpick
    game551 = true
    mass = 1
    isThem = true
    sdesc = "some colored mushrooms"
    adesc = { self.sdesc; }
    thedesc = "the colored mushrooms"
    ldesc = "They're just normal-looking colored mushrooms.  They
            appear to be edible, but something in the back of your
            mind advises caution.  You probably shouldn't try them
            until you have a reason to do so. "
    location = In_Forest_3
    growtime = 20
    regrow = {
        self.moveInto(In_Forest_3);
        self.moved := nil; // in case we make this an initmess object
        if (parserGetMe().isIn(self.location)) {
            P(); I();
            "There are some colored mushrooms here! ";
        }
    }
    noun = 'mushrooms' 'peyote'
    adjective = 'colored' 'coloured' 'magic'
    doEat( actor ) =
    {
        // make mushrooms effective in Ledge_By_Door, which is really the
        // same place as Top_Of_Steps
        if (not actor.isIn(Top_Of_Steps) and not actor.isIn(Ledge_By_Door)) {
            self.moveInto( nil );
            "You thought maybe these were peyote??  You feel a little
            dizzy, but nothing else happens. ";
            notify(self,&regrow,self.growtime);
        }
        else if(cakes.isIn(Steps))
            "You'd best take the cake off the steps first. ";
        else if(not cakes.isInside(toplocation(actor)) and not
             cakes.isInside(Cramped_Chamber)) {
            "That's not a good idea.  You'd be trapped in here until the 
            effects of the mushroom have worn off, and I don't know how 
            long that would take. ";
            if (toplocation(cakes) = nil) {
                "Maybe one of the cakes ";
                if (cakes.knowdrop)"you dropped ";
                "is around here somewhere. ";
                Steps.cakefind := true;
            }
            else "You'd better go back for that cake. ";
        }
        else {
            self.moveInto( nil );
            eat_messages.larger;
            notify(self,&regrow,self.growtime);
            actor.roomMoveTravel(&transmove,Cramped_Chamber);
        }
    }
;

/* 107 */
cakes: fooditem, readable
    game551 = true
    mass = 1
    isThem = true // initially 
    sdesc = {if (self.iseaten) "tiny cake"; else "tiny cakes";}
    adesc = {if (self.iseaten) pass adesc; else self.sdesc; }
    thedesc = {if (self.iseaten) "the cake"; else "the cakes"; }
    ldesc = {
        if (self.iseaten)
            "It's a little cupcake, which you must have dropped earlier. ";
        else
            "They are tiny cupcakes. "; 
        "On looking closely, %you% can
        just read the words \"Eat Me\" in minute lettering.";
    }
    readdesc = "%You% see the words \"Eat Me\" in minute lettering."
    location = Shelf
    noun = 'tiny' 'cakes' 'cupcakes' 'cake' 'cupcake'
    adjective = 'tiny' 'cup'
    doEat( actor ) =
    {
        if(not actor.isIn(Cramped_Chamber)) {
            "You take a small bite out of the cake, but it has no effect.
            You decide to wait until it's needed again. ";
            return;
        }
        eat_messages.smaller;
        if(tiny_key.isInside(Shelf)) {
            self.knowdrop := true;
            "Oops!  This is not your day. ";
            if (not self.iseaten) {
                "You've dropped at least one of the cakes, but maybe this
                is just as well because you've ";
                self.moveInto(Top_Of_Steps);
            }
            else {
                "Once again you've ";
                self.moveInto(Steps);
                Steps.fullcount++; // total number of cakes found on steps
            }
            "left the key on the shelf where you can't reach it!  You'd
            better go looking for more mushrooms - maybe you'll find some if
            you go back later.  "; 
            if (self.iseaten) "You spot another of the cakes you dropped,
            lying in shadow near the top of the steps. ";
            P();

        }
        else {
            self.moveInto( nil );
        }
        self.iseaten := true;
        isThem := nil;
        actor.roomMoveTravel(&transmove,Top_Of_Steps);
    }
    doCount(actor) = {
        if (self.iseaten) pass doCount;
        else 
            "There's something strange about these cakes which makes it hard
            to count them accurately, but there appear to be about a dozen
            of them. ";
    }
;

/* 108 */
sack: openable
    game551 = true
    mass = 2
    sdesc = "leather sack"
    ldesc = {
        "It's a capacious leather sack, large enough to
        hold most objects.  At present it is ";
        if (self.isopen) "open";
        else "closed";".\n";
        if (self.isopen) {
            if(itemcnt (self.contents) > 0) {
                P(); "It contains ";listcont(self);
                ". ";
            }
        }
    }
    noun = 'sack'
    adjective = 'large' 'leather'

    maxbulk = 100
    location = Inside_Building

    islarge = true  // can't put in safe
    nobird = true
    ioPutIn ( actor, dobj ) = {
        if(dobj.islong) {
            caps(); dobj.thedesc; " is too long to go into ";
            self.thedesc; ".  ";
        }
        else if(dobj.islarge) {
            caps(); dobj.thedesc; " is too large to go into ";
            self.thedesc; ".  ";
        }
        else if(dobj.ishuge) {
            caps(); dobj.thedesc; " is far too large to go into ";
            self.thedesc; ".  ";
        }
        else if((dobj = wicker_cage or dobj.objclass = wicker_cage)
        and length(dobj.contents) > 0){
            "Are you kidding?  %Do% %you% want to suffocate the poor
            bird?";
        }
        else pass ioPutIn;
    }
    // DJP - method to tell sack_of_holding whether this container is
    // suitable for a particular object
    accepts_item(dobj) = {
        if(dobj.islong or dobj.islarge or dobj.ishuge) return nil;
        if((dobj = wicker_cage or dobj.objclass = wicker_cage) and
        length(dobj.contents) > 0) return nil;
        return true;
    }
;

/* 113 */
poster: initmess, readable
    game551 = true
    mass = 1
    sdesc = "poster"
    adjective = 'faded'
    noun = 'poster'
    ldesc =
    "The poster has a picture of a thin man with a long white beard.
    He is wearing a high pointed cap embroidered with strange symbols,
    and he is pointing a finger at you.  Below the picture are the words:
    \"I want you!--To report all good ideas for extensions to this game
    to me without delay.  Remember: ask not what ADVENTURE can do to
    you; ask what you can do for ADVENTURE.\" \n
    -\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *  *  * \n
    \"A public service of the John Dillinger Died for You Society.\" "

    initdesc = "Taped to the wall is a faded poster."

    location = Inside_Building
    verDoLookbehind(actor) = {
        if(self.moved)pass verDoLookbehind;
    }
    doLookbehind(actor) = {
        if (self.moved) pass doLookbehind;
        else {
            "Hidden behind the poster is a steel safe, embedded in the
            wall.";
            Safe.moveInto(Inside_Building);
            Safe.hidden := true;
        }
    }
    doTake(actor) = {
        if(not self.moved) {
            inherited.doTake(actor);
            if (self.isIn(Me)) {
                if(not Safe.isIn(Inside_Building)) {
                    P(); "Hidden behind the poster is a steel safe,
                    embedded in the wall.\n";
                    Safe.moveInto(Inside_Building);
                }
                Dial.moveInto(Inside_Building);
                Safe.hidden := nil;
            }
        }
        else pass doTake;
    }
    fromloc = Walls
;

/* 114 */
whiskbroom: item
    game551 = true
    mass = 1
    sdesc = "small whiskbroom"
    noun='whiskbroom' 'whisk' 'broom' 'brush'
    adjective = 'small' 'whisk'
    location = Tongue_of_Rock
    verIoSweepWith(actor) = {}
    verIoCleanWith(actor) = {}
    ioSweepWith(actor,dobj) = {dobj.doSweepWith(actor,self);}
    ioCleanWith(actor,dobj) = {dobj.doCleanWith(actor,self);}
;

/* 118 */
canister: openable
    game551 = true
    mass = 3
    sdesc = "small metal canister"
    ldesc = {
        "It's a cylindrical container, made from a heavy grey
        metal - possibly lead. At present it is ";
        if (self.isopen) "open";
        else "closed";".\n";
        if (self.isopen) {
            if(itemcnt (self.contents) > 0) {
                P(); "It contains ";listcont(self);
                ". ";
            }
        }
    }
    ioPutIn(actor, dobj) = {
        if(dobj <> glowing_stone) {
            caps(); self.thedesc; " is not a suitable container for ";
            dobj.thedesc; ". ";
        }
        else pass ioPutIn;
    }

    noun = 'canister' 'cannister' 'tube' 'shield'
    adjective = 'small' 'grey' 'gray' 'metal' 'lead'
    isopen = true
    location = At_Window_On_Pit_2
;

/* Additional object (sign on throne) */
thronesign: initmess, readable
    game551 = true
    mass = 1
    sdesc = "Mountain King's sign"
    adesc = "the Mountain King's sign"
    noun = 'sign'
    adjective = 'king\'s'
    initdesc = "On the
        arm of the throne has been hung a sign which reads \"Gone for the
        day: visiting sick snake. --M.K.\""
    fromloc = Throne
    location = Throne_Room_East
    ldesc = "The sign reads: \"Gone for the
        day: visiting sick snake. --M.K.\""
;

/*
 * Treasures
 */
/* 47 */
cloak: initmess,CCR_treasure_item,clothingItem
    game551 = true
    mass = 1
    basis = 3

    sdesc = "silken cloak"
    ldesc = {
        "It's a valuable-looking silken cloak";
        if(not self.moved)
            ", partially buried under the rocks.
            There's little chance of moving the rocks, but you could
            probably yank it out without tearing it. ";
        else if (self.location = Me and self.isworn)
            "(being worn). You feel very warm! ";
        else ". ";
    }
    initdesc = "A lovely silken cloak lies partially buried under a pile of
    loose rocks."

    noun = 'cloak'
    adjective = 'silken' 'lovely' 'warm'

    location = Cloakroom
    fromloc = cloakrocks
    verifyRemove(actor) = {
        if(not self.moved)
            "The cloak is stuck tight under the rocks.  You'll probably
            have to yank it out. ";
        else pass verifyRemove;
    }
    yankobj = (not self.moved)
    doTake(actor) = {
        local m := self.moved;
        inherited.doTake(actor);
        if (self.moved and (not m)) Cloakroom.cave;
    }
    icecheck(actor) = {
        if(self.isworn and self.location = actor and
        actor.isIn(Hall_Of_Ice)) {
            "You'll freeze to death if you take off the cloak in
            here! ";
            return nil;
        }
        else return true;
    }
    verDoUnwear( actor ) = {
        if (self.icecheck(actor)) pass verDoUnwear;
    }
    verDoPutIn( actor, io ) = {
        if (self.icecheck(actor)) pass verDoPutIn;
    }
    verDoPutOn( actor, io ) = {
        if (self.icecheck(actor)) pass verDoPutOn;
    }
    verDoDrop( actor ) = {
        if (self.icecheck(actor)) pass verDoDrop;
    }
    doWear(actor) = {
        local pendanlist := [pendant, pendant2, pendant3, broken_pendant];
        local i, o, l := length(pendanlist), count := 0;
        inherited.doWear(actor);
        for (i := 1; i <= l; i++) {
            o := pendanlist[i];
            if ((self.location = actor) and self.isworn and 
            (o.location = actor) and o.isworn)
                count++;
        }
        if (count = 1)
            "The pendant which you are wearing is now concealed under the 
            cloak. ";
        else if (count > 1)
            "The pendants which you are wearing are now concealed under 
            the cloak. ";  
    }
;

/* 52 */
horn: CCR_treasure_item
    game551 = true
    mass = 2
    basis = 2

    sdesc = "silver horn"
    ldesc = "It appears to be made of solid silver!"
    location = West_Side_Of_Fissure
    noun = 'horn'
    adjective = 'silver'
    verDoBlow(actor) = {self.verDoPlay(actor);}
    doBlow(actor) = {self.doPlay(actor);}
    verDoPlay(actor) = {
        if (Wumpi.isIn(toplocation(actor)) or 
        Wumpi_remnant.isIn(toplocation(actor))) {
            "Don't be ridiculous! ";
        }
    }
    doPlay(actor) = {
        local metop := toplocation(actor);
        if ((not In_Arched_Hall.jericho) and (metop = In_Arched_Hall
        or metop = EW_Corridor_E)) {
            if(actor.location.islit) {
                "As the blast of the horn reverberates through the chamber, the
                seemingly solid rock wall crumbles away, revealing another
                room to the <<In_Arched_Hall_Walls.holedir>>.
                The wall was most likely worn thin by an ancient watercourse 
                which dried up just before completely wearing away the rock. ";
            }
            else {
                "As the blast of the horn reverberates through the chamber,
                you hear a crumbling sound and the acoustics of the room
                change subtly.  You sense that there is now another exit. ";
            }
            In_Arched_Hall.jericho := true;
            Sidehole.moveLoclist([In_Arched_Hall EW_Corridor_E]);
            Corridor_Rubble.moveInto(EW_Corridor_E);
        }
        else if (actor.isIn(Dog.location)) {
            if (Dog.isasleep)
                Dog.sleeplie;
            else
                "The dog growls and barks at %you%.  It clearly doesn't
                like %your% attempt to play the horn.  The result might be
                different if %you% find%s% an instrument %you% CAN play.";
        }
        else if (actor.isIn(Wumpus.location) and Wumpus.isasleep) {
            Wumpus.doWake(actor);
        }
        else if (metop.isoutside and not metop.isindoor)
            "The blast of %your% horn echoes throughout hill and dale.";
        else
            "The chamber reverberates to the blast of the horn.
            (Satchmo %you% ain't!)";
    }
;

/* 65 */
sword: initmess, CCR_treasure_item, weapon
    // Not to be confused with singing_sword.

    // Note that a refinement has been added from v2.00 - its image when seen
    // in a mirror (when waved at Window At Pit or seen in the metal plate) is
    // rusty, and the ogre also sees it as rusty.

    // Note that it is not possible to pour liquids over the sword in the
    // 701-point game - in this version you can only get into this area via
    // the waterfall.

    game551 = true
    mass = 2
    basis = 4

    sdesc = "gleaming sword"
    initdesc = {
        if(self.isclean)"A very clean sword is stuck in the anvil! ";
        else if(self.isoily)"An oily sword is stuck in the anvil. ";
        else "A gleaming sword is stuck into the anvil! ";
    }
    ldesc = {
        if(self.isclean and not self.moved)"It looks like a very clean
            elven sword. ";
        else if(self.isoily)"It's covered in oil, and you can't get
            a firm grip on the handle.  I suspect you won't
            be able to get it now, no matter how hard you try. ";
        else "It's a gleaming elven sword.  Against dwarves, you
            might try using it for hand-to-hand combat.  Due to your lack
            of experience in swordsmanship, I'll assume that you want to
            throw the sword when attacking anything larger. ";
    }

    noun = 'sword'
    adjective = 'gleaming' 'elven'
    location = Sword_Point
    nosack = true  // tell sack_of_holding not to put it into containers
    fromloc = Anvil

    verifyRemove(actor) = {
        if (self.isoily)
            "The handle is now too slippery to grasp. ";
        else if(not self.moved)
            "You grasp the sword's handle and pull, but the sword won't
             budge.  You could try yanking it out.";
        else pass verifyRemove;
    }
    yankobj = (not self.moved and not self.isoily)
    verDoPull(actor) = {
        if (not self.moved) self.verDoTake(actor);
        else pass verDoPull;
    }
    doPull(actor) = {
        if (not self.moved) self.doTake(actor);
        else pass doPull;
    }
    doTake(actor) = {
        if (not self.moved and not (crown.location = actor and
            crown.isworn) ) {
            "You grasp the sword's handle and give a mighty heave, but
            with a loud clang the sword blade shatters into several
            fragments. ";
            self.smash;
        }
        else {
            // DJP.  Stop the dwarves from attacking after the sword is
            // taken (in the original, the dwarves wouldn't attack after
            // any object was taken)
            Dwarves.noattack := true;
            pass doTake;
        }
    }
    verDoClean(actor) = {
        if(self.isoily) "You can't do that without soap of some sort. ";
        else if(self.isclean) "It's already very clean. ";
        else "You'll have to tell me how to do that. ";
    }
    verDoCleanWith(actor,io) = {
        if(self.isoily) "You can't remove the oil without soap of some
            sort. ";
        else "You clean the sword with <<io.thedesc>>, but it doesn't look
        noticeably different. ";
    }
    verIoPourOn(actor) = {
        if (self.moved) "There's no point in doing that now. ";
    }
    verDoWater(actor) = {
        if (self.moved) "There's no point in doing that now. ";
    }
    verDoOil(actor) = {
        if (self.moved) "There's no point in doing that now. ";
    }
    doWater(actor) = {
        if (bottle.isIn(Me) and bottle.haswater)
            bottle.doPourOn(actor, self);
        else if (cask.isIn(Me) and cask.haswater)
            cask.doPourOn(actor, self);
        else if (flask.isIn(Me) and flask.haswater)
            flask.doPourOn(actor, self);
        else
            "%You% %have% nothing to water the sword with.";
    }
    doOil(actor) = {
        if (bottle.isIn(Me) and bottle.hasoil)
            bottle.doPourOn(actor, self);
        else if (cask.isIn(Me) and cask.hasoil)
            cask.doPourOn(actor, self);
        else if (flask.isIn(Me) and flask.hasoil)
            flask.doPourOn(actor, self);
        else
            "%You% %have% nothing to oil the sword with.";
    }
    throwsmash = {
        local toproom := toplocation(self);
        if (toproom.softfloor) {
            "The sword misses. ";
            self.moveInto(toproom);
        }
        else {
            "The sword misses and smashes to smithereens against a rock. ";
             self.smash;
        }
    }
    smash = {
        sword.moveInto(nil);
        swordshards.moveInto(droploc(Me));
        swordshards.moved := nil;
        swordshards.heredesc;
    }
    verDoWear(actor) = {
        "You have no scabbard! ";
    }
;
swordshards: initmess, item
    game551 = true
    bulk = 3 // shards are hard to carry except in a container
    sdesc = "sword fragments"
    adesc = "sword fragments"
    initdesc = "Rusty fragments of a elven sword lie scattered about. "
    ldesc = "Something very odd has happened.  There wasn't a sign of
            corrosion on the sword, but the fragments are now covered in
            a thick layer of rust!"
    noun = 'sword' 'fragments' 'shards'
    adjective = 'sword'
;
/* 66 */
crown: initmess, CCR_treasure_item, clothingItem  // Not to be confused with irid_crown
    game551 = true
    mass = 1
    basis = 2

    sdesc = "elfin crown"
    adesc = {"an ";self.sdesc;}
    ldesc = "It's a small but ancient elfin crown, made of gold and
            encrusted with precious stones of all descriptions.  It must be
            worth an absolute fortune. "

    noun = 'crown'
    adjective = 'gold' 'elfin' 'elvish' 'ancient' 'small'
    initdesc = "An ancient crown of elfin kings lies here!"
    doWear( actor ) =
    {
        if (self.location <> actor) {
            "\n(Trying to take <<self.thedesc>> first)\n";
            self.doTake(actor);
        }
        if (self.location = actor) {
            "\n%You% feel%s% a slight tingling sensation as %you% put on
            the crown ...\n";
            "Okay, %you're% now wearing "; self.thedesc; ". ";
            self.isworn := true;
        }
    }
    location = Throne_Room_East
;

/* 67 */
slippers: CCR_treasure_item,clothingItem
    game551 = true
    mass = 1
    basis = 3

    sdesc = "pair of ruby slippers"
    ldesc = {
        "Close examination of the slippers reveals nothing unusual,
        but the song \"Somewhere, Over the Rainbow\" is going round and
        round in your head and you can't get rid of it! ";

        if(not self.clicked) {
            "You have a strong feeling that these slippers \(are\) special
            in some way.  You don't know the answer but I expect that it
            will all \"click\" sometime.  ";
        }
    }

    noun = 'slippers' 'shoes'
    adjective = 'ruby'

    location = Over_Rainbow

    verDoClick (actor ) = {}
    doClick ( actor ) = {
        if ((not self.isworn) or self.location <> actor) {
             "%You% click%s% <<self.thedesc>> together, but nothing 
             exciting happens. ";
        }
        else clickVerb.action(actor);
    }
;

/* 68 */
lyre: CCR_treasure_item
    game551 = true
    mass = 2

    sdesc = "delicate lyre"
    ldesc = "It's certainly a valuable antique.  In fact, it looks
    like the instrument depicted in ancient Greek art. %You've% never had
    any lessons, but somehow %you% know%s% you'll be able to play it well."
    verDoPlay(actor) = {}
    doPlay(actor) = {
        if (actor.isIn(Dog.location) and
        (not Dog.isasleep)) {
            "The air fills with beautiful music.  The dog gradually becomes
            less fierce, and after a short while he lies down by the side
            of the cavern and falls into a deep sleep.";
            Dog.isasleep := true;
            if (axe.nograb and Dog.location = axe.location)
                axe.nograb := nil;
        }
        else
            "The air is filled with beautiful music.";
    }
    location = Low_N_S_Passage
    noun = 'delicate' 'lyre'
    adjective = 'delicate'
;

/* 69 */
sapphire: CCR_treasure_item
    game551 = true
    mass = 2

    sdesc = "star sapphire"
    ldesc = "Its appearance is very striking - a brilliant blue
            six-pointed star. "
    noun = 'sapphire' 'star' 'starstone'
    adjective = 'star'
    location = Star_Chamber
;

/* 70 */
/* This was called a 'holy grail' in the Fortran but we avoid that description
   in this version - it might mislead people into thinking it has magic
   powers.
*/

chalice: initmess, CCR_treasure_item, liquidcont
/* Actually it can't really hold liquids but we pretend that it does */
    game551 = true
    mass = 2
    basis = 2

    sdesc = "silver chalice"
    contname = "chalice"
    sdescbase = "silver chalice"
    emptydesc = "silver chalice"
    adesc = {"a ";self.sdesc;}
    ldesc = "It's a priceless antique.  However, it appears to be slightly
            cracked, and can't actually be used. "

    initdesc = "There is an ornate silver chalice here! "

    noun = 'chalice' 'grail'
    adjective = 'ornate' 'silver' 'cracked' 'holy'

    location = Gothic_Chapel
    verIoPutIn(actor) = {}
    ioPutIn(actor, dobj) = {
        if (isclass(dobj,roomliquid)) {
            "The chalice is slightly cracked.  It won't hold any
            liquids.";
        }
        else if (not isclass(dobj,contliquid)){
            "You couldn't carry objects around in the
            chalice - they would fall out! ";
        }
    }

    verDoFill(actor) = {
        "The chalice is slightly cracked.  It won't hold any liquids.";
    }
;
/* 71 (oaken cask) was a treasure in the Fortran version but now the wine
   is the treasure. */

/* 72 */
/* N.B. the protect_ring class is now defined in ccr-it11.t */
gold_ring: initmess, CCR_treasure_item, clothingItem, protect_ring
    game551 = true
    mass = 1
    basis = 4
    protection = 3
    sdesc = "small gold ring"
    ldesc = "It's a plain gold ring.  Probably quite valuable, though."
    noun = 'ring'
    plural = 'rings'
    adjective = 'small' 'gold'
    location = nil
    initdesc = "On the Wumpus' finger is a small gold ring!"
    fromloc = Wumpus
    doTake(actor) = {
        if(not self.taken and not self.moved and
        (self.location = Wumpus.location)) {
            "As you slip the ring off the Wumpus' finger, you congratulate
            yourself on a job well done.  You're the first adventurer to 
            turn the tables on this evil, cunning monster!
            Another thought comes into your mind.  Old Elvish lore tells of
            many magic rings, and there's a distinct possibility that this
            may be one of them.  ";
            if(global.game701p and not transindection_key.moved)
                "In a flash of intuition - which also gives you a strange
                sense of foredoding - it occurs to you that the
                Wumpus may have had other possessions.  
                They would, of course, have been hidden away from the
                eyes of light-fingered adventurers like you ... ";
        }
        self.taken := true;
        pass doTake;
    }
;

/* 73 */
clover: CCR_treasure_item, clothingItem
// In the Fortran version this object didn't do anything, but now it
// brings luck in certain circumstances when carried by the player (even if
// it's in a closed container.)  It can be worn.
    game551 = true
    mass = 1
    sdesc = "four-leafed clover"
    ldesc = "It's a rare four-leafed clover, reputed to bring good luck."
    location = Knoll
    noun = 'clover'
    adjective = 'four-leafed' 'lucky'
;

/* 74 */
gold_tree: initmess, CCR_treasure_item
    game551 = true
    mass = 3
    basis = 5

    sdesc = "gold tree"
    ldesc = "It's an intricately carved statue of a tree, in solid gold.
            Every leaf is rendered with exquisitely fine detail, and it
            must be worth a fortune. "
    initdesc = "There is a gold statue of a tree here. "

    noun = 'tree' 'statue'

    adjective = 'statue' 'gold'

    location = Outer_Courtyard
;

/* 75 */
silver_droplet: initmess, CCR_treasure_item
    game551 = true
    mass = 1
    basis = 5

    sdesc = "silver droplet"
    ldesc = "It's a little sphere of mithril silver - an extremely
            rare and highly prized metal.  It's therefore highly
            valuable! "

    initdesc = "There is a single droplet of silver on the ground here. "

    noun = 'droplet' 'silver'

    adjective = 'mithril' 'silver'

    location = Inner_Courtyard

;
/* 86 */
wine_in_the_cask: contliquid, CCR_treasure_item
    game551 = true
    basis = 3

    mycont = cask
    myflag = &haswine

    targloc = cask
    contloc = treasure_chest
    outercontloc = Inside_Building

    sdesc = "wine in the cask"
    adesc = "wine"
    ldesc = "It's a large quantity of sparkling vintage wine.  It
            must be very valuable!"
    thedesc = "the in-cask wine"
    adjective = 'in-cask' 'wine'
    noun = 'wine'
;

/* 110 */
rare_book: CCR_treasure_item, readable
    game551 = true
    mass = 3
    basis = 2
    sdesc = "rare book"
    ldesc = "It's a dusty, leather-bound volume. It looks very valuable!"
    readdesc = {
        switch(global.vnumber) {
            case 1: self.readdesc1; break;
            case 11:
            case 15: self.readdesc15; break;
        }
    }
    readdesc1 = {
    "\ \ \ \ \ \ \ \ *** THE HISTORY OF ADVENTURE (ABRIDGED) ***\n
    \ \ \ \ \ \ \ \ ** By Ima Wimp **";
    P(); I();
    "ADVENTURE was originally developed by William Crowther, and later
    substantially rewritten and expanded by Don Woods at Stanford Univ.
    Crowther's original version was modelled on a real cavern, called
    Bedquilt Cave, which is a part of Kentucky's Mammoth Cave system.
    That version of the game included the main maze and a portion of the
    third-level (Complex Junction - Bedquilt -  Swiss Cheese rooms, etc.),
    but not much more.";
    P(); I();
    "Don Woods and some others at Stanford later rewrote portions of
    the original program, and greatly expanded the cave.  That version
    of the game is recognizable by the maximum score of 350 points.";
    P(); I();
    "Some major additions were done throughout 1978 by David Long while
    at the University of Chicago, Graduate School of Business.
    Long's additions include the seaside entrance and all of
    the cave on the \"far side\" of Lost River (Rainbow Rm - Crystal
    Palace - Blue Grotto - Rotunda - beyond Joshua's wall, etc., etc.).
    The castle problem was added in late 1984 by an anonymous writer.
    The current cave is about 50% larger than the Woods/Stanford model.
    In the process, the code was heavily rewritten to permit more
    generalized handling of objects and to allow a far more complex
    syntax.  The current maximum score is 551 points.";
    P(); I();
    "Thanks are owed to Roger Matus and David Feldman, both of U. of C.,
    for several suggestions, including the Rainbow Room, the telephone
    booth and the fearsome Wumpus.  Further thanks go to J. R. Carlson
    for many debugging suggestions.  Most thanks (and apologies)
    go to Thomas Malory, Charles Dodgson, the Grimm Brothers, Dante,
    Homer, Frank Baum and especially Anon., the real authors of
    ADVENTURE.";
    P(); I();
    "The original TADS port of the 350-point game (Colossal Cave Revisited)
    was written by David Baggett in 1993.  The 551-point extensions were 
    added by David Picton in 1999. ";
    }
    // used in the 701-point and 701+ point versions
    readdesc15 = {
    "\ \ \ \ \ \ \ \ *** THE HISTORY OF ADVENTURE (ABRIDGED) ***\n
    \ \ \ \ \ \ \ \ ** By Ima Wimp **";
    P(); I();
    "ADVENTURE was originally developed by William Crowther, and later
    substantially rewritten and expanded by Don Woods at Stanford Univ.
    Crowther's original version was modelled on a real cavern, called
    Bedquilt Cave, which is a part of Kentucky's Mammoth Cave system.
    That version of the game included the main maze and a portion of the
    third-level (Complex Junction - Bedquilt -  Swiss Cheese rooms, etc.),
    but not much more.";
    P(); I();
    "Don Woods and some others at Stanford later rewrote portions of
    the original program, and greatly expanded the cave.  That version
    of the game is recognizable by the maximum score of 350 points.";
    P(); I();
    "Some major additions were done throughout 1978 by David Long while
    at the University of Chicago, Graduate School of Business.
    Long's additions include the seaside entrance and all of
    the cave on the \"far side\" of Lost River (Rainbow Rm - Crystal
    Palace - Blue Grotto - Rotunda - beyond Joshua's wall, etc., etc.).
    The castle problem was added in late 1984 by an anonymous writer,
    bringing the maximum score up to 551 points. ";
    P(); I();
    "Another extended version, with 550 points, was independently
    developed in late 1979 by David Platt of the Honeywell Los
    Angeles Development Center.  The extensions in this version include
    the new areas beyond the Giant Room, the Arched Hall and the volcano.
    In 1984 the program was ported to UNIX C by Ken Wellsch. The extensions
    are drawn from the database source code.";
    P(); I();
    if(global.game701p)
        "This version of the game has a maximum score of at least 701 points,
        and includes the 550-point and 551-point games, with the exception of 
        the 551-point endgame.  But you now have something extra - a sort of
        sixth sense which may lead you to make discoveries which all 
        previous Adventurers have missed.  If so, you'll literally
        add a new dimension to your exploration of the cave. ";
    else
        "This version of the game has a maximum score of 701 points, and 
        combines the 550-point and 551-point games (with the exception of the 
        551-point endgame.) ";
    P(); I();
    "The original TADS port of the 350-point game (Colossal Cave Revisited)
    was written by David Baggett in 1993.  The 551-point extensions were 
    added by David Picton in 1999, followed by the 550-point extensions by 
    Bennett Standeven.  The combined 701-point mode was developed
    in by David Picton in 2000, and a 580-point mode was added by 
    Bennett Standeven in 2003. Finally, the extended 701+ point mode was
    released by David Picton in 2004. ";
    }
    noun = 'book'
    adjective = 'rare' 'dusty' 'leather' 'bound' 'leather-bound'
    location = Safe
    undiscovered = true // suppress scoring until safe is opened
    createloc = At_Sw_End // where to create a copy in the endgame.
;

/* 119 */
// This wasn't a light source in the Fortran version, but it is in this one,
// because a 'brightly' glowing stone would certainly light the room.
// Carrying it around for too long is bad for one's health, unless it's
// in its container.  In the TADS port, the troll knows this.
glowing_stone: initmess,CCR_treasure_item, lightsource
    game551 = true
    mass = 1
    basis = 4

    sdesc = "glowing stone"
    ldesc = "The strange green glow is bright enough to see by!  You
        could use it as a light source, but something in the back of
        your mind urges caution.  I wouldn't throw away your lamp if
        I were you. "

    initdesc = "Nearby, a strange, greenish stone is glowing brightly! "

    noun = 'stone' 'radium'
    adjective = 'glowing' 'greenish' 'strange'

    mycont = canister  // used by troll code
    islit = true

    location = Bubble_Chamber

;
// The troll puts the stone in here if it's not given in the canister.  It's
// seen only if the sapphire is given to the troll.
lead_box: openable
    game551 = true
    isopen = nil
    sdesc = "ornate lead casket"
    ldesc = "The troll uses this container to store the glowing stone if it
        isn't in the canister. "
;

/* 120 */
crystal_ball: CCR_treasure_item
    game551 = true
    mass = 2
    basis = 2

    sdesc = "crystal ball"
    ldesc = "At first sight, it's just a polished sphere of pure quartz.
    However, it begins to go a little cloudy as you examine it, and you
    are tempted to find out what will happen if you look IN the crystal
    ball!"
    noun = 'ball' 'sphere' 'palantir'
    adjective = 'crystal' 'quartz'

    location = Crystal_Palace
    verDoLookin (actor) = {
        if (Wumpus.ischasing)
            "You'd better do something about the Wumpus first - this
            isn't going to help! ";
        if (Goblins.ischasing)
            "You'd better do something about the goblins first - this
            isn't going to help! ";
        else if (Blob.ischasing and Blob.chase >= 13)
            "You'd better do something about the strange blob first - this
            isn't going to help! ";
        else if (Dwarves.numberhere(actor) = 1) {
            "You'd better do something about the dwarf first -
             this isn't going to help! ";
        }
        else if (Dwarves.numberhere(actor) > 1) {
            "You'd better do something about the dwarves
            first - this isn't going to help! ";
        }

    }
    verDoSearch(actor) = {self.verDoLookin(actor);}
    doLookin(actor) = {self.doSearch(actor);}
    doSearch(actor) = {
        local sapphloc, catobj, myloc := actor.location, count, myprep, 
        catacnum;
        local toploc := toplocation(actor);
        sapphloc := toplocation(sapphire);
        if (sapphloc = nil) sapphloc := sapphire.location;
        if (isclass(sapphloc, Actor)) {
            if(sapphloc.location)
                sapphloc := sapphloc.location;
        }
        // Special coding is needed if the sapphire is in Elsewhere,
        // indicating that the sapphire is really in a Catacomb (and if the
        // player is in a Catacomb, the sapphire is in a different one).
        // Adjust the contents of the Catacombs as appropriate
        if (sapphire.isIn(Elsewhere)) {
            catobj := sapphire;
            // If the object is contained, find the outermost
            // container.
            while (catobj.location <> Elsewhere) {
                catobj := catobj.location;
                if (catobj = nil) {
                    "Internal error while trying to find the
                    outermost container of <<sapphire.thedesc>>.";
                    return;
                }
            }
            // Remove objects from Catacombs (if the player is there) 
            // and label their room number
            if (actor.isIn(Catacombs))Catacombs.leaveroom;
            // Save the current Catacombs room number
            catacnum := Catacombs.roomnumber;
            // Set the Catacombs room number and move the relevant objects
            // into the room.
            Catacombs.roomnumber := catobj.catac_room_num;
            Catacombs.enterroom;
            if (sapphloc = Elsewhere) sapphloc := Catacombs;
        }
        if (isclass(toploc, Outside) and not isclass(toploc, Indoor))
            "You gaze into the crystal ball.  An image begins to form,
            but the bright daylight prevents you from seeing any detail.
            Maybe if you went somewhere a little darker ...";
        else {
            "You feel rather disembodied, as if you were suddenly somewhere
            else entirely. "; P();
            // Move the player out of the way if he's in the Catacombs and
            // the sapphire is in a different Catacomb, so the player's lamp
            // won't illuminate the location.
            if (catacnum and actor.isIn(Catacombs))actor.location := Elsewhere;
            if (not sapphire.islighted) {
                "You sense that you are in a dark place. The only thing in
                sight appears to be a companion to the crystal ball which
                holds your gaze. It seems to be searching the gloom for
                something to show you, but all it can see is itself: a
                brilliant blue six-pointed star suspended in space.";
                if ((toplocation(actor) = At_Y2) or 
                (toplocation(actor) = Fake_Y2)) {
                    P();
                    "A hollow voice says \"Plugh\". ";
                }
                actor.location := myloc;
                goto withdraw;
            }
            else
                actor.location := myloc;
            if (toplocation(actor) = toplocation(sapphloc) and
            isclass(sapphloc,room) and catacnum = nil) {
                "You then have a very strange and unnerving experience.
                You see yourself staring into the crystal
                ball, to which you somehow feel irresistibly drawn - and
                inside the ball, you see another image of yourself, and
                another ball, and another image, and another ball, until
                you realize that you can stop the process by closing
                your eyes. ";
            }
            else if(isclass(sapphloc,room)) {
                actor.location := sapphloc;
                global.view_artifact := self;
                global.onlyviewing := true;
                "\("; actor.location.sdesc; "\)";
                actor.location.nrmLkAround(true);
                global.onlyviewing := nil;
                global.view_artifact := nil;
                if(Dwarves.numberhere(actor) = 1) {
                    P();"You see a little dwarf here. ";
                }
                else if(Dwarves.numberhere(actor) > 1) {
                    P();
                    "You see <<say(Dwarves.numberhere(actor))>> little
                    dwarves here. ";
                }
                if(actor.location = Rise_Over_Bay) {
                    if (not Rise_Over_Bay.seenit or ((rand(100) <= 10)
                    and not gold_ring.seenspecial)) {
                        P();
                        "A large, stately elf walks up the rise, says the
                        word \"Saint-Michel\", and is instantly
                        transported to the castle. ";
                        Rise_Over_Bay.seenit := true;
                        if((gold_ring.location = actor) 
                        and gold_ring.isworn) {
                             gold_ring.seenspecial := true;
                             P();"You hear yourself repeat the word which the
                             elf has just issued. Out of the corner of your
                             eye, you then see your gold ring quiver - and
                             you seem to be somewhere else again... "; P();
                             actor.location := Castle_Pinnacle;
                             sapphire.moveInto(Castle_Pinnacle);
                             "\("; actor.location.sdesc; "\)";
                             actor.location.nrmLkAround(true);
                             P();
                             "You see the elf walk down the steps. ";
                        }
                    }
                }
                else if(actor.location = Castle_Pinnacle) {
                    if (not Castle_Pinnacle.seenit or rand(100) <= 10) {
                        P();
                        "A large, stately elf appears and walks down
                        the steps.";
                        Castle_Pinnacle.seenit := true;
                    }
                }
                else if(actor.location = Outer_Courtyard) {
                    if (not Outer_Courtyard.seenit or ((rand(100) <= 10)
                        and not gold_ring.seenspecial)) {
                        P();
                        "A large, stately elf comes down the steps.  He
                        says \"Phleece\".  You notice that a bracelet,
                        which he wears on his wrist, begins to glow - then
                        he disappears in a flash of light. ";
                        Outer_Courtyard.seenit := true;
                        if((gold_ring.location = actor) 
                        and gold_ring.isworn) {
                            gold_ring.seenspecial := true;
                            if(global.game701p) {
                                kataVerb.seenspecial := true;
                                anaVerb.seenspecial := true;
                            }
                            P();"You hear yourself repeat the word which
                            the elf has just used.  Out of the corner of 
                            your eye, you see your gold ring quiver - and
                            you seem to be somewhere else again... "; P();
                            sapphire.moveInto(Castle_Room);
                            actor.location := Castle_Room;
                            "\("; actor.location.sdesc; "\)";
                            actor.location.nrmLkAround(true);
                            P(); I(); 
                            if (global.game701p and not self.noelf) {
                                "You see the elf enter the room to the east,
                                and say \"Kata\".  The air around him seems to
                                shimmer, and he disappears!  Fearing that you 
                                may lose the emerald if you transport it again,
                                you stop yourself from repeating the word. ";

                            } else if (not self.noelf) {
                                "You see the elf enter the room to the east,
                                and utter a magic word which you don't quite
                                manage to hear.  The air around him seems to
                                shimmer, and he disappears!  ";
                            }
                        }
                    }
                }
                if((actor.location = Castle_Room) and 
                sapphire.isIn(Castle_Room) and not sapphire.plughed) {
                     P();
                    "You start to move your eyes away from the crystal
                    ball, but you notice movement in the sphere and
                    look again. Two elves come into the room from the 
                    southwest, deep in conversation.  Suddenly they notice the
                    sapphire, and immediately step back.  One of them
                    goes into a room to the north, and comes back
                    moments later, wearing a large glowing bracelet,
                    covered in knobs and buttons. He fiddles with the 
                    bracelet, then shouts a familiar word: \"Plugh!\"
                    You stop yourself from repeating the word, but
                    a hollow voice seems to say it anyway, 
                    and your gold ring quivers.  Once again, 
                    the elf and the sapphire are both transported. ";
                    P();
                    if (toplocation(myloc) = At_Y2)
                        sapphire.moveInto(Inside_Building);
                    else if (toplocation(myloc) = Fake_Y2)
                        sapphire.moveInto(Volcano_Platform);
                    else if (toplocation(myloc) = Volcano_Platform)
                        sapphire.moveInto(Fake_Y2);
                    else
                        sapphire.moveInto(At_Y2);
                    actor.location := sapphire.location;
                    "\("; actor.location.sdesc; "\)";
                    actor.location.nrmLkAround(true);
                    P();
                    "The elf picks up the sapphire and 
                    puts it down again, satisfied that it's now
                    out of harm's way.  Then he presses
                    another button on his glowing bracelet and 
                    disappears! ";
                    sapphire.plughed := true;
                }
                else if((actor.location = Castle_Room) and 
                sapphire.isIn(Castle_Room)){
                    P();
                    "You start to move your eyes away from the crystal ball,
                    but you notice movement in the sphere and look again.
                    Three elves are standing in the room, conversing in Elvish
                    and looking at the sapphire as if it's an unexploded bomb!
                    Once again a bracelet is produced, and once again a
                    button is pushed... ";
                    P();
                    sapphire.moveInto(Troll_Treasure);
                    actor.location := sapphire.location;
                    "\("; actor.location.sdesc; "\)";
                    actor.location.nrmLkAround(true);
                }
                actor.location := myloc;
            }
            else {
                if (isclass(sapphloc,surface))
                    myprep := 'on';
                else
                    myprep := 'in';
                "You're somehow <<myprep>> <<sapphloc.adesc>>! ";
                if (length(sapphloc.contents) > 0) {
                    P();
                    "You can see ";listcont(sapphloc);
                    " here. ";
                }
                else {
                    P();"It appears to be empty. ";
                }
            }
            withdraw: P();
            "Your gaze withdraws from the crystal ball, and you are
            now back in your normal senses. ";
        }
        // If catacnum is set, remove objects from the Catacombs location
        // and (if appropriate) move the right objects in.
        if (catacnum) {
            // Remove objects
            Catacombs.leaveroom;
            // Restore original room number
            Catacombs.roomnumber := catacnum;
            // If the player is in the Catacombs, move the right objects back.
            if(actor.isIn(Catacombs))Catacombs.enterroom;
        }
    }
;





