/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      bjs     In real life:   Bennett J. Standeven
 *
 *      djp     In real life:   David J. Picton
 *
 * Modification History
 *
 *
 * POLYADV
 * =======
 *
 * 12-Aug-03    bjs     Version 2.11: Created this file.
 *
 * 23-Aug-03    djp     Version 2:12 
 *                      * Added 'posters' as a synonym for 
 *                        'poster'.  Made posters visible in 
 *                        both computer center rooms.  Changed
 *                        poster code to remove risk of
 *                        summoning the blob twice, and to ensure that 
 *                        the player can't escape to the building.
 *               
 *              djp     * For reasons of efficiency and consistency, the
 *                        game580, location580 and loclist580 properties
 *                        have now been moved to ccr-thx.t.
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *
 */

card: item, initmess
        game580 = true
    sdesc = "plastic ID card"
    noun = 'card' 'plastic'
    adjective = 'id' 'rectangular' 'piece' 'magnetic'
    initdesc = "Over in one corner is a small rectangular piece of white plastic. "
    ldesc = "Gee, this is interesting.  This seems to be an I.D. card of some
             sort.  On the front are the initials R.W. and the number 10001,
             and there is some kind of black strip running along the back. "
    location = Tool_Room
;

stamp: CCR_treasure_item
        game580 = true
    noun = 'stamps'
    adjective = 'rare' 'priceless'
    sdesc = "rare stamps"
    adesc = {self.sdesc;}
    isThem = true
    ldesc = "It is an assortment of rare stamps. "
        initdesc = "Resting on the desk are several priceless rare stamps! "
    location = Study
;

disk: CCR_treasure_item, readable
        game580 = true
    sdesc = "floppy disk"
    noun = 'disk' 'floppy'
    adjective = 'source' 'adventure'
        initdesc = "Taped to the front of the computer is an 8-inch floppy disk. "
    ldesc = "Scrawled on the the disk's label in a nearly illegible handwriting
             are the words \"Adventure Source Files\"."
    location = Computer_Room
    readdesc = {
        "The disk label says \"ADVENTURE SOURCE FILES\"; the disk itself is
             unreadable without a floppy disk drive, and I don't see any of
             those here. ";
    }
;

class poster_coll: item, readable
    game580 = true
    noun = 'poster' 'posters'
    sdesc = "poster"
    ldesc = {
        switch(rand(9))
        {
            case 1: "One is a small poster of Albert Einstein. "; break;
            case 2: "One is a small poster of a cat. "; break;
            case 3: "One is a large poster of a cat. "; break;            
            case 4: "One poster is a two foot high nude centerfold. "; break;
            case 5: "One poster is a five foot high nude centerfold. "; break;
            case 6: "One is a three foot square poster of Mr. Spock."; break;
            case 7: "One is a poster of a mountain climber. "; break;
            case 8: "One is an eight foot wide poster showing an
                airplane flying over the Golden Gate bridge. "; break;
            case 9: "One of the posters is a seven foot high, 
                 twenty foot long, three hundred and sixty degree
                 view of Mars taken from the Viking lander. "; 
                break; 
        }       
    }
    isListed = nil // need to prevent it from showing in room desc.
    doTake(actor) = {   
            switch(rand(9))
        {
            case 1: "You carefully take a small poster of Albert Einstein
                 off the wall. "; break;
            case 2: "You carefully take down a small poster of a cat. "; break;
            case 3: "You carefully take down a large poster of a cat. "; break;            
            case 4: "You carefully take down a two foot high nude centerfold poster. "; break;            
            case 5: "You carefully remove from the wall a five foot high
                 nude centerfold poster. "; break;
            case 6: "You carefully take a three foot square poster of Mr.
                 Spock from the wall."; break;
            case 7: "You carefully take down a poster of a mountain climber. "; break;
            case 8: "You very carefully take down an eight foot wide poster
                 showing an airplane flying over the Golden Gate bridge. "; 
                break;
            case 9: "With extreme difficulty, you take down from the wall
                 a seven foot high, twenty foot long, three hundred and
                 sixty degree view of Mars taken from the Viking lander. "; 
                break; 
        }       
        P();
        if(rand(100) < 5)
        {
            "Unfortunately, you ripped one corner of the poster when you
             took it down.  The poster bursts into a ball of flame,
             incinerating you in the process.";
            die();
        }
            if(global.closed or global.triggered_alert)
            {} // do nothing, because a security alert has already been
               // triggered or the elevator is already locked.
        else
        {
            local delay := 2;
            P();
            ">bong<\t\t\t\t\t\tThe very air quivers with sound as though\n";
            "\ \ >bong<\t\t\t\t\tsomeone, somewhere in the distance, has 
             struck\n";
            "\t\ >bong<\t\t\t\t\tthree powerful blows on an immense brass 
             gong.\n";
            P();
            "From an overhead speaker an extremely loud mechanical voice says,
             \"This is a Class 1 security alarm.  All computer center security 
             forces go to Purple Alert. I repeat - Purple Alert.\""; P();
               
            // Add flag so that we can test whether an alert has been issued,
            // before the blob summoning code is executed.  This flag is reset
            // in the die() routine.
            global.triggered_alert := true;

            // stop the player from leaving via the elevator, if the button
            // has already been pressed.
            if((self.location = Elevator580.location) && (Elevator580.isopen))
                delay := 1; 
            notify(Blob, &summon, delay); // summon blob, will close and 
                                          // lock elevator.
        }
        "The poster in your hands disintegrates into fine dust and blows 
        away. ";

    }
;

postercoll_s: poster_coll
    location = S_Of_Center
;
postercoll_n: poster_coll
    location = N_Of_Center
;

cups: item
        game580 = true
    noun = 'cups' 'cup'
    adjective = 'suction'
    isThem = true
    sdesc = "suction cups"
    adesc = "suction cups"
    ldesc = "It looks like an ordinary set of suction cups. "
    location = Tool_Room
    
    verIoTakeWith(actor) = {}
    ioTakeWith(actor, dobj) = {
        return dobj.doTakeWith(actor, self);
    }
    verIoOpenWith(actor) = {}
    ioOpenWith(actor, dobj) = {
        return dobj.doOpenWith(actor, self);
    }
;
