#ifndef FULLSCR
#define FULLSCR
#pragma C+

/*
** Fullscr.t -- allows you to tell the player how he/she has scored all of
** his points, as seen in such Inform games as Curses and Jigsaw.  Each time
** the player's score is increased, call fullscrDaemon.addScoredesc(str) with
** the string you wish to add to the list.
**
** For example, say the player has just earned five points for finding the
** fibrillating gonkulator.  Just after the call to incscore(), put the
** following:
**
** fullscrDaemon.addScoredesc('5 points for finding the fibrillating
**    gonkulator');
**
** That's all!
**
** Copyright (c) 1996 Stephen Granade
** You are permitted to distribute this module freely, as long as 1) my name
** is left on it, and 2) you keep all files together.  You may also use
** this module in any game you like in any form you like.  Hack away at
** it, if you so desire.  All I ask is that you credit me in some way in your
** game.
** I would welcome any comments on or suggestions for this module.  I can be
** reached at:
**  Duke University Physics Department
**  Box 90305
**  Durham, NC  27708-0305
**  U.S.A.
**  sgranade@phy.duke.edu
**
** Version history:
**   7 Oct 96 -- Initial release
*/

#include "version.t"

fullscoreVersion: versionTag
    id="$Id: fullscr.t v 1.0  7 Oct 96\n"
    author = 'Stephen Granade'
    func = 'full score reporting'
;

// The fullscrDaemon keeps track of everything.  Call addScoredesc(str) to
// add a description to the list; "str" should be the description string. The
// string should NOT have a '\n' on its end.
fullscrDaemon: object
    scoredesc = []
    addScoredesc(str) = {
        scoredesc += str;
    }
    reportScore = {
        local i, len;

        for (i = 1, len = length(scoredesc); i <= len; i++)
            "\ \ \ \ <<self.scoredesc[i]>>\n";
    }
;

fullVerb: deepverb
    verb = 'full'
    sdesc = "full score"
    action(actor) = {
        if (global.score == 0) "You have not earned any points. ";
        else {
            "You have earned <<global.score>> points in the following
                manner:\n";
            fullscrDaemon.reportScore;
        }
    }
;

#endif
