/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.ScrollPane;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class JettyApplet
extends Applet
implements Runnable {
    private ScrollPane _scrollbar;
    private GameWindow _display;
    private Jetty _jetty;
    private Thread _thread;
    private final String[][] _params = new String[][]{{"file", "filename", "name of gamefile (with \".gam\", \".gam.zip\", or \".gam.gz\" suffix)"}, {"statusFont", "name", "font to use for status window"}, {"statusFontSize", "number", "point size of status window font"}, {"statusForegroundColor", "color", "foreground color for status window"}, {"statusBackgroundColor", "color", "background color for status window"}, {"mainFont", "name", "font to use for main window"}, {"mainFontSize", "number", "point size of main window font"}, {"mainForegroundColor", "color", "foreground color for main window"}, {"mainBackgroundColor", "color", "background color for main window"}, {"inputFont", "name", "font to use for input line"}, {"inputFontSize", "number", "point size of input line font"}, {"inputForegroundColor", "color", "foreground color for input line"}, {"cursorColor", "color", "color of cursor on input line"}};

    public void init() {
        String string = this.getParameter("file");
        if (string == null) {
            string = this.getParameter("StoryFile");
        }
        if (string == null) {
            System.err.println("Error: \"file\" parameter is null.");
            return;
        }
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[3];
        String[] stringArray3 = new String[3];
        stringArray[0] = this.getParameter("statusFont");
        stringArray2[0] = this.getParameter("statusForegroundColor");
        stringArray3[0] = this.getParameter("statusBackgroundColor");
        stringArray[1] = this.getParameter("mainFont");
        stringArray2[1] = this.getParameter("mainForegroundColor");
        stringArray3[1] = this.getParameter("mainBackgroundColor");
        stringArray[2] = this.getParameter("inputFont");
        stringArray2[2] = this.getParameter("inputForegroundColor");
        stringArray3[2] = this.getParameter("cursorColor");
        int[] nArray = new int[]{0, 0, 0};
        int n = 0;
        while (n < 3) {
            String string2 = this.getParameter(this._params[n * 4 + 2][0]);
            try {
                if (string2 != null) {
                    nArray[n] = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error reading parameter: font size not a number, is '" + string2 + "'");
                nArray[n] = 0;
            }
            ++n;
        }
        this.setLayout(new BorderLayout());
        this._scrollbar = new ScrollPane();
        this.add("Center", this._scrollbar);
        this._display = new GameWindow(stringArray, nArray, stringArray2, stringArray3);
        this._scrollbar.add(this._display);
        int n2 = this._scrollbar.getVScrollbarWidth() + 4;
        this._display.init_size(this.getSize().width, this.getSize().width - n2, this.getSize().height, this._scrollbar);
        this.add("North", this._display.get_status_line());
        this._scrollbar.setSize(this.getSize().width, this.getSize().height - this._display.get_status_line().getSize().height);
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            InputStream inputStream = uRL.openStream();
            if (string.toLowerCase().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.toLowerCase().endsWith(".zip")) {
                inputStream = new ZipInputStream(inputStream);
            }
            this._jetty = new Jetty(this._display, inputStream);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: bad url (" + this.getDocumentBase() + "): " + malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println("Error: i/o (" + this.getDocumentBase() + "): " + iOException);
        }
    }

    public void start() {
        if (this._display != null && this._jetty != null) {
            this._thread = new Thread(this);
            this._thread.setPriority(1);
            this._display.reset();
            this._scrollbar.setScrollPosition(0, this._display.getSize().height);
            this.validate();
            this._thread.start();
            this._display.requestFocus();
        }
    }

    public void run() {
        this._jetty.load();
        this._display.loaded(true);
        this._jetty.run();
    }

    public String getAppletInfo() {
        return "Jetty: a TADS 2 interpreter written in Java\nby Dan Shiovitz (dbs@cs.wisc.edu)\nType $$credits for more info";
    }

    public String[][] getParameterInfo() {
        return this._params;
    }
}

