////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ButtonItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _BUTTON_ITEM_H_
#define _BUTTON_ITEM_H_

#include <fixeditem.h>

#pragma C+

/*
 *  ButtonItem: FixedItem
 *
 *  A button (the type you push).  The individual button's action method
 *  doPush(actor), which must be specified in
 *  the button, carries out the function of the button.  Note that
 *  all buttons have the noun 'button' defined.
 */
class ButtonItem: FixedItem
    noun = 'button'
    plural = 'buttons'
    verDoPush(actor) = {}
;

#pragma C-

#endif /* _BUTTON_ITEM_H_ */
