////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ClothingItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CLOTHING_ITEM_H_
#define _CLOTHING_ITEM_H_

#include <wearable.h>
#include <item.h>

#pragma C+

/*
 *  ClothingItem: Wearable, Item
 *
 *  Something that can be worn.  By default, the only thing that
 *  happens when the Item is worn is that its wearer property
 *  is set to true.  If you want more to happen, override the
 *  doWear(actor) property.  
 *
 *  Note that, when a ClothingItem is being worn, certain 
 *  operations will cause it to be removed (for example, dropping 
 *  it causes it to be removed).  If you want something else to 
 *  happen, override the checkDrop method; if you want to disallow 
 *  such actions while the object is worn, use an exit statement 
 *  in the checkDrop method.
 */
class ClothingItem: Wearable, Item
    invDesc = {
        /* show any additional information about the item */
        if (self.isWorn)
            " (being worn)";
    }
    moveInto(obj) = {
        /*
         *   Catch any other movements with moveInto; this won't stop the
         *   movement from happening, but it will prevent any anamolous
         *   consequences caused by the object moving but still being worn.
         */
        self.wearer = nil;
        pass moveInto;
    }
    checkDrop = {
        if (self.isWornBy(gActor())) {
            "(Taking off _dobj_ first)\n";
            self.wearer = nil;
        }
    }
    doDrop(actor) = {
        self.checkDrop;
        pass doDrop;
    }
    doGiveTo(actor, io) = {
        self.checkDrop;
        pass doGiveTo;
    }
    doPutIn(actor, io) = {
        self.checkDrop;
        pass doPutIn;
    }
    doPutOn(actor, io) = {
        self.checkDrop;
        pass doPutOn;
    }
    verDoTake(actor) = {
        if (self.isWornBy(actor))
            self.verDoUnwear(actor);
        else
            pass verDoTake;
    }
    doTake(actor) = {
        if (self.isWornBy(actor))
            self.doUnwear(actor);
        else
            pass doTake;
    }
    doThrow(actor) = {
        self.checkDrop;
        pass doThrow;
    }
    doThrowAt(actor, io) = {
        self.checkDrop;
        pass doThrowAt;
    }
    doThrowTo(actor, io) = {
        self.checkDrop;
        pass doThrowTo;
    }
;

#pragma C-

#endif /* _CLOTHING_ITEM_H_ */
